/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __MainWindow__
#define __MainWindow__

#include <kdockwidget.h>
#include <qmap.h>
#include <qdict.h>

class ToolBarSeparator;
class ComposerWindow;
class MainWidget;
class QCloseEvent;
class QPopupMenu;
class EButton;
class SendReceiveDialog;
class BannerGraphic;
class ContentsWidget;
class BrowseWidget;
class KToolBar;
class UIComponent;
class VFolder;

typedef	QMap<int,UIComponent*> ComponentsMap;
typedef ComponentsMap::Iterator ComponentsMapIterator;
typedef	QDict<UIComponent> ComponentsDict;
typedef QDictIterator<UIComponent> ComponentsDictIterator;


class MainWindow: public KDockMainWindow
{
	Q_OBJECT

	public:
			MainWindow();
			~MainWindow();
			static MainWindow *ref();
			
			// menubar & toolbar switch
			void setMode(const QString &mode);
			
			bool isOffline();
			void updateArrows();
			
			/** Insert a new UI component.*/
			bool insertComponent(UIComponent*);
			
	public slots:

			void quitApp();
			void goNext();
			void goPrev();
			
			void newObject();
			/** Create a new message.*/
			void newMessage();
			/** Create a new folder.*/
			void newFolder();
			/** Create a new view for a folder.*/
			void createFolderView(VFolder* newFolder);
			/** Create a new contact.*/
			void newContact();
			/** Create a new note.*/
			void newNote();
			void newGroup();
			
			void markRead();
			void markUnread();
			void markAllRead();
			void markAllUnread();
			
			void undoAction();
			void redoAction();
			
			void cutSelection();
			void copySelection();
			void paste();
			void deleteSelection();
			
			void selectAll();
			
			void moveSelectionTo();
			void copySelectionTo();
			
			void toggleFlag();
			
			void changeColor();
			
			void setCategory();
			void editProperties();
			
			void reply();
			void replyAll();
			void forward();
			void forwardInline();
			void forwardQuoted();
			void forwardAsAttachment();
			
			void startSend(int);
			void startReceive(int);
			void startSendReceive(int);
			void startButtonSendReceive();

			// control center
			void controlCenter();
			void controlCenter_Accounts();
			void controlCenter_Notes();

			// about box
			void aboutMagellan();
			
			void toggleFolderTree();
			void toggleMagellanBar();
			void toggleMyShortcuts();
			void toggleCollapsedView();

			void slotBrowseToolBarClicked(int id);
			void slotBrowseToolBarToggled(int id);
			
			void slotConfigureMailFilter();
			
	protected slots:
			void genSendReceiveMenus();

	protected:
			void closeEvent(QCloseEvent *e);
			void saveAppearance();

			void initMenu();
      void initComponents();
			void initBrowseToolBar();
			void initWelcomeToolBar();
			void initGroupsToolBar();
			void initMailToolBar();
			void initContactsToolBar();
			void initNotesToolBar();
// XXX:DIMI
			void initJabberToolBar();
// / XXX:DIMI
      void initKOrganizerToolBar();
			ToolBarSeparator *toolSeparator(QWidget *parent, const char *name=0);
			/** Show the right toolbar and hide all the other toolbars.*/
      void showComponentToolBar(const QString &mode);
			
			KToolBar *m_browseToolBar;
			QStringList accounts;
			QString arrow_goto;
			QString currentMode;
			ContentsWidget *m_contentsWidget;
			BrowseWidget *m_browseWidget;
			BannerGraphic *m_bannerGraphic;
			EButton *arrowdown_button, *arrowup_button;
			QPopupMenu *filePopup, *newPopup, *editPopup, *selectPopup, *viewPopup, *sendReceivePopup;
			QPopupMenu *sendPopup, *receivePopup, *quickFiltersPopup, *toolsPopup, *gotoPopup, *forwardPopup;
			QPopupMenu *sortPopup, *optionsPopup, *helpPopup, *actionsPopup;
			
			SendReceiveDialog *sendReceiveDialog;
			
			// An small step for supporting components
			/** UI Components Map.*/
			ComponentsMap componentsMap;
			/** UI Components Dict.*/
			ComponentsDict componentsDict;
						
			static MainWindow *inst;
};

#endif






