/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <kapp.h>
#include <kiconloader.h>

#include <qmessagebox.h>
#include <qlabel.h>

#include <noteobj.h>
#include <brokeriface.h>
#include <videotoolbox.h>
#include <noteview.h>
#include <notewindow.h>
#include <notewidget.h>
#include <tilewidget.h>

NoteWidget::NoteWidget(NoteView *parent, NoteObject *item, const char *name)
	:TileWidget(parent, name), TemplateView(item), TextFitter()
{	
	// debug
	printf("NoteWidget contructor: enter\n");
	
  _localParent=parent;
  
	item->setIconView(this);
	
  setBackgroundColor(QColor("white"));
	
	ntxt=new QLabel(this);
	ntxt->setBackgroundColor(QColor("white"));
	ntxt->setFont(QPxFont("helvetica", 10));
  ntxt->setAlignment(AlignCenter);
	
	npix=new QLabel(this);
  npix->setBackgroundColor(QColor("white"));
	
	npix->move(27, 9);

	ntxt->setAlignment(AlignTop|AlignHCenter);
	ntxt->setFont(QPxFont("helvetica", 10));
	ntxt->move(5, 50);
	ntxt->setFixedSize(80, 15);
	
	update();
	
	installEventFilter(parent);
	npix->installEventFilter(parent);
	ntxt->installEventFilter(parent);
		
	npix->show();
	ntxt->show();
	
	// debug
	printf("NoteWidget constructor: exit\n");
}

NoteWidget::~NoteWidget()
{
	delete(ntxt);
	delete(npix);
}

QString NoteWidget::key(int number)
{
	QString s="";
	if(number==0)
		s=((NoteObject *)getVItem())->color();
	if(number==1)
		s=((NoteObject *)getVItem())->text();
	if(number==2)
	{        
		QDateTime base(QDate(1980, 1, 1));
		s.sprintf("%08d", base.secsTo(((NoteObject *)getVItem())->time()));
	}
	return s;
}

QString NoteWidget::keyName(int number)
{
	QString s="";
	if(number==0)
		s="Color";
	if(number==1)
		s="Text";
	if(number==2)
		s="Date";
	return s;
}

int NoteWidget::keyCount()
{
	return 3;
}

void NoteWidget::update()
{
	QString pname="notes-large-";
	pname+=((NoteObject *)getVItem())->color();
	npix->setPixmap(BarIcon(pname));
	QString txt=((NoteObject *)getVItem())->text();
	QFont displayFont=font();
	displayFont.setBold(true);
	QString src;
	unsigned int i=0;
	if (txt.length() > 0)
	{
		while (i < txt.length()) 
			if (txt[i]==0x0a || txt[i]==0x0d || txt[i]==0x20)
				i++;
			else
				break;
		while (i < txt.length()) 
			if (txt[i]!=0x0a && txt[i]!=0x0d)
				src+=txt[i++];
			else
				break;
	}
	if(src.stripWhiteSpace().isEmpty())
		src="(Empty)";
	ntxt->setText(fitText(src, 80, displayFont));
	
	((SortingWidget *)localParent())->screenUpdate();
}

void NoteWidget::setState(ViewState state)
{
	DataWidget::setState(state);
 	
 	if(state==Selected)
		ntxt->setFont(QFont("helvetica", 10, QFont::Bold));
	else
		ntxt->setFont(QFont("helvetica", 10, QFont::Normal));

  ntxt->repaint();
}

void NoteWidget::copy()
{
}

void NoteWidget::open()
{
	if(!getVItem())
	{
		printf("*FATAL*: No object for this view...\n");
		return;
	}
	NoteWindow *nwin=(NoteWindow *)getVItem()->altViews().at(0);
	if(!nwin)
	{
		nwin=new NoteWindow((NoteObject *)getVItem());
		nwin->show();
	}
	else
	{
		nwin->raise();
	}
}

void NoteWidget::setColor(const QString &c)
{
	QString pix = "notes-large-";
	pix += c;
	npix->setPixmap(BarIcon(pix));
	NoteObject *obj=(NoteObject *)getVItem();
	if(obj)
	{
		obj->setColor(c);
		obj->save();
	}
	((SortingWidget *)localParent())->screenUpdate();
}

QWidget* NoteWidget::localParent()
{
  return _localParent;
}

