/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <string.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qlist.h>
#include <miscfunctions.h>
#include <metaquality.h>

//#define DEBUG_META_QUALITY

#ifdef IDSTRING
#undef IDSTRING
#endif

#define IDSTRING "Metaquality:"

MetaQuality::MetaQuality(QString &q)
{
	parse(q);
	qualityList.setAutoDelete(TRUE);
}

MetaQuality::MetaQuality(const char *q)
{
	QString q1(q);
	parse(q1);
	qualityList.setAutoDelete(TRUE);
}

MetaQuality::MetaQuality(MetaQuality &mq)
{
	qualityList=mq.getQualityList();
	qualityList.setAutoDelete(TRUE);
}

Quality &MetaQuality::operator[](int index)
{
	return *(qualityList.at(index));
}

Quality &MetaQuality::operator[](const char *name)
{
	Quality *q;
	q=seekQuality(QString(name));
	if(q==NULL)
		return defaultValue();
	return (*q);
}

Quality &MetaQuality::operator[](QString &name)
{
	Quality *q;
	q=seekQuality(name);
	if(q==NULL)
		return defaultValue();
	return (*q);
}

Quality *MetaQuality::seekQuality(QString name)
{
	unsigned it;
  for( it = 0; it < qualityList.count(); it++ )
	{
		#ifdef DEBUG_META_QUALITY
			printf("2. req name: %s, current name: %p\n",
				(const char *)name, qualityList.at(it));
		#endif
		if(qualityList.at(it) && qualityList.at(it)->name()==name) 
		{
			return qualityList.at(it);
		}
	}
	return NULL;
}

bool MetaQuality::query(QString name, QString included, QString excluded)
{
	unsigned it;
  for( it = 0; it != qualityList.count(); it++ )
	{
#ifdef DEBUG_META_QUALITY
			printf("Query. included: <%s>, excluded: <%s>\n",(const char *)included,
				(const char *)excluded);
			printf("QUERY. req name: <%s>, current name: <%s>, content <%s>\n",
				(const char *)name, (const char *)qualityList.at(it)->name(),
				(const char *)qualityList.at(it)->oldContent());
#endif
		if(qualityList.at(it)->name().find(name,0,false)!=-1) 
		{
			if(qualityList.at(it)->checkContents(included, excluded))
				return TRUE;
		}
	}
	return FALSE;
}


void MetaQuality::parse(QString q)
{
	// first, trim the string
	q.stripWhiteSpace();
	QStringList unseparator;
	unseparator.append("\\");
	QStringList qualities=enhancedSplit(q,';',unseparator);
	for(unsigned i=0;i<qualities.count();i++)
	{
#ifdef DEBUG_META_QUALITY
		printf("[%s]\n", (const char *)qualities[i]);
#endif
		qualityList.append(new Quality(qualities[i]));
	}
	return;
}

MetaQuality &MetaQuality::operator=(MetaQuality &mq)
{
	qualityList=mq.getQualityList();
	return (*this);
}

void MetaQuality::show()
{
	unsigned it;
  for( it = 0; it != qualityList.count(); it++ )
	{
		printf("MetaQuality: Show %d\n",it);
		qualityList.at(it)->show();
	}
}

QString MetaQuality::recompose()
{
	static QString text;
	unsigned it;
	if(qualityList.count())
	{
		text=qualityList.at(0)->recompose();
	}
	else
	{
		text="";
		return text;
	}
  for( it = 1; it != qualityList.count(); it++ )
	{
		text+=";";
		text+=qualityList.at(it)->recompose();
	}
	return text;
}

void MetaQuality::appendQuality(QString name, QString content)
{
	Quality *q;
	q=seekQuality(name);
	if(!q)
	{
		q=new Quality(name,content);
		qualityList.append(q);
	}
	else
		q->appendContent(content);
}
void MetaQuality::replaceQuality(QString name, QString content)
{
	Quality *q;
	q=seekQuality(name);
	if(!q)
	{
		q=new Quality(name,content);
		qualityList.append(q);
	}
	else
		q->replaceContent(content);
}
void MetaQuality::eraseQuality(QString name, QString included, QString excluded)
{
	unsigned it;
  for( it = 0; it != qualityList.count(); it++ )
	{
		if(qualityList.at(it)->name()==name &&
				qualityList.at(it)->checkContents(included, excluded))
		{
			qualityList.remove(it);
			if(it) it--;
		}
	}
}





