/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <stdio.h>
#include <qstringlist.h>
#include <vcard.h>
#include <miscfunctions.h>

unsigned int VCard::lastNumID;

VCard::VCard()
{
  setID();
  mObj=0;
}

VCard::VCard(VCard &c)
{
  mObj=new MetaObject(*c.data());
  setID();
}

VCard::VCard(QString s)
{
  mObj=new MetaObject(s);
  setID();
}

VCard::~VCard()
{
  if(mObj)
    delete mObj;
}

void VCard::setID()
{
  cID="MVC"+QString::number(lastNumID);
  lastNumID++;
}

QString VCard::ID()
{
  return cID;
}

VCard& VCard::operator=(VCard &c)
{
  mObj=c.data();
  return *this;
}


void VCard::setData(MetaObject *m)
{
  mObj=m;
}

/******************************************************************************
 * field QUERY METHODS 																												*
 ******************************************************************************/

QString VCard::CardName()
{
	return (*mObj)["FN"].getContent();
}
QString VCard::Name(unsigned fields)
{
	bool verFlag=true;
	if(Version().find("2.1")!=-1)
		verFlag=false;
#ifdef DEBUG_VCARD
	printf("Version: %s\n",(const char *)version());
#endif
	QString result="";
	QStringList qsl=split((*mObj)["n"].getContent(),';');
	bool flag=false;
	bool nameflag=false;
	if(verFlag && (fields & VCARD_HONOR_PREFIXES))
	{
		result+=qsl[3];
		flag=true;
	}
	if(fields & VCARD_FAMILY_NAME)
	{
		if(verFlag)
		{
			result+=((flag) ? " ":"") +qsl[0];
		}
			else
		{	// version 2.1
			if(qsl.count()>1)
				result+=((flag) ? " ":"") +qsl[1];
		}
		flag=true;
		nameflag=true;
	}
	if(fields & VCARD_GIVEN_NAME)
	{
		result+=(nameflag) ? ",":"";
		nameflag=false;
		if(verFlag)
		{
			result+=((flag) ? " ":"") +qsl[1];
		}
			else
		{
			if(qsl.count()>0)
				result+=((flag) ? " ":"") +qsl[0];			
		}
		flag=true;
	}
	if(fields & VCARD_ADDITIONAL_NAMES)
	{
		result+=(nameflag) ? ",":"";
		if(qsl.count()>2)
			result+=((flag) ? " ":"") +qsl[2];
		flag=true;
	}
	if(verFlag && (fields & VCARD_HONOR_SUFFIXES))
	{
		result+=((flag) ? " ":"") +qsl[4];
		flag=true;
	}
	return result;
}
QString VCard::EmailPrefered()
{
	QValueList<int> matches;
	QString emailType;
	if(Version().find("2.1")==-1) emailType="TYPE=internet,pref";
		else emailType="pref;internet";
	matches=mObj->query("email",emailType);
	// get the first one!
	if(matches.count()==0)
		return QString::null;
	return mObj->getLines().at(matches[0])->getContent();
}

QStringList VCard::EmailOthers()
{
	QStringList result;
	QValueList<int> matches;
	QString emailType;
	QString rejectType;
	if(Version().find("2.1")==-1) 
	{
		emailType="TYPE=internet";
		rejectType="TYPE=pref";
	}
		else 
	{
		emailType="internet";
		rejectType="pref";
	}
	matches=mObj->query("email",emailType,rejectType);
	for(int i=0;i<matches.count();i++)
		result.append(mObj->getLines().at(matches[i])->getContent());
	return result;
}

QStringList VCard::Phone(QString which)
{
	QStringList result;
	QValueList<int> matches;
	QString phoneType;
	if(Version().find("2.1")==-1)
	{	// then I have version 3.0
		phoneType="type="+which;
	} 
		else
	{
		phoneType=which;
		// replacing all the commas with semicolons
		for(int i=0;i>=0;)
		{
			i=phoneType.find(',',i);
			if(i!=-1)
				phoneType.replace(i,1,";");
		}
	}
	matches=mObj->query("tel",phoneType);
	for(int i=0;i<matches.count();i++)
		result.append(mObj->getLines().at(matches[i])->getContent());
	return result;	
}

QStringList VCard::PhoneType(QString which)
{
	QStringList result;
	QValueList<int> matches;
	QString phoneType;
	if(Version().find("2.1")==-1)
	{	// then I have version 3.0
		phoneType="type="+which;
	} 
		else
	{
		phoneType=which;
		// replacing all the commas with semicolons
		for(int i=0;i>=0;)
		{
			i=phoneType.find(',',i);
			if(i!=-1)
				phoneType.replace(i,1,";");
		}
	}
	matches=mObj->query("tel",phoneType);
	for(int i=0;i<matches.count();i++)
		result.append(mObj->getLines().at(matches[i])->getQuality()->recompose());
	return result;	
}

QString VCard::Title()
{
	return (*mObj)["title"].getContent();
}
QStringList VCard::URL()
{
	QStringList result;
	QValueList<int> matches;
	matches=mObj->query("url");
	for(int i=0;i<matches.count();i++)
		result.append(mObj->getLines().at(matches[i])->getContent());
	return result;
	
}
QString VCard::Class()
{
	QString result=(*mObj)["class"].getContent();
	if(	(result.find("private",0,false)==-1) && 
			(result.find("public",0,false)==-1) &&
			(result.find("confidential",0,false)==-1))
		result="PRIVATE";
	return result;
}
QString VCard::Note()
{
	if (mObj->query("note").count()==0) return QString::null;
	return (*mObj)["note"].getContent();
}
QString VCard::Categories()
{
	if (mObj->query("categories").count()==0) return QString::null;
	return (*mObj)["categories"].getContent();
}
QStringList VCard::Organisation()
{
	return split((*mObj)["org"].getContent(),';');
}
QString VCard::Role()
{
	if (mObj->query("role").count()==0) return QString::null;
	return (*mObj)["role"].getContent();
}
QString VCard::Nickname()
{
	if (mObj->query("nickname").count()==0) return QString::null;
	return 	split((*mObj)["nickname"].getContent(),',')[0];
}
QString VCard::Birthday()
{
	if (mObj->query("bday").count()==0) return QString::null;
	return 	split((*mObj)["bday"].getContent(),',')[0];
}
QString VCard::Address(QString which, unsigned fields)
{
	QString result;
	QValueList<int> matches;
	QString adrType;
	if(Version().find("2.1")==-1)
	{	// then I have version 3.0
		adrType="type="+which;
	} 
		else
	{
		adrType=which;
		// replacing all the commas with semicolons
		for(int i=0;i>=0;)
		{
			i=adrType.find(',',i);
			if(i!=-1)
				adrType.replace(i,1,";");
		}
	}
	matches=mObj->query("adr",adrType);
	QStringList sp=split(mObj->getLines().at(matches[0])->getContent(),';');
	bool alreadyField=false;
	// PO-BOX
	if((fields & VCARD_PO_BOX) && ! sp[0].isEmpty())
	{
		result+=sp[0];
		alreadyField=true;
	}
	// Extended Address
	if((fields & VCARD_EXT_ADDRESS) && ! sp[1].isEmpty())
	{
		result+=((alreadyField)?", ":"") + sp[1];
		alreadyField=true;
	}
	// Street Address
	if((fields & VCARD_STREET_ADDRESS) && ! sp[2].isEmpty())
	{
		result+=((alreadyField)?", ":"") + sp[2];
		alreadyField=true;
	}
	// Locality
	if((fields & VCARD_CITY) && ! sp[3].isEmpty())
	{
		result+=((alreadyField)?", ":"") + sp[3];
		alreadyField=true;
	}
	// Region
	if((fields & VCARD_REGION) && ! sp[4].isEmpty())
	{
		result+=((alreadyField)?", ":"") + sp[4];
		alreadyField=true;
	}
	// Postal Code
	if((fields & VCARD_POSTAL_CODE) && ! sp[5].isEmpty())
	{
		result+=((alreadyField)?", ":"") + sp[5];
		alreadyField=true;
	}
	// Country Name
	if((fields & VCARD_COUNTRY) && ! sp[6].isEmpty())
	{
		result+=((alreadyField)?", ":"") + sp[6];
		alreadyField=true;
	}
	return result;
}
QString VCard::recompose()
{
	return mObj->recompose();
}

QString VCard::Version()
{
	QValueList<int> matches;
	matches=mObj->query("version");
	// get the first one!
	return (mObj->getLines()).at(matches[0])->getContent();
}





