/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <metaobject.h>

#ifndef HAS_VCARD
#define HAS_VCARD

// for the N field
#define VCARD_FAMILY_NAME					0x01
#define VCARD_GIVEN_NAME					0x02
#define VCARD_ADDITIONAL_NAMES		0x04
#define VCARD_HONOR_PREFIXES			0x08
#define VCARD_HONOR_SUFFIXES			0x10

#define VCARD_ALL_FIELDS					0xFF

// for the BDATE field
#define VCARD_DATE			0x01
#define VCARD_TIME			0x02

// for the Address field
#define VCARD_PO_BOX					0x01
#define VCARD_EXT_ADDRESS			0x02
#define VCARD_STREET_ADDRESS	0x04
#define VCARD_CITY						0x08
#define VCARD_REGION					0x10
#define VCARD_POSTAL_CODE			0x20
#define VCARD_COUNTRY					0x40

// which in the methods is used for querying the type (type=home) ...

class VCard
{
  public:
    VCard();
    VCard(VCard &);
    VCard(QString s);
    ~VCard();
    VCard& operator=(VCard &);
    MetaObject* data() { return mObj; };
    void setData(MetaObject *);
    QString ID();
    
    // methods operating on the card data; temporary right now
    QString CardName();									// fn
    QString Name(unsigned fields);			// n
    QString EmailPrefered();						// email; type=prefered
		QStringList EmailOthers();					// email; type!=prefered
    QStringList Phone(QString which);		// tel
		QStringList PhoneType(QString which);	// the phone type
		QString Birthday();									// bday
		QString Title();										// title
		QStringList URL();									// URL
		QString Class();										// class
		QString Note();											// note
		QString Categories();								// categories
		QStringList Organisation();					// org
		QString Role();											// role
    QString Nickname();									// nickname
    QString Address(QString which, unsigned fields); // adr
		QString recompose(); // for recomposing the vcard from its fields...
		QString Version(); // returns the version for vCard!
  private:
		QString version(); // returns the version for vCard!
    MetaObject *mObj;
    QString cID;
    void setID();
    static unsigned int lastNumID;
};

#endif








