
#include <kore/version.h>
#include <kore/servicemanager.h>

#include <iostream>

#include "mailfilter_plugin.h"
#include "mailfilterdialog.h"


#define MF_MAJOR 0
#define MF_MINOR 0
#define MF_REVISION 0
#define MF_VERSION "0.0.0"
#define MF_API_MAJOR 0
#define MF_API_MINOR 0
#define MF_API_REVISION 0
#define MF_API_VERSION "0.0.0"
#define MF_NAME "Mail Filter Plugin"
#define MF_TYPE MAILFILTER_TYPE
#define MF_DESCRIPTION "This plugin for filtering your emails."
#define MF_SERVICE MAILFILTER_SERVICE "/filter"
#define MF_SERVICE_DESCRIPTION "'mailfilter'-based '" MAILFILTER_SERVICE "' service"

#include <kconfig.h>
#include <kapp.h>


#include "messagedevice.h"
#include "indexclass.h"
#include "filter.h"

extern KConfig *GlobalConfig;

MailFilter::MailFilter()
{
    _mfVersion = new Version(MF_MAJOR,MF_MINOR,MF_REVISION,MF_VERSION);
    _mfAPIVersion = new Version(MF_API_MAJOR,MF_API_MINOR,MF_API_REVISION,MF_API_VERSION);
    _mfInfo = new Info(this, MF_NAME, MF_TYPE, MF_DESCRIPTION, _mfVersion, _mfAPIVersion);
    setInfo(_mfInfo);
    _mfService = new Service(this, MF_SERVICE, MF_SERVICE_DESCRIPTION);
    addService(_mfService);
    _mfeService = new Service(this, MAILFILTER_SERVICE, MF_SERVICE_DESCRIPTION);
    addService(_mfeService);

    qDebug("Mail Filter loaded");

    filters.setAutoDelete(true);

    readConfig();

}

MailFilter::~MailFilter()
{
    delete _mfInfo;
    delete _mfVersion;
    delete _mfAPIVersion;
    delete _mfService;
    delete _mfeService;
}

void MailFilter::applyFilter( IndexClass *idx, bool useForwardActions )
{
  Filter *f;
  MessageDevice dev(idx);
  dev.loadDescriptor();

  for ( f=filters.first(); f != 0; f=filters.next() )
    if ( f->match( &dev ) )
       f->apply( idx, &dev, useForwardActions );
}

QString MailFilter::messageFolder( MessageClass* message )
{
  Filter *f;
  QString res;

  for ( f=filters.first(); f != 0; f=filters.next() ) {
    res = f->messageFolder(message);
    if ( !res.isNull() )
      return res;
  }

  return QString();
}

void MailFilter::configure(QWidget *w,const char *n)
{
  MailFilterDialog *dlg = new MailFilterDialog(w,n,true);
  dlg->load();

  if ( dlg->exec() ) {
    dlg->sync();
    readConfig();
  }
  delete dlg;
}


void MailFilter::readConfig()
{
   filters.clear();
   KConfig *config = GlobalConfig;
   config->setGroup("MailFilters");
   int fCount = config->readNumEntry("filters_count",0);

   for (int i=0; i<fCount; i++) {
     filters.append( new Filter( config, "MailFilters", i) );
   }

}


