# ---------------------------------------------------------------------------
# - apx-nrply                                                               -
# - afnix:apx reply node class module                                       -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - global section                                                           -
# ----------------------------------------------------------------------------

# the reply node class
const afnix:apx:reply (class)

# ----------------------------------------------------------------------------
# - public section                                                          -
# ----------------------------------------------------------------------------

# the reply tag name
const AFNIX:APX:XML-RPLY-NAME "apx:reply"

# ----------------------------------------------------------------------------
# - private section                                                          -
# ----------------------------------------------------------------------------

# the reply status tag name
const AFNIX:APX:XML-RSTA-NAME "apx:status"

# the reply status attribute name
const AFNIX:APX:XML-RSTA-ATTR "code"

# ----------------------------------------------------------------------------
# - initial section                                                          -
# ----------------------------------------------------------------------------

# initialize the apx reply node

trans afnix:apx:reply:preset nil {
  # set the base message object
  trans this:super (afnix:apx:mesg AFNIX:APX:XML-RPLY-NAME)
}

# ----------------------------------------------------------------------------
# - method section                                                          -
# ----------------------------------------------------------------------------

# add a status code in the reply node
# @param code the reply code to set

trans afnix:apx:reply:set-status (code) {
  # get the head node
  const head (this:get-head-node)
  # check if the status node exists
  if (head:child-p AFNIX:APX:XML-RSTA-NAME) {
    throw "apx-error" "status already exists in reply node"
  }
  # create a status tag
  const rsta (afnix:xml:XmlTag AFNIX:APX:XML-RSTA-NAME)
  rsta:set-attribute AFNIX:APX:XML-RSTA-ATTR code
  # add the node to the head
  head:add-child rsta
}

# @return the reply status code

trans afnix:apx:reply:get-status nil {
  # get the head node
  const head (this:get-head-node)
  # get the status node
  const rsta (head:lookup-child AFNIX:APX:XML-RSTA-NAME)
  # get the status code attribute value
  rsta:get-attribute-value AFNIX:APX:XML-RSTA-ATTR
}
