// ---------------------------------------------------------------------------
// - ccnv.hpp                                                                -
// - standard system library - c conversion function definition              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_CCNV_HPP
#define  AFNIX_CCNV_HPP

#ifndef  AFNIX_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace afnix {
  /// convert an integer to a c-string representation.
  /// @param value the integer value
  /// @return the c-string representation
  char* c_ltoa (const long value);
  
  /// convert a long long integer to a c-string representation
  /// @param value the integer to convert
  /// @return the character buffer
  char* c_lltoa (const t_long value);

  /// convert an integer to a c-string hexadecimal representation.
  /// @param value the integer value
  /// @param pflag the prefix flag
  /// @return the c-string representation
  char* c_ltoh (const long value, const bool pflag);
  
  /// convert a long long integer to a c-string hexadecimal representation
  /// @param value the integer to convert
  /// @param pflag the prefix flag
  /// @return the character buffer
  char* c_lltoh (const t_long value, const bool pflag);
  
  /// convert a char string to a long long integer
  /// @param buffer the buffer to convert
  /// @param status a boolean flag set to true if the conversion succeds
  /// @return a long long integer value
  t_long c_atoll (const char* buffer, bool& status);
  
  /// convert a double float to a c-string representation
  /// @param value the float to convert
  /// @return the character buffer
  char* c_dtoa (const double value);
  
  /// convert a double float to a c-string representation with a format
  /// @param value the float to convert
  /// @param precision the conversion precision
  /// @return the character buffer
  char* c_dtoap (const double value, const long precision);
  
  /// convert a char string to a double float
  /// @param buffer the buffer to convert
  /// @param status a boolean flag set to true if the conversion succeds
  /// @return a double float value
  double c_atod (const char* buffer, bool& status);

  /// @return true if the platform operates in big endian mode
  bool c_isbe (void);

  /// convert a word to an array of bytes
  /// @param value the value to convert
  /// @param array the resulting array
  void c_whton (const t_word value, t_byte* array);

  /// convert an array of bytes to a word
  /// @param array the array to convert
  /// @return the word value
  t_word c_wntoh (const t_byte* array);

  /// swap a word between network and host format
  /// @param value the value to convert
  /// @return the swapped word
  t_word c_wswap (const t_word value);

  /// convert a quad to an array of bytes
  /// @param value the value to convert
  /// @param array the resulting array
  void c_qhton (const t_quad value, t_byte* array);

  /// convert an array of bytes to a quad
  /// @param array the array to convert
  /// @return the quad value
  t_quad c_qntoh (const t_byte* array);

  /// swap a quad between network and host format
  /// @param value the value to convert
  /// @return the swapped quad
  t_quad c_qswap (const t_quad value);

  /// convert an octa to an array of bytes
  /// @param value the value to convert
  /// @param array the resulting array
  void c_ohton (const t_octa value, t_byte* array);

  /// convert an array of bytes to an octa
  /// @param array the array to convert
  /// @return the integer value
  t_octa c_ontoh (const t_byte* array);

  /// swap an octa between network and host format
  /// @param value the value to convert
  /// @return the swapped octa
  t_octa c_oswap (const t_octa value);
}

#endif
