// ---------------------------------------------------------------------------
// - P0002.hxx                                                               -
// - unicode database (ucd) library definitions: plane 2                     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cucd.hpp"

namespace afnix {
  // the plane size
  const long  UCD_PSIZE_0002   = 542;
  // the plane data
  const ucd_s UCD_PLANE_0002[] = {
    {
      0x0002F800,
      "CJK COMPATIBILITY IDEOGRAPH-2F800",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004E3D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F801,
      "CJK COMPATIBILITY IDEOGRAPH-2F801",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004E38, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F802,
      "CJK COMPATIBILITY IDEOGRAPH-2F802",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004E41, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F803,
      "CJK COMPATIBILITY IDEOGRAPH-2F803",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00020122, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F804,
      "CJK COMPATIBILITY IDEOGRAPH-2F804",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004F60, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F805,
      "CJK COMPATIBILITY IDEOGRAPH-2F805",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004FAE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F806,
      "CJK COMPATIBILITY IDEOGRAPH-2F806",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004FBB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F807,
      "CJK COMPATIBILITY IDEOGRAPH-2F807",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005002, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F808,
      "CJK COMPATIBILITY IDEOGRAPH-2F808",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000507A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F809,
      "CJK COMPATIBILITY IDEOGRAPH-2F809",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005099, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F80A,
      "CJK COMPATIBILITY IDEOGRAPH-2F80A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000050E7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F80B,
      "CJK COMPATIBILITY IDEOGRAPH-2F80B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000050CF, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F80C,
      "CJK COMPATIBILITY IDEOGRAPH-2F80C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000349E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F80D,
      "CJK COMPATIBILITY IDEOGRAPH-2F80D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002063A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F80E,
      "CJK COMPATIBILITY IDEOGRAPH-2F80E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000514D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F80F,
      "CJK COMPATIBILITY IDEOGRAPH-2F80F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005154, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F810,
      "CJK COMPATIBILITY IDEOGRAPH-2F810",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005164, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F811,
      "CJK COMPATIBILITY IDEOGRAPH-2F811",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005177, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F812,
      "CJK COMPATIBILITY IDEOGRAPH-2F812",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002051C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F813,
      "CJK COMPATIBILITY IDEOGRAPH-2F813",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000034B9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F814,
      "CJK COMPATIBILITY IDEOGRAPH-2F814",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005167, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F815,
      "CJK COMPATIBILITY IDEOGRAPH-2F815",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000518D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F816,
      "CJK COMPATIBILITY IDEOGRAPH-2F816",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002054B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F817,
      "CJK COMPATIBILITY IDEOGRAPH-2F817",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005197, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F818,
      "CJK COMPATIBILITY IDEOGRAPH-2F818",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000051A4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F819,
      "CJK COMPATIBILITY IDEOGRAPH-2F819",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004ECC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F81A,
      "CJK COMPATIBILITY IDEOGRAPH-2F81A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000051AC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F81B,
      "CJK COMPATIBILITY IDEOGRAPH-2F81B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000051B5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F81C,
      "CJK COMPATIBILITY IDEOGRAPH-2F81C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000291DF, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F81D,
      "CJK COMPATIBILITY IDEOGRAPH-2F81D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000051F5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F81E,
      "CJK COMPATIBILITY IDEOGRAPH-2F81E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005203, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F81F,
      "CJK COMPATIBILITY IDEOGRAPH-2F81F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000034DF, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F820,
      "CJK COMPATIBILITY IDEOGRAPH-2F820",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000523B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F821,
      "CJK COMPATIBILITY IDEOGRAPH-2F821",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005246, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F822,
      "CJK COMPATIBILITY IDEOGRAPH-2F822",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005272, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F823,
      "CJK COMPATIBILITY IDEOGRAPH-2F823",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005277, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F824,
      "CJK COMPATIBILITY IDEOGRAPH-2F824",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003515, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F825,
      "CJK COMPATIBILITY IDEOGRAPH-2F825",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000052C7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F826,
      "CJK COMPATIBILITY IDEOGRAPH-2F826",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000052C9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F827,
      "CJK COMPATIBILITY IDEOGRAPH-2F827",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000052E4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F828,
      "CJK COMPATIBILITY IDEOGRAPH-2F828",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000052FA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F829,
      "CJK COMPATIBILITY IDEOGRAPH-2F829",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005305, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F82A,
      "CJK COMPATIBILITY IDEOGRAPH-2F82A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005306, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F82B,
      "CJK COMPATIBILITY IDEOGRAPH-2F82B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005317, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F82C,
      "CJK COMPATIBILITY IDEOGRAPH-2F82C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005349, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F82D,
      "CJK COMPATIBILITY IDEOGRAPH-2F82D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005351, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F82E,
      "CJK COMPATIBILITY IDEOGRAPH-2F82E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000535A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F82F,
      "CJK COMPATIBILITY IDEOGRAPH-2F82F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005373, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F830,
      "CJK COMPATIBILITY IDEOGRAPH-2F830",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000537D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F831,
      "CJK COMPATIBILITY IDEOGRAPH-2F831",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000537F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F832,
      "CJK COMPATIBILITY IDEOGRAPH-2F832",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000537F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F833,
      "CJK COMPATIBILITY IDEOGRAPH-2F833",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000537F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F834,
      "CJK COMPATIBILITY IDEOGRAPH-2F834",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00020A2C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F835,
      "CJK COMPATIBILITY IDEOGRAPH-2F835",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007070, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F836,
      "CJK COMPATIBILITY IDEOGRAPH-2F836",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000053CA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F837,
      "CJK COMPATIBILITY IDEOGRAPH-2F837",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000053DF, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F838,
      "CJK COMPATIBILITY IDEOGRAPH-2F838",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00020B63, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F839,
      "CJK COMPATIBILITY IDEOGRAPH-2F839",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000053EB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F83A,
      "CJK COMPATIBILITY IDEOGRAPH-2F83A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000053F1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F83B,
      "CJK COMPATIBILITY IDEOGRAPH-2F83B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005406, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F83C,
      "CJK COMPATIBILITY IDEOGRAPH-2F83C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000549E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F83D,
      "CJK COMPATIBILITY IDEOGRAPH-2F83D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005438, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F83E,
      "CJK COMPATIBILITY IDEOGRAPH-2F83E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005448, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F83F,
      "CJK COMPATIBILITY IDEOGRAPH-2F83F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005468, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F840,
      "CJK COMPATIBILITY IDEOGRAPH-2F840",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000054A2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F841,
      "CJK COMPATIBILITY IDEOGRAPH-2F841",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000054F6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F842,
      "CJK COMPATIBILITY IDEOGRAPH-2F842",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005510, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F843,
      "CJK COMPATIBILITY IDEOGRAPH-2F843",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005553, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F844,
      "CJK COMPATIBILITY IDEOGRAPH-2F844",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005563, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F845,
      "CJK COMPATIBILITY IDEOGRAPH-2F845",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005584, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F846,
      "CJK COMPATIBILITY IDEOGRAPH-2F846",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005584, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F847,
      "CJK COMPATIBILITY IDEOGRAPH-2F847",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005599, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F848,
      "CJK COMPATIBILITY IDEOGRAPH-2F848",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000055AB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F849,
      "CJK COMPATIBILITY IDEOGRAPH-2F849",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000055B3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F84A,
      "CJK COMPATIBILITY IDEOGRAPH-2F84A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000055C2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F84B,
      "CJK COMPATIBILITY IDEOGRAPH-2F84B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005716, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F84C,
      "CJK COMPATIBILITY IDEOGRAPH-2F84C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005606, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F84D,
      "CJK COMPATIBILITY IDEOGRAPH-2F84D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005717, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F84E,
      "CJK COMPATIBILITY IDEOGRAPH-2F84E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005651, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F84F,
      "CJK COMPATIBILITY IDEOGRAPH-2F84F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005674, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F850,
      "CJK COMPATIBILITY IDEOGRAPH-2F850",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005207, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F851,
      "CJK COMPATIBILITY IDEOGRAPH-2F851",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000058EE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F852,
      "CJK COMPATIBILITY IDEOGRAPH-2F852",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000057CE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F853,
      "CJK COMPATIBILITY IDEOGRAPH-2F853",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000057F4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F854,
      "CJK COMPATIBILITY IDEOGRAPH-2F854",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000580D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F855,
      "CJK COMPATIBILITY IDEOGRAPH-2F855",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000578B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F856,
      "CJK COMPATIBILITY IDEOGRAPH-2F856",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005832, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F857,
      "CJK COMPATIBILITY IDEOGRAPH-2F857",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005831, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F858,
      "CJK COMPATIBILITY IDEOGRAPH-2F858",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000058AC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F859,
      "CJK COMPATIBILITY IDEOGRAPH-2F859",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000214E4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F85A,
      "CJK COMPATIBILITY IDEOGRAPH-2F85A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000058F2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F85B,
      "CJK COMPATIBILITY IDEOGRAPH-2F85B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000058F7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F85C,
      "CJK COMPATIBILITY IDEOGRAPH-2F85C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005906, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F85D,
      "CJK COMPATIBILITY IDEOGRAPH-2F85D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000591A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F85E,
      "CJK COMPATIBILITY IDEOGRAPH-2F85E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005922, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F85F,
      "CJK COMPATIBILITY IDEOGRAPH-2F85F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005962, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F860,
      "CJK COMPATIBILITY IDEOGRAPH-2F860",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000216A8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F861,
      "CJK COMPATIBILITY IDEOGRAPH-2F861",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000216EA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F862,
      "CJK COMPATIBILITY IDEOGRAPH-2F862",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000059EC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F863,
      "CJK COMPATIBILITY IDEOGRAPH-2F863",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005A1B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F864,
      "CJK COMPATIBILITY IDEOGRAPH-2F864",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005A27, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F865,
      "CJK COMPATIBILITY IDEOGRAPH-2F865",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000059D8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F866,
      "CJK COMPATIBILITY IDEOGRAPH-2F866",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005A66, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F867,
      "CJK COMPATIBILITY IDEOGRAPH-2F867",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000036EE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F868,
      "CJK COMPATIBILITY IDEOGRAPH-2F868",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000036FC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F869,
      "CJK COMPATIBILITY IDEOGRAPH-2F869",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005B08, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F86A,
      "CJK COMPATIBILITY IDEOGRAPH-2F86A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005B3E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F86B,
      "CJK COMPATIBILITY IDEOGRAPH-2F86B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005B3E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F86C,
      "CJK COMPATIBILITY IDEOGRAPH-2F86C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000219C8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F86D,
      "CJK COMPATIBILITY IDEOGRAPH-2F86D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005BC3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F86E,
      "CJK COMPATIBILITY IDEOGRAPH-2F86E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005BD8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F86F,
      "CJK COMPATIBILITY IDEOGRAPH-2F86F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005BE7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F870,
      "CJK COMPATIBILITY IDEOGRAPH-2F870",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005BF3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F871,
      "CJK COMPATIBILITY IDEOGRAPH-2F871",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00021B18, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F872,
      "CJK COMPATIBILITY IDEOGRAPH-2F872",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005BFF, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F873,
      "CJK COMPATIBILITY IDEOGRAPH-2F873",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005C06, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F874,
      "CJK COMPATIBILITY IDEOGRAPH-2F874",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005F53, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F875,
      "CJK COMPATIBILITY IDEOGRAPH-2F875",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005C22, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F876,
      "CJK COMPATIBILITY IDEOGRAPH-2F876",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003781, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F877,
      "CJK COMPATIBILITY IDEOGRAPH-2F877",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005C60, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F878,
      "CJK COMPATIBILITY IDEOGRAPH-2F878",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005C6E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F879,
      "CJK COMPATIBILITY IDEOGRAPH-2F879",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005CC0, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F87A,
      "CJK COMPATIBILITY IDEOGRAPH-2F87A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005C8D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F87B,
      "CJK COMPATIBILITY IDEOGRAPH-2F87B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00021DE4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F87C,
      "CJK COMPATIBILITY IDEOGRAPH-2F87C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005D43, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F87D,
      "CJK COMPATIBILITY IDEOGRAPH-2F87D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00021DE6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F87E,
      "CJK COMPATIBILITY IDEOGRAPH-2F87E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005D6E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F87F,
      "CJK COMPATIBILITY IDEOGRAPH-2F87F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005D6B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F880,
      "CJK COMPATIBILITY IDEOGRAPH-2F880",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005D7C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F881,
      "CJK COMPATIBILITY IDEOGRAPH-2F881",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005DE1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F882,
      "CJK COMPATIBILITY IDEOGRAPH-2F882",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005DE2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F883,
      "CJK COMPATIBILITY IDEOGRAPH-2F883",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000382F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F884,
      "CJK COMPATIBILITY IDEOGRAPH-2F884",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005DFD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F885,
      "CJK COMPATIBILITY IDEOGRAPH-2F885",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005E28, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F886,
      "CJK COMPATIBILITY IDEOGRAPH-2F886",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005E3D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F887,
      "CJK COMPATIBILITY IDEOGRAPH-2F887",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005E69, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F888,
      "CJK COMPATIBILITY IDEOGRAPH-2F888",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003862, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F889,
      "CJK COMPATIBILITY IDEOGRAPH-2F889",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00022183, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F88A,
      "CJK COMPATIBILITY IDEOGRAPH-2F88A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000387C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F88B,
      "CJK COMPATIBILITY IDEOGRAPH-2F88B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005EB0, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F88C,
      "CJK COMPATIBILITY IDEOGRAPH-2F88C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005EB3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F88D,
      "CJK COMPATIBILITY IDEOGRAPH-2F88D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005EB6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F88E,
      "CJK COMPATIBILITY IDEOGRAPH-2F88E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005ECA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F88F,
      "CJK COMPATIBILITY IDEOGRAPH-2F88F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002A392, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F890,
      "CJK COMPATIBILITY IDEOGRAPH-2F890",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005EFE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F891,
      "CJK COMPATIBILITY IDEOGRAPH-2F891",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00022331, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F892,
      "CJK COMPATIBILITY IDEOGRAPH-2F892",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00022331, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F893,
      "CJK COMPATIBILITY IDEOGRAPH-2F893",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008201, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F894,
      "CJK COMPATIBILITY IDEOGRAPH-2F894",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005F22, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F895,
      "CJK COMPATIBILITY IDEOGRAPH-2F895",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005F22, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F896,
      "CJK COMPATIBILITY IDEOGRAPH-2F896",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000038C7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F897,
      "CJK COMPATIBILITY IDEOGRAPH-2F897",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000232B8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F898,
      "CJK COMPATIBILITY IDEOGRAPH-2F898",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000261DA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F899,
      "CJK COMPATIBILITY IDEOGRAPH-2F899",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005F62, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F89A,
      "CJK COMPATIBILITY IDEOGRAPH-2F89A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005F6B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F89B,
      "CJK COMPATIBILITY IDEOGRAPH-2F89B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000038E3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F89C,
      "CJK COMPATIBILITY IDEOGRAPH-2F89C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005F9A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F89D,
      "CJK COMPATIBILITY IDEOGRAPH-2F89D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005FCD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F89E,
      "CJK COMPATIBILITY IDEOGRAPH-2F89E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005FD7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F89F,
      "CJK COMPATIBILITY IDEOGRAPH-2F89F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005FF9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A0,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006081, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A1,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000393A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A2,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000391C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A3,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006094, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A4,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000226D4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A5,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000060C7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A6,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006148, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A7,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000614C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A8,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000614E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8A9,
      "CJK COMPATIBILITY IDEOGRAPH-2F8A9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000614C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8AA,
      "CJK COMPATIBILITY IDEOGRAPH-2F8AA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000617A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8AB,
      "CJK COMPATIBILITY IDEOGRAPH-2F8AB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000618E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8AC,
      "CJK COMPATIBILITY IDEOGRAPH-2F8AC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000061B2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8AD,
      "CJK COMPATIBILITY IDEOGRAPH-2F8AD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000061A4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8AE,
      "CJK COMPATIBILITY IDEOGRAPH-2F8AE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000061AF, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8AF,
      "CJK COMPATIBILITY IDEOGRAPH-2F8AF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000061DE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B0,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000061F2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B1,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000061F6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B2,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006210, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B3,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000621B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B4,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000625D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B5,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000062B1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B6,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000062D4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B7,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006350, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B8,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00022B0C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8B9,
      "CJK COMPATIBILITY IDEOGRAPH-2F8B9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000633D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8BA,
      "CJK COMPATIBILITY IDEOGRAPH-2F8BA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000062FC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8BB,
      "CJK COMPATIBILITY IDEOGRAPH-2F8BB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006368, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8BC,
      "CJK COMPATIBILITY IDEOGRAPH-2F8BC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006383, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8BD,
      "CJK COMPATIBILITY IDEOGRAPH-2F8BD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000063E4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8BE,
      "CJK COMPATIBILITY IDEOGRAPH-2F8BE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00022BF1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8BF,
      "CJK COMPATIBILITY IDEOGRAPH-2F8BF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006422, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C0,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000063C5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C1,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000063A9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C2,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003A2E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C3,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006469, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C4,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000647E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C5,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000649D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C6,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006477, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C7,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003A6C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C8,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000654F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8C9,
      "CJK COMPATIBILITY IDEOGRAPH-2F8C9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000656C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8CA,
      "CJK COMPATIBILITY IDEOGRAPH-2F8CA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002300A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8CB,
      "CJK COMPATIBILITY IDEOGRAPH-2F8CB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000065E3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8CC,
      "CJK COMPATIBILITY IDEOGRAPH-2F8CC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000066F8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8CD,
      "CJK COMPATIBILITY IDEOGRAPH-2F8CD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006649, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8CE,
      "CJK COMPATIBILITY IDEOGRAPH-2F8CE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003B19, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8CF,
      "CJK COMPATIBILITY IDEOGRAPH-2F8CF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006691, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D0,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003B08, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D1,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003AE4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D2,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005192, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D3,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005195, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D4,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006700, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D5,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000669C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D6,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000080AD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D7,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000043D9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D8,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006717, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8D9,
      "CJK COMPATIBILITY IDEOGRAPH-2F8D9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000671B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8DA,
      "CJK COMPATIBILITY IDEOGRAPH-2F8DA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006721, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8DB,
      "CJK COMPATIBILITY IDEOGRAPH-2F8DB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000675E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8DC,
      "CJK COMPATIBILITY IDEOGRAPH-2F8DC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006753, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8DD,
      "CJK COMPATIBILITY IDEOGRAPH-2F8DD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000233C3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8DE,
      "CJK COMPATIBILITY IDEOGRAPH-2F8DE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003B49, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8DF,
      "CJK COMPATIBILITY IDEOGRAPH-2F8DF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000067FA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E0,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006785, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E1,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006852, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E2,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006885, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E3,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002346D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E4,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000688E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E5,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000681F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E6,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006914, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E7,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003B9D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E8,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006942, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8E9,
      "CJK COMPATIBILITY IDEOGRAPH-2F8E9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000069A3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8EA,
      "CJK COMPATIBILITY IDEOGRAPH-2F8EA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000069EA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8EB,
      "CJK COMPATIBILITY IDEOGRAPH-2F8EB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006AA8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8EC,
      "CJK COMPATIBILITY IDEOGRAPH-2F8EC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000236A3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8ED,
      "CJK COMPATIBILITY IDEOGRAPH-2F8ED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006ADB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8EE,
      "CJK COMPATIBILITY IDEOGRAPH-2F8EE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003C18, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8EF,
      "CJK COMPATIBILITY IDEOGRAPH-2F8EF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006B21, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F0,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000238A7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F1,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006B54, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F2,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003C4E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F3,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006B72, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F4,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006B9F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F5,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006BBA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F6,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006BBB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F7,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00023A8D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F8,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00021D0B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8F9,
      "CJK COMPATIBILITY IDEOGRAPH-2F8F9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00023AFA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8FA,
      "CJK COMPATIBILITY IDEOGRAPH-2F8FA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006C4E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8FB,
      "CJK COMPATIBILITY IDEOGRAPH-2F8FB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00023CBC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8FC,
      "CJK COMPATIBILITY IDEOGRAPH-2F8FC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006CBF, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8FD,
      "CJK COMPATIBILITY IDEOGRAPH-2F8FD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006CCD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8FE,
      "CJK COMPATIBILITY IDEOGRAPH-2F8FE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006C67, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F8FF,
      "CJK COMPATIBILITY IDEOGRAPH-2F8FF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006D16, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F900,
      "CJK COMPATIBILITY IDEOGRAPH-2F900",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006D3E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F901,
      "CJK COMPATIBILITY IDEOGRAPH-2F901",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006D77, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F902,
      "CJK COMPATIBILITY IDEOGRAPH-2F902",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006D41, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F903,
      "CJK COMPATIBILITY IDEOGRAPH-2F903",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006D69, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F904,
      "CJK COMPATIBILITY IDEOGRAPH-2F904",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006D78, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F905,
      "CJK COMPATIBILITY IDEOGRAPH-2F905",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006D85, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F906,
      "CJK COMPATIBILITY IDEOGRAPH-2F906",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00023D1E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F907,
      "CJK COMPATIBILITY IDEOGRAPH-2F907",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006D34, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F908,
      "CJK COMPATIBILITY IDEOGRAPH-2F908",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006E2F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F909,
      "CJK COMPATIBILITY IDEOGRAPH-2F909",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006E6E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F90A,
      "CJK COMPATIBILITY IDEOGRAPH-2F90A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003D33, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F90B,
      "CJK COMPATIBILITY IDEOGRAPH-2F90B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006ECB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F90C,
      "CJK COMPATIBILITY IDEOGRAPH-2F90C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006EC7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F90D,
      "CJK COMPATIBILITY IDEOGRAPH-2F90D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00023ED1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F90E,
      "CJK COMPATIBILITY IDEOGRAPH-2F90E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006DF9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F90F,
      "CJK COMPATIBILITY IDEOGRAPH-2F90F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006F6E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F910,
      "CJK COMPATIBILITY IDEOGRAPH-2F910",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00023F5E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F911,
      "CJK COMPATIBILITY IDEOGRAPH-2F911",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00023F8E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F912,
      "CJK COMPATIBILITY IDEOGRAPH-2F912",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00006FC6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F913,
      "CJK COMPATIBILITY IDEOGRAPH-2F913",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007039, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F914,
      "CJK COMPATIBILITY IDEOGRAPH-2F914",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000701E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F915,
      "CJK COMPATIBILITY IDEOGRAPH-2F915",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000701B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F916,
      "CJK COMPATIBILITY IDEOGRAPH-2F916",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003D96, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F917,
      "CJK COMPATIBILITY IDEOGRAPH-2F917",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000704A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F918,
      "CJK COMPATIBILITY IDEOGRAPH-2F918",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000707D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F919,
      "CJK COMPATIBILITY IDEOGRAPH-2F919",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007077, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F91A,
      "CJK COMPATIBILITY IDEOGRAPH-2F91A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000070AD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F91B,
      "CJK COMPATIBILITY IDEOGRAPH-2F91B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00020525, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F91C,
      "CJK COMPATIBILITY IDEOGRAPH-2F91C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007145, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F91D,
      "CJK COMPATIBILITY IDEOGRAPH-2F91D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00024263, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F91E,
      "CJK COMPATIBILITY IDEOGRAPH-2F91E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000719C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F91F,
      "CJK COMPATIBILITY IDEOGRAPH-2F91F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000243AB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F920,
      "CJK COMPATIBILITY IDEOGRAPH-2F920",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007228, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F921,
      "CJK COMPATIBILITY IDEOGRAPH-2F921",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007235, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F922,
      "CJK COMPATIBILITY IDEOGRAPH-2F922",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007250, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F923,
      "CJK COMPATIBILITY IDEOGRAPH-2F923",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00024608, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F924,
      "CJK COMPATIBILITY IDEOGRAPH-2F924",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007280, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F925,
      "CJK COMPATIBILITY IDEOGRAPH-2F925",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007295, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F926,
      "CJK COMPATIBILITY IDEOGRAPH-2F926",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00024735, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F927,
      "CJK COMPATIBILITY IDEOGRAPH-2F927",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00024814, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F928,
      "CJK COMPATIBILITY IDEOGRAPH-2F928",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000737A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F929,
      "CJK COMPATIBILITY IDEOGRAPH-2F929",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000738B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F92A,
      "CJK COMPATIBILITY IDEOGRAPH-2F92A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003EAC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F92B,
      "CJK COMPATIBILITY IDEOGRAPH-2F92B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000073A5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F92C,
      "CJK COMPATIBILITY IDEOGRAPH-2F92C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003EB8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F92D,
      "CJK COMPATIBILITY IDEOGRAPH-2F92D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003EB8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F92E,
      "CJK COMPATIBILITY IDEOGRAPH-2F92E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007447, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F92F,
      "CJK COMPATIBILITY IDEOGRAPH-2F92F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000745C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F930,
      "CJK COMPATIBILITY IDEOGRAPH-2F930",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007471, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F931,
      "CJK COMPATIBILITY IDEOGRAPH-2F931",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007485, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F932,
      "CJK COMPATIBILITY IDEOGRAPH-2F932",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000074CA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F933,
      "CJK COMPATIBILITY IDEOGRAPH-2F933",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003F1B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F934,
      "CJK COMPATIBILITY IDEOGRAPH-2F934",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007524, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F935,
      "CJK COMPATIBILITY IDEOGRAPH-2F935",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00024C36, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F936,
      "CJK COMPATIBILITY IDEOGRAPH-2F936",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000753E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F937,
      "CJK COMPATIBILITY IDEOGRAPH-2F937",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00024C92, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F938,
      "CJK COMPATIBILITY IDEOGRAPH-2F938",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007570, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F939,
      "CJK COMPATIBILITY IDEOGRAPH-2F939",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002219F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F93A,
      "CJK COMPATIBILITY IDEOGRAPH-2F93A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007610, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F93B,
      "CJK COMPATIBILITY IDEOGRAPH-2F93B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00024FA1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F93C,
      "CJK COMPATIBILITY IDEOGRAPH-2F93C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00024FB8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F93D,
      "CJK COMPATIBILITY IDEOGRAPH-2F93D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025044, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F93E,
      "CJK COMPATIBILITY IDEOGRAPH-2F93E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00003FFC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F93F,
      "CJK COMPATIBILITY IDEOGRAPH-2F93F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004008, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F940,
      "CJK COMPATIBILITY IDEOGRAPH-2F940",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000076F4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F941,
      "CJK COMPATIBILITY IDEOGRAPH-2F941",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000250F3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F942,
      "CJK COMPATIBILITY IDEOGRAPH-2F942",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000250F2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F943,
      "CJK COMPATIBILITY IDEOGRAPH-2F943",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025119, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F944,
      "CJK COMPATIBILITY IDEOGRAPH-2F944",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025133, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F945,
      "CJK COMPATIBILITY IDEOGRAPH-2F945",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000771E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F946,
      "CJK COMPATIBILITY IDEOGRAPH-2F946",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000771F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F947,
      "CJK COMPATIBILITY IDEOGRAPH-2F947",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000771F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F948,
      "CJK COMPATIBILITY IDEOGRAPH-2F948",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000774A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F949,
      "CJK COMPATIBILITY IDEOGRAPH-2F949",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004039, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F94A,
      "CJK COMPATIBILITY IDEOGRAPH-2F94A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000778B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F94B,
      "CJK COMPATIBILITY IDEOGRAPH-2F94B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004046, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F94C,
      "CJK COMPATIBILITY IDEOGRAPH-2F94C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004096, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F94D,
      "CJK COMPATIBILITY IDEOGRAPH-2F94D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002541D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F94E,
      "CJK COMPATIBILITY IDEOGRAPH-2F94E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000784E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F94F,
      "CJK COMPATIBILITY IDEOGRAPH-2F94F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000788C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F950,
      "CJK COMPATIBILITY IDEOGRAPH-2F950",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000078CC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F951,
      "CJK COMPATIBILITY IDEOGRAPH-2F951",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000040E3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F952,
      "CJK COMPATIBILITY IDEOGRAPH-2F952",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025626, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F953,
      "CJK COMPATIBILITY IDEOGRAPH-2F953",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007956, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F954,
      "CJK COMPATIBILITY IDEOGRAPH-2F954",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002569A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F955,
      "CJK COMPATIBILITY IDEOGRAPH-2F955",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000256C5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F956,
      "CJK COMPATIBILITY IDEOGRAPH-2F956",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000798F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F957,
      "CJK COMPATIBILITY IDEOGRAPH-2F957",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000079EB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F958,
      "CJK COMPATIBILITY IDEOGRAPH-2F958",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000412F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F959,
      "CJK COMPATIBILITY IDEOGRAPH-2F959",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007A40, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F95A,
      "CJK COMPATIBILITY IDEOGRAPH-2F95A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007A4A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F95B,
      "CJK COMPATIBILITY IDEOGRAPH-2F95B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007A4F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F95C,
      "CJK COMPATIBILITY IDEOGRAPH-2F95C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002597C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F95D,
      "CJK COMPATIBILITY IDEOGRAPH-2F95D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025AA7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F95E,
      "CJK COMPATIBILITY IDEOGRAPH-2F95E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025AA7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F95F,
      "CJK COMPATIBILITY IDEOGRAPH-2F95F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007AEE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F960,
      "CJK COMPATIBILITY IDEOGRAPH-2F960",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004202, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F961,
      "CJK COMPATIBILITY IDEOGRAPH-2F961",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025BAB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F962,
      "CJK COMPATIBILITY IDEOGRAPH-2F962",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007BC6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F963,
      "CJK COMPATIBILITY IDEOGRAPH-2F963",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007BC9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F964,
      "CJK COMPATIBILITY IDEOGRAPH-2F964",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004227, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F965,
      "CJK COMPATIBILITY IDEOGRAPH-2F965",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025C80, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F966,
      "CJK COMPATIBILITY IDEOGRAPH-2F966",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007CD2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F967,
      "CJK COMPATIBILITY IDEOGRAPH-2F967",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000042A0, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F968,
      "CJK COMPATIBILITY IDEOGRAPH-2F968",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007CE8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F969,
      "CJK COMPATIBILITY IDEOGRAPH-2F969",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007CE3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F96A,
      "CJK COMPATIBILITY IDEOGRAPH-2F96A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007D00, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F96B,
      "CJK COMPATIBILITY IDEOGRAPH-2F96B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00025F86, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F96C,
      "CJK COMPATIBILITY IDEOGRAPH-2F96C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007D63, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F96D,
      "CJK COMPATIBILITY IDEOGRAPH-2F96D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004301, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F96E,
      "CJK COMPATIBILITY IDEOGRAPH-2F96E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007DC7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F96F,
      "CJK COMPATIBILITY IDEOGRAPH-2F96F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007E02, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F970,
      "CJK COMPATIBILITY IDEOGRAPH-2F970",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007E45, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F971,
      "CJK COMPATIBILITY IDEOGRAPH-2F971",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004334, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F972,
      "CJK COMPATIBILITY IDEOGRAPH-2F972",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026228, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F973,
      "CJK COMPATIBILITY IDEOGRAPH-2F973",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026247, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F974,
      "CJK COMPATIBILITY IDEOGRAPH-2F974",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004359, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F975,
      "CJK COMPATIBILITY IDEOGRAPH-2F975",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000262D9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F976,
      "CJK COMPATIBILITY IDEOGRAPH-2F976",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007F7A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F977,
      "CJK COMPATIBILITY IDEOGRAPH-2F977",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002633E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F978,
      "CJK COMPATIBILITY IDEOGRAPH-2F978",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007F95, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F979,
      "CJK COMPATIBILITY IDEOGRAPH-2F979",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00007FFA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F97A,
      "CJK COMPATIBILITY IDEOGRAPH-2F97A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008005, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F97B,
      "CJK COMPATIBILITY IDEOGRAPH-2F97B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000264DA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F97C,
      "CJK COMPATIBILITY IDEOGRAPH-2F97C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026523, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F97D,
      "CJK COMPATIBILITY IDEOGRAPH-2F97D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008060, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F97E,
      "CJK COMPATIBILITY IDEOGRAPH-2F97E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000265A8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F97F,
      "CJK COMPATIBILITY IDEOGRAPH-2F97F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008070, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F980,
      "CJK COMPATIBILITY IDEOGRAPH-2F980",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002335F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F981,
      "CJK COMPATIBILITY IDEOGRAPH-2F981",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000043D5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F982,
      "CJK COMPATIBILITY IDEOGRAPH-2F982",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000080B2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F983,
      "CJK COMPATIBILITY IDEOGRAPH-2F983",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008103, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F984,
      "CJK COMPATIBILITY IDEOGRAPH-2F984",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000440B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F985,
      "CJK COMPATIBILITY IDEOGRAPH-2F985",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000813E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F986,
      "CJK COMPATIBILITY IDEOGRAPH-2F986",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005AB5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F987,
      "CJK COMPATIBILITY IDEOGRAPH-2F987",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000267A7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F988,
      "CJK COMPATIBILITY IDEOGRAPH-2F988",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000267B5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F989,
      "CJK COMPATIBILITY IDEOGRAPH-2F989",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00023393, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F98A,
      "CJK COMPATIBILITY IDEOGRAPH-2F98A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002339C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F98B,
      "CJK COMPATIBILITY IDEOGRAPH-2F98B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008201, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F98C,
      "CJK COMPATIBILITY IDEOGRAPH-2F98C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008204, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F98D,
      "CJK COMPATIBILITY IDEOGRAPH-2F98D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008F9E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F98E,
      "CJK COMPATIBILITY IDEOGRAPH-2F98E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000446B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F98F,
      "CJK COMPATIBILITY IDEOGRAPH-2F98F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008291, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F990,
      "CJK COMPATIBILITY IDEOGRAPH-2F990",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000828B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F991,
      "CJK COMPATIBILITY IDEOGRAPH-2F991",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000829D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F992,
      "CJK COMPATIBILITY IDEOGRAPH-2F992",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000052B3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F993,
      "CJK COMPATIBILITY IDEOGRAPH-2F993",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000082B1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F994,
      "CJK COMPATIBILITY IDEOGRAPH-2F994",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000082B3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F995,
      "CJK COMPATIBILITY IDEOGRAPH-2F995",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000082BD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F996,
      "CJK COMPATIBILITY IDEOGRAPH-2F996",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000082E6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F997,
      "CJK COMPATIBILITY IDEOGRAPH-2F997",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026B3C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F998,
      "CJK COMPATIBILITY IDEOGRAPH-2F998",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000082E5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F999,
      "CJK COMPATIBILITY IDEOGRAPH-2F999",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000831D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F99A,
      "CJK COMPATIBILITY IDEOGRAPH-2F99A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008363, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F99B,
      "CJK COMPATIBILITY IDEOGRAPH-2F99B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000083AD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F99C,
      "CJK COMPATIBILITY IDEOGRAPH-2F99C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008323, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F99D,
      "CJK COMPATIBILITY IDEOGRAPH-2F99D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000083BD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F99E,
      "CJK COMPATIBILITY IDEOGRAPH-2F99E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000083E7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F99F,
      "CJK COMPATIBILITY IDEOGRAPH-2F99F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008457, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A0,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008353, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A1,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000083CA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A2,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000083CC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A3,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000083DC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A4,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026C36, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A5,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026D6B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A6,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026CD5, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A7,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000452B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A8,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000084F1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9A9,
      "CJK COMPATIBILITY IDEOGRAPH-2F9A9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000084F3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9AA,
      "CJK COMPATIBILITY IDEOGRAPH-2F9AA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008516, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9AB,
      "CJK COMPATIBILITY IDEOGRAPH-2F9AB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000273CA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9AC,
      "CJK COMPATIBILITY IDEOGRAPH-2F9AC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008564, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9AD,
      "CJK COMPATIBILITY IDEOGRAPH-2F9AD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026F2C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9AE,
      "CJK COMPATIBILITY IDEOGRAPH-2F9AE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000455D, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9AF,
      "CJK COMPATIBILITY IDEOGRAPH-2F9AF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004561, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B0,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00026FB1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B1,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000270D2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B2,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000456B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B3,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008650, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B4,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000865C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B5,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008667, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B6,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008669, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B7,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000086A9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B8,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008688, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9B9,
      "CJK COMPATIBILITY IDEOGRAPH-2F9B9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000870E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9BA,
      "CJK COMPATIBILITY IDEOGRAPH-2F9BA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000086E2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9BB,
      "CJK COMPATIBILITY IDEOGRAPH-2F9BB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008779, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9BC,
      "CJK COMPATIBILITY IDEOGRAPH-2F9BC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008728, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9BD,
      "CJK COMPATIBILITY IDEOGRAPH-2F9BD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000876B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9BE,
      "CJK COMPATIBILITY IDEOGRAPH-2F9BE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008786, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9BF,
      "CJK COMPATIBILITY IDEOGRAPH-2F9BF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000045D7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C0,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000087E1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C1,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008801, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C2,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000045F9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C3,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008860, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C4,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008863, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C5,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00027667, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C6,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000088D7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C7,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000088DE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C8,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004635, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9C9,
      "CJK COMPATIBILITY IDEOGRAPH-2F9C9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000088FA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9CA,
      "CJK COMPATIBILITY IDEOGRAPH-2F9CA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000034BB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9CB,
      "CJK COMPATIBILITY IDEOGRAPH-2F9CB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000278AE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9CC,
      "CJK COMPATIBILITY IDEOGRAPH-2F9CC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00027966, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9CD,
      "CJK COMPATIBILITY IDEOGRAPH-2F9CD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000046BE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9CE,
      "CJK COMPATIBILITY IDEOGRAPH-2F9CE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000046C7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9CF,
      "CJK COMPATIBILITY IDEOGRAPH-2F9CF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008AA0, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D0,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008AED, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D1,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008B8A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D2,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008C55, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D3,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00027CA8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D4,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008CAB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D5,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008CC1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D6,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008D1B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D7,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008D77, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D8,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00027F2F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9D9,
      "CJK COMPATIBILITY IDEOGRAPH-2F9D9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00020804, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9DA,
      "CJK COMPATIBILITY IDEOGRAPH-2F9DA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008DCB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9DB,
      "CJK COMPATIBILITY IDEOGRAPH-2F9DB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008DBC, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9DC,
      "CJK COMPATIBILITY IDEOGRAPH-2F9DC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008DF0, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9DD,
      "CJK COMPATIBILITY IDEOGRAPH-2F9DD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000208DE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9DE,
      "CJK COMPATIBILITY IDEOGRAPH-2F9DE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008ED4, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9DF,
      "CJK COMPATIBILITY IDEOGRAPH-2F9DF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00008F38, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E0,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000285D2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E1,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000285ED, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E2,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009094, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E3,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000090F1, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E4,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009111, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E5,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002872E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E6,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000911B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E7,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009238, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E8,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000092D7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9E9,
      "CJK COMPATIBILITY IDEOGRAPH-2F9E9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000092D8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9EA,
      "CJK COMPATIBILITY IDEOGRAPH-2F9EA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000927C, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9EB,
      "CJK COMPATIBILITY IDEOGRAPH-2F9EB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000093F9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9EC,
      "CJK COMPATIBILITY IDEOGRAPH-2F9EC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009415, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9ED,
      "CJK COMPATIBILITY IDEOGRAPH-2F9ED",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00028BFA, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9EE,
      "CJK COMPATIBILITY IDEOGRAPH-2F9EE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000958B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9EF,
      "CJK COMPATIBILITY IDEOGRAPH-2F9EF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004995, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F0,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F0",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000095B7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F1,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F1",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00028D77, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F2,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F2",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000049E6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F3,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F3",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000096C3, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F4,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F4",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00005DB2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F5,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F5",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009723, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F6,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F6",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00029145, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F7,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F7",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002921A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F8,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F8",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004A6E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9F9,
      "CJK COMPATIBILITY IDEOGRAPH-2F9F9",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004A76, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9FA,
      "CJK COMPATIBILITY IDEOGRAPH-2F9FA",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000097E0, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9FB,
      "CJK COMPATIBILITY IDEOGRAPH-2F9FB",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002940A, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9FC,
      "CJK COMPATIBILITY IDEOGRAPH-2F9FC",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004AB2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9FD,
      "CJK COMPATIBILITY IDEOGRAPH-2F9FD",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00029496, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9FE,
      "CJK COMPATIBILITY IDEOGRAPH-2F9FE",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000980B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002F9FF,
      "CJK COMPATIBILITY IDEOGRAPH-2F9FF",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0000980B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA00,
      "CJK COMPATIBILITY IDEOGRAPH-2FA00",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009829, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA01,
      "CJK COMPATIBILITY IDEOGRAPH-2FA01",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000295B6, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA02,
      "CJK COMPATIBILITY IDEOGRAPH-2FA02",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000098E2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA03,
      "CJK COMPATIBILITY IDEOGRAPH-2FA03",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004B33, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA04,
      "CJK COMPATIBILITY IDEOGRAPH-2FA04",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009929, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA05,
      "CJK COMPATIBILITY IDEOGRAPH-2FA05",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000099A7, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA06,
      "CJK COMPATIBILITY IDEOGRAPH-2FA06",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000099C2, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA07,
      "CJK COMPATIBILITY IDEOGRAPH-2FA07",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x000099FE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA08,
      "CJK COMPATIBILITY IDEOGRAPH-2FA08",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004BCE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA09,
      "CJK COMPATIBILITY IDEOGRAPH-2FA09",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00029B30, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA0A,
      "CJK COMPATIBILITY IDEOGRAPH-2FA0A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009B12, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA0B,
      "CJK COMPATIBILITY IDEOGRAPH-2FA0B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009C40, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA0C,
      "CJK COMPATIBILITY IDEOGRAPH-2FA0C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009CFD, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA0D,
      "CJK COMPATIBILITY IDEOGRAPH-2FA0D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004CCE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA0E,
      "CJK COMPATIBILITY IDEOGRAPH-2FA0E",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004CED, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA0F,
      "CJK COMPATIBILITY IDEOGRAPH-2FA0F",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009D67, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA10,
      "CJK COMPATIBILITY IDEOGRAPH-2FA10",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002A0CE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA11,
      "CJK COMPATIBILITY IDEOGRAPH-2FA11",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004CF8, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA12,
      "CJK COMPATIBILITY IDEOGRAPH-2FA12",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002A105, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA13,
      "CJK COMPATIBILITY IDEOGRAPH-2FA13",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002A20E, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA14,
      "CJK COMPATIBILITY IDEOGRAPH-2FA14",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002A291, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA15,
      "CJK COMPATIBILITY IDEOGRAPH-2FA15",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009EBB, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA16,
      "CJK COMPATIBILITY IDEOGRAPH-2FA16",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00004D56, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA17,
      "CJK COMPATIBILITY IDEOGRAPH-2FA17",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009EF9, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA18,
      "CJK COMPATIBILITY IDEOGRAPH-2FA18",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009EFE, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA19,
      "CJK COMPATIBILITY IDEOGRAPH-2FA19",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009F05, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA1A,
      "CJK COMPATIBILITY IDEOGRAPH-2FA1A",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009F0F, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA1B,
      "CJK COMPATIBILITY IDEOGRAPH-2FA1B",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009F16, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA1C,
      "CJK COMPATIBILITY IDEOGRAPH-2FA1C",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x00009F3B, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    },
    {
      0x0002FA1D,
      "CJK COMPATIBILITY IDEOGRAPH-2FA1D",
      0x04, 0, 0x00, 0x00,
      0x00,
      {0x0002A600, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000,
       0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000},
      {0x00000000, 0x00000000, 0x00000000}
    }
  };
};
