// ---------------------------------------------------------------------------
// - t_trie.cpp                                                              -
// - standard object library - trie class tester                             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Trie.hpp"

int main (int, char**) {
  using namespace afnix;

  // create a new trie
  Trie trie;
  if (trie.length () != 0) return 1;
  String* hello  = new String ("hello");
  String* world  = new String ("world");
  
  // insert out favorite message
  trie.add (*hello, hello);
  trie.add (*world, world);
  // check trie size
  if (trie.length () != 2) return 1;

  // check existence
  if (trie.exists (*hello) == false) return 1;
  if (trie.exists (*world) == false) return 1;

  // ok - everything is fine
  return 0;
}
