# ---------------------------------------------------------------------------
# - TXT0001.als                                                             -
# - afnix:txt module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   hasher test unit
# @author amaury darsch

# get the module
interp:library "afnix-txt"

# ---------------------------------------------------------------------------
# - MD5 test section                                                        -
# ---------------------------------------------------------------------------

# get a default digest (MD5)
const md5 (afnix:txt:Md5)

# check with a string
assert "D41D8CD98F00B204E9800998ECF8427E" (md5:compute "")
assert "0CC175B9C0F1B6A831C399E269772661" (md5:compute "a")
assert "900150983CD24FB0D6963F7D28E17F72" (md5:compute "abc")
assert "5EB63BBBE01EEED093CB22BB8F5ACDC3" (md5:compute "hello world")
assert "F96B697D7CB7938D525A2F31AAF161D0" (md5:compute "message digest")

# check with a buffer
assert "D41D8CD98F00B204E9800998ECF8427E" (md5:compute (Buffer ""))
assert "0CC175B9C0F1B6A831C399E269772661" (md5:compute (Buffer "a"))
assert "900150983CD24FB0D6963F7D28E17F72" (md5:compute (Buffer "abc"))
assert "5EB63BBBE01EEED093CB22BB8F5ACDC3" (md5:compute (Buffer "hello world"))

# ---------------------------------------------------------------------------
# - SHA-1 test section                                                      -
# ---------------------------------------------------------------------------

# get a SHA-1 digest 
const sha-1 (afnix:txt:Sha1)

# check with a string
assert "A9993E364706816ABA3E25717850C26C9CD0D89D" (sha-1:compute "abc")
assert "FAD1FD98E882B0013DD257DF063BF4A2926EDA17" (sha-1:compute "afnix")

# ---------------------------------------------------------------------------
# - SHA-256 test section                                                    -
# ---------------------------------------------------------------------------

# get a SHA-256 digest 
const sha-256 (afnix:txt:Sha256)

# check with a string
trans  MD1 "BA7816BF8F01CFEA414140DE5DAE2223"
trans  MD2 "B00361A396177A9CB410FF61F20015AD"
trans  MDS (+ MD1 MD2)
assert MDS (sha-256:compute "abc")

trans  MD1 "DEBDB627802EECBF0171E229D9470CB6"
trans  MD2 "E94DD7E713D80E61D0B877A01B56AF2F"
trans  MDS (+ MD1 MD2)
assert MDS (sha-256:compute "afnix")

# ---------------------------------------------------------------------------
# - SHA-384 test section                                                    -
# ---------------------------------------------------------------------------

# get a SHA-384 digest 
const sha-384 (afnix:txt:Sha384)

# check with a string
trans  MD1 "CB00753F45A35E8BB5A03D699AC65007272C32AB0EDED163"
trans  MD2 "1A8B605A43FF5BED8086072BA1E7CC2358BAECA134C825A7"
trans  MDS (+ MD1 MD2)
assert MDS (sha-384:compute "abc")

trans  MD1 "33ABEC90674F5DC0823578EF189498FF8B98B8A82FB7CEFD"
trans  MD2 "ACBF39428AAD03213ADCDC1317E884A86A9DEBD2FFF6B3D4"
trans  MDS (+ MD1 MD2)
assert MDS (sha-384:compute "afnix")

# ---------------------------------------------------------------------------
# - SHA-512 test section                                                    -
# ---------------------------------------------------------------------------

# get a SHA-512 digest 
const sha-512 (afnix:txt:Sha512)

# check with a string
trans  MD1 "DDAF35A193617ABACC417349AE20413112E6FA4E89A97EA20A9EEEE64B55D39A"
trans  MD2 "2192992A274FC1A836BA3C23A3FEEBBD454D4423643CE80E2A9AC94FA54CA49F"
trans  MDS (+ MD1 MD2)
assert MDS (sha-512:compute "abc")

# check with a string
trans  MD1 "40B11B89056BBB0BD2266AD30E1ADE9DEE2CECFFB8950A23AE4FE666EC80E054"
trans  MD2 "10727E900029313F1D10269F1609638FB0CB82D419D82743A96167AA1E80E21E"
trans  MDS (+ MD1 MD2)
assert MDS (sha-512:compute "afnix")
