#ifndef __LINKEDLIST_H_
#define __LINKEDLIST_H_

class MudObject;
class Merger;
class Player;

class LinkedNode
{
public:
   LinkedNode(MudObject *the_data);

   void       set_data(MudObject *the_data);
   MudObject  *get_data();
   void       set_next(LinkedNode *nextnode);
   void       set_prev(LinkedNode *prevnode);

   LinkedNode *get_next();
   LinkedNode *get_prev();

private:

  MudObject *data;
  LinkedNode *next;
  LinkedNode *prev;
};

class LinkedList
{
public:
   LinkedList();
   ~LinkedList();
   int  add_entry(MudObject *new_entry);
   int  del_entry(MudObject *entry);
   int  del_cur_entry();
   void reset_current();
   LinkedNode *store_current();
   void restore_current(LinkedNode *new_current);
   MudObject *get_next();
   MudObject *get_prev();
   MudObject *get_first();
   MudObject *find(char *the_name, int *the_num);
   MudObject *find_by_objname(char *the_name, char *the_area);
   MudObject *find_altname(char *the_name);
   Merger *get_same_merger(char *the_parent);

   int display_list(Player *the_player);

   int get_mem_size();
   int get_mem_size_dynamic();

private:
   LinkedNode *root;
   LinkedNode *current;
};
 
#endif



