#ifndef _MUDTYPES_H_
#define _MUDTYPES_H_


class Code;
class Specials;
class MudObject;
struct params;
struct in_params;
struct special_env;


#define MAXNAMELEN     80   /* max length a mudobject name can have */
#define MAXFILENAMELEN 60   /* max length of a filename that we will allow */
#define MAXTITLELEN    80
#define MAX_COM_LEN    600  /* max length for communications */
#define MAX_VERB_LEN   16   /* max length a command (verb) can be */
#define MAXPROMPTLEN   100  /* max length of a user prompt */
#define MAX_MUTEX_SEC  3    /* max seconds we try to lock a mutex */

#define CPP  "/usr/lib/cpp -P -traditional -I../src"  /* C preprocessor */

#define END_TABLE      -1   /* signifies the end of a table */

//the ifdef that follows is for use by compiler that don't have bool builtin.
//Uncomment DEF in the Makefile to define BOOL_COMPAT. 
#ifdef BOOL_COMPAT
typedef enum { false, true } bool;
#endif

enum load_type { None, Header, Full };

class Player;
class Parse;
typedef void (*Cmd_Func)(Parse *, MudObject *); 
typedef params *(*Spec_Func)(params *, Specials *, Player *, in_params *, 
                                         special_env *, int *);
typedef int (*Inp_Func)(MudObject *, char *); 


#endif


