#ifndef __LINKEDLIST_H_
#define __LINKEDLIST_H_

template<class TYPE>
class LinkedNode
{
public:
   LinkedNode(TYPE *the_data);

   void       set_data(TYPE *the_data);
   TYPE       *get_data();
   void       del_data();
   void       set_next(LinkedNode<TYPE> *nextnode);
   void       set_prev(LinkedNode<TYPE> *prevnode);

   LinkedNode *get_next();
   LinkedNode *get_prev();

private:

  TYPE *data;
  LinkedNode<TYPE> *next;
  LinkedNode<TYPE> *prev;
};

template<class TYPE>
class cur_ptr {
 public:
  cur_ptr();
  ~cur_ptr();

  LinkedNode<TYPE> *current;  
  cur_ptr *next;
};


template<class TYPE>
class LinkedList
{
public:
   LinkedList();
   ~LinkedList();
   void clr_list();
   int  add_tail_entry(TYPE *new_entry);
   int  add_entry(TYPE *new_entry);
   int  del_entry(TYPE *entry);
   int  del_cur_entry();
   void reset_current();
   int  push_current();
   int  pop_current();
   TYPE *get_next();
   TYPE *get_prev();
   TYPE *get_first();
   void set_del_data();

   int get_mem_size();
   int get_mem_size_dynamic();
   int get_mem_size_linkedlist();

private:
   LinkedNode<TYPE> *root;
   cur_ptr<TYPE> *cur_list;

   int del_data;  // Should data be deleted when the entry is?  Default no
};
 
#endif



