#
# Copyright 2004 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test "require" tag
#
# $Id: require.py 6204 2005-03-01 03:12:17Z andrewm $

import unittest
import albatross
import albatross_test

class RequireCase(albatross_test.AlbatrossTestCase):
    template_dir = "require"

    def check_require(self):
        self.short_html_test("<al-require>", "")
        self.assertRaises(albatross.ApplicationError, self.short_html_test,
                          "<al-require nosuchattribute=\"\">", "")

    def check_require_version(self):
        fmt = "<al-require version=\"%d\">"
        self.short_html_test(fmt % albatross.template_version, "")
        self.short_html_test(fmt % (albatross.template_version - 1), "")
        self.assertRaises(albatross.ApplicationError, self.short_html_test,
                          fmt % (albatross.template_version + 1), "")

    def check_require_feature(self):
        self.short_html_test("<al-require feature=\"\">", "")
        self.assertRaises(albatross.ApplicationError, self.short_html_test,
                          "<al-require feature=\"nosuchfeature\">", "")

class RequireSuite(unittest.TestSuite):
    test_list = (
        "check_require",
        "check_require_version",
        "check_require_feature",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(RequireCase, self.test_list))

def suite():
    return RequireSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
