# ----------------------------------------------------------------------------
# - aleph-defs                                                               -
# - aleph definition make file configuration                                 -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2001 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - distribution path definition                                             -
# ----------------------------------------------------------------------------

CNFDIR          = $(TOPDIR)/cnf
SRCDIR		= $(TOPDIR)/src
BLDDIR          = $(TOPDIR)/bld
TEXDIR		= $(TOPDIR)/tex
ETCDIR		= $(TOPDIR)/etc
EXPDIR		= $(TOPDIR)/exp
EXTDIR		= $(SRCDIR)/ext

# ----------------------------------------------------------------------------
# - build path definition                                                    -
# ----------------------------------------------------------------------------

BLDBIN		= $(BLDDIR)/bin
BLDLIB		= $(BLDDIR)/lib
BLDHDR		= $(BLDDIR)/hdr
BLDDOC		= $(BLDDIR)/aleph-doc-$(MAJOR)-$(MINOR)-$(PATCH)
BLDDST		= $(BLDDIR)/aleph-src-$(MAJOR)-$(MINOR)-$(PATCH)

# ----------------------------------------------------------------------------
# - indirect project definition                                              -
# ----------------------------------------------------------------------------

ALPBLD          = $(BLDDIR)
ALPBIN          = $(BLDLIB)
ALPLIB          = $(BLDLIB)
ALPHDR          = $(BLDHDR)

# ----------------------------------------------------------------------------
# - install path definition                                                  -
# ----------------------------------------------------------------------------

BINDIR		= $(PREFIX)/bin
LIBDIR		= $(PREFIX)/lib
HDRDIR		= $(PREFIX)/include/aleph
DOCDIR		= $(PREFIX)/doc/aleph
MANDIR		= $(PREFIX)/man
ETCDIR		= $(PREFIX)/etc/aleph

# ----------------------------------------------------------------------------
# - other shared commands and scripts                                        -
# ----------------------------------------------------------------------------

MKDIR           = $(CNFDIR)/bin/aleph-mkdir
ATEST		= $(CNFDIR)/bin/aleph-atest
BTEST		= $(CNFDIR)/bin/aleph-btest
LTEST		= $(CNFDIR)/bin/aleph-ltest
XTEST		= $(CNFDIR)/bin/aleph-xtest
AXRUN		= $(CNFDIR)/bin/aleph-axrun

# ----------------------------------------------------------------------------
# - configuration definitions                                                -
# ----------------------------------------------------------------------------

CNFDEFINES	= -DPLATNAME=\"$(PLATNAME)\" 
CNFDEFINES     += -DPLATVERS=\"$(PLATVERS)\"
CNFDEFINES     += -DPLATVMAJ=\"$(PLATVMAJ)\"
CNFDEFINES     += -DPLATVMIN=\"$(PLATVMIN)\"
CNFDEFINES     += -DPROCNAME=\"$(PROCNAME)\"
CNFDEFINES     += -DPROCTYPE=\"$(PROCTYPE)\"
CNFDEFINES     += -DPLTMAJOR=\"$(MAJOR)\"
CNFDEFINES     += -DPLTMINOR=\"$(MINOR)\"
CNFDEFINES     += -DPLTPATCH=\"$(PATCH)\"
CNFDEFINES     += -DLINKTYPE=\"$(LKTYPE)\"
