// ---------------------------------------------------------------------------
// - Main.cpp                                                                -
// - the aleph interpreter main program  (static version)                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Interp.hpp"
#include "Options.hpp"
#include "Libasys.hpp"
#include "Libasio.hpp"
#include "Libanet.hpp"
#include "Libawww.hpp"
#include "Library.hpp"

// main interpreter 

int main (int argc, char** argv) {
  using namespace aleph;

  // create a new option instance
  Options* options = new Options (argc,argv);

  // register the standard libraries
  Library::stareg ("aleph-sys", (void*) init_aleph_sys);
  Library::stareg ("aleph-sio", (void*) init_aleph_sio);
  Library::stareg ("aleph-net", (void*) init_aleph_net);
  Library::stareg ("aleph-www", (void*) init_aleph_www);

  // get the optional file name
  String fname = options->getfname ();
  bool   sflag = (fname.length () == 0);

  // create a new interpreter
  Input*  is = nilp;
  Output* os = nilp;
  Output* es = nilp;
  Interp* interp = (sflag == true) ? new Interp : new Interp (is,os,es);

  // set some interpreter flags
  interp->setassert (options->getassert ());
  interp->setargs   (options->getargs   ());
  interp->setpath   (options->getpath   ());

  // loop or execute on the standard input or a file
  bool status = false;
  try {
    status = (sflag == true) ? interp->loop () : interp->loop (fname); 
  } catch (...) {
    status = false;
  }

  // clean eveything and return
  delete options;
  delete interp;
  return status ? 0 : 1;
}
