// ---------------------------------------------------------------------------
// - Url.hpp                                                                 -
// - aleph:www library - url class definition                                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_URL_HPP
#define  ALEPH_URL_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The Url class is a base object used to parse or build URL. The URL
  /// can be built by specifiying each component. When a string is given
  /// in the constructor, the class parse the string and extract all
  /// components. The URL components are the scheme, the host, the port,
  /// the path, the query and the fragment. The class takes care of the
  /// character escaping.
  /// @author amaury darsch

  class Url : public Object {
  private:
    /// the url scheme
    String d_scheme;
    /// the url host
    String d_host;
    /// the url port
    long   d_port;
    /// the url path
    String d_path;
    /// the url query
    String d_query;
    /// the url fragment
    String d_fragment;

  public:
    /// create an empty URL
    Url (void);

    /// create a URL by string
    /// @param url the string to parse
    Url (const String& url);

    /// @return the class name
    String repr (void) const;

    /// parse an url by name
    /// @param url the url to parse
    void parse (const String& url);

    /// reset an url name to its default
    void reset (void);

    /// @return this url scheme
    String getscheme (void) const;

    /// @return this url host
    String gethost (void) const;

    /// @return this url port
    long getport (void) const;

    /// @return this url path
    String getpath (void) const;

    /// @return this url query
    String getquery (void) const;

    /// @return this url fragment
    String getfragment (void) const;

    /// generate a new url object
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// apply this url with a set of arguments and a quark
    /// @param robj  robj the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);

  private:
    // make the copy constructor private
    Url (const Url&);
    // make the assignment operator private
    Url& operator = (const Url&);
  };
}

#endif
