// ---------------------------------------------------------------------------
// - cmem.hpp                                                                -
// - standard system library - c memory function definitions                 -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_CMEM_HPP
#define  ALEPH_CMEM_HPP

#ifndef  ALEPH_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace aleph {

  /// allocate some memory
  /// @param size the size to allocate
  void* c_malloc (const long size);

  /// free some memory
  /// @param ptr the memory handle
  void c_free (void* ptr);

  /// allocate some memory for tracing
  /// @param size the memory to allocate
  void* c_galloc (const long size);

  /// free some previously traced memory
  /// @param ptr the pointer to free
  void c_gfree (void* ptr);

  /// register a memory cleanup function
  /// @param func the cleanup function
  void c_gcleanup (void (*func) (void));

  /// @return the system page size
  long c_pagesize (void);

  /// allocate some memory.
  /// @param size the size to allocate
  /// @return the base pointer of the allocated memory
  void* c_mmap (const long size);

  /// map a file to to some memory
  /// @param sid the file descriptor
  /// @param size the size to map
  /// @param foff the file offset to use
  void* c_mmap (const int sid, const long size, const long foff);

  /// reallocate a memory previously allocated with c_mmap
  /// @param optr  the old base memory pointer
  /// @param osize the old memory size
  /// @param nsize the new memory size
  /// @return the base pointer of the new allocated memory
  void* c_mremap (void* optr, const long osize, const long nsize);

  /// deallocate a memory block previously allocated with c_mmap
  /// @param ptr the base memory pointer
  /// @param size the size of the memory block
  void c_munmap (void* ptr, const long size);
}

#endif
