// ---------------------------------------------------------------------------
// - Runnable.hpp                                                            -
// - standard object library - runnable abstract class definition i          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_RUNNABLE_HPP
#define  ALEPH_RUNNABLE_HPP

#ifndef  ALEPH_OBJECT_HPP
#include "Object.hpp"
#endif

namespace aleph {

  /// The Runnable class is the virtual class used as an interface to the 
  /// thread management system. The class define a single method called 'run'
  /// which is called when the thread is created.
  /// @author amaury darsch

  class Runnable : public Object  {
  public:
    /// post an object in this runnable class
    /// @param object the object to post
    virtual void post (Object* object) =0;

    /// run the method when the thread is started
    virtual Object* run (void) =0;

    /// evaluate a form in a thread
    /// @param form the form to evaluate
    virtual Object* launch (Object* form) =0;

    /// evaluate a form in a daemon thread
    /// @param form the form to evaluate
    virtual Object* daemon (Object* form) =0;

    /// @return the runnable input stream
    virtual class Input* getis (void) const =0;

    /// @return the runnable output stream
    virtual class Output* getos (void) const =0;

    /// @return the runnable error stream
    virtual class Output* getes (void) const =0;

    /// @return the runnable stack
    virtual class Stack* getstk (void) const =0;

    /// @return the runnable global nameset
    virtual Nameset* getgset (void) const =0;

    /// @return the runnable assert flag
    virtual bool getassert (void) const =0;
  };
}

#endif
