// ---------------------------------------------------------------------------
// - t_string.cpp                                                            -
// - standard object library - string class tester                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "String.hpp"
#include "Exception.hpp"

int main (int, char**) {
  using namespace aleph;

  // create a default null string
  String s1;

  // check for length equal to 0
  if (s1.length () != 0) return 1;

  // check for null string definition
  if (s1 != "") return 1;

  // add the magic string into it
  s1 = "hello world";

  // check for the length again
  if (s1.length () != 11) return 1;

  // create a second string
  String s2 = "hello world";

  // check for the length again
  if (s2.length () != 11) return 1;

  // compare the two string
  if ((s1 == s2) != true)            return 1;
  if ((s1 == "hello world") != true) return 1;
  if (s1 != s2)                      return 1;

  // check for concatenation
  String hello = "hello";
  hello = hello + ':' + "world";
  if (hello != "hello:world") return 1;

  // check for character access
  if (s1[0] != 'h') return 1;

  // check for substring
  String label = "@label";
  if (label.rsubstr (1) != "label") return 1;

  // everything is fine
  return 0;
}
