#  ICQ client library
#  Version 0.2	
#  Copyright (C) Ihar Viarheichyk 2001

#  This library gives ability to use ICQ v8 protocol (OSCAR) in tcl programs.
#  Protocol description and some ideas in implementattion were taken from 
#  ICQ2000.pm and ICQ2000_Easy.pm perl modules by
#  Robin Fisher <robin@phase3solutions.com> and vICQ program by 
#  Alexander Timoshenko

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
	       
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

package provide icq 0.31

namespace eval icq {

	variable counter 0
	variable SeqNum	3412
	variable delim [binary format c1 0xFE]
	variable Defaults {	-server		"login.icq.com"
				-port		5190
				-uin		0
				-password	""
				-encoding	""
				-register	{}
				-contactslist	{}
				-visiblelist	{}
				-invisiblelist	{}
				-reconnect	"no"
				-status		"online"
				-eventproc	{}
				-logproc	puts 
				ClientProfile	"ICQ Inc. - Product of ICQ (TM).2000b.4.63.1.3279.85"
				Language	"en"	Country "us"
				ClientType	266
				VersionMaj	4	VersionMin 63
				IcqNumber	1
				BuildMaj	3279	BuildMin 85
				Header		""	Body ""		WaitFor "Header"
				Length		6
				Flags		2
				Cookie		""
				Request		2
				MyStatus	"offline"
				proxy		"Http"
				direct 		0
				direct_ip	0
				glue		{<...>}
				direct_port	4000
				send_queue {}
				-proxy_server	""
				-proxy_port	 	443
				-proxy_user		""
				-proxy_password ""
			}

variable TLVBase {
		1	1 -uin			a*	
		2	1 -password		a*
		3	1 ClientProfile		a*
		5	1 UserInfo		a*
		6	1 Cookie		a*
		14	1 Country		a*
		15	1 Language		a*
		20	1 BuildMin		I
		22	1 ClientType		S
		23	1 VersionMaj		S
		24	1 VersionMin		S
		25	1 IcqNumber		S
		26	1 BuildMaj		S
                          
		1	2 UserClass		S
		2	2 SignupDate		I
		3	2 SignonDate		I
		4	2 Port			S
		5	2 EncodedMsg		a*
		6	2 Status		I
		8	2 ErrCode		S
		10	2 IP			I
		11	2 WebAddr		a*
		12	2 LanDetails		a*
		13	2 Unknown03		a*
		15	2 TimeOnline		I
		12  2 DC			a*
		          
		1	4 UIN			a
		4	4 HtmlAddr		a
		5	4 ServerAndPort		a
		6	4 Cookie		a
		8	4 ErrCode		S
		9	4 DisconnectCode	a
		18  2 Unk1			S
		0	0 NotFound		a
	}
array set StatusCode {  online		0
			away            1
			na              5
			occ				17
			dnd             19
			ffc				32
			invisible       256
		}
array set StatusName { 0 online
			1		away
			5		na
			17		occ
			19		dnd
			32      ffc
			256		invisible
		}
array set ErrorString { 24	"Connection rate exceeded" 
			5	"Wrong password" }
namespace export icq

proc log {level str} {
	if {$::icq::data(-logproc)!={puts}} {
		$::icq::data(-logproc) $level $str
	} else {puts $str}
}

proc icq {args} {
	upvar #0 icq::data data

	array set data $icq::Defaults
	set options [lsort [array names data -*]]
	foreach {option value} $args {
		if {[lsearch -exact $options $option]==-1} {
			return -code error "Unknown option $option"
		}
		set data($option) $value
	}
	if {$data(-password)!={}} {
		set data(-password) [EncryptPassword $data(-password)]
	}
	array set TLV {}
	if {$data(proxy)!="" && $data(-proxy_server)!=""} {
			uplevel #0 "package require proxy"
	}
	package require direct
	set data(direct) [direct::Start]
	if {$data(-status)!="offline"} { Connect $data(-server) $data(-port) }
}

proc CallHandlers {Event args} {
	upvar #0 icq::data data
	if {[info exists data(-eventproc)] && $data(-eventproc)!={}} {
		eval $data(-eventproc) $Event $args
	}
}
	
proc ReadData {} {
	upvar #0 icq::data data
	set bytes [read $data(socket) 1]
	if { $bytes=="" } {
		CloseConnection
		if {[string is true $data(-reconnect)]} {
			Connect $data(-server) $data(-port)
		}
		return 
	}
	append data($data(WaitFor)) $bytes
	incr data(Length) -1
	if { ! $data(Length) } {
		# Header
		if {$data(WaitFor)=="Header"} {
			binary scan $data(Header) c1@4S1 PacketId Size
			if {$PacketId != 42} { log 1 "Warning! Unaligned data!" }
			set data(WaitFor) "Body"
			set data(Length) $Size
			set data(Body) ""
		} else {
			set data(WaitFor) "Header"
			# Parse packet
			ParsePacket 
			set data(Length) 6
			set data(Header) ""
			set data(Body) ""
		}
	}
}
proc ParsePacket {} {
	upvar #0 icq::data data
	variable Containers
	
	binary scan $data(Header) c1c1S1S1 Tag ChanId SeqId Size
	binary scan $data(Body) S1S1 Family SubId
	if {$ChanId==1 || $ChanId==4} {
		set Family 0
		set SubId 0
	}
	set Msg "$ChanId:$Family:$SubId"
	if {[llength [info commands $Msg]]==1} { $Msg } else {
		log 10 "There is no handler for message $Msg"
		binary scan $data(Body) H* hex; log 10 $hex
	}
}
# These are handlers for server messages

# Login negotiation
proc 1:0:0 {} {
	upvar #0 icq::data data
	log 3 "Got login invitation, logging in"
	if {$data(-register)!={}} { 
		Register $data(-register)
		return
	}

	set LoginTLV {}
	if {$data(Cookie)!=""} {
		lappend LoginTLV Cookie $data(Cookie)
		log 3 "Using cookie"
	}
	foreach option {-uin -password ClientProfile ClientType \
		VersionMaj VersionMin IcqNumber BuildMaj BuildMin Language Country} {
		lappend LoginTLV $option $data($option)
	}
	Command 1:0:0 $LoginTLV
}
# Disconnect negotiation
proc 4:0:0 {} {
	upvar #0 icq::data data icq::TLV TLV
	variable ErrorString
	
	log 3 "Disconnect command"
	GetTLVs 4 0 $data(Body)
	CloseConnection
	if { [info exists TLV(Cookie)] && [info exists TLV(ServerAndPort)] } {
		set data(Cookie) $TLV(Cookie)
		log 3 "Server wants us to reconnect to $TLV(ServerAndPort)"
		eval Connect [split $TLV(ServerAndPort) :]
		return 
	}
	if {[info exists TLV(ErrCode)]} {
		if {[info exists ErrorString($TLV(ErrCode))]} {
			 set error_string $ErrorString($TLV(ErrCode))
		} else { set error_string "Unknown" }
		CallHandlers Error 4:$TLV(ErrCode) $error_string
		return
	}
	if {[string is true $data(-reconnect)]} { Connect $data(-server) $data(-port) }
	log 2 "stub: No disconnect handler here"
}

# Server Ready 
proc 2:1:3 {} {
	Command 2:1:23 {List {0 1 0 3 0 2 0 1 0 3 0 1 0 21 0 1 0 4 0 1 0 6 0 \
			      1 0 9 0 1 0 10 0 1}}
	OfflineMessagesRequest
}
# Rate info answer
proc 2:1:7 {} {
	#Rate info ack
	Command 2:1:8 {List {0 1 0 2 0 3 0 4 0 5}}
	# Some requests
	foreach cmd {2:1:14 2:2:2 2:3:2 2:4:4 2:9:2} { Command $cmd {}}
}
# My status
proc 2:1:15 {} {
	upvar #0 icq::data data icq::TLV TLV
	variable StatusName	

	set offset 10
	binary scan $data(Body) @${offset}c len
	incr offset
	binary scan $data(Body) @${offset}a${len} User
	incr offset $len
	binary scan $data(Body) @${offset}S WarningLevel
	
	GetTLVs 2 $offset $data(Body)
	if {$data(MyStatus)=="offline"}  { 
		UploadList contacts $data(-contactslist) 
	}
	set data(MyStatus) $StatusName([expr $TLV(Status)&65535])
	if {$data(MyStatus)=="invisible"} { UploadList visible $data(-visiblelist) }
	CallHandlers MyStatus $data(MyStatus)
}
# Conact online
proc 2:3:11 {} {
	variable StatusName
	upvar #0 icq::data data icq::TLV TLV 

	binary scan $data(Body) @10c len
	binary scan $data(Body) @11a${len} UIN

	GetTLVs 2 [expr 11+$len] $data(Body)

	set status [expr $TLV(Status)&65535]
	if {[info exists StatusName($status)]} {
		set str [list $UIN $StatusName($status) $TLV(IP)]
		if [info exists TLV(LanDetails)] {
			binary scan $TLV(LanDetails) IIcS LanIP LanPort ConnType ICQVer
			log 10 "Aux info: LanPort=$LanPort ConnType=$ConnType ICQ=$ICQVer"
			set str [concat $str $LanIP $LanPort $ConnType $ICQVer]
		}
		eval CallHandlers ContactStatus $str 
	}
}
# Contact offline
proc 2:3:12 {} {
	upvar #0 icq::data data icq::TLV TLV

	binary scan $data(Body) @10c len
	binary scan $data(Body) @11a${len} UIN

	GetTLVs 2 [expr 11+$len] $data(Body)

	CallHandlers ContactStatus $UIN offline
}
# Request rate info
proc 2:1:24 {} {
	upvar #0 icq::data data
	#Set status
	set status_cmd [list Status\
		[expr ($data(Flags)<<16)+$icq::StatusCode($data(-status))]]
	if {$data(direct)} { 
		set status_cmd [concat $status_cmd [list ErrCode 0 DC [direct::Status] Unk1 0]]
	}
	Command 2:1:30 $status_cmd
	# Strange command (maybe remove it?)
	Command 2:1:17 {List {0 0 0 0}}
	#Client ready
	Command 2:1:2 {List {0 1 0 3 1 16 2 138 0 2 0 1 1 1 2 138 0 3 0 1\
			1 16 2 138 0 21 0 1 1 16 2 138 0 4 0 1 1 16 2 183 \
			0 6 0 1 1 16 2 183 0 9 0 1 1 16 2 183 0 10 0 1 1 16\
			2 183}}
}

# Error message
proc 2:1:1 {} {
	upvar #0 icq::data data icq::TLV TLV
	CallHandlers Error 2:0
}

proc ParseEncodedMessage {Message {parm {}}} {
	set items [split $Message $icq::delim]
	binary scan [lindex $items 0] ${parm}a* Sender
	set mail [lindex $items 3]
	set Message [FromWire [lindex $items 5]]
	set Message [string range $Message 0 [expr [string length $Message]-2]]
	set Message "From: [FromWire $Sender]\nE-Mail: [FromWire $mail]\n$Message"
	CallHandlers "IncomingMessage" 0 [clock seconds] $Message
}
# Message Received
proc 2:4:7 {} {
	upvar #0 icq::data data icq::TLV TLV
	set Message ""
	binary scan $data(Body) @19c SenderType
	binary scan $data(Body) @20c DataSize
	binary scan $data(Body) @21a$DataSize Sender
	set pos [GetTLVs 2 [expr 21+$DataSize] $data(Body)]
	if {[info exists TLV(EncodedMsg)]} {
		ParseEncodedMessage	$TLV(EncodedMsg) @8
		return
	}
	binary scan $data(Body) @${pos}SS MessageType DataLength
	set DataLength [expr ($DataLength+0x10000)%0x10000]
	binary scan $data(Body) @[expr $pos+4]a$DataLength RawMessage
	if {$MessageType==2} {
		#binary scan $data(Body) @[expr $pos+4]a$DataLength RawMessage
		# workaround for gaim messages
		binary scan $RawMessage @3c Adder
		binary scan $RawMessage @[expr 6+$Adder]S TextLen
		set TextLen [expr ($TextLen+0x10000)%0x10000]
		binary scan $RawMessage @[expr 12+$Adder]a[expr $TextLen-4] Message
	
		set Message [FromWire $Message]
		if [string match "$data(glue)*" $Message] {
			if [info exists data(incomplete:$Sender)] {
				set prev $data(incomplete:$Sender)	
			} else { set prev {} }
			set msg [string range $Message [string length $data(glue)] end]
			set Message $prev$msg
		}
		if [string match "*$data(glue)" $Message] {
			set data(incomplete:$Sender) [string range $Message 0 end-[string length $data(glue)]]
			return
		}
		if [info exists data(incomplete:$Sender)] {unset data(incomplete:$Sender)}
		CallHandlers "IncomingMessage" $Sender [clock seconds] $Message 
		return
	}
	if {$MessageType==5} {
		binary scan $RawMessage @4c1 SubType
		set ids {}
		switch $SubType {
			12 { log 3 "You have been included to contact list. Don't know what to do else :)"
				 CallHandlers AddedToContactList 	
			   }
			6  { binary scan $RawMessage ix4a* UIN Request
			     foreach id {nick fname lname email xxx reason} val [split $Request $icq::delim] {
			     	lappend ids $id $val
			     }
			     CallHandlers "AuthorizationRequest" $UIN $ids
			   }
			 7 { binary scan $RawMessage i UIN
				 log 3 "Authorization rejected"	 
			 	 CallHandlers "AuthorizationDenied" $UIN
			 	}
			 8 {
				 binary scan $RawMessage i UIN
				 log 3 "Authorization given"	 
				 CallHandlers "AuthorizationGiven" $UIN
			   }
			 4 {binary scan $RawMessage @6s DataLength
			    binary scan $RawMessage @8a[expr $DataLength-1] Data
				foreach item [split $Data $icq::delim] {
			  		lappend ids [FromWire $item]
				}
			    CallHandlers IncomingURL $Sender [clock seconds] $ids 
			   }
			26 { log 3 "Contact request"
			   }
			19 { log 3 "Contacts"
			     binary scan $RawMessage @8a* PackedContacts
			     set Contacts {}
			     foreach {elem} [split $PackedContacts $icq::delim] {
				     lappend Contacts [FromWire $elem]
			     }
			     set amount [lindex $Contacts 0]
			     CallHandlers "Contacts" $Sender $amount [lrange $Contacts 1 [expr $amount*2]]
			   }
			 * { log 1 "Unknown subtype -----> $SubType"
				 binary scan $RawMessage H* hex; log 3 $hex
			   }
		}
		return
	}
	log 1 "Message type $MessageType is not supported yet"
}

# All ICQ-specific stuff not fitting to original OSCAR
proc 2:21:3 {} {
	upvar #0 icq::data data icq::TLV TLV

	binary scan $data(Body) @4SS Flags Ref
	binary scan $data(Body) @16isa* MyUIN MessageType RawMessage
	log 5 "My UIN: $MyUIN, Type: $MessageType, Ref: $Ref"
	switch $MessageType {
		65 { log 3 "Offline message"
			binary scan $RawMessage @2isccccccs UIN Year Month Day Hour Min\
					Type Flags TextLen
			log 3 "Subtype $Type" 
			binary scan $RawMessage H* hex; log 5 $hex
			switch $Type {
			   1 {
					binary scan $RawMessage @16a[expr $TextLen-1] Message
					CallHandlers "IncomingMessage" $UIN [clock scan "$Month/$Day/$Year $Hour:$Min" -gmt yes] [FromWire $Message]
			      }
			   4 { binary scan $RawMessage @16a[expr $TextLen-1] Message
				   foreach {descr url} [split $Message $icq::delim]	break
				   CallHandlers IncomingURL $UIN [clock scan "$Month/$Day/$Year $Hour:$Min" -gmt yes] [list [FromWire $descr] [FromWire $url]]
			     }
			  13 { binary scan $RawMessage @16a$TextLen Message
				   ParseEncodedMessage $Message	  
			     }
			   6 -   
			   5  {
					binary scan $RawMessage @8a* auth_data
					set ids {}
					foreach id {nick fname lname email xxx reason}\
					   		   val [split $auth_data $icq::delim] {
			     	     	lappend ids $id $val
			     	}
					CallHandlers "AuthorizationRequest" $UIN $ids
			       }
			}
			SrvMessage [binary format iSsc $data(-uin) 0x3e00 2 0] 2
		   }
		66 { log 3 "Offline messages complete" }
	    2010 { 	binary scan $RawMessage @1Ia* SubType RawMessage
				set SubType [expr $SubType & 0xFFFFFF]
				set Info {}
				log 3 "Subtype is $SubType"
				binary scan $RawMessage H* hex; log 10 $hex
				switch $SubType {
				262410 {log 3 "Short user info"
						foreach id {Nick FirstName LastName email} \
					        value [lindex [GetInfoList 4 $RawMessage 0] 0] {
						lappend Info $id $value
					}
					CallHandlers ContactInfo $Ref $Info
				}
				10618890 { log 3 "Ads" }
				11403570 { log 3 "No results found"
						CallHandlers SearchResults $Ref {}
				}
				11141130 { log 3 "Password changed"
						   CallHandlers PasswordChanged $Ref
						 }
				10092810 -
				10748170 -
				11403530 { log 3 "Results info"
			      	binary scan $RawMessage @2i UIN
					lappend Info UIN $UIN
					foreach id {Nick FirstName LastName email} \
					        value [lindex [GetInfoList 4 $RawMessage 6] 0] {
						log 5 "$id: $value"
						lappend Info $id $value
					}
					CallHandlers SearchResults $Ref $Info
					if {$SubType==11403530} { log 3 "Last item of the result"
							CallHandlers SearchResults $Ref {}
					}
		      	}
				10748210 { log 3 "WP_Empty" }
				13107210 { log 3 "User info main"
					foreach {info pos} [GetInfoList 11 $RawMessage 0] break
					foreach id {Nick FirstName LastName email City State\
						    	Phone Fax Address Mobile ZIP}\
							value $info {
						lappend Info $id $value
					}
					binary scan $RawMessage @${pos}sc Country TimeZone
					lappend Info Country $Country TimeZone $TimeZone
					CallHandlers ContactInfo $Ref $Info
				}
				15400970 { log 3 "Extra emails"
					binary scan $RawMessage c EmailCount
					log 5 "Extra emails: $EmailCount"
					set i 0
					foreach email [lindex [GetInfoList $EmailCount $RawMessage 2 3] 0] {
						lappend Info "email$i" $email
						incr i
					 }
					CallHandlers ContactInfo $Ref $Info
				}
				14417930 { log 3 "homepage"
					binary scan $RawMessage sc Age Sex
					foreach {info pos} [GetInfoList 1 $RawMessage 3] break
					binary scan $RawMessage @${pos}sccccc \
							Year Month Day Lang1 Lang2 Lang3
					CallHandlers ContactInfo $Ref \
						[list Age $Age Sex $Sex\
						      Homepage [lindex $info 0] \
							  Year $Year Month $Month Day $Day\
							  Lang1 $Lang1 Lang2 $Lang2 Lang3 $Lang3
					    ]
		      	}
				917770   { log 3 "User info unknown"}
				16384020 { log 3 "User info not found"}
				13762570 { log 3 "User info work"}
				15073290 { log 3 "User info about"}
				15728650 { log 3 "Personal interests"}
				16384010 { log 3 "Past interests"}
			}
		}
	}
}
proc 2:23:5 {} {
		upvar #0 icq::data data
		binary scan $data(body) H* hex; log 1 "23:5:"; log 1 $hex
		binary scan $data(body) @56I uin
		CloseConnection
}
# End of server messages handlers

# Client commands
proc Register {password} {
		upvar #0 icq::data data
		set id {0xb4 0x25 0 0}
		#set id {0x9e 0x27 0 0}
		log 1 "Registerng"
		Send [BuildPacket 1 [binary format i 1]]
		Command 2:23:4 [list List {0 1 0 0x38 0 0 0 0 0x28 0 3 0\
								   0 0 0 0 0 0 0 0}\
							List $id List $id \
							List {0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0}\
							Raw [LNTS $password] List $id List {0 0 0xcf 1}
		         ]
}
proc SendMessage {UIN Message} {
	upvar #0 icq::data data

	if {$data(MyStatus)=="offline"} {
		CallHandlers Error 0:2 "Offline"
		return
	}
	
	foreach {UIN Time Message} [CallHandlers "OutgoingMessage" $UIN [clock seconds] $Message] break
	SendMessageSplit $UIN [ToWire $Message]
}
proc SendMessageSplit {UIN Message} {
	upvar #0 icq::data data
	set msg [string range $Message 0 399]
	set msgTail [string range $Message 400 end]
	log 1 $msg
	if {$msgTail!={}} {
		append msg $data(glue)
		set msgTail "$data(glue)$msgTail"
	}
	set msglen [string length $msg]
	Command 2:4:6 [list List {0 0 0 0 0 0 0 0 0 1 } \
		Raw [FormatUIN $UIN]\
		List [list 0 2]\
		Raw [binary format S [expr $msglen+13]]\
		List {5 1 0 1 1 1 1}\
		Raw [binary format S [expr $msglen+4]]\
		List {0 0 0 0}\
		Raw $msg\
		List {0 6 0 0}\
	]
	if {$msgTail!={}} {after 1500 "icq::SendMessageSplit $UIN {$msgTail}"}
}

proc SendURL {UIN Url Description} {
	upvar #0 icq::data data

	if {$data(MyStatus)=="offline"} {
		CallHandlers Error 0:2 "Offline"
		return
	}
	
	CallHandlers "OutgoingURL" $UIN [clock seconds] $UIN [list $Description $Url]
	set Message [join [list [ToWire $Description] [ToWire $Url]] [binary format c1 0xfe] ]
	set msglen [string length $Message]

	Command 2:4:6 [list List {0 0 0 0 0 0 0 0 0 4 } \
			    Raw [FormatUIN $UIN]\
			    List [list 0 5]\
			    Raw [binary format Si [expr $msglen+9] $data(-uin)]\
			    List {4 0}\
			    Raw [binary format s [expr $msglen+1]]\
			    Raw $Message\
				List {0} \
			    List {0 6 0 0}\
	    ]
}
proc Authorize {UIN {type 1}} {
	CallHandlers "AuthorizationResponse" $UIN
	Command 2:19:26 [list Raw [FormatUIN $UIN] List [list $type 0 0 0 0]]
}
proc AskAuthorization {UIN Message} {
	set msg [ToWire $Message]
	Command 2:19:24 [list Raw [FormatUIN $UIN]\
					  Raw [binary format Sa* [string length $msg] $msg]\
					  List {0 0} \
					]
}

array set ListCmd {contacts 2:3:4 visible 2:9:5 invisible 2:9:7}
proc UploadList {type ContactList} {	
	set PackedList {}
	foreach Contact $ContactList {
		append PackedList [FormatUIN $Contact]
	}
	if {$PackedList=={}} return
	Command $icq::ListCmd($type) [list Raw $PackedList]
}

proc SetStatus {status} {
	upvar #0 icq::data data
	log 5 "Setting status $status"
	if {$status=="offline"} { CloseConnection; return}
	set data(-status) $status	
	if { $data(MyStatus)=="offline"} { 
		Connect $data(-server) $data(-port)
		return
	}
	if {[info exists icq::StatusCode($status)]} {
		Command 2:1:30 [list Status [expr ($data(Flags)<<16)+$icq::StatusCode($status)]]
	}
}
proc OfflineMessagesRequest {} {
	upvar #0 icq::data data
	SrvMessage [binary format iScc $data(-uin) 0x3c00 2 0] 2
}
proc ShortInfoRequest {UIN id} {
	upvar #0 icq::data data
	SrvMessage [binary format iSsSi $data(-uin) 0xd007 $id 0xba04 $UIN] $id
}
proc SendSMS {Number Message {id 201}} {
		upvar #0 icq::data data
		set Time [clock format [clock seconds] -format "%a, %d %b %Y %T GMT" -gmt yes]
		set message "<icq_sms_message><destination>${Number}</destination><text>${Message}</text>"
		append message "<codepage>1252</codepage><senders_UIN>${data(-uin)}</senders_UIN><senders_name>Bob</senders_name>"
		append message "<delivery_receipt>Yes</delivery_receipt><time>${Time}</time></icq_sms_message>"
		SrvMessage [binary format iScIIiiiica* $data(-uin) 0xd007 $id 0x00821400 0x01001600\
				   0 0 0 0 0 [LNTS $message]] $id
}

proc ChangePassword {password {id 200}} {
	upvar #0 icq::data data
	SrvMessage [binary format iSsSa* $data(-uin) 0xd007 $id 0x2e04\
		[LNTS $password]] $id
}

proc FullInfoRequest {UIN {id 200}} {
	upvar #0 icq::data data
	SrvMessage [binary format iSsSi $data(-uin) 0xd007 $id 0xb204 $UIN] $id
}

proc Search {SearchList {id 204}} {
	upvar #0 icq::data data
	array set Attrs $SearchList
	set search_rq {}
	foreach {formatter item} {LNTS FirstName LNTS LastName\
			LNTS Nick LNTS Email s MinAge s MaxAge\
			c Sex c Language LNTS City LNTS State s Country\
			LNTS CompanyName LNTS CompanyDep LNTS CompanyPos \
			c CompanyOcc S PastInfoCat LNTS Interests s OrgCat \
			LNTS OrgDesc S HomepageCat LNTS Homepage c OnlineOnly} {
		if {![info exists Attrs($item)]} {set Attrs($item) {}}
		if {[info proc $formatter]!={}} {
			append search_rq [$formatter $Attrs($item)]	
		} else { 
			if {$Attrs($item)=={}} {set Attrs($item) 0}
			append search_rq [binary format $formatter $Attrs($item)]
		}
	}
	SrvMessage [binary format iSsSa* $data(-uin) 0xd007 $id 0x3305 $search_rq] $id		
	unset Attrs search_rq
}

proc UpdateInfo {Info {id 205}} {
	upvar #0 icq::data data
	array set Attrs $Info
	foreach {formatter var item} { LNTS main Nick LNTS main FirstName \
			LNTS main LastName LNTS main email LNTS main City LNTS main State\
			LNTS main Phone LNTS main Fax LNTS main Street LNTS main Mobile\
			LNTS main Zip s main Country c main TimeZone c main PublishEmail\
			c more Age c more Unk c more Sex LNTS more Homepage s more Year\
			c more Month c more Day c more Lang1 c more Lang2 c more Lang3} {
		if {![info exists Attrs($item)]} {set Attrs($item) {}}
		if {[info proc $formatter]!={}} {
			append info($var) [$formatter $Attrs($item)]	
		} else { 
			if {$Attrs($item)=={}} {set Attrs($item) 0}
			append info($var) [binary format $formatter $Attrs($item)]
		}
	}
	foreach {item cmd} {main 0xea03 more 0xfd03} {
		SrvMessage [binary format iSsSa* $data(-uin) 0xd007 $id $cmd $info($item)] $id
	}	
	unset Attrs
}

proc SrvMessage {packet id} {
	set len [string length $packet]
	Command 2:21:2 [list Raw [binary format SSsa* 1 [expr $len+2] $len $packet]] $id
}

# End of client commands
proc GetInfoList {amount data pos {adder 2}} {
	set result {}
	while {$amount>0} {
		binary scan $data @${pos}cc Size Trash
		binary scan $data @[expr $pos+2]a[expr $Size-1] elem
		lappend result [FromWire $elem]
		incr pos [expr $Size+$adder]
		incr amount -1
	}
	return [list $result $pos]
}
proc LNTS {str} {set str [ToWire $str]; return [binary format sa*c [expr [string length $str]+1] $str 0]}
proc LLNTS {str} {return [LNTS [LNTS $str]]}

proc FromWire {text} {
	upvar #0 icq::data data
	set text [encoding convertfrom $data(-encoding) $text]
	regsub -all {\r\n} $text \n text
	return $text
}
proc ToWire {text} {
	upvar #0 icq::data data
	set text [encoding convertto $data(-encoding) $text]
	regsub -all {[\r\n]} $text \r\n text
	return $text
}
proc BuildPacket { Channel Data} {
	variable SeqNum
	set packet [binary format c1c1S1S1a* 42 $Channel $SeqNum [string length $Data] $Data]
	incr SeqNum
	if { $SeqNum>65535 } {set SeqNum 0}
	return $packet
}

proc Connect {Server Port} {
	upvar #0 icq::data data
	CloseConnection
	if {$data(proxy)!="" && $data(-proxy_server)!=""} {
		set proxycmd "::proxy::${data(proxy)}Proxy"
		if {[llength [info commands $proxycmd]]==1} {
			$proxycmd $Server $Port
			return
		}	
	}
	log 1 "Connecting to $Server:$Port"
	if {[catch {set data(socket) [socket -async $Server $Port]}]} {
		CallHandlers Error 0:1 "Unknown host"
		return
	}
	fconfigure $data(socket) -blocking no -translation binary
	log 1 "Name resolved, connecting..."
	fileevent $data(socket) readable "icq::ReadData"
}
proc CloseConnection {} {
	upvar #0 icq::data data
	if {[info exists data(socket)]} {
		close $data(socket)
		unset data(socket)
	}
	set data(Header) ""
	set data(Body) ""
	set data(Length) 6
	set data(WaitFor) "Header"
	set data(MyStatus) "offline"
	CallHandlers MyStatus offline
}
proc Send {packet} {
	upvar #0 icq::data data
	set full [llength $data(send_queue)]
	lappend data(send_queue) $packet
	if {!$full} Sender
}

proc Sender {} {
	upvar #0 icq::data data
	if {[catch { puts -nonewline $data(socket) [lindex $data(send_queue) 0]
			     flush $data(socket)
				}]} {
		CallHandlers Error 0:1
	}
	set data(send_queue) [lrange $data(send_queue) 1 end]
	if {$data(send_queue)!={}} { after idle icq::Sender }
}

proc GetTLVs {ChanId pos Body} {
	upvar #0 icq::TLV TLV

	set len [string length $Body]
	if {$ChanId==2} { 
		binary scan $Body @${pos}I TagCount
		incr pos 4
	} else {set TagCount 4}
	while {$pos<$len} {
		binary scan $Body @${pos}SS TagId Size
		incr pos 4
		FindTLV $TagId $ChanId TagName spec
		if {$spec=="a"} { append spec $Size }
		binary scan $Body @${pos}${spec} Value
		set TLV($TagName) $Value
		incr pos $Size
		incr TagCount -1
		if {!$TagCount} {break}
	}
	return $pos
}
proc TLVInfo {myChanId myTagName id type} {
	variable TLVBase
	upvar 1 $id TagId $type TagType
	foreach {TagId ChanId TagName TagType} $TLVBase {
		if {$myChanId==$ChanId && $myTagName==$TagName} {break}
	}
}
proc FindTLV {myTagId myChanId tname ttype} {
	variable TLVBase
	upvar 1 $tname TagName $ttype TagType
	foreach {TagId ChanId TagName TagType} $TLVBase {
		if {$TagId==$myTagId && $ChanId==$myChanId} {break}
	}
}


proc EncryptPassword {inpwd} {
	set i 0
	set len [string length $inpwd]
	set outpwd ""
	foreach val {243 38 129 196 57 134 219 146
		     113 163 185 230 83 122 149 124} {
		binary scan $inpwd @${i}c char
		append outpwd [binary format c [expr $char^$val]]
		incr i
		if {$i==$len} break
	}
	return $outpwd
}
proc MakeSNAC {Family SubFamily FlagA FlagB RequestId} {
	return [binary format SSccSS $Family $SubFamily $FlagA $FlagB $RequestId $SubFamily]
}
proc FormatUIN {UIN} { return [binary format ca* [string length $UIN] $UIN] }

proc Command {Cmd TagList {ReqId 0}} {
	upvar #0 icq::data data

	foreach {ChanId Family SubFamily} [split $Cmd :] {break}
	if {$ChanId!=1} { 
		 set Data [MakeSNAC $Family $SubFamily 0 0 $ReqId]
	} else { set Data [binary format I 1] }
	foreach {Key Value} $TagList {
			if {$Key=="List"} {
				foreach item $Value {
					append Data [binary format c $item]
				}
				continue
			}
			if {$Key=="Raw"} {
				append Data $Value
				continue
			}
			TLVInfo $ChanId $Key TagId TagType
			set Chunk [binary format $TagType $Value]
			set len [string length $Chunk]
			append Data [binary format SS $TagId $len] $Chunk
	}
	set packet [BuildPacket $ChanId $Data]
	binary scan $packet H* hex; log 10 $hex
	Send $packet

}
proc AddToList {type Contacts} {
	upvar #0 icq::data data
	foreach contact $Contacts { lappend data(-${type}list) $contact }
	if {$data(MyStatus)!="offline"} {UploadList $type $data(-${type}list)}
}
proc RemoveFromList {type Contacts} {
	upvar #0 icq::data data
	foreach contact $Contacts {
		set pos [lsearch $data(-${type}list) $contact]
		set data(-${type}list) [lreplace $data(-${type}list) $pos $pos]
	}
	if {$data(MyStatus)!="offline"} {UploadList $type $data(-${type}list)}
}
}
