/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2001-2003 by Matthias Troyer <troyer@comp-phys.org>,
*                            Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: evaluator.h,v 1.8 2004/07/07 11:51:44 wistaria Exp $ */

#ifndef ALPS_EVALUATOR_H
#define ALPS_EVALUATOR_H

#include <alps/config.h>

#ifndef ALPS_WITH_NEW_EXPRESSION

#include <alps/parameters.h>
#include <string>

namespace alps {

class Expression;

class Evaluator {
public:
  typedef double value_type;
  enum Direction { left_to_right, right_to_left};
  Evaluator() {}
  virtual bool can_evaluate(const std::string&) const;
  virtual bool can_evaluate_function(const std::string&, const Expression& ) const;
  virtual double evaluate(const std::string&) const;
  virtual double evaluate_function(const std::string&, const Expression&) const;
  virtual Expression partial_evaluate(const std::string& name) const;
  virtual Expression partial_evaluate_function(const std::string& name, const Expression&) const;
  virtual Direction direction() const;
};

class ParameterEvaluator : public Evaluator {
public:
  typedef double value_type;
  ParameterEvaluator(const Parameters& p) : parms_(p) {}
  virtual ~ParameterEvaluator() {}
  bool can_evaluate(const std::string&) const;
  double evaluate(const std::string&) const;
  Expression partial_evaluate(const std::string& name) const;
  const Parameters& parameters() const { return parms_;}
private:
  Parameters parms_;
};
  
} // end namespace alps

#else

#include <alps/expression2.h>

#endif // ! ALPS_WITH_NEW_EXPRESSION

#endif // ! ALPS_EVALUATOR_H
