/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2001-2004 by Matthias Troyer <troyer@itp.phys.ethz.ch>,
*                            Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: expression.C,v 1.10 2004/10/07 04:05:10 wistaria Exp $ */

#include <alps/expression.h>

#include <boost/throw_exception.hpp>
#include <iostream>
#include <stdexcept>

int main()
{
#ifndef BOOST_NO_EXCEPTIONS
  try {
#endif

  alps::Parameters parms;
  std::cin >> std::skipws;
  std::cin >> parms;
  std::cout << "Parameters:\n" << parms << std::endl;
  alps::check_character(std::cin,'%',"Expected a %-sign separating parameters from expressions");
  
  alps::ParameterEvaluator eval(parms);
  while (std::cin) {
    alps::Expression expr(std::cin);
    if (!expr.can_evaluate(eval))
      std::cout << "Cannot evaluate [" << expr << "]." << std::endl;
    else 
#ifndef ALPS_WITH_NEW_EXPRESSION
      std::cout << "The value of [" << expr << "] is " << expr.value(eval) 
                << std::endl;
#else
      std::cout << "The value of [" << expr << "] is "
                << alps::evaluate<double>(expr, eval) << std::endl;
#endif
    char c;
    std::cin >> c;
    if (c!=',')
      break;
  }

  while (std::cin) {
    std::string v;
    std::cin >> v;
    if (v.empty()) break;
    if (!alps::can_evaluate(v, parms))
      std::cout << "Cannot evaluate [" << v << "]." << std::endl;
    else 
#ifndef ALPS_WITH_NEW_EXPRESSION
      std::cout << "The value of [" << v << "] is "
                << alps::evaluate(v, parms) << std::endl;
#else
      std::cout << "The value of [" << v << "] is "
                << alps::evaluate<double>(v, parms) << std::endl;
#endif
  }

#ifndef BOOST_NO_EXCEPTIONS
}
catch (std::exception& e)
{
  std::cerr << "Caught exception: " << e.what() << "\n";
  exit(-1);
}
catch (...)
{
  std::cerr << "Caught unknown exception\n";
  exit(-2);
}
#endif
}
