//
//  imap.cpp  --  IMAP functions 
//  -- created 5/23/00 updated 5/23/00
///////////////////////////////////////////

#include	"imap.h"

extern Althea gAlthea;

//IMAPLogin logs into the host, returns 0 if successful or 102 if not

int IMAPLogin(AConPtr &the_connection, const string &host, const int port, const string &username, const string &password, bool usessl)
{

string	errcode;
int err;
 
 
	/* connect to port "port" on "host" */
        the_connection = MakeConnection( host.c_str(), port, usessl );
	errcode = readTilEOL(the_connection);
	if (errcode.find(gIMAPStarOK)>=errcode.length()) 
	{
		return SERVER_NOT_READY_FOR_CONNECTION;
	}
	// make login command 

	string logincommand=gIMAPLoginTag + " " + gIMAPLoginCommand + " \"";
	logincommand += username;
	logincommand += gIMAPQuoteSpaceQuote;
	logincommand += password;
	logincommand += gIMAPQuoteEOL;
	
	// make noop command
	string noopcommand=gIMAPCheckMailTag + " " + gIMAPCheckMailCommand;
	noopcommand += gIMAPEOL;

	//Send logincommand

        WriteToSocket(the_connection, logincommand.c_str() , logincommand.length());
	if (gAlthea.get_Verbose()==2)
	  cout << "C: " << logincommand << endl;
	  
	string OKResponse=gIMAPLoginTag + " " + gIMAPOK;

	// read response if not what we expect, return error code 102
	errcode = readTilEOLTilExpected(the_connection, gIMAPLoginTag, gIMAPLoginExpected, err);
	if (errcode.find(OKResponse)>=errcode.length()) 
	{
		return BAD_LOGIN;
	}
	return SUCCESS;
}



// Get folder listing

int getIMAPFolders(AConPtr the_connection, list<string>& folders, string folderroot)
{
string line,foldername;
int i;


// check for INBOX

	// form command
	string isINBOXcommand = gIMAPListTag + " " + gIMAPListCommand + " " + gIMAPQuoteQuote + " \"" + gIMAPINBOXName + gIMAPQuoteEOL;

	// send command
        WriteToSocket(the_connection, isINBOXcommand.c_str(), isINBOXcommand.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << isINBOXcommand << endl;
	// read in response
	line = readTilEOL(the_connection);

	// if it is not a list item, this server must not have an "INBOX" otherwise (if it does give an item,) it does....
	if (line.find(gIMAPListResponse)<line.length())
	{
		folders.push_back(gIMAPINBOXName);        // add INBOX to the list of folders
		line = readTilEOL(the_connection); // to get rid of "OK" line
	}


// Check for everything else


	// form command
	string listcommand = gIMAPListTag + " " + gIMAPListCommand + " " + gIMAPQuoteQuote + " \"" + folderroot + "/" + gIMAPListWildcard + gIMAPQuoteEOL;
	
	
	// Send command
        WriteToSocket(the_connection, listcommand.c_str(), listcommand.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << listcommand << endl;

	// Get first response	
	line = readTilEOL(the_connection);


	// while it is giving us list items, process them
	while (line.find(gIMAPListResponse)<line.length())
	{
	  if (line.find(gIMAPListNoSelect)>=line.length())
	  {
	    
	    
	    i=0;
	    int lastslash=line.find(folderroot) + folderroot.length();	    
	    i=lastslash;
	    if (line[i]=='/')
	      i++;
	    if (line[i]!='.') 
	      {
		foldername="";
		while (line[i] !=0 && line[i] != '\"' && line[i]!='\r')
		  {
		    
		    foldername+=line[i];
		    i++;
		  }
		if (foldername!="")
		  folders.push_back(foldername); // add the folder to the list
	      }
	  }
	  line = readTilEOL(the_connection); // read the next line
	}

	// if this isn't what we expect, there might have been a server error. 
	// However, even if we didn't ask for a valid directory it won't complain here.
	
	string commandDoneTag = gIMAPListTag + " " + gIMAPOK;

	if (line.find(commandDoneTag)<line.length())
	{
		return SUCCESS;
	} else {
		return LIST_FAILED;
	}

}

// Get folder listing

int IMAPExpunge(AConPtr the_connection, list<int>& deleted)
{
string line,foldername,message;
int i,mess,err;


	// form command
	string expungecommand = gIMAPExpungeTag + " " + gIMAPExpungeCommand + gIMAPEOL;

	// send command
        WriteToSocket(the_connection, expungecommand.c_str(), expungecommand.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << expungecommand << endl;
	// read in response

	line = readTilEOLTilExpected(the_connection,gIMAPExpungeExpected,gIMAPExpungeTag,err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}
	// while it is giving us list items, process them
	while (line.find(gIMAPItemMarker)<line.length())
	{
		i=gIMAPExpungeCharsToItem;
		if (line[i]!='.') 
		{
			message="";
			while (line[i] !=' ')
			{
				message+=line[i];
				i++;
			}
			mess = atoi(message.c_str());

			deleted.push_back(mess); // add the folder to the list
		}
	line = readTilEOLTilExpected(the_connection,gIMAPExpungeExpected,gIMAPExpungeTag,err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}


	}

	// if this isn't what we expect, there might have been a server error. 
	// However, even if we didn't ask for a valid directory it won't complain here.
	return err;
}




int IMAPGetMessagePartByUID(AConPtr the_connection, int UID, string &messagetext, int part)
{

string line;
int size=0;
char c;
int z=0;
int err;

	// form command
	string fetchcommand = gIMAPFetchTag + " " + gIMAPFetchCommand + " " + itoa(UID) + " body[" + itoa(part) + "]"  + gIMAPEOL;
	// send command
        WriteToSocket(the_connection, fetchcommand.c_str() , fetchcommand.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << fetchcommand << endl;
	// read response
	line = readTilEOLTilExpected(the_connection,gIMAPFetchExpected,gIMAPFetchTag,err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}
	if (line.find(gIMAPItemMarker)<line.length()) //check that the message actually exists
	{

		int i=0;
		//go until you pass the flags, if we ever do sub folders, we will need to
		//parse those too.
		while (line[i] != '{' && line[i] != '\"')
		{
			i++;
		}
		if (line[i] == '\"')
		{
			messagetext="";
			line = readTilEOLTilExpected(the_connection, gIMAPFetchTag, gIMAPFetchTag, err);
			return err;
		}
		// pass over the {
		i++;


		// use temp to store the number of bytes as a string
		string temp;
		while (line[i] != '}')
		{
			temp += line[i];
			i++;
		}

		// convert the string to an int
		size=atoi(temp.c_str());
		messagetext="";
		// read size bytes in from the network and put it on message text
	        i = ReadFromSocket( the_connection, &c, 1 );
       		while( i > 0  && z<size )
        	{
			messagetext+=c;
               		i = ReadFromSocket( the_connection, &c, 1 );
			z++;
        	}
	line = readTilEOLTilExpected(the_connection, gIMAPFetchTag, gIMAPFetchTag, err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}


			
	} else {
		return MESSAGE_NOT_THERE; //message doesn't exist
	}

return err;

}





// get the message body by the UID (this is a different IMAP command than 
// getting the message by the index, so if we do that it will need to be 
// a different command


int IMAPGetMessageBodyByUID(AConPtr the_connection, int UID, string &messagetext)
{

return IMAPGetMessagePartByUID(the_connection, UID, messagetext, 1);

}


// get the message header by the UID (this is a different IMAP command than 
// getting the message by the index, so if we do that it will need to be 
// a different command


int IMAPGetMessageHeaderByUID(AConPtr the_connection, int UID, string &messagetext)
{

string line;
int size=0;
char c;
int z=0;
int err;
string sUID = itoa(UID);

	// form command
	string fetchcommand = gIMAPFetchHeaderTag + " " + gIMAPFetchCommand + " " + itoa(UID) + " " + gIMAPHeaderMIMEPart + gIMAPEOL;
	// send command
        WriteToSocket(the_connection, fetchcommand.c_str() , fetchcommand.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << fetchcommand << endl;
	// read response
	line = readTilEOLTilExpected(the_connection,gIMAPFetchHeaderTag,gIMAPFetchExpected,err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}
	
	if (line.find(gIMAPItemMarker)<line.length()) //check that the message actually exists
	{

		int i=0;
		//go until you pass the flags, if we ever do sub folders, we will need to
		//parse those too.
		while (line[i] != '{')
		{
			i++;
		}
		// pass over the {
		i++;


		// use temp to store the number of bytes as a string
		string temp;
		while (line[i] != '}')
		{
			temp += line[i];
			i++;
		}

		// convert the string to an int
		size=atoi(temp.c_str());
		messagetext="";
		// read size bytes in from the network and put it on message text
	        i = ReadFromSocket( the_connection, &c, 1 );
       		while( i > 0  && z<size )
        	{
			messagetext+=c;
               		i = ReadFromSocket( the_connection, &c, 1 );
			z++;
        	}

		line = readTilEOLTilExpected(the_connection,gIMAPFetchHeaderTag,gIMAPFetchHeaderTag,err);
		if (err==LOST_CONNECTION_TO_SERVER) 
		  return err;
		

		
	} else {
	  return MESSAGE_NOT_THERE; //message doesn't exist
	}
	
return err;

}

// get the Set flags by the UID (this is a different IMAP command than 
// getting the message by the index, so if we do that it will need to be 
// a different command


int IMAPSetFlagByUID(AConPtr the_connection, int UID, const string &flagtoset, string
&currentflags)
{

string line;
int err;



	// form command
	string fetchcommand = gIMAPSetFlagTag + " " + gIMAPStoreCommand + " " + itoa(UID) + " " + gIMAPSetFlagCommand + " (" + flagtoset + ")" + gIMAPEOL; 

	
	// send command
        WriteToSocket(the_connection, fetchcommand.c_str() , fetchcommand.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << fetchcommand << endl;
	// read response

	line = readTilEOLTilExpected(the_connection, gIMAPFetchExpected, gIMAPSetFlagTag, err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}

	if (line.find(gIMAPItemMarker)<line.length()) //check that the message actually exists
	{

		int i=0;
		//go until you pass the message id
		while (line[i] != '(')
		{
			i++;
		}
		i++;
		//go until you pass SOMETHING ELSE
		while (line[i] != '(')
		{
			i++;
		}
		// pass over the {
		i++;


		// use temp to store the number of bytes as a string
		string temp;
		while (line[i] != ')')
		{
			currentflags += line[i];
			i++;
		}

		line = readTilEOLTilExpected(the_connection,gIMAPSetFlagTag,gIMAPSetFlagTag,err);
		if (err==LOST_CONNECTION_TO_SERVER) {return err;}



			
	} else {
		return MESSAGE_NOT_THERE; //message doesn't exist
	}

return err;

}
// get the unSet flags by the UID (this is a different IMAP command than 
// getting the message by the index, so if we do that it will need to be 
// a different command


int IMAPUnSetFlagByUID(AConPtr the_connection, int UID, const string &flagtounset, string
&currentflags)
{

string line;
int err;



	// form command
	string fetchcommand = gIMAPSetFlagTag + " " + gIMAPStoreCommand + " " + itoa(UID) + " " + gIMAPUnSetFlagCommand + " (" + flagtounset + ")" + gIMAPEOL; 

	
	// send command
        WriteToSocket(the_connection, fetchcommand.c_str() , fetchcommand.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << fetchcommand << endl;
	// read response

	line = readTilEOLTilExpected(the_connection, gIMAPFetchExpected, gIMAPSetFlagTag, err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}

	if (line.find(gIMAPItemMarker)<line.length()) //check that the message actually exists
	{

		int i=0;
		//go until you pass the message id
		while (line[i] != '(')
		{
			i++;
		}
		i++;
		//go until you pass SOMETHING ELSE
		while (line[i] != '(')
		{
			i++;
		}
		// pass over the {
		i++;


		// use temp to store the number of bytes as a string
		string temp;
		while (line[i] != ')')
		{
			currentflags += line[i];
			i++;
		}

		line = readTilEOLTilExpected(the_connection,gIMAPSetFlagTag,gIMAPSetFlagTag,err);
		if (err==LOST_CONNECTION_TO_SERVER) {return err;}



			
	} else {
		return MESSAGE_NOT_THERE; //message doesn't exist
	}

return err;

}

//
// Create a folder
// 


int IMAPCreateFolder(AConPtr the_connection, const string &foldername, const string &folderroot)
{

string line;
int err;


	// form command

	string createcommand = gIMAPCreateFolderTag + " " + gIMAPCreateFolderCommand + " " + folderroot + gIMAPDirectoryIndicator + foldername + gIMAPEOL;

	
	// send command
        WriteToSocket(the_connection, createcommand.c_str() , createcommand.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << createcommand << endl;
	// read response

	line = readTilEOLTilExpected(the_connection, gIMAPCreateFolderExpected, gIMAPCreateFolderTag, err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}

	if (line.find(gIMAPCreateFolderSuccessful)>=line.length()) {
		return err;		
	} else if (line.find(gIMAPCreateFolderFailed)>=line.length()) { 
		return CREATE_FOLDER_FAILED;
	} else	{
		return CREATE_FOLDER_FAILED;
	}

}


//
// Delete a folder
// 


int IMAPDeleteFolder(AConPtr the_connection, const string &foldername, const string &folderroot)
{

string line;
int err;
if (foldername != gIMAPINBOXName)
{
	// form command
	string command = gIMAPDeleteFolderTag + " " + gIMAPDeleteFolderCommand + " " + folderroot + gIMAPDirectoryIndicator + foldername + gIMAPEOL;

	
	// send command
        WriteToSocket(the_connection, command.c_str() , command.length());
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << command << endl;
	// read response

	line = readTilEOLTilExpected(the_connection,gIMAPDeleteFolderExpected,gIMAPDeleteFolderTag,err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}

	if (line.find(gIMAPDeleteFolderSuccessful)>=line.length()) {
		return err;		
	} else if (line.find(gIMAPDeleteFolderFailedDueToInferior)>=line.length()) { 
		return DELETE_FAILED_DUE_TO_INFERIOR;
	} else if (strstr(line.c_str(),gIMAPDeleteFolderFailed.c_str())!=NULL){
		return DELETE_FAILED;
	} else {
		return DELETE_FAILED;
	}
} else {
return NO_DELETE_INBOX;
}



}


//
// Rename a folder
// 


int IMAPRenameFolder(AConPtr the_connection, const string &fromname, const string &toname, const string &folderroot)
{
  int err;
  string line;
  string command="";
  if (fromname==gIMAPINBOXName) {
    // form command
    command = gIMAPRenameFolderTag + " " + gIMAPRenameFolderCommand + " " + fromname + " " + folderroot + gIMAPDirectoryIndicator + toname + gIMAPEOL;
  } else {
    // form command
    command = gIMAPRenameFolderTag + " " + gIMAPRenameFolderCommand + " " + folderroot + gIMAPDirectoryIndicator + fromname + " " + folderroot + gIMAPDirectoryIndicator + toname + gIMAPEOL;
  }
  
  // send command
  WriteToSocket(the_connection, command.c_str() , command.length());
  if (gAlthea.get_Verbose()==2)
    cout << "C: " << command << endl;	
  // read response
  
  line = readTilEOLTilExpected(the_connection,gIMAPRenameFolderExpected,gIMAPRenameFolderTag,err);
  if (err==LOST_CONNECTION_TO_SERVER) {return err;}
  
  if (line.find(gIMAPRenameFolderSuccessful)>=line.length()) {
    return err;		
  } else if (line.find(gIMAPRenameFolderFailed)>=line.length()){
    return RENAME_FAILED;
  } else {
    return RENAME_FAILED;
  }

}



int IMAPLogout(AConPtr the_connection)
{
	// form command
	string logoutcommand = gIMAPLogoutTag + " " + gIMAPLogoutCommand + gIMAPEOL;
	// send command
        WriteToSocket(the_connection, logoutcommand.c_str() , strlen(logoutcommand.c_str()));
        if (gAlthea.get_Verbose()==2)
          cout << "C: " << logoutcommand << endl;
	return SUCCESS;
}



int IMAPSeq2UID(AConPtr the_connection, const int seq, int &UID)
{
string line;
string command="";
int i,err;

	// form command
	command = gIMAPSeq2UIDTag + " " + gIMAPFetchUIDCommand + " " +
itoa(seq) + " " + gIMAPUIDMIMEPart + gIMAPEOL; 
	
	// send command
        WriteToSocket(the_connection, command.c_str() , strlen(command.c_str()));
        if (gAlthea.get_Verbose()==2)
          cout << "C: " << command << endl;	
	// read response
	line = readTilEOLTilExpected(the_connection,gIMAPFetchExpected,gIMAPSeq2UIDTag,err);
		if (err==LOST_CONNECTION_TO_SERVER) {return err;}
	if (line.find("*")<line.length()) {

		i=2;
		// use temp to store the number of bytes as a string
		while (line[i] != '(')
		{
			i++;
		}
		i=i+5;
		string temp="";

		while (line[i] != ')')
		{
			temp += line[i];
			i++;
		}
		UID=atoi(temp.c_str());
		line = readTilEOLTilExpected(the_connection,gIMAPSeq2UIDTag,gIMAPSeq2UIDTag,err);
		if (err==LOST_CONNECTION_TO_SERVER) {return err;}
		return err;
			
	} else {
		return MESSAGE_NOT_THERE;
	}
}

int IMAPCopyMessage(AConPtr the_connection, const int uid, const string &tofolder, 
        const string &folderroot)
{
int err;
string line,command;

	if (tofolder == gIMAPINBOXName)
	{
		// form command
		command = gIMAPCopyTag + " " + gIMAPCopyCommand + " " + itoa(uid) + " " + tofolder + gIMAPEOL; 
	} else {
		// not INBOX
		// form command
		command = gIMAPCopyTag + " " + gIMAPCopyCommand + " " + itoa(uid) + " " + folderroot + gIMAPDirectoryIndicator + tofolder + gIMAPEOL; 
	}

		// send command
		WriteToSocket(the_connection, command.c_str() , strlen(command.c_str()));
	        if (gAlthea.get_Verbose()==2)
	          cout << "C: " << command << endl;	
		// read response

		line = readTilEOLTilExpected(the_connection,gIMAPCopyExpected,gIMAPCopyTag,err);
		if (err==LOST_CONNECTION_TO_SERVER) {return err;}
		if (strstr(line.c_str(),gIMAPCopySuccessful.c_str())!=NULL) {
			return err;		
		} else if (strstr(line.c_str(),gIMAPCopyFailedDueToNoFolder.c_str())!=NULL) { 
			return COPY_FAILED_DUE_TO_NO_FOLDER;
		} else if (strstr(line.c_str(),gIMAPCopyFailed.c_str())!=NULL){
			return COPY_FAILED;
		} else {
			return COPY_FAILED;
		}
}



int IMAPCheckMail(AConPtr the_connection)
{

int err;
	string command = gIMAPCheckMailTag + " " + gIMAPCheckMailCommand + gIMAPEOL;
	// send command
	WriteToSocket(the_connection, command.c_str() , strlen(command.c_str()));
        if (gAlthea.get_Verbose()==2)
          cout << "C: " << command << endl;
	string line = readTilEOLTilExpected(the_connection,gIMAPCheckMailTag,gIMAPCheckMailExpected,err);

	return err;
}




// append posts the message to the folder


int IMAPAppend(AConPtr the_connection, const string &text, const string &folder, const string &folderroot)
{

  string line;

  int err;

  // form command
  string command = gIMAPAppendTag + " " + gIMAPAppendCommand + " " + folderroot +    "/" + folder + " (\\Seen) {"; 
  command = command + itoa(strlen(text.c_str())) + "}" + gIMAPEOL;
	// send command
        WriteToSocket(the_connection, command.c_str() , strlen(command.c_str()));
	if (gAlthea.get_Verbose()==2)
          cout << "C: " << command << endl;
	// read response
	WriteToSocket(the_connection, text.c_str(), strlen(text.c_str()));
	WriteToSocket(the_connection, gIMAPEOL.c_str(), strlen(gIMAPEOL.c_str()));

	line = readTilEOLTilExpected(the_connection,gIMAPAppendExpected,gIMAPAppendTag,err);
	if (err==LOST_CONNECTION_TO_SERVER) {return err;}

	if (strstr(gIMAPAppendSuccessful.c_str(),line.c_str())==0) 
	{
	  return err;
	}

	if (strstr(gIMAPAppendNoSuchFolder.c_str(),line.c_str())==0)
	{
	  return APPEND_FAILED_DUE_TO_NO_FOLDER;
	}
	
	if (strstr(gIMAPAppendFailed.c_str(),line.c_str())==0) 
	{
	  return APPEND_FAILED;
	}



return err;

}





