PRESENTATION Annot;

VIEWS
   Formatted_view,
   Structure_view merge with Structure_view,
   Links_view merge with Links_view;

#ifdef PAGE
PRINT
   Formatted_view;
#endif

#define DOC_FONTSIZE 12 pt
#define RDF_FONTSIZE 12 pt
#define STRUCT_INDENT 0.5 cm
#define MARGIN 1.2
#define RDF_FgColor Black
#define RDF_BgColor Yellow
#define THREADSEL_FgColor Yellow
#define THREADSEL_BgColor Red
#define THREAD_INDENT 0.5
#define THREAD_ITEM_INDENT 1
#define POINT_INDENT 1
#define Thread_visibility 5

DEFAULT
	BEGIN
	HorizRef: Enclosed . HRef;
	VertRef: * . Left;
	Width: Enclosed . Width;
	Height: Enclosed . Height;
	VertPos: Top = Previous . Bottom;
	HorizPos: Left = Enclosing . Left;
	Hyphenate: Enclosing =;
	LineSpacing: Enclosing =;
	LineWeight: Enclosing =;
	LineBreak: Yes;
	PageBreak: Yes;
	Visibility: Enclosing =;
	Font: Enclosing =;
	Style: Enclosing =;
	Weight: Enclosing =;
	Underline: Enclosing =;
	Thickness: Enclosing =;
	Size: Enclosing =;
	Adjust: Enclosing =;
	Indent: Enclosing =;
	Depth: Enclosing =;
	FillPattern: nopattern;
	IN Links_view
	   Visibility: 0;
	END;

BOXES

 ATitle_Box:
	BEGIN
	Content: (Text 'Title: ');
	Visibility: Creator =;
	VertPos: Top = Previous . Bottom + 0.2;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: RDF_FONTSIZE;
        Foreground: RDF_FgColor;
        Background: RDF_BgColor;
	END;

 Author_Box:
	BEGIN
	Content: (Text 'Author: ');
	Visibility: Creator =;
	VertPos: Top = Previous . Bottom + 0.2;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: RDF_FONTSIZE;
        Foreground: RDF_FgColor;
        Background: RDF_BgColor;
	END;

 SourceDoc_Box:
	BEGIN
	Content: (Text 'Source document: ');
	Visibility: Creator =;
	VertPos: Top = Previous . Bottom + 0.2;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: RDF_FONTSIZE;
        Foreground: RDF_FgColor;
        Background: RDF_BgColor;

	END;

 RDFAtype_Box:
	BEGIN
	Content: (Text 'Annotation type: ');
	Visibility: Creator =;
	VertPos: Top = Previous . Bottom + 0.2;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: RDF_FONTSIZE;
        Foreground: RDF_FgColor;
        Background: RDF_BgColor;
	END;

 RDFRtype_Box:
	BEGIN
	Content: (Text 'Reply type: ');
	Visibility: Creator =;
	VertPos: Top = Previous . Bottom + 0.2;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: RDF_FONTSIZE;
        Foreground: RDF_FgColor;
        Background: RDF_BgColor;
	END;

 CDate_Box:
	BEGIN
	Content: (Text 'Created: ');
	VertPos: Top = Previous . Bottom + 0.2;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: RDF_FONTSIZE;
        Foreground: RDF_FgColor;
        Background: RDF_BgColor;
	END;

 MDate_Box:
	BEGIN
	Content: (Text 'Last modified: ');
	Visibility: Creator =;
	VertPos: Top = Previous . Bottom + 0.2;
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Size: RDF_FONTSIZE;
        Foreground: RDF_FgColor;
        Background: RDF_BgColor;
	END;

 Thread_box: BEGIN
	Content: (Text 'Replies ');
	Font: Creator =;
	Style: Creator =;
	Weight: Creator =;
	Width: Enclosing . Width;
	VertPos: Top = Previous . Bottom + 0.2;
	HorizPos: Left = Enclosing . Left;
	Size: RDF_FONTSIZE;
        Foreground: RDF_FgColor;
        Background: RDF_BgColor;
	BorderTopColor: Black;
	BorderTopStyle: Solid;
	BorderTopWidth: 2 px;
	BorderBottomColor: Black;
	BorderBottomStyle: Solid;
	BorderBottomWidth: 2 px;
	PaddingTop: 0.3;
	PaddingBottom: 0.3;
	IN Links_view
	   Visibility: Thread_visibility;
        END;

 Thread_point_box: BEGIN
	Content: Graphics 'c';
	Height: 0.4;
	Width: 0.4;
	Size: Creator =;
	LineWeight: 1 px;
	Foreground: Creator =;
        VertPos: Bottom = Creator . HRef;
        HorizPos: Right = Creator . Left - 0.3;
	Visibility: Creator =;
	IN Links_view
	   Visibility: Thread_visibility;
	END;

 Thread_orphan_box: BEGIN
	Content: (Text '?  ');
	Size: Creator =;
	Foreground: Creator =;
        VertPos: Href = Creator . HRef;
        HorizPos: Right = Creator . Left - 0.3;
	Visibility: Creator =;
	IN Links_view
	   Visibility: Thread_visibility;
	END;

 Selected_gif: BEGIN
#ifndef PAGE
	Visibility: 5;
	Content: Picture 'selected.gif';
        VertPos: Bottom = Creator . HRef + 0.2;
        HorizPos: Left = Enclosing  . Left;
#endif
	END;

 LeftSpace_box: BEGIN
	Visibility: 5;
	Content: (Text ' ');
	END;

 LeftP_box: BEGIN
	Visibility: 5;
	Content: (Text ' (');
	END;

 RightP_box: BEGIN
	Visibility: 5;
	Content: (Text ')');
	END;

 LeftSB_box: BEGIN
	Visibility: 5;
	Content: (Text ' [');
	END;

 RightSB_box: BEGIN
	Visibility: 5;
	Content: (Text ']');
	END;

RULES

  Document:
	BEGIN
	Adjust: Left;
	Indent: 0;
	Font: Helvetica;
	Style: Roman;
	Weight: Normal;
	LineWeight: 0;
	Width: Enclosing . Width;
	Height: Enclosing . Height min;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . Left;
	END;

  Annot:
	BEGIN
	Width: Enclosing . Width;
	Size: DOC_FONTSIZE;
	MarginLeft: MARGIN;
	MarginRight: MARGIN;
	VertPos: Top = Enclosing . Top;
	IN Links_view
	   Visibility: Thread_visibility;
	END;

 Description:
	BEGIN
	Visibility: Enclosing =;
{	Width: Enclosing . Width; }
	Width: Enclosed . Width;
	MarginTop: 0.2;
	PaddingTop: 0.2;
	PaddingLeft: MARGIN;
	PaddingBottom: 0.2;
	PaddingRight: MARGIN;
	BorderTopWidth: 1 px;
	BorderLeftWidth: 1 px;
	BorderBottomWidth: 1 px;
	BorderRightWidth: 1 px;
	BorderTopColor: Black;
	BorderLeftColor: Black;
	BorderBottomColor: Black;
	BorderRightColor: Black;
	BorderTopStyle: Solid;
	BorderLeftStyle: Solid;
	BorderBottomStyle: Solid;
	BorderRightStyle: Solid;
	Background:  LightCoral4;
	FillPattern: backgroundcolor;
	Foreground: DarkSkyBlue3;
	IN Structure_view
	   Visibility: 0;
	END;

 Body:
	BEGIN
	Width: Enclosing . Width;
	Height: 1 cm min;
	HorizPos: Left = Enclosing . Left - MARGIN;
	VertPos: Top = Previous . Bottom + 0.2;
	Font: Times;
	END;

 ATitle:
	BEGIN
	CreateBefore (ATitle_Box);
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	END;

 Author:
	BEGIN
	CreateBefore (Author_Box);
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	END;

 CreatorEmail:
	BEGIN
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right + 0.2;
	END;

 CreatorGivenName:
	BEGIN
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right + 0.2;
	END;

 CreatorFamilyName:
	BEGIN
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right + 0.2;
	END;

 SourceDoc:
	BEGIN
	CreateBefore (SourceDoc_Box);
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	END;

 RDFtype:
	BEGIN
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	Width: 1 px;
	END;

 AnnotCDate:
	BEGIN
	CreateBefore (CDate_Box);
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	END;

 AnnotMDate:
	BEGIN
	CreateBefore (MDate_Box);
	VertPos: HRef = Previous . HRef;
	HorizPos: Left = Previous . Right;
	END;

 { Threads }

 Thread:
        BEGIN
	CreateBefore (Thread_box);
	VertPos: Top = Previous . Bottom + 0.2;
	HorizPos: Left = Enclosing . Left;
	Width: Enclosing . Width;
	IN Links_view
	   Visibility: Thread_visibility;
        END;

 Thread_item:
        BEGIN	
	if  NOT Orphan_item
	   CreateBefore (Thread_point_box);
        VertPos: Top = Previous AnyElem . Bottom + 0.2;
	HorizPos: Left = Enclosing . left + THREAD_ITEM_INDENT;
	Width: Enclosing . width - THREAD_ITEM_INDENT;
	IN Links_view
	   Visibility: Thread_visibility;
        END;

 TI_desc:
        BEGIN
	Line;
	VertPos: Top = Enclosing . Top;
	HorizPos: Left = Enclosing . left;
	Width: Enclosing . width;
	IN Links_view
	   Visibility: Thread_visibility;
        END;

 TI_content:
	BEGIN
	VertPos: Top = Previous . Bottom + 0.2;
	HorizPos: Left = Enclosing . left + THREAD_INDENT;
	Width: Enclosing . width - THREAD_INDENT;
	IN Links_view
	   Visibility: Thread_visibility;
	END;

 TI_Title:
	BEGIN
	Style: Bold;
	IN Links_view
	   Visibility: Thread_visibility;
	END;

 TI_Date:
	BEGIN
        CreateBefore (LeftSpace_box);
	Style: Italics;
	HorizPos: Left = Previous . Right + 5.0;
	IN Links_view
	   Visibility: Thread_visibility;
	END;

 TI_Author:
	BEGIN
        CreateBefore (LeftP_box);
        CreateAfter (RightP_box);
	HorizPos: Left = Previous . Right + 5.0;
	IN Links_view
	   Visibility: Thread_visibility;
	END;

 TI_Type:
	BEGIN
        CreateBefore (LeftSB_box);
        CreateAfter (RightSB_box);
	HorizPos: Left = Previous . Right + 5.0;
	IN Links_view
	   Visibility: Thread_visibility;
	END;

ATTRIBUTES

 isReply = NO_:
	BEGIN
 	CreateBefore (RDFAtype_Box);
        END;

 isReply = YES_:
	BEGIN
 	CreateBefore (RDFRtype_Box);
        END;

 Selected_:
	 BEGIN
	 CreateFirst (Selected_gif);
 	 Foreground: Red;
	 END;

Orphan_item = Yes_:
	 CreateBefore (Thread_orphan_box);
END


