#ifndef M_VCO_H
#define M_VCO_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <qwidget.h>
#include <qstring.h>
#include <qslider.h>   
#include <qcheckbox.h>  
#include <qlabel.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qdialog.h>
#include <alsa/asoundlib.h>
#include "synthdata.h"
#include "module.h"
#include "port.h"

#define MODULE_VCO_WIDTH                 85
#define MODULE_VCO_HEIGHT               220

enum auxWaveFormType { WAVE_SAW, WAVE_SAW2, WAVE_SAW3 };

class M_vco : public Module
{
  Q_OBJECT

  private:
    float freq, phi0, pw0;
    int harmonic, subharmonic, octave;
    float edge;
    float phi[MAXPOLY];
    float wave_period;
    auxWaveFormType waveForm;
    float vcoExpFMGain, vcoLinFMGain, pwGain;
    Port *port_M_freq, *port_M_exp, *port_M_lin, *port_M_pw;
    Port *port_sine, *port_tri, *port_saw, *port_rect, *port_aux;
    
  public: 
    float **freqData;        
    float **pwData;  // Duty cycle modulation generated by M_lfo
    float **expFMData;        // Frequency modulation exp characteristic
    float **linFMData;        // Frequency modulation lin characteristic
                            
  public:
    M_vco(QWidget* parent=0, const char *name=0, SynthData *p_synthdata=0);
    ~M_vco();
    virtual void noteOnEvent(int osc);

  public slots:
    void generateCycle();
    void showConfigDialog();
};
  
#endif
