/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __CHAINEDCOMPILER_HPP
#define __CHAINEDCOMPILER_HPP

#include "compiler.hpp"

/** @addtogroup compilers
    @{ */
/** Compiler chain consisting of two compilers.
    @date Sun Jan 09 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class ChainedCompiler: public Compiler
{
public:
  /** Constructor taking two compilers as argument.
      @param aCompiler1 Compiler to be applied first.
      @param aCompiler2 Second compiler in the chain. */
  ChainedCompiler( CompilerPtr aCompiler1, CompilerPtr aCompiler2 ):
    compiler1( aCompiler1 ), compiler2( aCompiler2 ) {}
  ///
  virtual void translate( std::istream &inputStream,
                          std::ostream &outputStream ) const
    throw (Error);
protected:
  ///
  CompilerPtr compiler1;
  ///
  CompilerPtr compiler2;
};

///
typedef boost::shared_ptr< ChainedCompiler > ChainedCompilerPtr;

///@}

#endif
