/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __MEALMASTERPARSEERRORHANDLER_HPP
#define __MEALMASTERPARSEERRORHANDLER_HPP

#include "object.hpp"
#include "mealMasterParseError.hpp"

/** Base class for error handlers for handling parse errors.
    This implementation just throws the error.
    @see MealMasterParseError
    @see StoreErroneousHandler
    @see MealMasterCompiler
    @date Sun Jan 09 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class MealMasterParseErrorHandler: public Object {
public:
  /// Constructor.
  MealMasterParseErrorHandler(void) {}
  /// Method handling the errors.
  virtual void error( const MealMasterParseError &e ) throw (Error);
};

///
typedef boost::shared_ptr< MealMasterParseErrorHandler > MealMasterParseErrorHandlerPtr;

#endif
