/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <boost/shared_array.hpp>
#include <klocale.h>
#include "mealMasterStoreErroneousHandler.hpp"

using namespace boost;
using namespace std;

void MealMasterStoreErroneousHandler::error( const MealMasterParseError &e ) throw (Error)
{
  int size = e.getRecipeEndPos() - e.getRecipeStartPos();

  // Clear state of stream.
  e.getInputStream().clear();

  // Copy chunk with erroneous data.
  streampos previousPos = e.getInputStream().tellg();
  e.getInputStream().seekg( e.getRecipeStartPos(), ios::beg );
  shared_array< char > buffer( new char[ size ] );
  e.getInputStream().read( buffer.get(), size );

  // Restore previous stream-position.
  e.getInputStream().seekg( previousPos, ios::beg );

  // Print error-information.
#ifndef NDEBUG
  lineNumber++;
#endif
  *outputStream << "Error in line "
                << ( lineNumber + e.getErrorLineNumber() -
                     e.getRecipeStartLine() + 1 )
                << ": " << e.what() << endl;
  lineNumber++;
#ifndef NDEBUG
  *outputStream << "Stream-position: " << e.getRecipeStartPos()
                << " size of recipe: " << size << endl;
#endif
  // Write erroneous data to the error-file.
  outputStream->write( buffer.get(), size );
  *outputStream << endl << endl;
  lineNumber += e.getRecipeEndLine() - e.getRecipeStartLine() + 3;

  ERRORMACRO( *outputStream, Error, ,
              i18n( "Error writing to %1." ).arg( systemId ) );
}
