/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
/****************************************************************************
 ** ui.h extension file, included from the uic-generated form implementation.
 **
 ** If you wish to add, delete or rename slots use Qt Designer which will
 ** update this file, preserving your code. Create an init() slot in place of
 ** a constructor, and a destroy() slot in place of a destructor.
 *****************************************************************************/


void SearchDialog::init()
{
  categoryListView->setColumnAlignment( 0, Qt::AlignRight );
  categoryListView->setSorting( 1, true );
}


void SearchDialog::clearCategorySelection()
{
  QCheckListItem *item = (QCheckListItem *)categoryListView->firstChild();

  while ( item != NULL ) {

    item->setOn( false );
    item = (QCheckListItem *)item->nextSibling();

  };
}

void SearchDialog::selectAllCategories()
{
  QCheckListItem *item = (QCheckListItem *)categoryListView->firstChild();

  while ( item != NULL ) {

    item->setOn( true );
    item = (QCheckListItem *)item->nextSibling();

  };
}


void SearchDialog::splitWords(std::istream &words,std::ostream &xmlOut)
{

  while ( true ) {
    
    std::string word;
    words >> word;
    
    if ( !words ) break;
    
    xmlOut << "      <word>" << xmlText( word ) << "</word>" << std::endl;
    
  };
  
}


std::string SearchDialog::xmlQuery(void)
{
  assert( cookBook );

  std::ostringstream searchXML;
  searchXML << "<?xml version='1.0' encoding='UTF-8'?>" << std::endl
            << "<list limit='" << limitSpinBox->value()
            << "' ordered='"
            << ( orderedCheckBox->isChecked() ? "true" : "false" )
            <<"'><selection user='"
            << cookBook->getDatabase()->getServer()->getUserName()
            << "'><search>" << std::endl;

  // Restrict to selected recipes.
  if ( restrictCheckBox->isChecked() ) {
    searchXML << "<selection/>" << std::endl;
  };

  // Title
  if ( titleWordView->childCount() > 0  ) {
    searchXML << "   <title>" << std::endl;
    QListViewItem *item = titleWordView->firstChild();
    while ( item != NULL ) {
      searchXML << "      <word>" << xmlText( (const char *)item->text( 0 ) )
                << "</word>" << std::endl;
      item = item->nextSibling();
    };
    searchXML << "   </title>" << std::endl;
  };

  // Categories.
  {
    // Create two vectors:
    // One vector containing the identity numbers of the deselected categories
    // and one specifying the selected categories.
    std::map< bool, std::vector< std::string > > categories;

    QCheckListItem *item = (QCheckListItem *)categoryListView->firstChild();
    while ( item != NULL ) {
      categories[ item->isOn() ].push_back( (const char *)item->text( 1 ) );
      item = (QCheckListItem *)item->nextSibling();
    };
    
    bool positiveQuery =
      categories[ true ].size() <= categories[ false ].size();
    
    if ( !categories[ positiveQuery ].empty() ) {
      searchXML << "   <category positive='" << positiveQuery << "'>"
                << std::endl;
      for ( int i=0; i<(signed)categories[ positiveQuery ].size(); i++ )
        searchXML << "      <word>"
                  << xmlText( categories[ positiveQuery ][ i ] )
                  << "</word>" << std::endl;
      searchXML << "   </category>" << std::endl;
    };
  };

  // Ingredients.
  if ( ingredientWordView->childCount() > 0 ) {
    searchXML << "   <ingredient>" << std::endl;
    QCheckListItem *item = (QCheckListItem *)ingredientWordView->firstChild();
    while ( item != NULL ) {
      searchXML << "      <word positive='" << ( item->isOn() ? 1 : 0 )
                << "'>" << xmlText( (const char *)item->text( 0 ) )
                << "</word>" << std::endl;
      item = (QCheckListItem *)item->nextSibling();
    };
    searchXML << "   </ingredient>" << std::endl;
  };
  
  searchXML << "</search></selection></list>";

#ifndef NDEBUG
  std::cerr << searchXML.str() << std::endl;
#endif

  return searchXML.str();
}


void SearchDialog::reloadCategories()
{
  assert( cookBook );
  DisplayWaitCursor w;

  // Extract list of categories.
  XMLDocument xmlDocument( "" );
  xmlDocument.fromString
    ( cookBook->getXMLLayer()->translate
      ( "<?xml version='1.0' encoding='UTF-8'?><categories/>" ) );

  XMLNodeReferenceList nodeList( xmlDocument.getDocumentElement().
                                 selectNodes( "categories/table/row" ) );

  // Clear list.
  categoryListView->clear();

  for ( int i=0; i<nodeList.getLength(); i++ ) {
    XMLReference< XalanElement > category =
      dynamic_pointer_cast< XalanElement >( nodeList.item( i ) );
    QCheckListItem *checkListItem =
      new CategoryListItem( categoryListView,
                            category.selectNode( "column[position()=1]" ).
                            getNodeText().c_str() );
    checkListItem->setText( 1,
                            category.selectNode( "column[position()=2]" ).
                            getNodeText().c_str() );
    checkListItem->setOn( true );
  };
  
}


void SearchDialog::addTitleButtonEnable()
{
  addTitleWordButton->setEnabled
    ( !titleEdit->text().isEmpty() &&
      titleWordView->findItem( titleEdit->text(), 0 ) == NULL );
}


void SearchDialog::selectTitleWord(QListViewItem *item)
{
  removeTitleWordButton->setEnabled( item != NULL );
  if ( item != NULL )
    titleEdit->setText( item->text( 0 ) );
}


void SearchDialog::addTitleWord()
{
  assert( !titleEdit->text().isEmpty() );
  new QListViewItem( titleWordView, titleEdit->text() );
  titleEdit->clear();
}


void SearchDialog::removeTitleWord()
{
  if ( titleWordView->currentItem() )
    delete titleWordView->currentItem();
  removeTitleWordButton->setEnabled( false );
  addTitleButtonEnable();
}


void SearchDialog::addIngredientWord()
{
  assert( !ingredientEdit->text().isEmpty() );
  QCheckListItem *item =
    new QCheckListItem( ingredientWordView, ingredientEdit->text(),
                        QCheckListItem::CheckBoxController );
  item->setOn( true );
  ingredientEdit->clear();
}


void SearchDialog::removeIngredientWord()
{
  if ( ingredientWordView->currentItem() )
    delete ingredientWordView->currentItem();
  removeIngredientWordButton->setEnabled( false );
  addIngredientButtonEnable();
}


void SearchDialog::selectIngredientWord( QListViewItem *item )
{
  removeIngredientWordButton->setEnabled( item != NULL );
  if ( item != NULL )
    ingredientEdit->setText( item->text( 0 ) );
}


void SearchDialog::addIngredientButtonEnable()
{
  addIngredientWordButton->setEnabled
    ( !ingredientEdit->text().isEmpty() &&
      ingredientWordView->findItem( ingredientEdit->text(), 0 ) == NULL );
}
