#include "xmlNodeReferenceList.hpp"

XMLNodeReferenceList::XMLNodeReferenceList( const XMLNodeReferenceList &l ):
  Object( l ),
#ifndef SIMPLEXPATH
  xObject( l.xObject ),
#endif
  nodeList( l.nodeList ), document( l.document )
{}

XMLReference< XalanNode > XMLNodeReferenceList::item( int index ) const
{
  return XMLReference< XalanNode >( nodeList.item( index ), document );
}

int XMLNodeReferenceList::getLength(void) const
{
#ifdef SIMPLEXPATH
  return nodeList.getLength();
#else
  return (*xObject)->nodeset().getLength();
#endif
}
