/*
 * Copyright (C) 2005 Universitat d'Alacant / Universidad de Alicante
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
/** 
 *  Word class and MorphoStream class definitions
 *
 *  @author	Felipe Snchez-Martnez 
 */

#ifndef __MORPHOSTREAM_H
#define __MORPHOSTREAM_H

#include <cstdio>
#include <set>
#include <map>
#include <iostream>
#include <string>
#include <vector>

#include <apertium/ConstantManager.H>
#include <apertium/LexWrapper.H>
#include <apertium/TaggerWord.H>

using namespace std;

/** Class MorphoStream.  
 *  This class process the ouput of class  yyFlexLexer (lex.yy.cc), and 
 *  build the TaggerWord objects managed by the tagger 
 */
class MorphoStream {
private:
  LexWrapper *flexx;
  bool foundEOF;
  string last_string_tag;
  bool debug;

  vector<TaggerWord*> vwords; //Vector used to implement a buffer
                       //to treat ambiguous multiword units

  map<string, int> tags_index;
  vector<string> prefer_rules;
  ConstantManager constants;  
 
public:

   /** Constructor 
    *  @param is the input stream.
    */
   MorphoStream(FILE *ftxt, bool d, ConstantManager const &cm, 
                map<string, int> const &ti, vector<string> const &pr);
  
   /** 
    *  Destructor 
    */
   ~MorphoStream();
  
   /** Get next word in the input strem
    *  @return  A pointer to the next word in the input stream 
    */
   TaggerWord* get_next_word();
  
   /** Get the next tag. This method is useful when evaluating the tagger performance.
    */
   TTag get_next_tag();
   
   /** Get the string that made the last tag to be matched
    *  Devuelve la cadena a partir de la cual, se obtuvo la ltima etiqueta.
    *  El mtodo es til para la depuracin del programa de evaluacin del tagger.
    */
   string get_string_last_tag();
};

#endif
