#include <apertium/TransferInstr.H>

void
TransferInstr::copy(TransferInstr const &o)
{
  type = o.type;
  content = o.content;
  pos = o.pos;
  pointer = o.pointer;
}

void
TransferInstr::destroy()
{
}

TransferInstr::TransferInstr(TransferInstrType t, string const &c, int const p, void *ptr)
{
  type = t;
  content = c;
  pos = p;
  pointer = ptr;
}

TransferInstr::~TransferInstr()
{
  destroy();
}

TransferInstr::TransferInstr(TransferInstr const &o)
{
  copy(o);
}

TransferInstr &
TransferInstr::operator =(TransferInstr const &o)
{
  if(this != &o)
  {
    destroy();
    copy(o);
  }
  return *this;
}

TransferInstrType
TransferInstr::getType()
{
  return type;
}

string const &
TransferInstr::getContent()
{
  return content;
}

int
TransferInstr::getPos()
{
  return pos;
}

void *
TransferInstr::getPointer()
{
  return pointer;
}
