#include "main.h"

extern int EARLY_FINISH;
int error_flag;
bench_struct benched[25];
extern int STATUS_WHEEL;


mysock *make_socket(void)
{
	mysock *sock = (mysock*)malloc(sizeof(mysock));
	if(sock != NULL)
	{
		memset(sock->domain, ' ', 255);
		memset(sock->tail, ' ', SOCKET_BUFFER_SIZE-1);
		sock->speed = 0;
		sock-> fd = 0;
		sock->stream = NULL;
	}
	else
		printf("\nERROR MALLOCING\n");

	return sock;
}

mysock *Open_Site(char *site, int port)
{
	int myFD, totalRead, ret, sel;
	FILE *fp;
	struct sockaddr_in inDeb;
	struct hostent* hostinfo;
	mysock *sock;
	fd_set set;
	struct timeval tv;
	socklen_t vallen;

	fflush(stdout);
	fflush(stdin);

	sock = make_socket();
	if(sock == NULL)
		return sock;


	totalRead=0;
	memset(&inDeb, 0, sizeof(inDeb));
	inDeb.sin_family = AF_INET;
	inDeb.sin_port   = htons(port);

	clr_line();
	post_message("[|s] Resolving host ...");
	fflush(stdout);

	hostinfo = gethostbyname(site);
	if(hostinfo == NULL)
	{
		post_message("[*] Error resolving %s.", site);
		return NULL;
	}

	post_message("[|s] Creating socket ...");
	fflush(stdout);
	inDeb.sin_addr = *(struct in_addr*)hostinfo->h_addr;
	myFD = socket(AF_INET, SOCK_STREAM, 0);

	if (myFD < 0)
	{
		post_message("[*] Could not create FD with socket().");
		fflush(stdout);
		return NULL;
	}

	post_message("[|s] Connecting to socket ...");
	fflush(stdout);



	//////////////////////////////////////////////////////////////

	ret = 1;
	ioctl(myFD, FIONBIO, &ret);

	if(-1 == connect(myFD, (const struct sockaddr*)&inDeb, sizeof(inDeb)))
		//if(connect(myFD, &inDeb, sizeof(inDeb)) == -1)
	{
		if(EINPROGRESS == errno)
		{
			tv.tv_sec = 5;
			tv.tv_usec = 0;
			FD_ZERO(&set);
			FD_SET(myFD, &set);

			post_message("[|s] Selecting socket ...     ");
			fflush(stdout);

			switch(select(myFD+1, NULL, &set, NULL, &tv))
			{
				case 0:
				post_message("[*] Connect timed out");
				fflush(stdout);
				Close_Socket(sock);
				return NULL;

				case 1:
				post_message("[*] Connected to %s @ %d", site, port);
				vallen = sizeof(ret);
				getsockopt(myFD, SOL_SOCKET, SO_ERROR, &ret, &vallen);

				if(0 == ret)
				{
					clr_line();
					post_message("[*] Connect verified");
					fflush(stdout);
					goto done;
				}
				else
				{
					clr_line();
					post_message("[*] Connect failed");
					fflush(stdout);
					Close_Socket(sock);
					return NULL;
				}

				default:
				perror("select: ");
				exit(-1);
			}
		}
		else
		{
			perror("connect: ");
			exit(-1);
		}
	}

done:

	ret = 0;
	ioctl(myFD, FIONBIO, &ret);

	//////////////////////////////////////////////////////////////


	/*
		if(ret < 0)
		{
			post_message("[*] Error with connect()'ing to address.");
			fflush(stdout);
			return NULL;
		}
	*/

	//   post_message("[*] Connected to %s @ %d", site, port);


	sock->fd = myFD;
	strcpy(sock->domain, site);
	sock->stream = fdopen(myFD, "r+");
	fflush(sock->stream);

	return sock;
}


void Close_Socket(mysock *sock)
{
	shutdown(sock->fd, 2);
	free((void*)sock);
}


int Check_Reply(mysock *sock)
{
	int readNum, num_blocks, leftover, ret;
	char myBuff[SOCKET_BUFFER_SIZE];

	bzero(myBuff, SOCKET_BUFFER_SIZE);
	ret = 0;

	update_status;
	if(NULL == fgets(myBuff, SOCKET_BUFFER_SIZE, sock->stream))
	{
		return 0;
	}
	update_status;

	if(myBuff[3] == '-')
		while(myBuff[3] != ' ' || !isalnum(myBuff[0]))
		{
			if(NULL == fgets(myBuff, SOCKET_BUFFER_SIZE, sock->stream))
				return 0;
			update_status;
		}

	strcpy(sock->tail, myBuff);
	update_status;

	if(myBuff[3] == ' ')
	{
		sscanf(myBuff, "%d ", &ret);
		update_status;
		return ret;
	}
	else
		return 0;
}


int Get_Pos(char *str, int c)
{
	int len = strlen(str), i;

	for(i=0; i < len, str[i] != c; i++)
		update_status;

	if(str[i] == c)
		return i;
	return -1;
}


int Places(long i)
{
	if(i > 1000000000)
		return 10;
	else if(i > 100000000)
		return 9;
	else if(i > 10000000)
		return 8;
	else if(i > 1000000)
		return 7;
	else if(i > 100000)
		return 6;
	else if(i > 10000)
		return 5;
	else if(i > 1000)
		return 4;
	else if(i > 100)
		return 3;
	else if(i > 10)
		return 2;
	return 1;
}


int timeoutAlarm=0;

void *timeoutFunction()
{
	timeoutAlarm=1;
}
void (*func)() = timeoutFunction;


FILE *Get_FTP_File(char *url, int binary, float *bench)
{
	mysock *sock, *sock2;
	char domain[256], path[256], tmp[256],real_address[256];
	char *proxy;
	int pos, i, ret, x1, x2, x3, x4, p1, p2,port;
	long filelen, li;
	float ans;
	FILE *out;
	time_t start, end;

	struct sigaction action;

	error_flag=0;
	port = 21;
	proxy = NULL;

	post_message("[|s] Attempting connection...");
	sscanf(url, "ftp://%s", domain);

	pos = Get_Pos(domain, '/');
	if(pos < 0)
	{
		error_flag=1;
		return NULL;
	}

	for(i=pos; i < strlen(domain)+1; i++)
		path[i-pos] = domain[i];

	domain[pos] = '\0';

	/*                Proxy support

	 * Connect to  $ftp_proxy if it's set instead of the URL given */
	proxy = getenv("ftp_proxy");
	if(proxy != NULL)
	{
		memcpy(real_address, domain, strlen(domain)+1);
		memset(domain, '\0', sizeof(domain));

		sscanf(proxy,"ftp://%s:%d",domain,&port);
	}


	sock = Open_Site(domain, port);
	if(sock == NULL)
	{
		error_flag=1;
		return NULL;
	}
	ret = 0;


	clr_line();
	post_message("[|s] Logging in...");

	timeoutAlarm = 0;
	action.sa_handler = func;
	action.sa_flags   = 0;
	sigemptyset(&(action.sa_mask));
	sigaction(SIGALRM, &action, NULL);
	alarm(10);

	while( (ret/100) != 2 )
	{
		ret = Check_Reply(sock);
		if(!ret)
		{
			Close_Socket(sock);
			error_flag=1;
			alarm(0);
			return NULL;
		}
	}

	if(timeoutAlarm)
	{
		post_message("|cOperation Timeout...");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}
	/*            more proxy support
		      
	 * if proxy is being used send this login instead of the 
	 * default one. This is the part that must be changed 
	 * to support other kinds of FTP proxies? */

	if(proxy)
	{
		sprintf(tmp,"USER anonymous@%s\x0d\x0a",real_address);
		fprintf(sock->stream, tmp);
	}
	else
	{
		fprintf(sock->stream, "USER anonymous\x0d\x0a");
	}

	ret = Check_Reply(sock);

	if(timeoutAlarm)
	{
		post_message("|cOperation Timeout...");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}


	if( (ret/100) == 3 )
	{
		fprintf(sock->stream, "PASS apt-sources@\x0d\x0a");
		ret = Check_Reply(sock);

		if(timeoutAlarm)
		{
			post_message("|cOperation Timeout...");
			Close_Socket(sock);
			error_flag=1;
			alarm(0);
			return NULL;
		}
		if( (ret/100) == 3 )
		{
			fprintf(sock->stream, "ACCT noaccount\x0d\x0a");
			ret = Check_Reply(sock);
		}
	}
	if( (ret/100) != 2)
	{
		sock->tail[strlen(sock->tail)-1] = '\0';
		post_message("|cLogin unsuccessful [%s]...", sock->tail);
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}
	post_message("[|s] Login successful ...");


	if(timeoutAlarm)
	{
		post_message("|cOperation Timeout...");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}

	fprintf(sock->stream, binary ? "TYPE I\x0d\x0a" : "TYPE A\x0d\x0a");
	post_message("[|s] Setting type to %s", binary ? "binary ..." : "ascii ...");
	ret = Check_Reply(sock);

	if(timeoutAlarm)
	{
		post_message("|cOperation Timeout...");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}


	if( (ret/100) != 2)
	{
		post_message("|cUnable to set type");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}

	post_message("[|s] Setting passive mode ...");
	fprintf(sock->stream, "PASV\x0d\x0a");
	ret = Check_Reply(sock);

	if(timeoutAlarm)
	{
		post_message("|cOperation Timeout...");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}


	if( ret != 227 )
	{
		post_message("|cUnable to set passive mode");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}

	fflush(stdout);
	post_message("[|s] Parsing address and port for transfer ...");
	sscanf(sock->tail, "%*[^(](%s)", tmp);
	sscanf(tmp, "%d,%d,%d,%d,%d,%d)", &x1, &x2, &x3, &x4, &p1, &p2);
	p1 = p1 * 256 + p2;
	sprintf(tmp, "%d.%d.%d.%d", x1, x2, x3, x4);
	//	printf("%s @ %d\n", tmp, p1);


	alarm(0);
	timeoutAlarm = 0;
	action.sa_handler = func;
	action.sa_flags   = 0;
	sigemptyset(&(action.sa_mask));
	sigaction(SIGALRM, &action, NULL);
	alarm(10);


	sock2 = Open_Site(tmp, p1);
	if(sock2 == NULL)
	{
		post_message("|cCould not connect to %s @ %ld for transfer", tmp, p1);
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}

	if(timeoutAlarm)
	{
		post_message("|cOperation Timeout...");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}


	fflush(stdout);
	clr_line();
	post_message("[|s] Attempting to a RETR ...");

	fprintf(sock->stream, "RETR %s\x0d\x0a", path);
	ret = Check_Reply(sock);

	if(timeoutAlarm)
	{
		post_message("|cOperation Timeout...");
		Close_Socket(sock);
		error_flag=1;
		alarm(0);
		return NULL;
	}


	if( (ret/100) != 1)
	{
		post_message("|cRetrieving of %s failed", path);
		Close_Socket(sock);
		Close_Socket(sock2);
		error_flag=1;
		alarm(0);
		return NULL;
	}

	sscanf(sock->tail, "%*[^(](%ld", &filelen);
	fflush(stdout);

	alarm(0);

	if(bench == NULL)
	{
		post_message("|c[|s:%1.2d%%] Getting data (%ld bytes)", 0, filelen);
		out = tmpfile();

		for(li=0; li < filelen; li++)
		{
			x1 = fgetc(sock2->stream);

			if(x1 != EOF)
			{
				ans = (float)li / (float)filelen * 100;

				if(li%128 == 0)
				{
					if(!STATUS_WHEEL)
						post_message("[|s:%1.2d%%]",(int)ans);
				}
				if(binary)
					fputc(x1&0xff, out);
				else
					fputc(x1,out);
			}
		}

		post_message("[|s:%1.2d%%] Getting data (%ld bytes) - Done", 100, filelen);

		fprintf(sock->stream, "QUIT\x0d\x0a");
		Close_Socket(sock);
		Close_Socket(sock2);
		fflush(stdout);
		return out;
	}

	post_message("[|s : 000.000  kB/s] Benchmarking %s", domain);

	start = time(NULL);

	for(li=0; li < filelen; li++)
	{
		x1 = fgetc(sock2->stream);
		update_status;

		end = time(NULL) - start;
		if(x1 != EOF)
		{
			if(li%2048 == 0)
			{
				ans = ((float)li/1024.0) / end;
				if(!STATUS_WHEEL)
					post_message("[|s : %2.2f", ans);
			}
		}

		if(end > BENCHMARK_TIME)
			break;
	}

	end = time(NULL) - start;
	if(end == 0)
		end = 1;
	ans = ((float)li/2048) / end;


	clr_line();
	post_message("[|s : %2.2f  kB/s] Benchmarking %s", ans, domain);

	fprintf(sock->stream, "QUIT\x0d\x0a");
	Close_Socket(sock);
	Close_Socket(sock2);

	*bench = ans;

	fflush(stdout);
	return NULL;
}

int compar(const void *a, const void *b)
{
	bench_struct *tmp1, *tmp2;
	tmp1 = (bench_struct *)a;
	tmp2 = (bench_struct *)b;

	if(!STATUS_WHEEL)
		post_message("[|s]");

	if((tmp1->speed) < (tmp2->speed))
		return -1;
	else if((tmp1->speed) > (tmp2->speed))
		return 1;
	else
		return 0;
}



FILE *Benchmark_List(FILE *in)
{
	char myBuff[STRING_BUFFER_SIZE], domain[STRING_BUFFER_SIZE];
	FILE *out = tmpfile();
	float speed;
	int index=0,i;

	fseek(in, 0L, SEEK_SET);
	post_message("|c[|s] Benchmarking List");

	for(index=0; index < 25; index++)
	{
		benched[index].speed = 0;
		strcpy(benched[index].domain, "");
	}
	index=0;

	while(!feof(in))
	{
		fgets(domain, STRING_BUFFER_SIZE, in);
		sscanf(domain, "%s", myBuff);
		strcpy(domain, myBuff);
		if(!feof(in))
		{
			//			while(myBuff[strlen(myBuff)] == '\r' || myBuff[strlen(myBuff)] == '\n')
			if(isspace(myBuff[strlen(myBuff)-1]))
				myBuff[strlen(myBuff)-1] = '\0';
			if(myBuff[strlen(myBuff)] != '/')
				sprintf(myBuff, "%s/ls-lR.gz", myBuff);
			else
				sprintf(myBuff, "%sls-lR.gz", myBuff);
			fflush(stdout);
			Get_FTP_File(myBuff, BINARY, &speed);

			if(!error_flag)
			{
				if(benched[0].speed < speed)
				{
					benched[0].speed = speed;
					strcpy(benched[0].domain, domain);
					qsort(benched, 25, sizeof(bench_struct), compar);
				}
				index++;
				//				for(i=0; i < 25; i++)
				//					printf("\n%s @ %1.2f", benched[i].domain, benched[i].speed);
			}
			newline;
		}
		if(index >= EARLY_FINISH && EARLY_FINISH)
			break;
	}

	for(i=24; i != 0; i--)
	{
		fprintf(out, "%s @ %1.2f\n", benched[i].domain, benched[i].speed);
	}

	fclose(in);
	return out;
}


