# apt-transport-tor

Easily install Debian packages via Tor.

This package implements an APT "acquire method" that handles URLs starting
with "tor+http://" or "tor+https://" in your sources.list.

## Usage

Edit your /etc/apt/sources.list like so, adjusting the suite/components
appropriately for your system:

    deb     tor+http://httpredir.debian.org/debian unstable main
    deb-src tor+http://httpredir.debian.org/debian unstable main

Note the use of httpredir.debian.org so that a mirror close to your exit node
will be automatically chosen.

Alternatively, if you have the Tor onion service address of a Debian
mirror, you can use that:

    deb     tor+http://<long string>.onion/debian unstable main
    deb-src tor+http://<long string>.onion/debian unstable main

## APT repositories as onion services

While apt sends no directly identifying information to mirrors the download of
metadata like the Translation files as well as individual package names can
potentially reveal information about a user an adversary could observe.
If this is a concern, some APT repositories are available as onion services
which means the information doesn't leave the Tor network via an exit node:

Debian Project: [Complete List](https://onion.debian.org) [Announcement](https://bits.debian.org/2016/08/debian-and-tor-services-available-as-onion-services.html)

 * ftp.debian.org: tor+http://vwakviie2ienjx6t.onion/
 * security.debian.org: tor+http://sgvtcaew4bxjd7ln.onion/
 * people.debian.org: tor+http://hd37oiauf5uoz7gg.onion/
 * mozilla.debian.net: tor+http://fkbjngvraoici6k7.onion/
 * debug.mirrors.debian.org: tor+http://ktqxbqrhg5ai2c7f.onion/
 * incoming.debian.org: tor+http://oscbw3h7wrfxqi4m.onion/
 * ftp.ports.debian.org: tor+http://nbybwh4atabu6xq3.onion/
 * incoming.ports.debian.org: tor+http://vyrxto4jsgoxvilf.onion/

Tor Project: [Complete List](https://onion.torproject.org/) [Announcement](https://blog.torproject.org/blog/debian-and-tor-services-available-onion-services)

 * deb.torproject.org: tor+http://sdscoq7snqtznauu.onion/

Note that this list might not be current: Verify before use! The list is
provided only to showcase that many commonly used repositories are already
available as an onion service.

## Configuration

### Using a different Tor instance

By default, apt-transport-tor uses the following SOCKS proxy setting, which
is the default location of a locally installed Tor instance:

	Acquire::tor::proxy "socks5h://apt-transport-tor@localhost:9050";

Note the use of a username to make use of the default IsolateSOCKSAuth Tor
setting for stream isolation, which requires Tor 0.2.4.19 to work well.
This means your apt traffic will be sent over a different circuit from your
regular Tor traffic and for each host you connect to.

### Disabling use of http(s) without Tor in APT

APT >= 1.3 allows methods to be disabled without removing them from the system,
so to avoid mistakenly adding new sources without using tor you can tell apt
via the following configuration options to fail for non-tor-http(s) sources:

	Dir::Bin::Methods::http "false";
	Dir::Bin::Methods::https "false";

## Caveats

Downloading your Debian packages over Tor prevents an attacker who is
sniffing your network connection from being able to tell which packages
you are fetching, or even that your traffic is Debian-related.

However, this does not necessarily defend you from, amongst other things:

* a global passive adversary (who could potentially correlate the exit
  node's traffic with your local Tor traffic)
* an attacker looking at the size of your downloads, and making an
  educated guess about the contents
* an attacker who has broken into your machine

Download speeds will be slower via Tor.

## Copyright & Licensing

    Copyright (C) 2014 Tim Retout <diocles@debian.org>
    Copyright (C) 2016 David Kalnischkies <donkult@debian.org>

License:

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

## Feedback

Comments and suggestions to: [APT developer mailinglist](mailto:deity@lists.debian.org) ([archive](https://lists.debian.org/deity/))

Bug reports should be sent to the Debian BTS.
