// download.cc
//
//  Copyright 2000 Daniel Burrows
//
//  Contains the scary code to download various things.  A little hairier than
// it has to be, partly because I didn't understand how it worked at the time
// that I wrote it.

#include "aptitude.h"
#include "ui.h"
#include "cmdline.h"

#include "generic/apt.h"
#include "generic/config_signal.h"

#include "download_manager.h"

#ifdef HAVEAPTCFG_H
#include "../config.h"
#endif

#include <vscreen/vscreen.h>
#include <vscreen/vs_center.h>
#include <vscreen/vs_frame.h>
#include <vscreen/vs_label.h>
#include <vscreen/vs_multiplex.h>

#include <signal.h>

#include <apt-pkg/init.h>
#include <apt-pkg/clean.h>
#include <apt-pkg/error.h>
#include <apt-pkg/dpkgpm.h>
#include <apt-pkg/packagemanager.h>
#include <apt-pkg/sourcelist.h>
#include <apt-pkg/acquire.h>
#include <apt-pkg/acquire-item.h>
#ifdef HAVE_LIBAPT_PKG3
#include <apt-pkg/pkgsystem.h>
#endif

#if (APT_PKG_MAJOR==3 && APT_PKG_MINOR>=2) || APT_PKG_MAJOR>3
typedef pkgAcquire::ItemIterator pkgAcquireIterator;
#else
typedef pkgAcquire::Item** pkgAcquireIterator;
#endif

// (ewww, this is duplicated code)
//
// Ok, this is, uh, weird.  Erase has to be overridden to at least
// call unlink()
//
// Should I list what I'm doing like apt-get does?
class my_cleaner:public pkgArchiveCleaner
{
protected:
  virtual void Erase(const char *file,
		     string pkg,
		     string ver,
		     struct stat &stat)
  {
    unlink(file);
  }
};

using namespace std;

// This is a somewhat odd class, but it's useful for allowing downloads to be
// aborted.
class downloader:public SigC::Object
{
  bool aborted;
public:
  downloader():aborted(false) {}
  void abort() {aborted=true;}
  bool get_aborted() {return aborted;}
};

bool do_pkglist_update(OpProgress *load_progress,
		       bool text_download)
  // I made heavy reference here to apt-get and console-apt's code..
  // As a result, this routine is terribly hairy :(
{
  pkgSourceList src_list;

  if(!(*apt_cache_file)->save_selection_list(*load_progress))
    return false;

  // FIXME: should save_selection_list do this?
  load_progress->Done();

  if(src_list.ReadMainList()==false)
    {
      _error->Error(_("Couldn't read list of package sources"));
      return false;
    }

  // Lock the list directory
  FileFd lock;
  if(aptcfg->FindB("Debug::NoLocking", false)==false)
    {
      lock.Fd(GetLock(aptcfg->FindDir("Dir::State::Lists")+"lock"));
      if(_error->PendingError()==true)
	{
	  _error->Error(_("Couldn't lock list directory..are you root?"));
	  return false;
	}
    }

  download_manager *download_progress;
  if(!text_download)
    download_progress=gen_download_progress();
  else
    download_progress=gen_cmdline_download_progress();
  pkgAcquire fetcher(download_progress);

#ifndef HAVE_LIBAPT_PKG3
  for(pkgSourceList::const_iterator i=src_list.begin(); i!=src_list.end(); i++)
    {
      new pkgAcqIndex(&fetcher, i);
      if(_error->PendingError()==true)
	{
	  // FIXME: show an error message??
	  // FIXME: will this deallocate all the workers and stuff?
	  delete download_progress;
	  return false;
	}
    }
#else
  if(!src_list.GetIndexes(&fetcher))
    {
      delete download_progress;
      return false;
    }
#endif

  sigset_t signals,oldsigs;
  sigemptyset(&signals);
  sigaddset(&signals, SIGWINCH);
  sigprocmask(SIG_UNBLOCK, &signals, &oldsigs);

  switch(fetcher.Run())
    // At this point the widget should be deleted
    {
    case pkgAcquire::Failed:
    case pkgAcquire::Cancelled:
      for(pkgAcquireIterator i=fetcher.ItemsBegin(); i!=fetcher.ItemsEnd(); ++i)
	(*i)->Finished();
      // ??????
      // Shouldn't that cure my "dequeuing fetching object" woes?  HELP!

      sigprocmask(SIG_SETMASK, &oldsigs, &signals);

      download_progress->Complete();

      delete download_progress;

      apt_reload_cache(load_progress, true);
      return false;  // Should I return true for cancelled?
    case pkgAcquire::Continue:
      for(pkgAcquireIterator i=fetcher.ItemsBegin(); i!=fetcher.ItemsEnd(); ++i)
	if((*i)->Status!=pkgAcquire::Item::StatDone)
	  (*i)->Finished();

      sigprocmask(SIG_SETMASK, &oldsigs, &signals);

      break;
    }

  // Clean old stuff out (?)
  if(fetcher.Clean(aptcfg->FindDir("Dir::State::lists"))==false ||
     fetcher.Clean(aptcfg->FindDir("Dir::State::lists")+"partial/")==false)
    {
      _error->Error(_("Couldn't clean out list directories"));
      delete download_progress;
      return false;
    }

  download_progress->Complete();

  apt_reload_cache(load_progress, true);

  if(aptcfg->FindB(PACKAGE "::Forget-New-On-Update", false))
    do_forget_new();

  if(aptcfg->FindB(PACKAGE "::AutoClean-After-Update", false))
    {
      vscreen_widget *msg=NULL;
      if(!text_download)
	{
	  msg=new vs_center(new vs_frame(new vs_label(_("Deleting obsolete downloaded files"))));
	  popup_widget(msg);
	  vscreen_tryupdate();
	}
      else
	printf(_("Deleting obsolete downloaded files\n"));

      my_cleaner cleaner;
      cleaner.Go(aptcfg->FindDir("Dir::Cache::archives"), *apt_cache_file);
      cleaner.Go(aptcfg->FindDir("Dir::Cache::archives")+"partial/",
		 *apt_cache_file);

      if(msg)
	msg->destroy();
    }

  return true;
}

// This stuff is for logging:
typedef pair<pkgCache::PkgIterator, pkg_action_state> logitem;
typedef list<logitem> loglist;

struct log_sorter
{
public:
  inline bool operator()(const logitem &a, const logitem &b)
  {
    if(a.second<b.second)
      return true;
    else if(a.second>b.second)
      return false;
    else return strcmp(a.first.Name(), b.first.Name())<0;
  }
};

bool do_install_run(OpProgress *load_progress,
		    bool text_download, bool download_only)
{
  downloader abortable;

  if(!(*apt_cache_file)->save_selection_list(*load_progress))
    return false;

  load_progress->Done();

  // Lock the archive directory..
  FileFd lock;
  if(aptcfg->FindB("Debug::NoLocking", false)==false)
    {
      lock.Fd(GetLock(aptcfg->FindDir("Dir::State::Lists")+"lock"));
      if(_error->PendingError()==true)
	{
	  _error->Error(_("Couldn't lock list directory..are you root?"));
	  return false;
	}
    }

  download_manager *download_progress;
  if(!text_download)
    download_progress=gen_download_progress(false,
					    SigC::slot(&abortable,
						       &downloader::abort));
  else
    download_progress=gen_cmdline_download_progress();

  pkgAcquire fetcher(download_progress);

  // Get source lists.
  pkgSourceList list;
  if(!list.ReadMainList())
    {
      _error->Error(_("Couldn't read source list"));

      delete download_progress;
      return false;
    }

  // Make a package manager, get ready to download
  pkgDPkgPM pm(*apt_cache_file);
  if(!pm.GetArchives(&fetcher, &list, apt_package_records) || _error->PendingError())
    {
      _error->Error(_("Internal error: couldn't generate list of packages to download"));

      delete download_progress;
      return false;
    }

  // FIXME: check for free space

  // FIXME: console-apt checks for errors here.  I don't see anything that
  // could cause errors :)

  sigset_t signals,oldsigs;
  sigemptyset(&signals);
  sigaddset(&signals, SIGWINCH);
  sigprocmask(SIG_UNBLOCK, &signals, &oldsigs);

  // FIXME: the control logic in the following loop is very tortuous and
  //       should be simplified.

  // This variable is set at the end of the loop iff the package run was
  // *not incomplete*.  However, there are several other exits from the loop;
  // in fact, the apt-get equivalent to this just does "while(1)" and breaks
  // out as necessary.
  bool done=false;
  bool ok=true;

  while(!done)
    {
      sigprocmask(SIG_SETMASK, &oldsigs, &signals);

      pkgAcquire::RunResult res=fetcher.Run();
      if(res!=pkgAcquire::Continue || abortable.get_aborted())
	// We failed or were cancelled
	{
	  ok=(res==pkgAcquire::Continue);
	  break;
	}

      // Break out if download_only is on...not the best :(
      if(download_only)
	return true;

      bool failed=false;
      // Check for failures.  Viva la undocumentation!
      for(pkgAcquireIterator i=fetcher.ItemsBegin();
	  i!=fetcher.ItemsEnd();
	  ++i)
	{
	  if((*i)->Status==pkgAcquire::Item::StatDone &&
	     (*i)->Complete)
	    continue;

	  if((*i)->Status==pkgAcquire::Item::StatIdle)
	    continue;

	  failed=true;
	  break;
	}

      if(failed && !pm.FixMissing())
	{
	  _error->Error(_("Unable to correct for unavailable packages"));
	  ok=false;
	  break;
	}

      string log=aptcfg->Find(PACKAGE "::Log", "/var/log/" PACKAGE);
      if(log!="")
	{
	  FILE *f=NULL;
	  // Hmmm.  popen is nice, but I don't like libc's file-handling routines..
	  // system calls all the way!! :P
	  // (but for now..I don't want 50 lines of code to deal with fork() and
	  //  associated stuff..)

	  if(log[0]=='|')
	    f=popen(log.c_str()+1, "w");
	  else
	    f=fopen(log.c_str(), "a");

	  if(!f)
	    {
	      _error->Errno(_("Unable to open %s to log actions"), log.c_str());

	      ok=false;

	      break;
	    }

	  loglist changed_packages;
	  for(pkgCache::PkgIterator i=(*apt_cache_file)->PkgBegin(); !i.end(); i++)
	    {
	      pkg_action_state s=find_pkg_state(i);
	      if(s!=pkg_unchanged)
		changed_packages.push_back(logitem(i, s));
	    }

	  changed_packages.sort(log_sorter());

	  time_t curtime=time(NULL);
	  fprintf(f, "Aptitude " VERSION ": log report\n%s\n\n", ctime(&curtime));
	  fprintf(f, _("IMPORTANT: this log only lists intended actions; actions which fail due to\ndpkg problems may not be completed.\n\n"));
	  fprintf(f, _("Will install %li packages, and remove %li packages.\n"), (*apt_cache_file)->InstCount(), (*apt_cache_file)->DelCount());
	  if((*apt_cache_file)->UsrSize()>0)
	    fprintf(f, _("%li bytes of disk space will be used\n"), (long int) (*apt_cache_file)->UsrSize());
	  else
	    fprintf(f, _("%li bytes of disk space will be freed\n"), (long int) (*apt_cache_file)->UsrSize());
	  fprintf(f, "===============================================================================\n");
	  // FIXME: sort this by something useful
	  for(loglist::iterator i=changed_packages.begin();
	      i!=changed_packages.end(); ++i)
	    {
	      if(i->second==pkg_upgrade)
		fprintf(f, _("[UPGRADE] %s %s -> %s\n"), i->first.Name(),
			i->first.CurrentVer().VerStr(),
			(*apt_cache_file)[i->first].CandidateVerIter(*apt_cache_file).VerStr());
	      else
		if(i->second!=pkg_unchanged)
		  {
		    const char *tag=NULL;
		    switch(i->second)
		      {
		      case pkg_remove:
			tag=_("REMOVE");
			break;
			//case pkg_upgrade:
			//tag=_("UPGRADE");
			//break;
		      case pkg_install:
			tag=_("INSTALL");
			break;
		      case pkg_reinstall:
			tag=_("REINSTALL");
			break;
		      case pkg_hold:
			tag=_("HOLD");
			break;
		      case pkg_broken:
			tag=_("BROKEN");
			break;
		      case pkg_unused_remove:
			tag=_("REMOVE, NOT USED");
			break;
		      case pkg_auto_remove:
			tag=_("REMOVE, DEPENDENCIES");
			break;
		      case pkg_auto_install:
			tag=_("INSTALL, DEPENDENCIES");
			break;
		      case pkg_auto_hold:
			tag=_("HOLD, DEPENDENCIES");
		      default:
			tag=_("????????");
			break;
		      }

		    fprintf(f, _("[%s] %s\n"), tag, i->first.Name());
		  }
	    }
	  fprintf(f, _("===============================================================================\n\nLog complete.\n"));

	  if(log[0]=='|')
	    pclose(f);
	  else
	    fclose(f);
	}

      if(!text_download)
	vscreen_suspend();

      //  Ewww!  This is a race condition waiting to happen!
      //  Ok, that's a little strong ;-)  But there's a potential problem if
      // someone tries to lock the file in the miniscule amount of time between
      // our releasing the lock and dpkg's taking it.  Not sure we can do much
      // about this, though..
      apt_cache_file->ReleaseLock();

      switch(pm.DoInstall())
	{
	case pkgPackageManager::Failed:
	  _error->DumpErrors();
	  cerr<<_("Ack!  Something bad happened while installing packages.  Trying to recover:")<<endl;
	  // and this is really a hack:
	  system("dpkg --configure -a");
	  _error->Discard();
	  ok=false;

	  // Fallthrough!
	case pkgPackageManager::Completed:
	  if(!text_download)
	    {
	      cerr<<_("Press return to continue.\n");
	      getchar();
	    }

	  done=true;

	  break;

	case pkgPackageManager::Incomplete:
	  break;
	}

      if(!text_download)
	vscreen_resume();

      fetcher.Shutdown();

      if(!pm.GetArchives(&fetcher, &list, apt_package_records))
	{
	  ok=false;
	  break;
	}

      if(!apt_cache_file->GainLock())
	// This really shouldn't happen.
	{
	  _error->Error(_("Could not regain the system lock!  (Perhaps another apt or dpkg is running?"));
	  ok=false;
	  break;
	}
    }

  download_progress->Complete();
  apt_reload_cache(load_progress, true);

  if(aptcfg->FindB(PACKAGE "::Forget-New-On-Install", false))
    do_forget_new();

  delete download_progress;

  return ok;
}
