// tasks.h             -*-c++-*-
//
//  Copyright 2001 Daniel Burrows
//
//  Handles parsing the list of tasks and getting the task of a given
// package.

#include <string>
#include <list>
#include <map>
#include <apt-pkg/pkgcache.h>

struct task
{
  std::string section;
  std::string shortdesc;
  std::string longdesc;
};

// The caller should **NOT** delete the list.
std::list<std::string> *get_tasks(const pkgCache::PkgIterator &pkg);

// Stores the various tasks.
extern std::map<std::string, task> *task_list;

// (re)loads in the current list of available tasks.  Necessary after a
// cache reload, for obvious reasons.  apt_reload_cache will call this.
void load_tasks();

// Discards the current task list and readies a new one to be loaded.
// Since the task list contains package iterators, we have to do something
// in case they're still hanging around.
void reset_tasks();
