// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package sqs provides a client for Amazon Simple Queue Service.
package sqs

import (
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddPermission = "AddPermission"

// AddPermissionRequest generates a request for the AddPermission operation.
func (c *SQS) AddPermissionRequest(input *AddPermissionInput) (req *request.Request, output *AddPermissionOutput) {
	op := &request.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AddPermissionOutput{}
	req.Data = output
	return
}

// Adds a permission to a queue for a specific principal (http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P).
// This allows for sharing access to the queue.
//
// When you create a queue, you have full control access rights for the queue.
// Only you (as owner of the queue) can grant or deny permissions to the queue.
// For more information about these permissions, see Shared Queues (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html)
// in the Amazon SQS Developer Guide.
//
//  AddPermission writes an Amazon SQS-generated policy. If you want to write
// your own policy, use SetQueueAttributes to upload your policy. For more information
// about writing your own policy, see Using The Access Policy Language (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AccessPolicyLanguage.html)
// in the Amazon SQS Developer Guide.
//
//  Some API actions take lists of parameters. These lists are specified using
// the param.n notation. Values of n are integers starting from 1. For example,
// a parameter list with two elements looks like this:  &Attribute.1=this
//
// &Attribute.2=that
func (c *SQS) AddPermission(input *AddPermissionInput) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opChangeMessageVisibility = "ChangeMessageVisibility"

// ChangeMessageVisibilityRequest generates a request for the ChangeMessageVisibility operation.
func (c *SQS) ChangeMessageVisibilityRequest(input *ChangeMessageVisibilityInput) (req *request.Request, output *ChangeMessageVisibilityOutput) {
	op := &request.Operation{
		Name:       opChangeMessageVisibility,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ChangeMessageVisibilityInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ChangeMessageVisibilityOutput{}
	req.Data = output
	return
}

// Changes the visibility timeout of a specified message in a queue to a new
// value. The maximum allowed timeout value you can set the value to is 12 hours.
// This means you can't extend the timeout of a message in an existing queue
// to more than a total visibility timeout of 12 hours. (For more information
// visibility timeout, see Visibility Timeout (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AboutVT.html)
// in the Amazon SQS Developer Guide.)
//
// For example, let's say you have a message and its default message visibility
// timeout is 5 minutes. After 3 minutes, you call ChangeMessageVisiblity with
// a timeout of 10 minutes. At that time, the timeout for the message would
// be extended by 10 minutes beyond the time of the ChangeMessageVisibility
// call. This results in a total visibility timeout of 13 minutes. You can continue
// to call ChangeMessageVisibility to extend the visibility timeout to a maximum
// of 12 hours. If you try to extend beyond 12 hours, the request will be rejected.
//
// There is a 120,000 limit for the number of inflight messages per queue.
// Messages are inflight after they have been received from the queue by a consuming
// component, but have not yet been deleted from the queue. If you reach the
// 120,000 limit, you will receive an OverLimit error message from Amazon SQS.
// To help avoid reaching the limit, you should delete the messages from the
// queue after they have been processed. You can also increase the number of
// queues you use to process the messages.
//
// If you attempt to set the VisibilityTimeout to an amount more than the maximum
// time left, Amazon SQS returns an error. It will not automatically recalculate
// and increase the timeout to the maximum time remaining. Unlike with a queue,
// when you change the visibility timeout for a specific message, that timeout
// value is applied immediately but is not saved in memory for that message.
// If you don't delete a message after it is received, the visibility timeout
// for the message the next time it is received reverts to the original timeout
// value, not the value you set with the ChangeMessageVisibility action.
func (c *SQS) ChangeMessageVisibility(input *ChangeMessageVisibilityInput) (*ChangeMessageVisibilityOutput, error) {
	req, out := c.ChangeMessageVisibilityRequest(input)
	err := req.Send()
	return out, err
}

const opChangeMessageVisibilityBatch = "ChangeMessageVisibilityBatch"

// ChangeMessageVisibilityBatchRequest generates a request for the ChangeMessageVisibilityBatch operation.
func (c *SQS) ChangeMessageVisibilityBatchRequest(input *ChangeMessageVisibilityBatchInput) (req *request.Request, output *ChangeMessageVisibilityBatchOutput) {
	op := &request.Operation{
		Name:       opChangeMessageVisibilityBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ChangeMessageVisibilityBatchInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ChangeMessageVisibilityBatchOutput{}
	req.Data = output
	return
}

// Changes the visibility timeout of multiple messages. This is a batch version
// of ChangeMessageVisibility. The result of the action on each message is reported
// individually in the response. You can send up to 10 ChangeMessageVisibility
// requests with each ChangeMessageVisibilityBatch action.
//
// Because the batch request can result in a combination of successful and
// unsuccessful actions, you should check for batch errors even when the call
// returns an HTTP status code of 200. Some API actions take lists of parameters.
// These lists are specified using the param.n notation. Values of n are integers
// starting from 1. For example, a parameter list with two elements looks like
// this:  &Attribute.1=this
//
// &Attribute.2=that
func (c *SQS) ChangeMessageVisibilityBatch(input *ChangeMessageVisibilityBatchInput) (*ChangeMessageVisibilityBatchOutput, error) {
	req, out := c.ChangeMessageVisibilityBatchRequest(input)
	err := req.Send()
	return out, err
}

const opCreateQueue = "CreateQueue"

// CreateQueueRequest generates a request for the CreateQueue operation.
func (c *SQS) CreateQueueRequest(input *CreateQueueInput) (req *request.Request, output *CreateQueueOutput) {
	op := &request.Operation{
		Name:       opCreateQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateQueueInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateQueueOutput{}
	req.Data = output
	return
}

// Creates a new queue, or returns the URL of an existing one. When you request
// CreateQueue, you provide a name for the queue. To successfully create a new
// queue, you must provide a name that is unique within the scope of your own
// queues.
//
//  If you delete a queue, you must wait at least 60 seconds before creating
// a queue with the same name.
//
//  You may pass one or more attributes in the request. If you do not provide
// a value for any attribute, the queue will have the default value for that
// attribute. Permitted attributes are the same that can be set using SetQueueAttributes.
//
// Use GetQueueUrl to get a queue's URL. GetQueueUrl requires only the QueueName
// parameter.
//
// If you provide the name of an existing queue, along with the exact names
// and values of all the queue's attributes, CreateQueue returns the queue URL
// for the existing queue. If the queue name, attribute names, or attribute
// values do not match an existing queue, CreateQueue returns an error.
//
// Some API actions take lists of parameters. These lists are specified using
// the param.n notation. Values of n are integers starting from 1. For example,
// a parameter list with two elements looks like this:  &Attribute.1=this
//
// &Attribute.2=that
func (c *SQS) CreateQueue(input *CreateQueueInput) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteMessage = "DeleteMessage"

// DeleteMessageRequest generates a request for the DeleteMessage operation.
func (c *SQS) DeleteMessageRequest(input *DeleteMessageInput) (req *request.Request, output *DeleteMessageOutput) {
	op := &request.Operation{
		Name:       opDeleteMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMessageInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteMessageOutput{}
	req.Data = output
	return
}

// Deletes the specified message from the specified queue. You specify the message
// by using the message's receipt handle and not the message ID you received
// when you sent the message. Even if the message is locked by another reader
// due to the visibility timeout setting, it is still deleted from the queue.
// If you leave a message in the queue for longer than the queue's configured
// retention period, Amazon SQS automatically deletes it.
//
//   The receipt handle is associated with a specific instance of receiving
// the message. If you receive a message more than once, the receipt handle
// you get each time you receive the message is different. When you request
// DeleteMessage, if you don't provide the most recently received receipt handle
// for the message, the request will still succeed, but the message might not
// be deleted.
//
//    It is possible you will receive a message even after you have deleted
// it. This might happen on rare occasions if one of the servers storing a copy
// of the message is unavailable when you request to delete the message. The
// copy remains on the server and might be returned to you again on a subsequent
// receive request. You should create your system to be idempotent so that receiving
// a particular message more than once is not a problem.
func (c *SQS) DeleteMessage(input *DeleteMessageInput) (*DeleteMessageOutput, error) {
	req, out := c.DeleteMessageRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteMessageBatch = "DeleteMessageBatch"

// DeleteMessageBatchRequest generates a request for the DeleteMessageBatch operation.
func (c *SQS) DeleteMessageBatchRequest(input *DeleteMessageBatchInput) (req *request.Request, output *DeleteMessageBatchOutput) {
	op := &request.Operation{
		Name:       opDeleteMessageBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMessageBatchInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteMessageBatchOutput{}
	req.Data = output
	return
}

// Deletes up to ten messages from the specified queue. This is a batch version
// of DeleteMessage. The result of the delete action on each message is reported
// individually in the response.
//
//   Because the batch request can result in a combination of successful and
// unsuccessful actions, you should check for batch errors even when the call
// returns an HTTP status code of 200.
//
//  Some API actions take lists of parameters. These lists are specified using
// the param.n notation. Values of n are integers starting from 1. For example,
// a parameter list with two elements looks like this:  &Attribute.1=this
//
// &Attribute.2=that
func (c *SQS) DeleteMessageBatch(input *DeleteMessageBatchInput) (*DeleteMessageBatchOutput, error) {
	req, out := c.DeleteMessageBatchRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteQueue = "DeleteQueue"

// DeleteQueueRequest generates a request for the DeleteQueue operation.
func (c *SQS) DeleteQueueRequest(input *DeleteQueueInput) (req *request.Request, output *DeleteQueueOutput) {
	op := &request.Operation{
		Name:       opDeleteQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteQueueInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteQueueOutput{}
	req.Data = output
	return
}

// Deletes the queue specified by the queue URL, regardless of whether the queue
// is empty. If the specified queue does not exist, Amazon SQS returns a successful
// response.
//
//   Use DeleteQueue with care; once you delete your queue, any messages in
// the queue are no longer available.
//
//   When you delete a queue, the deletion process takes up to 60 seconds.
// Requests you send involving that queue during the 60 seconds might succeed.
// For example, a SendMessage request might succeed, but after the 60 seconds,
// the queue and that message you sent no longer exist. Also, when you delete
// a queue, you must wait at least 60 seconds before creating a queue with the
// same name.
//
//  We reserve the right to delete queues that have had no activity for more
// than 30 days. For more information, see How Amazon SQS Queues Work (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSConcepts.html)
// in the Amazon SQS Developer Guide.
func (c *SQS) DeleteQueue(input *DeleteQueueInput) (*DeleteQueueOutput, error) {
	req, out := c.DeleteQueueRequest(input)
	err := req.Send()
	return out, err
}

const opGetQueueAttributes = "GetQueueAttributes"

// GetQueueAttributesRequest generates a request for the GetQueueAttributes operation.
func (c *SQS) GetQueueAttributesRequest(input *GetQueueAttributesInput) (req *request.Request, output *GetQueueAttributesOutput) {
	op := &request.Operation{
		Name:       opGetQueueAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQueueAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetQueueAttributesOutput{}
	req.Data = output
	return
}

// Gets attributes for the specified queue. The following attributes are supported:
//   All - returns all values.  ApproximateNumberOfMessages - returns the approximate
// number of visible messages in a queue. For more information, see Resources
// Required to Process Messages (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/ApproximateNumber.html)
// in the Amazon SQS Developer Guide.  ApproximateNumberOfMessagesNotVisible
// - returns the approximate number of messages that are not timed-out and not
// deleted. For more information, see Resources Required to Process Messages
// (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/ApproximateNumber.html)
// in the Amazon SQS Developer Guide.  VisibilityTimeout - returns the visibility
// timeout for the queue. For more information about visibility timeout, see
// Visibility Timeout (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AboutVT.html)
// in the Amazon SQS Developer Guide.  CreatedTimestamp - returns the time when
// the queue was created (epoch time in seconds).  LastModifiedTimestamp - returns
// the time when the queue was last changed (epoch time in seconds).  Policy
// - returns the queue's policy.  MaximumMessageSize - returns the limit of
// how many bytes a message can contain before Amazon SQS rejects it.  MessageRetentionPeriod
// - returns the number of seconds Amazon SQS retains a message.  QueueArn -
// returns the queue's Amazon resource name (ARN).  ApproximateNumberOfMessagesDelayed
// - returns the approximate number of messages that are pending to be added
// to the queue.  DelaySeconds - returns the default delay on the queue in seconds.
//  ReceiveMessageWaitTimeSeconds - returns the time for which a ReceiveMessage
// call will wait for a message to arrive.  RedrivePolicy - returns the parameters
// for dead letter queue functionality of the source queue. For more information
// about RedrivePolicy and dead letter queues, see Using Amazon SQS Dead Letter
// Queues (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSDeadLetterQueue.html)
// in the Amazon SQS Developer Guide.
//
// Going forward, new attributes might be added. If you are writing code that
// calls this action, we recommend that you structure your code so that it can
// handle new attributes gracefully. Some API actions take lists of parameters.
// These lists are specified using the param.n notation. Values of n are integers
// starting from 1. For example, a parameter list with two elements looks like
// this:  &Attribute.1=this
//
// &Attribute.2=that
func (c *SQS) GetQueueAttributes(input *GetQueueAttributesInput) (*GetQueueAttributesOutput, error) {
	req, out := c.GetQueueAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetQueueUrl = "GetQueueUrl"

// GetQueueUrlRequest generates a request for the GetQueueUrl operation.
func (c *SQS) GetQueueUrlRequest(input *GetQueueUrlInput) (req *request.Request, output *GetQueueUrlOutput) {
	op := &request.Operation{
		Name:       opGetQueueUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQueueUrlInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetQueueUrlOutput{}
	req.Data = output
	return
}

// Returns the URL of an existing queue. This action provides a simple way to
// retrieve the URL of an Amazon SQS queue.
//
//  To access a queue that belongs to another AWS account, use the QueueOwnerAWSAccountId
// parameter to specify the account ID of the queue's owner. The queue's owner
// must grant you permission to access the queue. For more information about
// shared queue access, see AddPermission or go to Shared Queues (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html)
// in the Amazon SQS Developer Guide.
func (c *SQS) GetQueueUrl(input *GetQueueUrlInput) (*GetQueueUrlOutput, error) {
	req, out := c.GetQueueUrlRequest(input)
	err := req.Send()
	return out, err
}

const opListDeadLetterSourceQueues = "ListDeadLetterSourceQueues"

// ListDeadLetterSourceQueuesRequest generates a request for the ListDeadLetterSourceQueues operation.
func (c *SQS) ListDeadLetterSourceQueuesRequest(input *ListDeadLetterSourceQueuesInput) (req *request.Request, output *ListDeadLetterSourceQueuesOutput) {
	op := &request.Operation{
		Name:       opListDeadLetterSourceQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeadLetterSourceQueuesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeadLetterSourceQueuesOutput{}
	req.Data = output
	return
}

// Returns a list of your queues that have the RedrivePolicy queue attribute
// configured with a dead letter queue.
//
// For more information about using dead letter queues, see Using Amazon SQS
// Dead Letter Queues (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSDeadLetterQueue.html).
func (c *SQS) ListDeadLetterSourceQueues(input *ListDeadLetterSourceQueuesInput) (*ListDeadLetterSourceQueuesOutput, error) {
	req, out := c.ListDeadLetterSourceQueuesRequest(input)
	err := req.Send()
	return out, err
}

const opListQueues = "ListQueues"

// ListQueuesRequest generates a request for the ListQueues operation.
func (c *SQS) ListQueuesRequest(input *ListQueuesInput) (req *request.Request, output *ListQueuesOutput) {
	op := &request.Operation{
		Name:       opListQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListQueuesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListQueuesOutput{}
	req.Data = output
	return
}

// Returns a list of your queues. The maximum number of queues that can be returned
// is 1000. If you specify a value for the optional QueueNamePrefix parameter,
// only queues with a name beginning with the specified value are returned.
func (c *SQS) ListQueues(input *ListQueuesInput) (*ListQueuesOutput, error) {
	req, out := c.ListQueuesRequest(input)
	err := req.Send()
	return out, err
}

const opPurgeQueue = "PurgeQueue"

// PurgeQueueRequest generates a request for the PurgeQueue operation.
func (c *SQS) PurgeQueueRequest(input *PurgeQueueInput) (req *request.Request, output *PurgeQueueOutput) {
	op := &request.Operation{
		Name:       opPurgeQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurgeQueueInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PurgeQueueOutput{}
	req.Data = output
	return
}

// Deletes the messages in a queue specified by the queue URL.
//
// When you use the PurgeQueue API, the deleted messages in the queue cannot
// be retrieved. When you purge a queue, the message deletion process takes
// up to 60 seconds. All messages sent to the queue before calling PurgeQueue
// will be deleted; messages sent to the queue while it is being purged may
// be deleted. While the queue is being purged, messages sent to the queue before
// PurgeQueue was called may be received, but will be deleted within the next
// minute.
func (c *SQS) PurgeQueue(input *PurgeQueueInput) (*PurgeQueueOutput, error) {
	req, out := c.PurgeQueueRequest(input)
	err := req.Send()
	return out, err
}

const opReceiveMessage = "ReceiveMessage"

// ReceiveMessageRequest generates a request for the ReceiveMessage operation.
func (c *SQS) ReceiveMessageRequest(input *ReceiveMessageInput) (req *request.Request, output *ReceiveMessageOutput) {
	op := &request.Operation{
		Name:       opReceiveMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReceiveMessageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReceiveMessageOutput{}
	req.Data = output
	return
}

// Retrieves one or more messages, with a maximum limit of 10 messages, from
// the specified queue. Long poll support is enabled by using the WaitTimeSeconds
// parameter. For more information, see Amazon SQS Long Poll (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-long-polling.html)
// in the Amazon SQS Developer Guide.
//
//  Short poll is the default behavior where a weighted random set of machines
// is sampled on a ReceiveMessage call. This means only the messages on the
// sampled machines are returned. If the number of messages in the queue is
// small (less than 1000), it is likely you will get fewer messages than you
// requested per ReceiveMessage call. If the number of messages in the queue
// is extremely small, you might not receive any messages in a particular ReceiveMessage
// response; in which case you should repeat the request.
//
//  For each message returned, the response includes the following:
//
//    Message body
//
//    MD5 digest of the message body. For information about MD5, go to http://www.faqs.org/rfcs/rfc1321.html
// (http://www.faqs.org/rfcs/rfc1321.html).
//
//    Message ID you received when you sent the message to the queue.
//
//    Receipt handle.
//
//    Message attributes.
//
//    MD5 digest of the message attributes.
//
//    The receipt handle is the identifier you must provide when deleting the
// message. For more information, see Queue and Message Identifiers (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/ImportantIdentifiers.html)
// in the Amazon SQS Developer Guide.
//
//  You can provide the VisibilityTimeout parameter in your request, which
// will be applied to the messages that Amazon SQS returns in the response.
// If you do not include the parameter, the overall visibility timeout for the
// queue is used for the returned messages. For more information, see Visibility
// Timeout (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AboutVT.html)
// in the Amazon SQS Developer Guide.
//
//   Going forward, new attributes might be added. If you are writing code
// that calls this action, we recommend that you structure your code so that
// it can handle new attributes gracefully.
func (c *SQS) ReceiveMessage(input *ReceiveMessageInput) (*ReceiveMessageOutput, error) {
	req, out := c.ReceiveMessageRequest(input)
	err := req.Send()
	return out, err
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a request for the RemovePermission operation.
func (c *SQS) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RemovePermissionOutput{}
	req.Data = output
	return
}

// Revokes any permissions in the queue policy that matches the specified Label
// parameter. Only the owner of the queue can remove permissions.
func (c *SQS) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	err := req.Send()
	return out, err
}

const opSendMessage = "SendMessage"

// SendMessageRequest generates a request for the SendMessage operation.
func (c *SQS) SendMessageRequest(input *SendMessageInput) (req *request.Request, output *SendMessageOutput) {
	op := &request.Operation{
		Name:       opSendMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendMessageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendMessageOutput{}
	req.Data = output
	return
}

// Delivers a message to the specified queue. With Amazon SQS, you now have
// the ability to send large payload messages that are up to 256KB (262,144
// bytes) in size. To send large payloads, you must use an AWS SDK that supports
// SigV4 signing. To verify whether SigV4 is supported for an AWS SDK, check
// the SDK release notes.
//
//   The following list shows the characters (in Unicode) allowed in your message,
// according to the W3C XML specification. For more information, go to http://www.w3.org/TR/REC-xml/#charsets
// (http://www.w3.org/TR/REC-xml/#charsets) If you send any characters not included
// in the list, your request will be rejected.
//
//  #x9 | #xA | #xD | [#x20 to #xD7FF] | [#xE000 to #xFFFD] | [#x10000 to #x10FFFF]
func (c *SQS) SendMessage(input *SendMessageInput) (*SendMessageOutput, error) {
	req, out := c.SendMessageRequest(input)
	err := req.Send()
	return out, err
}

const opSendMessageBatch = "SendMessageBatch"

// SendMessageBatchRequest generates a request for the SendMessageBatch operation.
func (c *SQS) SendMessageBatchRequest(input *SendMessageBatchInput) (req *request.Request, output *SendMessageBatchOutput) {
	op := &request.Operation{
		Name:       opSendMessageBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendMessageBatchInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendMessageBatchOutput{}
	req.Data = output
	return
}

// Delivers up to ten messages to the specified queue. This is a batch version
// of SendMessage. The result of the send action on each message is reported
// individually in the response. The maximum allowed individual message size
// is 256 KB (262,144 bytes).
//
// The maximum total payload size (i.e., the sum of all a batch's individual
// message lengths) is also 256 KB (262,144 bytes).
//
// If the DelaySeconds parameter is not specified for an entry, the default
// for the queue is used.
//
// The following list shows the characters (in Unicode) that are allowed in
// your message, according to the W3C XML specification. For more information,
// go to http://www.faqs.org/rfcs/rfc1321.html (http://www.faqs.org/rfcs/rfc1321.html).
// If you send any characters that are not included in the list, your request
// will be rejected. #x9 | #xA | #xD | [#x20 to #xD7FF] | [#xE000 to #xFFFD]
// | [#x10000 to #x10FFFF]
//
//   Because the batch request can result in a combination of successful and
// unsuccessful actions, you should check for batch errors even when the call
// returns an HTTP status code of 200.  Some API actions take lists of parameters.
// These lists are specified using the param.n notation. Values of n are integers
// starting from 1. For example, a parameter list with two elements looks like
// this:  &Attribute.1=this
//
// &Attribute.2=that
func (c *SQS) SendMessageBatch(input *SendMessageBatchInput) (*SendMessageBatchOutput, error) {
	req, out := c.SendMessageBatchRequest(input)
	err := req.Send()
	return out, err
}

const opSetQueueAttributes = "SetQueueAttributes"

// SetQueueAttributesRequest generates a request for the SetQueueAttributes operation.
func (c *SQS) SetQueueAttributesRequest(input *SetQueueAttributesInput) (req *request.Request, output *SetQueueAttributesOutput) {
	op := &request.Operation{
		Name:       opSetQueueAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetQueueAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetQueueAttributesOutput{}
	req.Data = output
	return
}

// Sets the value of one or more queue attributes. When you change a queue's
// attributes, the change can take up to 60 seconds for most of the attributes
// to propagate throughout the SQS system. Changes made to the MessageRetentionPeriod
// attribute can take up to 15 minutes.
//
// Going forward, new attributes might be added. If you are writing code that
// calls this action, we recommend that you structure your code so that it can
// handle new attributes gracefully.
func (c *SQS) SetQueueAttributes(input *SetQueueAttributesInput) (*SetQueueAttributesOutput, error) {
	req, out := c.SetQueueAttributesRequest(input)
	err := req.Send()
	return out, err
}

type AddPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS account number of the principal (http://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P)
	// who will be given permission. The principal must have an AWS account, but
	// does not need to be signed up for Amazon SQS. For information about locating
	// the AWS account identification, see Your AWS Identifiers (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AWSCredentials.html)
	// in the Amazon SQS Developer Guide.
	AWSAccountIds []*string `locationNameList:"AWSAccountId" type:"list" flattened:"true" required:"true"`

	// The action the client wants to allow for the specified principal. The following
	// are valid values: * | SendMessage | ReceiveMessage | DeleteMessage | ChangeMessageVisibility
	// | GetQueueAttributes | GetQueueUrl. For more information about these actions,
	// see Understanding Permissions (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/acp-overview.html#PermissionTypes)
	// in the Amazon SQS Developer Guide.
	//
	// Specifying SendMessage, DeleteMessage, or ChangeMessageVisibility for the
	// ActionName.n also grants permissions for the corresponding batch versions
	// of those actions: SendMessageBatch, DeleteMessageBatch, and ChangeMessageVisibilityBatch.
	Actions []*string `locationNameList:"ActionName" type:"list" flattened:"true" required:"true"`

	// The unique identification of the permission you're setting (e.g., AliceSendMessage).
	// Constraints: Maximum 80 characters; alphanumeric characters, hyphens (-),
	// and underscores (_) are allowed.
	Label *string `type:"string" required:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

type AddPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

// This is used in the responses of batch API to give a detailed description
// of the result of an action on each entry in the request.
type BatchResultErrorEntry struct {
	_ struct{} `type:"structure"`

	// An error code representing why the action failed on this entry.
	Code *string `type:"string" required:"true"`

	// The id of an entry in a batch request.
	Id *string `type:"string" required:"true"`

	// A message explaining why the action failed on this entry.
	Message *string `type:"string"`

	// Whether the error happened due to the sender's fault.
	SenderFault *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s BatchResultErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchResultErrorEntry) GoString() string {
	return s.String()
}

type ChangeMessageVisibilityBatchInput struct {
	_ struct{} `type:"structure"`

	// A list of receipt handles of the messages for which the visibility timeout
	// must be changed.
	Entries []*ChangeMessageVisibilityBatchRequestEntry `locationNameList:"ChangeMessageVisibilityBatchRequestEntry" type:"list" flattened:"true" required:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ChangeMessageVisibilityBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeMessageVisibilityBatchInput) GoString() string {
	return s.String()
}

// For each message in the batch, the response contains a ChangeMessageVisibilityBatchResultEntry
// tag if the message succeeds or a BatchResultErrorEntry tag if the message
// fails.
type ChangeMessageVisibilityBatchOutput struct {
	_ struct{} `type:"structure"`

	// A list of BatchResultErrorEntry items.
	Failed []*BatchResultErrorEntry `locationNameList:"BatchResultErrorEntry" type:"list" flattened:"true" required:"true"`

	// A list of ChangeMessageVisibilityBatchResultEntry items.
	Successful []*ChangeMessageVisibilityBatchResultEntry `locationNameList:"ChangeMessageVisibilityBatchResultEntry" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ChangeMessageVisibilityBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeMessageVisibilityBatchOutput) GoString() string {
	return s.String()
}

// Encloses a receipt handle and an entry id for each message in ChangeMessageVisibilityBatch.
//
//  All of the following parameters are list parameters that must be prefixed
// with ChangeMessageVisibilityBatchRequestEntry.n, where n is an integer value
// starting with 1. For example, a parameter list for this action might look
// like this:
//
//  &ChangeMessageVisibilityBatchRequestEntry.1.Id=change_visibility_msg_2
//
// &ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle=Your_Receipt_Handle
//
// &ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout=45
type ChangeMessageVisibilityBatchRequestEntry struct {
	_ struct{} `type:"structure"`

	// An identifier for this particular receipt handle. This is used to communicate
	// the result. Note that the Ids of a batch request need to be unique within
	// the request.
	Id *string `type:"string" required:"true"`

	// A receipt handle.
	ReceiptHandle *string `type:"string" required:"true"`

	// The new value (in seconds) for the message's visibility timeout.
	VisibilityTimeout *int64 `type:"integer"`
}

// String returns the string representation
func (s ChangeMessageVisibilityBatchRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeMessageVisibilityBatchRequestEntry) GoString() string {
	return s.String()
}

// Encloses the id of an entry in ChangeMessageVisibilityBatch.
type ChangeMessageVisibilityBatchResultEntry struct {
	_ struct{} `type:"structure"`

	// Represents a message whose visibility timeout has been changed successfully.
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ChangeMessageVisibilityBatchResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeMessageVisibilityBatchResultEntry) GoString() string {
	return s.String()
}

type ChangeMessageVisibilityInput struct {
	_ struct{} `type:"structure"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`

	// The receipt handle associated with the message whose visibility timeout should
	// be changed. This parameter is returned by the ReceiveMessage action.
	ReceiptHandle *string `type:"string" required:"true"`

	// The new value (in seconds - from 0 to 43200 - maximum 12 hours) for the message's
	// visibility timeout.
	VisibilityTimeout *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ChangeMessageVisibilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeMessageVisibilityInput) GoString() string {
	return s.String()
}

type ChangeMessageVisibilityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ChangeMessageVisibilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeMessageVisibilityOutput) GoString() string {
	return s.String()
}

type CreateQueueInput struct {
	_ struct{} `type:"structure"`

	// A map of attributes with their corresponding values.
	//
	// The following lists the names, descriptions, and values of the special request
	// parameters the CreateQueue action uses:
	//
	//    DelaySeconds - The time in seconds that the delivery of all messages
	// in the queue will be delayed. An integer from 0 to 900 (15 minutes). The
	// default for this attribute is 0 (zero).  MaximumMessageSize - The limit of
	// how many bytes a message can contain before Amazon SQS rejects it. An integer
	// from 1024 bytes (1 KiB) up to 262144 bytes (256 KiB). The default for this
	// attribute is 262144 (256 KiB).  MessageRetentionPeriod - The number of seconds
	// Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute)
	// to 1209600 (14 days). The default for this attribute is 345600 (4 days).
	//  Policy - The queue's policy. A valid AWS policy. For more information about
	// policy structure, see Overview of AWS IAM Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/PoliciesOverview.html)
	// in the Amazon IAM User Guide.  ReceiveMessageWaitTimeSeconds - The time for
	// which a ReceiveMessage call will wait for a message to arrive. An integer
	// from 0 to 20 (seconds). The default for this attribute is 0.   VisibilityTimeout
	// - The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
	// The default for this attribute is 30. For more information about visibility
	// timeout, see Visibility Timeout (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/AboutVT.html)
	// in the Amazon SQS Developer Guide.
	Attributes map[string]*string `locationName:"Attribute" locationNameKey:"Name" locationNameValue:"Value" type:"map" flattened:"true"`

	// The name for the queue to be created.
	QueueName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQueueInput) GoString() string {
	return s.String()
}

// Returns the QueueUrl element of the created queue.
type CreateQueueOutput struct {
	_ struct{} `type:"structure"`

	// The URL for the created Amazon SQS queue.
	QueueUrl *string `type:"string"`
}

// String returns the string representation
func (s CreateQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQueueOutput) GoString() string {
	return s.String()
}

type DeleteMessageBatchInput struct {
	_ struct{} `type:"structure"`

	// A list of receipt handles for the messages to be deleted.
	Entries []*DeleteMessageBatchRequestEntry `locationNameList:"DeleteMessageBatchRequestEntry" type:"list" flattened:"true" required:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMessageBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageBatchInput) GoString() string {
	return s.String()
}

// For each message in the batch, the response contains a DeleteMessageBatchResultEntry
// tag if the message is deleted or a BatchResultErrorEntry tag if the message
// cannot be deleted.
type DeleteMessageBatchOutput struct {
	_ struct{} `type:"structure"`

	// A list of BatchResultErrorEntry items.
	Failed []*BatchResultErrorEntry `locationNameList:"BatchResultErrorEntry" type:"list" flattened:"true" required:"true"`

	// A list of DeleteMessageBatchResultEntry items.
	Successful []*DeleteMessageBatchResultEntry `locationNameList:"DeleteMessageBatchResultEntry" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s DeleteMessageBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageBatchOutput) GoString() string {
	return s.String()
}

// Encloses a receipt handle and an identifier for it.
type DeleteMessageBatchRequestEntry struct {
	_ struct{} `type:"structure"`

	// An identifier for this particular receipt handle. This is used to communicate
	// the result. Note that the Ids of a batch request need to be unique within
	// the request.
	Id *string `type:"string" required:"true"`

	// A receipt handle.
	ReceiptHandle *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMessageBatchRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageBatchRequestEntry) GoString() string {
	return s.String()
}

// Encloses the id an entry in DeleteMessageBatch.
type DeleteMessageBatchResultEntry struct {
	_ struct{} `type:"structure"`

	// Represents a successfully deleted message.
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMessageBatchResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageBatchResultEntry) GoString() string {
	return s.String()
}

type DeleteMessageInput struct {
	_ struct{} `type:"structure"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`

	// The receipt handle associated with the message to delete.
	ReceiptHandle *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageInput) GoString() string {
	return s.String()
}

type DeleteMessageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageOutput) GoString() string {
	return s.String()
}

type DeleteQueueInput struct {
	_ struct{} `type:"structure"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteQueueInput) GoString() string {
	return s.String()
}

type DeleteQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteQueueOutput) GoString() string {
	return s.String()
}

type GetQueueAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of attributes to retrieve information for.
	AttributeNames []*string `locationNameList:"AttributeName" type:"list" flattened:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetQueueAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueueAttributesInput) GoString() string {
	return s.String()
}

// A list of returned queue attributes.
type GetQueueAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of attributes to the respective values.
	Attributes map[string]*string `locationName:"Attribute" locationNameKey:"Name" locationNameValue:"Value" type:"map" flattened:"true"`
}

// String returns the string representation
func (s GetQueueAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueueAttributesOutput) GoString() string {
	return s.String()
}

type GetQueueUrlInput struct {
	_ struct{} `type:"structure"`

	// The name of the queue whose URL must be fetched. Maximum 80 characters; alphanumeric
	// characters, hyphens (-), and underscores (_) are allowed.
	QueueName *string `type:"string" required:"true"`

	// The AWS account ID of the account that created the queue.
	QueueOwnerAWSAccountId *string `type:"string"`
}

// String returns the string representation
func (s GetQueueUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueueUrlInput) GoString() string {
	return s.String()
}

// For more information, see Responses (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/UnderstandingResponses.html)
// in the Amazon SQS Developer Guide.
type GetQueueUrlOutput struct {
	_ struct{} `type:"structure"`

	// The URL for the queue.
	QueueUrl *string `type:"string"`
}

// String returns the string representation
func (s GetQueueUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueueUrlOutput) GoString() string {
	return s.String()
}

type ListDeadLetterSourceQueuesInput struct {
	_ struct{} `type:"structure"`

	// The queue URL of a dead letter queue.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListDeadLetterSourceQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeadLetterSourceQueuesInput) GoString() string {
	return s.String()
}

// A list of your dead letter source queues.
type ListDeadLetterSourceQueuesOutput struct {
	_ struct{} `type:"structure"`

	// A list of source queue URLs that have the RedrivePolicy queue attribute configured
	// with a dead letter queue.
	QueueUrls []*string `locationName:"queueUrls" locationNameList:"QueueUrl" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ListDeadLetterSourceQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeadLetterSourceQueuesOutput) GoString() string {
	return s.String()
}

type ListQueuesInput struct {
	_ struct{} `type:"structure"`

	// A string to use for filtering the list results. Only those queues whose name
	// begins with the specified string are returned.
	QueueNamePrefix *string `type:"string"`
}

// String returns the string representation
func (s ListQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueuesInput) GoString() string {
	return s.String()
}

// A list of your queues.
type ListQueuesOutput struct {
	_ struct{} `type:"structure"`

	// A list of queue URLs, up to 1000 entries.
	QueueUrls []*string `locationNameList:"QueueUrl" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueuesOutput) GoString() string {
	return s.String()
}

// An Amazon SQS message.
type Message struct {
	_ struct{} `type:"structure"`

	// SenderId, SentTimestamp, ApproximateReceiveCount, and/or ApproximateFirstReceiveTimestamp.
	// SentTimestamp and ApproximateFirstReceiveTimestamp are each returned as an
	// integer representing the epoch time (http://en.wikipedia.org/wiki/Unix_time)
	// in milliseconds.
	Attributes map[string]*string `locationName:"Attribute" locationNameKey:"Name" locationNameValue:"Value" type:"map" flattened:"true"`

	// The message's contents (not URL-encoded).
	Body *string `type:"string"`

	// An MD5 digest of the non-URL-encoded message body string.
	MD5OfBody *string `type:"string"`

	// An MD5 digest of the non-URL-encoded message attribute string. This can be
	// used to verify that Amazon SQS received the message correctly. Amazon SQS
	// first URL decodes the message before creating the MD5 digest. For information
	// about MD5, go to http://www.faqs.org/rfcs/rfc1321.html (http://www.faqs.org/rfcs/rfc1321.html).
	MD5OfMessageAttributes *string `type:"string"`

	// Each message attribute consists of a Name, Type, and Value. For more information,
	// see Message Attribute Items (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSMessageAttributes.html#SQSMessageAttributesNTV).
	MessageAttributes map[string]*MessageAttributeValue `locationName:"MessageAttribute" locationNameKey:"Name" locationNameValue:"Value" type:"map" flattened:"true"`

	// A unique identifier for the message. Message IDs are considered unique across
	// all AWS accounts for an extended period of time.
	MessageId *string `type:"string"`

	// An identifier associated with the act of receiving the message. A new receipt
	// handle is returned every time you receive a message. When deleting a message,
	// you provide the last received receipt handle to delete the message.
	ReceiptHandle *string `type:"string"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// The user-specified message attribute value. For string data types, the value
// attribute has the same restrictions on the content as the message body. For
// more information, see SendMessage (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html).
//
// Name, type, and value must not be empty or null. In addition, the message
// body should not be empty or null. All parts of the message attribute, including
// name, type, and value, are included in the message size restriction, which
// is currently 256 KB (262,144 bytes).
type MessageAttributeValue struct {
	_ struct{} `type:"structure"`

	// Not implemented. Reserved for future use.
	BinaryListValues [][]byte `locationName:"BinaryListValue" locationNameList:"BinaryListValue" type:"list" flattened:"true"`

	// Binary type attributes can store any binary data, for example, compressed
	// data, encrypted data, or images.
	BinaryValue []byte `type:"blob"`

	// Amazon SQS supports the following logical data types: String, Number, and
	// Binary. In addition, you can append your own custom labels. For more information,
	// see Message Attribute Data Types (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSMessageAttributes.html#SQSMessageAttributes.DataTypes).
	DataType *string `type:"string" required:"true"`

	// Not implemented. Reserved for future use.
	StringListValues []*string `locationName:"StringListValue" locationNameList:"StringListValue" type:"list" flattened:"true"`

	// Strings are Unicode with UTF8 binary encoding. For a list of code values,
	// see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s MessageAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageAttributeValue) GoString() string {
	return s.String()
}

type PurgeQueueInput struct {
	_ struct{} `type:"structure"`

	// The queue URL of the queue to delete the messages from when using the PurgeQueue
	// API.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PurgeQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurgeQueueInput) GoString() string {
	return s.String()
}

type PurgeQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PurgeQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurgeQueueOutput) GoString() string {
	return s.String()
}

type ReceiveMessageInput struct {
	_ struct{} `type:"structure"`

	// A list of attributes that need to be returned along with each message.
	//
	//  The following lists the names and descriptions of the attributes that can
	// be returned:
	//
	//   All - returns all values.  ApproximateFirstReceiveTimestamp - returns
	// the time when the message was first received from the queue (epoch time in
	// milliseconds).  ApproximateReceiveCount - returns the number of times a message
	// has been received from the queue but not deleted.  SenderId - returns the
	// AWS account number (or the IP address, if anonymous access is allowed) of
	// the sender.  SentTimestamp - returns the time when the message was sent to
	// the queue (epoch time in milliseconds).
	AttributeNames []*string `locationNameList:"AttributeName" type:"list" flattened:"true"`

	// The maximum number of messages to return. Amazon SQS never returns more messages
	// than this value but may return fewer. Values can be from 1 to 10. Default
	// is 1.
	//
	// All of the messages are not necessarily returned.
	MaxNumberOfMessages *int64 `type:"integer"`

	// The name of the message attribute, where N is the index. The message attribute
	// name can contain the following characters: A-Z, a-z, 0-9, underscore (_),
	// hyphen (-), and period (.). The name must not start or end with a period,
	// and it should not have successive periods. The name is case sensitive and
	// must be unique among all attribute names for the message. The name can be
	// up to 256 characters long. The name cannot start with "AWS." or "Amazon."
	// (or any variations in casing), because these prefixes are reserved for use
	// by Amazon Web Services.
	//
	// When using ReceiveMessage, you can send a list of attribute names to receive,
	// or you can return all of the attributes by specifying "All" or ".*" in your
	// request. You can also use "foo.*" to return all message attributes starting
	// with the "foo" prefix.
	MessageAttributeNames []*string `locationNameList:"MessageAttributeName" type:"list" flattened:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`

	// The duration (in seconds) that the received messages are hidden from subsequent
	// retrieve requests after being retrieved by a ReceiveMessage request.
	VisibilityTimeout *int64 `type:"integer"`

	// The duration (in seconds) for which the call will wait for a message to arrive
	// in the queue before returning. If a message is available, the call will return
	// sooner than WaitTimeSeconds.
	WaitTimeSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s ReceiveMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiveMessageInput) GoString() string {
	return s.String()
}

// A list of received messages.
type ReceiveMessageOutput struct {
	_ struct{} `type:"structure"`

	// A list of messages.
	Messages []*Message `locationNameList:"Message" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ReceiveMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiveMessageOutput) GoString() string {
	return s.String()
}

type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// The identification of the permission to remove. This is the label added with
	// the AddPermission action.
	Label *string `type:"string" required:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

type SendMessageBatchInput struct {
	_ struct{} `type:"structure"`

	// A list of SendMessageBatchRequestEntry items.
	Entries []*SendMessageBatchRequestEntry `locationNameList:"SendMessageBatchRequestEntry" type:"list" flattened:"true" required:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendMessageBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageBatchInput) GoString() string {
	return s.String()
}

// For each message in the batch, the response contains a SendMessageBatchResultEntry
// tag if the message succeeds or a BatchResultErrorEntry tag if the message
// fails.
type SendMessageBatchOutput struct {
	_ struct{} `type:"structure"`

	// A list of BatchResultErrorEntry items with the error detail about each message
	// that could not be enqueued.
	Failed []*BatchResultErrorEntry `locationNameList:"BatchResultErrorEntry" type:"list" flattened:"true" required:"true"`

	// A list of SendMessageBatchResultEntry items.
	Successful []*SendMessageBatchResultEntry `locationNameList:"SendMessageBatchResultEntry" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s SendMessageBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageBatchOutput) GoString() string {
	return s.String()
}

// Contains the details of a single Amazon SQS message along with a Id.
type SendMessageBatchRequestEntry struct {
	_ struct{} `type:"structure"`

	// The number of seconds for which the message has to be delayed.
	DelaySeconds *int64 `type:"integer"`

	// An identifier for the message in this batch. This is used to communicate
	// the result. Note that the Ids of a batch request need to be unique within
	// the request.
	Id *string `type:"string" required:"true"`

	// Each message attribute consists of a Name, Type, and Value. For more information,
	// see Message Attribute Items (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSMessageAttributes.html#SQSMessageAttributesNTV).
	MessageAttributes map[string]*MessageAttributeValue `locationName:"MessageAttribute" locationNameKey:"Name" locationNameValue:"Value" type:"map" flattened:"true"`

	// Body of the message.
	MessageBody *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendMessageBatchRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageBatchRequestEntry) GoString() string {
	return s.String()
}

// Encloses a message ID for successfully enqueued message of a SendMessageBatch.
type SendMessageBatchResultEntry struct {
	_ struct{} `type:"structure"`

	// An identifier for the message in this batch.
	Id *string `type:"string" required:"true"`

	// An MD5 digest of the non-URL-encoded message attribute string. This can be
	// used to verify that Amazon SQS received the message batch correctly. Amazon
	// SQS first URL decodes the message before creating the MD5 digest. For information
	// about MD5, go to http://www.faqs.org/rfcs/rfc1321.html (http://www.faqs.org/rfcs/rfc1321.html).
	MD5OfMessageAttributes *string `type:"string"`

	// An MD5 digest of the non-URL-encoded message body string. This can be used
	// to verify that Amazon SQS received the message correctly. Amazon SQS first
	// URL decodes the message before creating the MD5 digest. For information about
	// MD5, go to http://www.faqs.org/rfcs/rfc1321.html (http://www.faqs.org/rfcs/rfc1321.html).
	MD5OfMessageBody *string `type:"string" required:"true"`

	// An identifier for the message.
	MessageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendMessageBatchResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageBatchResultEntry) GoString() string {
	return s.String()
}

type SendMessageInput struct {
	_ struct{} `type:"structure"`

	// The number of seconds (0 to 900 - 15 minutes) to delay a specific message.
	// Messages with a positive DelaySeconds value become available for processing
	// after the delay time is finished. If you don't specify a value, the default
	// value for the queue applies.
	DelaySeconds *int64 `type:"integer"`

	// Each message attribute consists of a Name, Type, and Value. For more information,
	// see Message Attribute Items (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSMessageAttributes.html#SQSMessageAttributesNTV).
	MessageAttributes map[string]*MessageAttributeValue `locationName:"MessageAttribute" locationNameKey:"Name" locationNameValue:"Value" type:"map" flattened:"true"`

	// The message to send. String maximum 256 KB in size. For a list of allowed
	// characters, see the preceding important note.
	MessageBody *string `type:"string" required:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageInput) GoString() string {
	return s.String()
}

// The MD5OfMessageBody and MessageId elements.
type SendMessageOutput struct {
	_ struct{} `type:"structure"`

	// An MD5 digest of the non-URL-encoded message attribute string. This can be
	// used to verify that Amazon SQS received the message correctly. Amazon SQS
	// first URL decodes the message before creating the MD5 digest. For information
	// about MD5, go to http://www.faqs.org/rfcs/rfc1321.html (http://www.faqs.org/rfcs/rfc1321.html).
	MD5OfMessageAttributes *string `type:"string"`

	// An MD5 digest of the non-URL-encoded message body string. This can be used
	// to verify that Amazon SQS received the message correctly. Amazon SQS first
	// URL decodes the message before creating the MD5 digest. For information about
	// MD5, go to http://www.faqs.org/rfcs/rfc1321.html (http://www.faqs.org/rfcs/rfc1321.html).
	MD5OfMessageBody *string `type:"string"`

	// An element containing the message ID of the message sent to the queue. For
	// more information, see Queue and Message Identifiers (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/ImportantIdentifiers.html)
	// in the Amazon SQS Developer Guide.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SendMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageOutput) GoString() string {
	return s.String()
}

type SetQueueAttributesInput struct {
	_ struct{} `type:"structure"`

	// A map of attributes to set.
	//
	// The following lists the names, descriptions, and values of the special request
	// parameters the SetQueueAttributes action uses:
	//
	//    DelaySeconds - The time in seconds that the delivery of all messages
	// in the queue will be delayed. An integer from 0 to 900 (15 minutes). The
	// default for this attribute is 0 (zero).  MaximumMessageSize - The limit of
	// how many bytes a message can contain before Amazon SQS rejects it. An integer
	// from 1024 bytes (1 KiB) up to 262144 bytes (256 KiB). The default for this
	// attribute is 262144 (256 KiB).  MessageRetentionPeriod - The number of seconds
	// Amazon SQS retains a message. Integer representing seconds, from 60 (1 minute)
	// to 1209600 (14 days). The default for this attribute is 345600 (4 days).
	//  Policy - The queue's policy. A valid AWS policy. For more information about
	// policy structure, see Overview of AWS IAM Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/PoliciesOverview.html)
	// in the Amazon IAM User Guide.  ReceiveMessageWaitTimeSeconds - The time for
	// which a ReceiveMessage call will wait for a message to arrive. An integer
	// from 0 to 20 (seconds). The default for this attribute is 0.   VisibilityTimeout
	// - The visibility timeout for the queue. An integer from 0 to 43200 (12 hours).
	// The default for this attribute is 30. For more information about visibility
	// timeout, see Visibility Timeout in the Amazon SQS Developer Guide.  RedrivePolicy
	// - The parameters for dead letter queue functionality of the source queue.
	// For more information about RedrivePolicy and dead letter queues, see Using
	// Amazon SQS Dead Letter Queues in the Amazon SQS Developer Guide.
	Attributes map[string]*string `locationName:"Attribute" locationNameKey:"Name" locationNameValue:"Value" type:"map" flattened:"true" required:"true"`

	// The URL of the Amazon SQS queue to take action on.
	QueueUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetQueueAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetQueueAttributesInput) GoString() string {
	return s.String()
}

type SetQueueAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetQueueAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetQueueAttributesOutput) GoString() string {
	return s.String()
}

const (
	// @enum QueueAttributeName
	QueueAttributeNamePolicy = "Policy"
	// @enum QueueAttributeName
	QueueAttributeNameVisibilityTimeout = "VisibilityTimeout"
	// @enum QueueAttributeName
	QueueAttributeNameMaximumMessageSize = "MaximumMessageSize"
	// @enum QueueAttributeName
	QueueAttributeNameMessageRetentionPeriod = "MessageRetentionPeriod"
	// @enum QueueAttributeName
	QueueAttributeNameApproximateNumberOfMessages = "ApproximateNumberOfMessages"
	// @enum QueueAttributeName
	QueueAttributeNameApproximateNumberOfMessagesNotVisible = "ApproximateNumberOfMessagesNotVisible"
	// @enum QueueAttributeName
	QueueAttributeNameCreatedTimestamp = "CreatedTimestamp"
	// @enum QueueAttributeName
	QueueAttributeNameLastModifiedTimestamp = "LastModifiedTimestamp"
	// @enum QueueAttributeName
	QueueAttributeNameQueueArn = "QueueArn"
	// @enum QueueAttributeName
	QueueAttributeNameApproximateNumberOfMessagesDelayed = "ApproximateNumberOfMessagesDelayed"
	// @enum QueueAttributeName
	QueueAttributeNameDelaySeconds = "DelaySeconds"
	// @enum QueueAttributeName
	QueueAttributeNameReceiveMessageWaitTimeSeconds = "ReceiveMessageWaitTimeSeconds"
	// @enum QueueAttributeName
	QueueAttributeNameRedrivePolicy = "RedrivePolicy"
)
