// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package organizations provides a client for AWS Organizations.
package organizations

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptHandshake = "AcceptHandshake"

// AcceptHandshakeRequest generates a "aws/request.Request" representing the
// client's request for the AcceptHandshake operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AcceptHandshake for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AcceptHandshake method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AcceptHandshakeRequest method.
//    req, resp := client.AcceptHandshakeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AcceptHandshake
func (c *Organizations) AcceptHandshakeRequest(input *AcceptHandshakeInput) (req *request.Request, output *AcceptHandshakeOutput) {
	op := &request.Operation{
		Name:       opAcceptHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptHandshakeInput{}
	}

	output = &AcceptHandshakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptHandshake API operation for AWS Organizations.
//
// Sends a response to the originator of a handshake agreeing to the action
// proposed by the handshake request.
//
// This operation can be called only by the following principals when they also
// have the relevant IAM permissions:
//
//    * Invitation to join or Approve all features request handshakes: only
//    a principal from the member account.
//
//    * Enable all features final confirmation handshake: only a principal from
//    the master account.
//
// For more information about invitations, see Inviting an AWS Account to Join
//    Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html)
//    in the AWS Organizations User Guide. For more information about requests
//    to enable all features in the organization, see Enabling All Features
//    in Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
//    in the AWS Organizations User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation AcceptHandshake for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeHandshakeConstraintViolationException "HandshakeConstraintViolationException"
//   The requested operation would violate the constraint identified in the reason
//   code.
//
//   * ErrCodeHandshakeNotFoundException "HandshakeNotFoundException"
//   We can't find a handshake with the HandshakeId that you specified.
//
//   * ErrCodeInvalidHandshakeTransitionException "InvalidHandshakeTransitionException"
//   You can't perform the operation on the handshake in its current state. For
//   example, you can't cancel a handshake that was already accepted, or accept
//   a handshake that was already declined.
//
//   * ErrCodeHandshakeAlreadyInStateException "HandshakeAlreadyInStateException"
//   The specified handshake is already in the requested state. For example, you
//   can't accept a handshake that was already accepted.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AcceptHandshake
func (c *Organizations) AcceptHandshake(input *AcceptHandshakeInput) (*AcceptHandshakeOutput, error) {
	req, out := c.AcceptHandshakeRequest(input)
	return out, req.Send()
}

// AcceptHandshakeWithContext is the same as AcceptHandshake with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptHandshake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) AcceptHandshakeWithContext(ctx aws.Context, input *AcceptHandshakeInput, opts ...request.Option) (*AcceptHandshakeOutput, error) {
	req, out := c.AcceptHandshakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachPolicy = "AttachPolicy"

// AttachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachPolicyRequest method.
//    req, resp := client.AttachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AttachPolicy
func (c *Organizations) AttachPolicyRequest(input *AttachPolicyInput) (req *request.Request, output *AttachPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachPolicyInput{}
	}

	output = &AttachPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachPolicy API operation for AWS Organizations.
//
// Attaches a policy to a root, an organizational unit, or an individual account.
// How the policy affects accounts depends on the type of policy:
//
//    * Service control policy (SCP) - An SCP specifies what permissions can
//    be delegated to users in affected member accounts. The scope of influence
//    for a policy depends on what you attach the policy to:
//
// If you attach an SCP to a root, it affects all accounts in the organization.
//
// If you attach an SCP to an OU, it affects all accounts in that OU and in
//    any child OUs.
//
// If you attach the policy directly to an account, then it affects only that
//    account.
//
// SCPs essentially are permission "filters". When you attach one SCP to a higher
//    level root or OU, and you also attach a different SCP to a child OU or
//    to an account, the child policy can further restrict only the permissions
//    that pass through the parent filter and are available to the child. An
//    SCP that is attached to a child cannot grant a permission that is not
//    already granted by the parent. For example, imagine that the parent SCP
//    allows permissions A, B, C, D, and E. The child SCP allows C, D, E, F,
//    and G. The result is that the accounts affected by the child SCP are allowed
//    to use only C, D, and E. They cannot use A or B because they were filtered
//    out by the child OU. They also cannot use F and G because they were filtered
//    out by the parent OU. They cannot be granted back by the child SCP; child
//    SCPs can only filter the permissions they receive from the parent SCP.
//
// AWS Organizations attaches a default SCP named "FullAWSAccess to every root,
//    OU, and account. This default SCP allows all services and actions, enabling
//    any new child OU or account to inherit the permissions of the parent root
//    or OU. If you detach the default policy, you must replace it with a policy
//    that specifies the permissions that you want to allow in that OU or account.
//
// For more information about how Organizations policies permissions work, see
//    Using Service Control Policies (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
//    in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation AttachPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeDuplicatePolicyAttachmentException "DuplicatePolicyAttachmentException"
//   The selected policy is already attached to the specified target.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodePolicyNotFoundException "PolicyNotFoundException"
//   We can't find a policy with the PolicyId that you specified.
//
//   * ErrCodePolicyTypeNotEnabledException "PolicyTypeNotEnabledException"
//   The specified policy type is not currently enabled in this root. You cannot
//   attach policies of the specified type to entities in a root until you enable
//   that type in the root. For more information, see Enabling All Features in
//   Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
//   in the AWS Organizations User Guide.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTargetNotFoundException "TargetNotFoundException"
//   We can't find a root, OU, or account with the TargetId that you specified.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AttachPolicy
func (c *Organizations) AttachPolicy(input *AttachPolicyInput) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	return out, req.Send()
}

// AttachPolicyWithContext is the same as AttachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AttachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) AttachPolicyWithContext(ctx aws.Context, input *AttachPolicyInput, opts ...request.Option) (*AttachPolicyOutput, error) {
	req, out := c.AttachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelHandshake = "CancelHandshake"

// CancelHandshakeRequest generates a "aws/request.Request" representing the
// client's request for the CancelHandshake operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelHandshake for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelHandshake method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelHandshakeRequest method.
//    req, resp := client.CancelHandshakeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshake
func (c *Organizations) CancelHandshakeRequest(input *CancelHandshakeInput) (req *request.Request, output *CancelHandshakeOutput) {
	op := &request.Operation{
		Name:       opCancelHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelHandshakeInput{}
	}

	output = &CancelHandshakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelHandshake API operation for AWS Organizations.
//
// Cancels a handshake. Canceling a handshake sets the handshake state to CANCELED.
//
// This operation can be called only from the account that originated the handshake.
// The recipient of the handshake can't cancel it, but can use DeclineHandshake
// instead. After a handshake is canceled, the recipient can no longer respond
// to that handshake.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CancelHandshake for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeHandshakeNotFoundException "HandshakeNotFoundException"
//   We can't find a handshake with the HandshakeId that you specified.
//
//   * ErrCodeInvalidHandshakeTransitionException "InvalidHandshakeTransitionException"
//   You can't perform the operation on the handshake in its current state. For
//   example, you can't cancel a handshake that was already accepted, or accept
//   a handshake that was already declined.
//
//   * ErrCodeHandshakeAlreadyInStateException "HandshakeAlreadyInStateException"
//   The specified handshake is already in the requested state. For example, you
//   can't accept a handshake that was already accepted.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshake
func (c *Organizations) CancelHandshake(input *CancelHandshakeInput) (*CancelHandshakeOutput, error) {
	req, out := c.CancelHandshakeRequest(input)
	return out, req.Send()
}

// CancelHandshakeWithContext is the same as CancelHandshake with the addition of
// the ability to pass a context and additional request options.
//
// See CancelHandshake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CancelHandshakeWithContext(ctx aws.Context, input *CancelHandshakeInput, opts ...request.Option) (*CancelHandshakeOutput, error) {
	req, out := c.CancelHandshakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccount = "CreateAccount"

// CreateAccountRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccount operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAccount for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAccount method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAccountRequest method.
//    req, resp := client.CreateAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccount
func (c *Organizations) CreateAccountRequest(input *CreateAccountInput) (req *request.Request, output *CreateAccountOutput) {
	op := &request.Operation{
		Name:       opCreateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccountInput{}
	}

	output = &CreateAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccount API operation for AWS Organizations.
//
// Creates an AWS account that is automatically a member of the organization
// whose credentials made the request. This is an asynchronous request that
// AWS performs in the background. If you want to check the status of the request
// later, you need the OperationId response element from this operation to provide
// as a parameter to the DescribeCreateAccountStatus operation.
//
// AWS Organizations preconfigures the new member account with a role (named
// OrganizationAccountAccessRole by default) that grants administrator permissions
// to the new account. Principals in the master account can assume the role.
// AWS Organizations clones the company name and address information for the
// new account from the organization's master account.
//
// For more information about creating accounts, see Creating an AWS Account
// in Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html)
// in the AWS Organizations User Guide.
//
// You cannot remove accounts that are created with this operation from an organization.
// That also means that you cannot delete an organization that contains an account
// that is created with this operation.
//
// When you create a member account with this operation, the account is created
// with the IAM User and Role Access to Billing Information switch enabled.
// This allows IAM users and roles that are granted appropriate permissions
// to view billing information. If this is disabled, then only the account root
// user can access billing information. For information about how to disable
// this for an account, see Granting Access to Your Billing Information and
// Tools (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html).
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreateAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeFinalizingOrganizationException "FinalizingOrganizationException"
//   AWS Organizations could not finalize the creation of your organization. Try
//   again later. If this persists, contact AWS customer support.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccount
func (c *Organizations) CreateAccount(input *CreateAccountInput) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	return out, req.Send()
}

// CreateAccountWithContext is the same as CreateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreateAccountWithContext(ctx aws.Context, input *CreateAccountInput, opts ...request.Option) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOrganization = "CreateOrganization"

// CreateOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateOrganization operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateOrganization for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateOrganization method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateOrganizationRequest method.
//    req, resp := client.CreateOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganization
func (c *Organizations) CreateOrganizationRequest(input *CreateOrganizationInput) (req *request.Request, output *CreateOrganizationOutput) {
	op := &request.Operation{
		Name:       opCreateOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOrganizationInput{}
	}

	output = &CreateOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOrganization API operation for AWS Organizations.
//
// Creates an AWS organization. The account whose user is calling the CreateOrganization
// operation automatically becomes the master account (http://docs.aws.amazon.com/IAM/latest/UserGuide/orgs_getting-started_concepts.html#account)
// of the new organization.
//
// This operation must be called using credentials from the account that is
// to become the new organization's master account. The principal must also
// have the relevant IAM permissions.
//
// By default (or if you set the FeatureSet parameter to ALL), the new organization
// is created with all features enabled and service control policies automatically
// enabled in the root. If you instead choose to create the organization supporting
// only the consolidated billing features by setting the FeatureSet parameter
// to CONSOLIDATED_BILLING", then no policy types are enabled by default and
// you cannot use organization policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreateOrganization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAlreadyInOrganizationException "AlreadyInOrganizationException"
//   This account is already a member of an organization. An account can belong
//   to only one organization at a time.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganization
func (c *Organizations) CreateOrganization(input *CreateOrganizationInput) (*CreateOrganizationOutput, error) {
	req, out := c.CreateOrganizationRequest(input)
	return out, req.Send()
}

// CreateOrganizationWithContext is the same as CreateOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreateOrganizationWithContext(ctx aws.Context, input *CreateOrganizationInput, opts ...request.Option) (*CreateOrganizationOutput, error) {
	req, out := c.CreateOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOrganizationalUnit = "CreateOrganizationalUnit"

// CreateOrganizationalUnitRequest generates a "aws/request.Request" representing the
// client's request for the CreateOrganizationalUnit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateOrganizationalUnit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateOrganizationalUnit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateOrganizationalUnitRequest method.
//    req, resp := client.CreateOrganizationalUnitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationalUnit
func (c *Organizations) CreateOrganizationalUnitRequest(input *CreateOrganizationalUnitInput) (req *request.Request, output *CreateOrganizationalUnitOutput) {
	op := &request.Operation{
		Name:       opCreateOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOrganizationalUnitInput{}
	}

	output = &CreateOrganizationalUnitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOrganizationalUnit API operation for AWS Organizations.
//
// Creates an organizational unit (OU) within a root or parent OU. An OU is
// a container for accounts that enables you to organize your accounts to apply
// policies according to your business requirements. The number of levels deep
// that you can nest OUs is dependent upon the policy types enabled for that
// root. For service control policies, the limit is five.
//
// For more information about OUs, see Managing Organizational Units (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html)
// in the AWS Organizations User Guide.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreateOrganizationalUnit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeDuplicateOrganizationalUnitException "DuplicateOrganizationalUnitException"
//   An organizational unit (OU) with the same name already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeParentNotFoundException "ParentNotFoundException"
//   We can't find a root or organizational unit (OU) with the ParentId that you
//   specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationalUnit
func (c *Organizations) CreateOrganizationalUnit(input *CreateOrganizationalUnitInput) (*CreateOrganizationalUnitOutput, error) {
	req, out := c.CreateOrganizationalUnitRequest(input)
	return out, req.Send()
}

// CreateOrganizationalUnitWithContext is the same as CreateOrganizationalUnit with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOrganizationalUnit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreateOrganizationalUnitWithContext(ctx aws.Context, input *CreateOrganizationalUnitInput, opts ...request.Option) (*CreateOrganizationalUnitOutput, error) {
	req, out := c.CreateOrganizationalUnitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePolicyRequest method.
//    req, resp := client.CreatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreatePolicy
func (c *Organizations) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	output = &CreatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicy API operation for AWS Organizations.
//
// Creates a policy of a specified type that you can attach to a root, an organizational
// unit (OU), or an individual AWS account.
//
// For more information about policies and their use, see Managing Organization
// Policies (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html).
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation CreatePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeDuplicatePolicyException "DuplicatePolicyException"
//   A policy with the same name already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocumentException"
//   The provided policy document does not meet the requirements of the specified
//   policy type. For example, the syntax might be incorrect. For details about
//   service control policy syntax, see Service Control Policy Syntax (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
//   in the AWS Organizations User Guide.
//
//   * ErrCodePolicyTypeNotAvailableForOrganizationException "PolicyTypeNotAvailableForOrganizationException"
//   You can't use the specified policy type with the feature set currently enabled
//   for this organization. For example, you can enable service control policies
//   (SCPs) only after you enable all features in the organization. For more information,
//   see Enabling and Disabling a Policy Type on a Root (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root)
//   in the AWS Organizations User Guide.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreatePolicy
func (c *Organizations) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	return out, req.Send()
}

// CreatePolicyWithContext is the same as CreatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) CreatePolicyWithContext(ctx aws.Context, input *CreatePolicyInput, opts ...request.Option) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineHandshake = "DeclineHandshake"

// DeclineHandshakeRequest generates a "aws/request.Request" representing the
// client's request for the DeclineHandshake operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeclineHandshake for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeclineHandshake method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeclineHandshakeRequest method.
//    req, resp := client.DeclineHandshakeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeclineHandshake
func (c *Organizations) DeclineHandshakeRequest(input *DeclineHandshakeInput) (req *request.Request, output *DeclineHandshakeOutput) {
	op := &request.Operation{
		Name:       opDeclineHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeclineHandshakeInput{}
	}

	output = &DeclineHandshakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineHandshake API operation for AWS Organizations.
//
// Declines a handshake request. This sets the handshake state to DECLINED and
// effectively deactivates the request.
//
// This operation can be called only from the account that received the handshake.
// The originator of the handshake can use CancelHandshake instead. The originator
// can't reactivate a declined request, but can re-initiate the process with
// a new handshake request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeclineHandshake for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeHandshakeNotFoundException "HandshakeNotFoundException"
//   We can't find a handshake with the HandshakeId that you specified.
//
//   * ErrCodeInvalidHandshakeTransitionException "InvalidHandshakeTransitionException"
//   You can't perform the operation on the handshake in its current state. For
//   example, you can't cancel a handshake that was already accepted, or accept
//   a handshake that was already declined.
//
//   * ErrCodeHandshakeAlreadyInStateException "HandshakeAlreadyInStateException"
//   The specified handshake is already in the requested state. For example, you
//   can't accept a handshake that was already accepted.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeclineHandshake
func (c *Organizations) DeclineHandshake(input *DeclineHandshakeInput) (*DeclineHandshakeOutput, error) {
	req, out := c.DeclineHandshakeRequest(input)
	return out, req.Send()
}

// DeclineHandshakeWithContext is the same as DeclineHandshake with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineHandshake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeclineHandshakeWithContext(ctx aws.Context, input *DeclineHandshakeInput, opts ...request.Option) (*DeclineHandshakeOutput, error) {
	req, out := c.DeclineHandshakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganization = "DeleteOrganization"

// DeleteOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganization operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteOrganization for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteOrganization method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteOrganizationRequest method.
//    req, resp := client.DeleteOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganization
func (c *Organizations) DeleteOrganizationRequest(input *DeleteOrganizationInput) (req *request.Request, output *DeleteOrganizationOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationInput{}
	}

	output = &DeleteOrganizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOrganization API operation for AWS Organizations.
//
// Deletes the organization. You can delete an organization only by using credentials
// from the master account. The organization must be empty of member accounts,
// OUs, and policies.
//
// If you create any accounts using Organizations operations or the Organizations
// console, you can't remove those accounts from the organization, which means
// that you can't delete the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeleteOrganization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeOrganizationNotEmptyException "OrganizationNotEmptyException"
//   The organization isn't empty. To delete an organization, you must first remove
//   all accounts except the master account, delete all organizational units (OUs),
//   and delete all policies.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganization
func (c *Organizations) DeleteOrganization(input *DeleteOrganizationInput) (*DeleteOrganizationOutput, error) {
	req, out := c.DeleteOrganizationRequest(input)
	return out, req.Send()
}

// DeleteOrganizationWithContext is the same as DeleteOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeleteOrganizationWithContext(ctx aws.Context, input *DeleteOrganizationInput, opts ...request.Option) (*DeleteOrganizationOutput, error) {
	req, out := c.DeleteOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOrganizationalUnit = "DeleteOrganizationalUnit"

// DeleteOrganizationalUnitRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOrganizationalUnit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteOrganizationalUnit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteOrganizationalUnit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteOrganizationalUnitRequest method.
//    req, resp := client.DeleteOrganizationalUnitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationalUnit
func (c *Organizations) DeleteOrganizationalUnitRequest(input *DeleteOrganizationalUnitInput) (req *request.Request, output *DeleteOrganizationalUnitOutput) {
	op := &request.Operation{
		Name:       opDeleteOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOrganizationalUnitInput{}
	}

	output = &DeleteOrganizationalUnitOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOrganizationalUnit API operation for AWS Organizations.
//
// Deletes an organizational unit from a root or another OU. You must first
// remove all accounts and child OUs from the OU that you want to delete.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeleteOrganizationalUnit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeOrganizationalUnitNotEmptyException "OrganizationalUnitNotEmptyException"
//   The specified organizational unit (OU) is not empty. Move all accounts to
//   another root or to other OUs, remove all child OUs, and then try the operation
//   again.
//
//   * ErrCodeOrganizationalUnitNotFoundException "OrganizationalUnitNotFoundException"
//   We can't find an organizational unit (OU) with the OrganizationalUnitId that
//   you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationalUnit
func (c *Organizations) DeleteOrganizationalUnit(input *DeleteOrganizationalUnitInput) (*DeleteOrganizationalUnitOutput, error) {
	req, out := c.DeleteOrganizationalUnitRequest(input)
	return out, req.Send()
}

// DeleteOrganizationalUnitWithContext is the same as DeleteOrganizationalUnit with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOrganizationalUnit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeleteOrganizationalUnitWithContext(ctx aws.Context, input *DeleteOrganizationalUnitInput, opts ...request.Option) (*DeleteOrganizationalUnitOutput, error) {
	req, out := c.DeleteOrganizationalUnitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeletePolicy
func (c *Organizations) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for AWS Organizations.
//
// Deletes the specified policy from your organization. Before you perform this
// operation, you must first detach the policy from all OUs, roots, and accounts.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodePolicyInUseException "PolicyInUseException"
//   The policy is attached to one or more entities. You must detach it from all
//   roots, organizational units (OUs), and accounts before performing this operation.
//
//   * ErrCodePolicyNotFoundException "PolicyNotFoundException"
//   We can't find a policy with the PolicyId that you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeletePolicy
func (c *Organizations) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccount = "DescribeAccount"

// DescribeAccountRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccount operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAccount for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAccount method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAccountRequest method.
//    req, resp := client.DescribeAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccount
func (c *Organizations) DescribeAccountRequest(input *DescribeAccountInput) (req *request.Request, output *DescribeAccountOutput) {
	op := &request.Operation{
		Name:       opDescribeAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountInput{}
	}

	output = &DescribeAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccount API operation for AWS Organizations.
//
// Retrieves Organizations-related information about the specified account.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAccountNotFoundException "AccountNotFoundException"
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request is not a member of
//   an organization.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccount
func (c *Organizations) DescribeAccount(input *DescribeAccountInput) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	return out, req.Send()
}

// DescribeAccountWithContext is the same as DescribeAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeAccountWithContext(ctx aws.Context, input *DescribeAccountInput, opts ...request.Option) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCreateAccountStatus = "DescribeCreateAccountStatus"

// DescribeCreateAccountStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCreateAccountStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCreateAccountStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCreateAccountStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCreateAccountStatusRequest method.
//    req, resp := client.DescribeCreateAccountStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatus
func (c *Organizations) DescribeCreateAccountStatusRequest(input *DescribeCreateAccountStatusInput) (req *request.Request, output *DescribeCreateAccountStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeCreateAccountStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCreateAccountStatusInput{}
	}

	output = &DescribeCreateAccountStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCreateAccountStatus API operation for AWS Organizations.
//
// Retrieves the current status of an asynchronous request to create an account.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeCreateAccountStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeCreateAccountStatusNotFoundException "CreateAccountStatusNotFoundException"
//   We can't find an create account request with the CreateAccountRequestId that
//   you specified.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatus
func (c *Organizations) DescribeCreateAccountStatus(input *DescribeCreateAccountStatusInput) (*DescribeCreateAccountStatusOutput, error) {
	req, out := c.DescribeCreateAccountStatusRequest(input)
	return out, req.Send()
}

// DescribeCreateAccountStatusWithContext is the same as DescribeCreateAccountStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCreateAccountStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeCreateAccountStatusWithContext(ctx aws.Context, input *DescribeCreateAccountStatusInput, opts ...request.Option) (*DescribeCreateAccountStatusOutput, error) {
	req, out := c.DescribeCreateAccountStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHandshake = "DescribeHandshake"

// DescribeHandshakeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHandshake operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeHandshake for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeHandshake method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeHandshakeRequest method.
//    req, resp := client.DescribeHandshakeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeHandshake
func (c *Organizations) DescribeHandshakeRequest(input *DescribeHandshakeInput) (req *request.Request, output *DescribeHandshakeOutput) {
	op := &request.Operation{
		Name:       opDescribeHandshake,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHandshakeInput{}
	}

	output = &DescribeHandshakeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHandshake API operation for AWS Organizations.
//
// Retrieves information about a previously requested handshake. The handshake
// ID comes from the response to the original InviteAccountToOrganization operation
// that generated the handshake.
//
// This operation can be called from any account in the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeHandshake for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeHandshakeNotFoundException "HandshakeNotFoundException"
//   We can't find a handshake with the HandshakeId that you specified.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeHandshake
func (c *Organizations) DescribeHandshake(input *DescribeHandshakeInput) (*DescribeHandshakeOutput, error) {
	req, out := c.DescribeHandshakeRequest(input)
	return out, req.Send()
}

// DescribeHandshakeWithContext is the same as DescribeHandshake with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHandshake for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeHandshakeWithContext(ctx aws.Context, input *DescribeHandshakeInput, opts ...request.Option) (*DescribeHandshakeOutput, error) {
	req, out := c.DescribeHandshakeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganization = "DescribeOrganization"

// DescribeOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganization operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeOrganization for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeOrganization method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeOrganizationRequest method.
//    req, resp := client.DescribeOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganization
func (c *Organizations) DescribeOrganizationRequest(input *DescribeOrganizationInput) (req *request.Request, output *DescribeOrganizationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationInput{}
	}

	output = &DescribeOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganization API operation for AWS Organizations.
//
// Retrieves information about the organization that the user's account belongs
// to.
//
// This operation can be called from any account in the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeOrganization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganization
func (c *Organizations) DescribeOrganization(input *DescribeOrganizationInput) (*DescribeOrganizationOutput, error) {
	req, out := c.DescribeOrganizationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationWithContext is the same as DescribeOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeOrganizationWithContext(ctx aws.Context, input *DescribeOrganizationInput, opts ...request.Option) (*DescribeOrganizationOutput, error) {
	req, out := c.DescribeOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationalUnit = "DescribeOrganizationalUnit"

// DescribeOrganizationalUnitRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationalUnit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeOrganizationalUnit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeOrganizationalUnit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeOrganizationalUnitRequest method.
//    req, resp := client.DescribeOrganizationalUnitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnit
func (c *Organizations) DescribeOrganizationalUnitRequest(input *DescribeOrganizationalUnitInput) (req *request.Request, output *DescribeOrganizationalUnitOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationalUnitInput{}
	}

	output = &DescribeOrganizationalUnitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationalUnit API operation for AWS Organizations.
//
// Retrieves information about an organizational unit (OU).
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribeOrganizationalUnit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeOrganizationalUnitNotFoundException "OrganizationalUnitNotFoundException"
//   We can't find an organizational unit (OU) with the OrganizationalUnitId that
//   you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnit
func (c *Organizations) DescribeOrganizationalUnit(input *DescribeOrganizationalUnitInput) (*DescribeOrganizationalUnitOutput, error) {
	req, out := c.DescribeOrganizationalUnitRequest(input)
	return out, req.Send()
}

// DescribeOrganizationalUnitWithContext is the same as DescribeOrganizationalUnit with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationalUnit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribeOrganizationalUnitWithContext(ctx aws.Context, input *DescribeOrganizationalUnitInput, opts ...request.Option) (*DescribeOrganizationalUnitOutput, error) {
	req, out := c.DescribeOrganizationalUnitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePolicy = "DescribePolicy"

// DescribePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribePolicyRequest method.
//    req, resp := client.DescribePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribePolicy
func (c *Organizations) DescribePolicyRequest(input *DescribePolicyInput) (req *request.Request, output *DescribePolicyOutput) {
	op := &request.Operation{
		Name:       opDescribePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePolicyInput{}
	}

	output = &DescribePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePolicy API operation for AWS Organizations.
//
// Retrieves information about a policy.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DescribePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodePolicyNotFoundException "PolicyNotFoundException"
//   We can't find a policy with the PolicyId that you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribePolicy
func (c *Organizations) DescribePolicy(input *DescribePolicyInput) (*DescribePolicyOutput, error) {
	req, out := c.DescribePolicyRequest(input)
	return out, req.Send()
}

// DescribePolicyWithContext is the same as DescribePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DescribePolicyWithContext(ctx aws.Context, input *DescribePolicyInput, opts ...request.Option) (*DescribePolicyOutput, error) {
	req, out := c.DescribePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachPolicy = "DetachPolicy"

// DetachPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachPolicyRequest method.
//    req, resp := client.DetachPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DetachPolicy
func (c *Organizations) DetachPolicyRequest(input *DetachPolicyInput) (req *request.Request, output *DetachPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachPolicyInput{}
	}

	output = &DetachPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachPolicy API operation for AWS Organizations.
//
// Detaches a policy from a target root, organizational unit, or account. If
// the policy being detached is a service control policy (SCP), the changes
// to permissions for IAM users and roles in affected accounts are immediate.
//
// Note: Every root, OU, and account must have at least one SCP attached. If
// you want to replace the default FullAWSAccess policy with one that limits
// the permissions that can be delegated, then you must attach the replacement
// policy before you can remove the default one. This is the authorization strategy
// of whitelisting (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_about-scps.html#orgs_policies_whitelist).
// If you instead attach a second SCP and leave the FullAWSAccess SCP still
// attached, and specify "Effect": "Deny" in the second SCP to override the
// "Effect": "Allow" in the FullAWSAccess policy (or any other attached SCP),
// then you are using the authorization strategy of blacklisting (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_about-scps.html#orgs_policies_blacklist).
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DetachPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodePolicyNotAttachedException "PolicyNotAttachedException"
//   The policy isn't attached to the specified target in the specified root.
//
//   * ErrCodePolicyNotFoundException "PolicyNotFoundException"
//   We can't find a policy with the PolicyId that you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTargetNotFoundException "TargetNotFoundException"
//   We can't find a root, OU, or account with the TargetId that you specified.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DetachPolicy
func (c *Organizations) DetachPolicy(input *DetachPolicyInput) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	return out, req.Send()
}

// DetachPolicyWithContext is the same as DetachPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DetachPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DetachPolicyWithContext(ctx aws.Context, input *DetachPolicyInput, opts ...request.Option) (*DetachPolicyOutput, error) {
	req, out := c.DetachPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisablePolicyType = "DisablePolicyType"

// DisablePolicyTypeRequest generates a "aws/request.Request" representing the
// client's request for the DisablePolicyType operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisablePolicyType for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisablePolicyType method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisablePolicyTypeRequest method.
//    req, resp := client.DisablePolicyTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisablePolicyType
func (c *Organizations) DisablePolicyTypeRequest(input *DisablePolicyTypeInput) (req *request.Request, output *DisablePolicyTypeOutput) {
	op := &request.Operation{
		Name:       opDisablePolicyType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisablePolicyTypeInput{}
	}

	output = &DisablePolicyTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisablePolicyType API operation for AWS Organizations.
//
// Disables an organizational control policy type in a root. A poicy of a certain
// type can be attached to entities in a root only if that type is enabled in
// the root. After you perform this operation, you no longer can attach policies
// of the specified type to that root or to any OU or account in that root.
// You can undo this by using the EnablePolicyType operation.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation DisablePolicyType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodePolicyTypeNotEnabledException "PolicyTypeNotEnabledException"
//   The specified policy type is not currently enabled in this root. You cannot
//   attach policies of the specified type to entities in a root until you enable
//   that type in the root. For more information, see Enabling All Features in
//   Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
//   in the AWS Organizations User Guide.
//
//   * ErrCodeRootNotFoundException "RootNotFoundException"
//   We can't find a root with the RootId that you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisablePolicyType
func (c *Organizations) DisablePolicyType(input *DisablePolicyTypeInput) (*DisablePolicyTypeOutput, error) {
	req, out := c.DisablePolicyTypeRequest(input)
	return out, req.Send()
}

// DisablePolicyTypeWithContext is the same as DisablePolicyType with the addition of
// the ability to pass a context and additional request options.
//
// See DisablePolicyType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) DisablePolicyTypeWithContext(ctx aws.Context, input *DisablePolicyTypeInput, opts ...request.Option) (*DisablePolicyTypeOutput, error) {
	req, out := c.DisablePolicyTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableAllFeatures = "EnableAllFeatures"

// EnableAllFeaturesRequest generates a "aws/request.Request" representing the
// client's request for the EnableAllFeatures operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableAllFeatures for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableAllFeatures method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableAllFeaturesRequest method.
//    req, resp := client.EnableAllFeaturesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAllFeatures
func (c *Organizations) EnableAllFeaturesRequest(input *EnableAllFeaturesInput) (req *request.Request, output *EnableAllFeaturesOutput) {
	op := &request.Operation{
		Name:       opEnableAllFeatures,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAllFeaturesInput{}
	}

	output = &EnableAllFeaturesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableAllFeatures API operation for AWS Organizations.
//
// Enables all features in an organization. This enables the use of organization
// policies that can restrict the services and actions that can be called in
// each account. Until you enable all features, you have access only to consolidated
// billing, and you can't use any of the advanced account administration features
// that AWS Organizations supports. For more information, see Enabling All Features
// in Your Organization (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
// in the AWS Organizations User Guide.
//
// This operation is required only for organizations that were created explicitly
// with only the consolidated billing features enabled, or that were migrated
// from a Consolidated Billing account family to Organizations. Calling this
// operation sends a handshake to every invited account in the organization.
// The feature set change can be finalized and the additional features enabled
// only after all administrators in the invited accounts approve the change
// by accepting the handshake.
//
// After all invited member accounts accept the handshake, you finalize the
// feature set change by accepting the handshake that contains "Action": "ENABLE_ALL_FEATURES".
// This completes the change.
//
// After you enable all features in your organization, the master account in
// the organization can apply policies on all member accounts. These policies
// can restrict what users and even administrators in those accounts can do.
// The master account can apply policies that prevent accounts from leaving
// the organization. Ensure that your account administrators are aware of this.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation EnableAllFeatures for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeHandshakeConstraintViolationException "HandshakeConstraintViolationException"
//   The requested operation would violate the constraint identified in the reason
//   code.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAllFeatures
func (c *Organizations) EnableAllFeatures(input *EnableAllFeaturesInput) (*EnableAllFeaturesOutput, error) {
	req, out := c.EnableAllFeaturesRequest(input)
	return out, req.Send()
}

// EnableAllFeaturesWithContext is the same as EnableAllFeatures with the addition of
// the ability to pass a context and additional request options.
//
// See EnableAllFeatures for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) EnableAllFeaturesWithContext(ctx aws.Context, input *EnableAllFeaturesInput, opts ...request.Option) (*EnableAllFeaturesOutput, error) {
	req, out := c.EnableAllFeaturesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnablePolicyType = "EnablePolicyType"

// EnablePolicyTypeRequest generates a "aws/request.Request" representing the
// client's request for the EnablePolicyType operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnablePolicyType for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnablePolicyType method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnablePolicyTypeRequest method.
//    req, resp := client.EnablePolicyTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnablePolicyType
func (c *Organizations) EnablePolicyTypeRequest(input *EnablePolicyTypeInput) (req *request.Request, output *EnablePolicyTypeOutput) {
	op := &request.Operation{
		Name:       opEnablePolicyType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnablePolicyTypeInput{}
	}

	output = &EnablePolicyTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnablePolicyType API operation for AWS Organizations.
//
// Enables a policy type in a root. After you enable a policy type in a root,
// you can attach policies of that type to the root, any OU, or account in that
// root. You can undo this by using the DisablePolicyType operation.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation EnablePolicyType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodePolicyTypeAlreadyEnabledException "PolicyTypeAlreadyEnabledException"
//   The specified policy type is already enabled in the specified root.
//
//   * ErrCodeRootNotFoundException "RootNotFoundException"
//   We can't find a root with the RootId that you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
//   * ErrCodePolicyTypeNotAvailableForOrganizationException "PolicyTypeNotAvailableForOrganizationException"
//   You can't use the specified policy type with the feature set currently enabled
//   for this organization. For example, you can enable service control policies
//   (SCPs) only after you enable all features in the organization. For more information,
//   see Enabling and Disabling a Policy Type on a Root (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root)
//   in the AWS Organizations User Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnablePolicyType
func (c *Organizations) EnablePolicyType(input *EnablePolicyTypeInput) (*EnablePolicyTypeOutput, error) {
	req, out := c.EnablePolicyTypeRequest(input)
	return out, req.Send()
}

// EnablePolicyTypeWithContext is the same as EnablePolicyType with the addition of
// the ability to pass a context and additional request options.
//
// See EnablePolicyType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) EnablePolicyTypeWithContext(ctx aws.Context, input *EnablePolicyTypeInput, opts ...request.Option) (*EnablePolicyTypeOutput, error) {
	req, out := c.EnablePolicyTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteAccountToOrganization = "InviteAccountToOrganization"

// InviteAccountToOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the InviteAccountToOrganization operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See InviteAccountToOrganization for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the InviteAccountToOrganization method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the InviteAccountToOrganizationRequest method.
//    req, resp := client.InviteAccountToOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/InviteAccountToOrganization
func (c *Organizations) InviteAccountToOrganizationRequest(input *InviteAccountToOrganizationInput) (req *request.Request, output *InviteAccountToOrganizationOutput) {
	op := &request.Operation{
		Name:       opInviteAccountToOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InviteAccountToOrganizationInput{}
	}

	output = &InviteAccountToOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteAccountToOrganization API operation for AWS Organizations.
//
// Sends an invitation to another account to join your organization as a member
// account. Organizations sends email on your behalf to the email address that
// is associated with the other account's owner. The invitation is implemented
// as a Handshake whose details are in the response.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation InviteAccountToOrganization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeHandshakeConstraintViolationException "HandshakeConstraintViolationException"
//   The requested operation would violate the constraint identified in the reason
//   code.
//
//   * ErrCodeDuplicateHandshakeException "DuplicateHandshakeException"
//   A handshake with the same action and target already exists. For example,
//   if you invited an account to join your organization, the invited account
//   might already have a pending invitation from this organization. If you intend
//   to resend an invitation to an account, ensure that existing handshakes that
//   might be considered duplicates are canceled or declined.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeFinalizingOrganizationException "FinalizingOrganizationException"
//   AWS Organizations could not finalize the creation of your organization. Try
//   again later. If this persists, contact AWS customer support.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/InviteAccountToOrganization
func (c *Organizations) InviteAccountToOrganization(input *InviteAccountToOrganizationInput) (*InviteAccountToOrganizationOutput, error) {
	req, out := c.InviteAccountToOrganizationRequest(input)
	return out, req.Send()
}

// InviteAccountToOrganizationWithContext is the same as InviteAccountToOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See InviteAccountToOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) InviteAccountToOrganizationWithContext(ctx aws.Context, input *InviteAccountToOrganizationInput, opts ...request.Option) (*InviteAccountToOrganizationOutput, error) {
	req, out := c.InviteAccountToOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLeaveOrganization = "LeaveOrganization"

// LeaveOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the LeaveOrganization operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See LeaveOrganization for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the LeaveOrganization method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the LeaveOrganizationRequest method.
//    req, resp := client.LeaveOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/LeaveOrganization
func (c *Organizations) LeaveOrganizationRequest(input *LeaveOrganizationInput) (req *request.Request, output *LeaveOrganizationOutput) {
	op := &request.Operation{
		Name:       opLeaveOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LeaveOrganizationInput{}
	}

	output = &LeaveOrganizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// LeaveOrganization API operation for AWS Organizations.
//
// Removes a member account from its parent organization. This version of the
// operation is performed by the account that wants to leave. To remove a member
// account as a user in the master account, use RemoveAccountFromOrganization
// instead.
//
// This operation can be called only from a member account in the organization.
//
// The master account in an organization with all features enabled can set service
// control policies (SCPs) that can restrict what administrators of member accounts
// can do, including preventing them from successfully calling LeaveOrganization
// and leaving the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation LeaveOrganization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAccountNotFoundException "AccountNotFoundException"
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request is not a member of
//   an organization.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeMasterCannotLeaveOrganizationException "MasterCannotLeaveOrganizationException"
//   You can't remove a master account from an organization. If you want the master
//   account to become a member account in another organization, you must first
//   delete the current organization of the master account.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/LeaveOrganization
func (c *Organizations) LeaveOrganization(input *LeaveOrganizationInput) (*LeaveOrganizationOutput, error) {
	req, out := c.LeaveOrganizationRequest(input)
	return out, req.Send()
}

// LeaveOrganizationWithContext is the same as LeaveOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See LeaveOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) LeaveOrganizationWithContext(ctx aws.Context, input *LeaveOrganizationInput, opts ...request.Option) (*LeaveOrganizationOutput, error) {
	req, out := c.LeaveOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccounts = "ListAccounts"

// ListAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccounts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAccounts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAccounts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAccountsRequest method.
//    req, resp := client.ListAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccounts
func (c *Organizations) ListAccountsRequest(input *ListAccountsInput) (req *request.Request, output *ListAccountsOutput) {
	op := &request.Operation{
		Name:       opListAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAccountsInput{}
	}

	output = &ListAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccounts API operation for AWS Organizations.
//
// Lists all the accounts in the organization. To request only the accounts
// in a root or OU, use the ListAccountsForParent operation instead.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListAccounts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccounts
func (c *Organizations) ListAccounts(input *ListAccountsInput) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	return out, req.Send()
}

// ListAccountsWithContext is the same as ListAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListAccountsWithContext(ctx aws.Context, input *ListAccountsInput, opts ...request.Option) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountsForParent = "ListAccountsForParent"

// ListAccountsForParentRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountsForParent operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAccountsForParent for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAccountsForParent method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAccountsForParentRequest method.
//    req, resp := client.ListAccountsForParentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccountsForParent
func (c *Organizations) ListAccountsForParentRequest(input *ListAccountsForParentInput) (req *request.Request, output *ListAccountsForParentOutput) {
	op := &request.Operation{
		Name:       opListAccountsForParent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAccountsForParentInput{}
	}

	output = &ListAccountsForParentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountsForParent API operation for AWS Organizations.
//
// Lists the accounts in an organization that are contained by the specified
// target root or organizational unit (OU). If you specify the root, you get
// a list of all the accounts that are not in any OU. If you specify an OU,
// you get a list of all the accounts in only that OU, and not in any child
// OUs. To get a list of all accounts in the organization, use the ListAccounts
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListAccountsForParent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeParentNotFoundException "ParentNotFoundException"
//   We can't find a root or organizational unit (OU) with the ParentId that you
//   specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccountsForParent
func (c *Organizations) ListAccountsForParent(input *ListAccountsForParentInput) (*ListAccountsForParentOutput, error) {
	req, out := c.ListAccountsForParentRequest(input)
	return out, req.Send()
}

// ListAccountsForParentWithContext is the same as ListAccountsForParent with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountsForParent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListAccountsForParentWithContext(ctx aws.Context, input *ListAccountsForParentInput, opts ...request.Option) (*ListAccountsForParentOutput, error) {
	req, out := c.ListAccountsForParentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChildren = "ListChildren"

// ListChildrenRequest generates a "aws/request.Request" representing the
// client's request for the ListChildren operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListChildren for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListChildren method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListChildrenRequest method.
//    req, resp := client.ListChildrenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListChildren
func (c *Organizations) ListChildrenRequest(input *ListChildrenInput) (req *request.Request, output *ListChildrenOutput) {
	op := &request.Operation{
		Name:       opListChildren,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListChildrenInput{}
	}

	output = &ListChildrenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChildren API operation for AWS Organizations.
//
// Lists all of the OUs or accounts that are contained in the specified parent
// OU or root. This operation, along with ListParents enables you to traverse
// the tree structure that makes up this root.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListChildren for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeParentNotFoundException "ParentNotFoundException"
//   We can't find a root or organizational unit (OU) with the ParentId that you
//   specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListChildren
func (c *Organizations) ListChildren(input *ListChildrenInput) (*ListChildrenOutput, error) {
	req, out := c.ListChildrenRequest(input)
	return out, req.Send()
}

// ListChildrenWithContext is the same as ListChildren with the addition of
// the ability to pass a context and additional request options.
//
// See ListChildren for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListChildrenWithContext(ctx aws.Context, input *ListChildrenInput, opts ...request.Option) (*ListChildrenOutput, error) {
	req, out := c.ListChildrenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCreateAccountStatus = "ListCreateAccountStatus"

// ListCreateAccountStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListCreateAccountStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListCreateAccountStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListCreateAccountStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListCreateAccountStatusRequest method.
//    req, resp := client.ListCreateAccountStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListCreateAccountStatus
func (c *Organizations) ListCreateAccountStatusRequest(input *ListCreateAccountStatusInput) (req *request.Request, output *ListCreateAccountStatusOutput) {
	op := &request.Operation{
		Name:       opListCreateAccountStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCreateAccountStatusInput{}
	}

	output = &ListCreateAccountStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCreateAccountStatus API operation for AWS Organizations.
//
// Lists the account creation requests that match the specified status that
// is currently being tracked for the organization.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListCreateAccountStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListCreateAccountStatus
func (c *Organizations) ListCreateAccountStatus(input *ListCreateAccountStatusInput) (*ListCreateAccountStatusOutput, error) {
	req, out := c.ListCreateAccountStatusRequest(input)
	return out, req.Send()
}

// ListCreateAccountStatusWithContext is the same as ListCreateAccountStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListCreateAccountStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListCreateAccountStatusWithContext(ctx aws.Context, input *ListCreateAccountStatusInput, opts ...request.Option) (*ListCreateAccountStatusOutput, error) {
	req, out := c.ListCreateAccountStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHandshakesForAccount = "ListHandshakesForAccount"

// ListHandshakesForAccountRequest generates a "aws/request.Request" representing the
// client's request for the ListHandshakesForAccount operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListHandshakesForAccount for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListHandshakesForAccount method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListHandshakesForAccountRequest method.
//    req, resp := client.ListHandshakesForAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForAccount
func (c *Organizations) ListHandshakesForAccountRequest(input *ListHandshakesForAccountInput) (req *request.Request, output *ListHandshakesForAccountOutput) {
	op := &request.Operation{
		Name:       opListHandshakesForAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListHandshakesForAccountInput{}
	}

	output = &ListHandshakesForAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHandshakesForAccount API operation for AWS Organizations.
//
// Lists the current handshakes that are associated with the account of the
// requesting user.
//
// This operation can be called from any account in the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListHandshakesForAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForAccount
func (c *Organizations) ListHandshakesForAccount(input *ListHandshakesForAccountInput) (*ListHandshakesForAccountOutput, error) {
	req, out := c.ListHandshakesForAccountRequest(input)
	return out, req.Send()
}

// ListHandshakesForAccountWithContext is the same as ListHandshakesForAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ListHandshakesForAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListHandshakesForAccountWithContext(ctx aws.Context, input *ListHandshakesForAccountInput, opts ...request.Option) (*ListHandshakesForAccountOutput, error) {
	req, out := c.ListHandshakesForAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHandshakesForOrganization = "ListHandshakesForOrganization"

// ListHandshakesForOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the ListHandshakesForOrganization operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListHandshakesForOrganization for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListHandshakesForOrganization method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListHandshakesForOrganizationRequest method.
//    req, resp := client.ListHandshakesForOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForOrganization
func (c *Organizations) ListHandshakesForOrganizationRequest(input *ListHandshakesForOrganizationInput) (req *request.Request, output *ListHandshakesForOrganizationOutput) {
	op := &request.Operation{
		Name:       opListHandshakesForOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListHandshakesForOrganizationInput{}
	}

	output = &ListHandshakesForOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHandshakesForOrganization API operation for AWS Organizations.
//
// Lists the handshakes that are associated with the organization that the requesting
// user is part of. The ListHandshakesForOrganization operation returns a list
// of handshake structures. Each structure contains details and status about
// a handshake.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListHandshakesForOrganization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForOrganization
func (c *Organizations) ListHandshakesForOrganization(input *ListHandshakesForOrganizationInput) (*ListHandshakesForOrganizationOutput, error) {
	req, out := c.ListHandshakesForOrganizationRequest(input)
	return out, req.Send()
}

// ListHandshakesForOrganizationWithContext is the same as ListHandshakesForOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See ListHandshakesForOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListHandshakesForOrganizationWithContext(ctx aws.Context, input *ListHandshakesForOrganizationInput, opts ...request.Option) (*ListHandshakesForOrganizationOutput, error) {
	req, out := c.ListHandshakesForOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOrganizationalUnitsForParent = "ListOrganizationalUnitsForParent"

// ListOrganizationalUnitsForParentRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationalUnitsForParent operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListOrganizationalUnitsForParent for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListOrganizationalUnitsForParent method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListOrganizationalUnitsForParentRequest method.
//    req, resp := client.ListOrganizationalUnitsForParentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListOrganizationalUnitsForParent
func (c *Organizations) ListOrganizationalUnitsForParentRequest(input *ListOrganizationalUnitsForParentInput) (req *request.Request, output *ListOrganizationalUnitsForParentOutput) {
	op := &request.Operation{
		Name:       opListOrganizationalUnitsForParent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOrganizationalUnitsForParentInput{}
	}

	output = &ListOrganizationalUnitsForParentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationalUnitsForParent API operation for AWS Organizations.
//
// Lists the organizational units (OUs) in a parent organizational unit or root.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListOrganizationalUnitsForParent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeParentNotFoundException "ParentNotFoundException"
//   We can't find a root or organizational unit (OU) with the ParentId that you
//   specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListOrganizationalUnitsForParent
func (c *Organizations) ListOrganizationalUnitsForParent(input *ListOrganizationalUnitsForParentInput) (*ListOrganizationalUnitsForParentOutput, error) {
	req, out := c.ListOrganizationalUnitsForParentRequest(input)
	return out, req.Send()
}

// ListOrganizationalUnitsForParentWithContext is the same as ListOrganizationalUnitsForParent with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationalUnitsForParent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListOrganizationalUnitsForParentWithContext(ctx aws.Context, input *ListOrganizationalUnitsForParentInput, opts ...request.Option) (*ListOrganizationalUnitsForParentOutput, error) {
	req, out := c.ListOrganizationalUnitsForParentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListParents = "ListParents"

// ListParentsRequest generates a "aws/request.Request" representing the
// client's request for the ListParents operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListParents for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListParents method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListParentsRequest method.
//    req, resp := client.ListParentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListParents
func (c *Organizations) ListParentsRequest(input *ListParentsInput) (req *request.Request, output *ListParentsOutput) {
	op := &request.Operation{
		Name:       opListParents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListParentsInput{}
	}

	output = &ListParentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParents API operation for AWS Organizations.
//
// Lists the root or organizational units (OUs) that serve as the immediate
// parent of the specified child OU or account. This operation, along with ListChildren
// enables you to traverse the tree structure that makes up this root.
//
// This operation can be called only from the organization's master account.
//
// In the current release, a child can have only a single parent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListParents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeChildNotFoundException "ChildNotFoundException"
//   We can't find an organizational unit (OU) or AWS account with the ChildId
//   that you specified.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListParents
func (c *Organizations) ListParents(input *ListParentsInput) (*ListParentsOutput, error) {
	req, out := c.ListParentsRequest(input)
	return out, req.Send()
}

// ListParentsWithContext is the same as ListParents with the addition of
// the ability to pass a context and additional request options.
//
// See ListParents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListParentsWithContext(ctx aws.Context, input *ListParentsInput, opts ...request.Option) (*ListParentsOutput, error) {
	req, out := c.ListParentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPoliciesRequest method.
//    req, resp := client.ListPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPolicies
func (c *Organizations) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for AWS Organizations.
//
// Retrieves the list of all policies in an organization of a specified type.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPolicies
func (c *Organizations) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	return out, req.Send()
}

// ListPoliciesWithContext is the same as ListPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListPoliciesWithContext(ctx aws.Context, input *ListPoliciesInput, opts ...request.Option) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPoliciesForTarget = "ListPoliciesForTarget"

// ListPoliciesForTargetRequest generates a "aws/request.Request" representing the
// client's request for the ListPoliciesForTarget operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPoliciesForTarget for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPoliciesForTarget method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPoliciesForTargetRequest method.
//    req, resp := client.ListPoliciesForTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTarget
func (c *Organizations) ListPoliciesForTargetRequest(input *ListPoliciesForTargetInput) (req *request.Request, output *ListPoliciesForTargetOutput) {
	op := &request.Operation{
		Name:       opListPoliciesForTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPoliciesForTargetInput{}
	}

	output = &ListPoliciesForTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPoliciesForTarget API operation for AWS Organizations.
//
// Lists the policies that are directly attached to the specified target root,
// organizational unit (OU), or account. You must specify the policy type that
// you want included in the returned list.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListPoliciesForTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTargetNotFoundException "TargetNotFoundException"
//   We can't find a root, OU, or account with the TargetId that you specified.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTarget
func (c *Organizations) ListPoliciesForTarget(input *ListPoliciesForTargetInput) (*ListPoliciesForTargetOutput, error) {
	req, out := c.ListPoliciesForTargetRequest(input)
	return out, req.Send()
}

// ListPoliciesForTargetWithContext is the same as ListPoliciesForTarget with the addition of
// the ability to pass a context and additional request options.
//
// See ListPoliciesForTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListPoliciesForTargetWithContext(ctx aws.Context, input *ListPoliciesForTargetInput, opts ...request.Option) (*ListPoliciesForTargetOutput, error) {
	req, out := c.ListPoliciesForTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRoots = "ListRoots"

// ListRootsRequest generates a "aws/request.Request" representing the
// client's request for the ListRoots operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRoots for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRoots method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRootsRequest method.
//    req, resp := client.ListRootsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListRoots
func (c *Organizations) ListRootsRequest(input *ListRootsInput) (req *request.Request, output *ListRootsOutput) {
	op := &request.Operation{
		Name:       opListRoots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRootsInput{}
	}

	output = &ListRootsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoots API operation for AWS Organizations.
//
// Lists the roots that are defined in the current organization.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListRoots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListRoots
func (c *Organizations) ListRoots(input *ListRootsInput) (*ListRootsOutput, error) {
	req, out := c.ListRootsRequest(input)
	return out, req.Send()
}

// ListRootsWithContext is the same as ListRoots with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListRootsWithContext(ctx aws.Context, input *ListRootsInput, opts ...request.Option) (*ListRootsOutput, error) {
	req, out := c.ListRootsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsForPolicy = "ListTargetsForPolicy"

// ListTargetsForPolicyRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsForPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTargetsForPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTargetsForPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTargetsForPolicyRequest method.
//    req, resp := client.ListTargetsForPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTargetsForPolicy
func (c *Organizations) ListTargetsForPolicyRequest(input *ListTargetsForPolicyInput) (req *request.Request, output *ListTargetsForPolicyOutput) {
	op := &request.Operation{
		Name:       opListTargetsForPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTargetsForPolicyInput{}
	}

	output = &ListTargetsForPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsForPolicy API operation for AWS Organizations.
//
// Lists all the roots, OUs, and accounts to which the specified policy is attached.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation ListTargetsForPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodePolicyNotFoundException "PolicyNotFoundException"
//   We can't find a policy with the PolicyId that you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTargetsForPolicy
func (c *Organizations) ListTargetsForPolicy(input *ListTargetsForPolicyInput) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	return out, req.Send()
}

// ListTargetsForPolicyWithContext is the same as ListTargetsForPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsForPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) ListTargetsForPolicyWithContext(ctx aws.Context, input *ListTargetsForPolicyInput, opts ...request.Option) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMoveAccount = "MoveAccount"

// MoveAccountRequest generates a "aws/request.Request" representing the
// client's request for the MoveAccount operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See MoveAccount for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the MoveAccount method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the MoveAccountRequest method.
//    req, resp := client.MoveAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/MoveAccount
func (c *Organizations) MoveAccountRequest(input *MoveAccountInput) (req *request.Request, output *MoveAccountOutput) {
	op := &request.Operation{
		Name:       opMoveAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MoveAccountInput{}
	}

	output = &MoveAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// MoveAccount API operation for AWS Organizations.
//
// Moves an account from its current source parent root or OU to the specified
// destination parent root or OU.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation MoveAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeSourceParentNotFoundException "SourceParentNotFoundException"
//   We can't find a source root or OU with the ParentId that you specified.
//
//   * ErrCodeDestinationParentNotFoundException "DestinationParentNotFoundException"
//   We can't find the destination container (a root or OU) with the ParentId
//   that you specified.
//
//   * ErrCodeDuplicateAccountException "DuplicateAccountException"
//   That account is already present in the specified destination.
//
//   * ErrCodeAccountNotFoundException "AccountNotFoundException"
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request is not a member of
//   an organization.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/MoveAccount
func (c *Organizations) MoveAccount(input *MoveAccountInput) (*MoveAccountOutput, error) {
	req, out := c.MoveAccountRequest(input)
	return out, req.Send()
}

// MoveAccountWithContext is the same as MoveAccount with the addition of
// the ability to pass a context and additional request options.
//
// See MoveAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) MoveAccountWithContext(ctx aws.Context, input *MoveAccountInput, opts ...request.Option) (*MoveAccountOutput, error) {
	req, out := c.MoveAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveAccountFromOrganization = "RemoveAccountFromOrganization"

// RemoveAccountFromOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the RemoveAccountFromOrganization operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveAccountFromOrganization for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveAccountFromOrganization method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveAccountFromOrganizationRequest method.
//    req, resp := client.RemoveAccountFromOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/RemoveAccountFromOrganization
func (c *Organizations) RemoveAccountFromOrganizationRequest(input *RemoveAccountFromOrganizationInput) (req *request.Request, output *RemoveAccountFromOrganizationOutput) {
	op := &request.Operation{
		Name:       opRemoveAccountFromOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveAccountFromOrganizationInput{}
	}

	output = &RemoveAccountFromOrganizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveAccountFromOrganization API operation for AWS Organizations.
//
// Removes the specified account from the organization.
//
// The removed account becomes a stand-alone account that is not a member of
// any organization. It is no longer subject to any policies and is responsible
// for its own bill payments. The organization's master account is no longer
// charged for any expenses accrued by the member account after it is removed
// from the organization.
//
// This operation can be called only from the organization's master account.
// Member accounts can remove themselves with LeaveOrganization instead.
//
// You can remove only existing accounts that were invited to join the organization.
// You cannot remove accounts that were created by AWS Organizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation RemoveAccountFromOrganization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAccountNotFoundException "AccountNotFoundException"
//   We can't find an AWS account with the AccountId that you specified, or the
//   account whose credentials you used to make this request is not a member of
//   an organization.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeMasterCannotLeaveOrganizationException "MasterCannotLeaveOrganizationException"
//   You can't remove a master account from an organization. If you want the master
//   account to become a member account in another organization, you must first
//   delete the current organization of the master account.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/RemoveAccountFromOrganization
func (c *Organizations) RemoveAccountFromOrganization(input *RemoveAccountFromOrganizationInput) (*RemoveAccountFromOrganizationOutput, error) {
	req, out := c.RemoveAccountFromOrganizationRequest(input)
	return out, req.Send()
}

// RemoveAccountFromOrganizationWithContext is the same as RemoveAccountFromOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveAccountFromOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) RemoveAccountFromOrganizationWithContext(ctx aws.Context, input *RemoveAccountFromOrganizationInput, opts ...request.Option) (*RemoveAccountFromOrganizationOutput, error) {
	req, out := c.RemoveAccountFromOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationalUnit = "UpdateOrganizationalUnit"

// UpdateOrganizationalUnitRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationalUnit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateOrganizationalUnit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateOrganizationalUnit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateOrganizationalUnitRequest method.
//    req, resp := client.UpdateOrganizationalUnitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdateOrganizationalUnit
func (c *Organizations) UpdateOrganizationalUnitRequest(input *UpdateOrganizationalUnitInput) (req *request.Request, output *UpdateOrganizationalUnitOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationalUnit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOrganizationalUnitInput{}
	}

	output = &UpdateOrganizationalUnitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateOrganizationalUnit API operation for AWS Organizations.
//
// Renames the specified organizational unit (OU). The ID and ARN do not change.
// The child OUs and accounts remain in place, and any attached policies of
// the OU remain attached.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation UpdateOrganizationalUnit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeDuplicateOrganizationalUnitException "DuplicateOrganizationalUnitException"
//   An organizational unit (OU) with the same name already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeOrganizationalUnitNotFoundException "OrganizationalUnitNotFoundException"
//   We can't find an organizational unit (OU) with the OrganizationalUnitId that
//   you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdateOrganizationalUnit
func (c *Organizations) UpdateOrganizationalUnit(input *UpdateOrganizationalUnitInput) (*UpdateOrganizationalUnitOutput, error) {
	req, out := c.UpdateOrganizationalUnitRequest(input)
	return out, req.Send()
}

// UpdateOrganizationalUnitWithContext is the same as UpdateOrganizationalUnit with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationalUnit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) UpdateOrganizationalUnitWithContext(ctx aws.Context, input *UpdateOrganizationalUnitInput, opts ...request.Option) (*UpdateOrganizationalUnitOutput, error) {
	req, out := c.UpdateOrganizationalUnitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePolicy = "UpdatePolicy"

// UpdatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdatePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdatePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdatePolicyRequest method.
//    req, resp := client.UpdatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdatePolicy
func (c *Organizations) UpdatePolicyRequest(input *UpdatePolicyInput) (req *request.Request, output *UpdatePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePolicyInput{}
	}

	output = &UpdatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePolicy API operation for AWS Organizations.
//
// Updates an existing policy with a new name, description, or content. If any
// parameter is not supplied, that value remains unchanged. Note that you cannot
// change a policy's type.
//
// This operation can be called only from the organization's master account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Organizations's
// API operation UpdatePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ErrCodeAWSOrganizationsNotInUseException "AWSOrganizationsNotInUseException"
//   Your account is not a member of an organization. To make this request, you
//   must use the credentials of an account that belongs to an organization.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   The target of the operation is currently being modified by a different request.
//   Try again later.
//
//   * ErrCodeConstraintViolationException "ConstraintViolationException"
//   Performing this operation violates a minimum or maximum value limit. For
//   example, attempting to removing the last SCP from an OU or root, inviting
//   or creating too many accounts to the organization, or attaching too many
//   policies to an account, OU, or root.
//
//   * ErrCodeDuplicatePolicyException "DuplicatePolicyException"
//   A policy with the same name already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   You provided invalid values for one or more of the request parameters.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocumentException"
//   The provided policy document does not meet the requirements of the specified
//   policy type. For example, the syntax might be incorrect. For details about
//   service control policy syntax, see Service Control Policy Syntax (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
//   in the AWS Organizations User Guide.
//
//   * ErrCodePolicyNotFoundException "PolicyNotFoundException"
//   We can't find a policy with the PolicyId that you specified.
//
//   * ErrCodeServiceException "ServiceException"
//   AWS Organizations can't complete your request because of an internal service
//   error. Try again later.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You've sent too many requests in too short a period of time. The limit helps
//   protect against denial-of-service attacks. Try again later.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdatePolicy
func (c *Organizations) UpdatePolicy(input *UpdatePolicyInput) (*UpdatePolicyOutput, error) {
	req, out := c.UpdatePolicyRequest(input)
	return out, req.Send()
}

// UpdatePolicyWithContext is the same as UpdatePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Organizations) UpdatePolicyWithContext(ctx aws.Context, input *UpdatePolicyInput, opts ...request.Option) (*UpdatePolicyOutput, error) {
	req, out := c.UpdatePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AcceptHandshakeRequest
type AcceptHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want to accept.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptHandshakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptHandshakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptHandshakeInput"}
	if s.HandshakeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandshakeId sets the HandshakeId field's value.
func (s *AcceptHandshakeInput) SetHandshakeId(v string) *AcceptHandshakeInput {
	s.HandshakeId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AcceptHandshakeResponse
type AcceptHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the accepted handshake.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s AcceptHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptHandshakeOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *AcceptHandshakeOutput) SetHandshake(v *Handshake) *AcceptHandshakeOutput {
	s.Handshake = v
	return s
}

// Contains information about an AWS account that is a member of an organization.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/Account
type Account struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the account.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The unique identifier (ID) of the account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	Id *string `type:"string"`

	// The method by which the account joined the organization.
	JoinedMethod *string `type:"string" enum:"AccountJoinedMethod"`

	// The date the account became a part of the organization.
	JoinedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The friendly name of the account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The status of the account in the organization.
	Status *string `type:"string" enum:"AccountStatus"`
}

// String returns the string representation
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Account) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Account) SetArn(v string) *Account {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Account) SetId(v string) *Account {
	s.Id = &v
	return s
}

// SetJoinedMethod sets the JoinedMethod field's value.
func (s *Account) SetJoinedMethod(v string) *Account {
	s.JoinedMethod = &v
	return s
}

// SetJoinedTimestamp sets the JoinedTimestamp field's value.
func (s *Account) SetJoinedTimestamp(v time.Time) *Account {
	s.JoinedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *Account) SetName(v string) *Account {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Account) SetStatus(v string) *Account {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AttachPolicyRequest
type AttachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the policy that you want to attach to the target.
	// You can get the ID for the policy by calling the ListPolicies operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lower-case letters or digits.
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root, OU, or account that you want to attach
	// the policy to. You can get the ID by calling the ListRoots, ListOrganizationalUnitsForParent,
	// or ListAccounts operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Account: a string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachPolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *AttachPolicyInput) SetPolicyId(v string) *AttachPolicyInput {
	s.PolicyId = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *AttachPolicyInput) SetTargetId(v string) *AttachPolicyInput {
	s.TargetId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/AttachPolicyOutput
type AttachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshakeRequest
type CancelHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want to cancel. You
	// can get the ID from the ListHandshakesForOrganization operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelHandshakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelHandshakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelHandshakeInput"}
	if s.HandshakeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandshakeId sets the HandshakeId field's value.
func (s *CancelHandshakeInput) SetHandshakeId(v string) *CancelHandshakeInput {
	s.HandshakeId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CancelHandshakeResponse
type CancelHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the handshake that you canceled.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s CancelHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelHandshakeOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *CancelHandshakeOutput) SetHandshake(v *Handshake) *CancelHandshakeOutput {
	s.Handshake = v
	return s
}

// Contains a list of child entities, either OUs or accounts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/Child
type Child struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of this child entity.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a child ID string
	// requires one of the following:
	//
	//    * Account: a string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that contains
	//    the OU) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	Id *string `type:"string"`

	// The type of this child entity.
	Type *string `type:"string" enum:"ChildType"`
}

// String returns the string representation
func (s Child) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Child) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Child) SetId(v string) *Child {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *Child) SetType(v string) *Child {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccountRequest
type CreateAccountInput struct {
	_ struct{} `type:"structure"`

	// The friendly name of the member account.
	//
	// AccountName is a required field
	AccountName *string `min:"1" type:"string" required:"true"`

	// The email address of the owner to assign to the new member account. This
	// email address must not already be associated with another AWS account.
	//
	// Email is a required field
	Email *string `min:"6" type:"string" required:"true"`

	// If set to ALLOW, the new account enables IAM users to access account billing
	// information if they have the required permissions. If set to DENY, then only
	// the root user of the new account can access account billing information.
	// For more information, see Activating Access to the Billing and Cost Management
	// Console (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate)
	// in the AWS Billing and Cost Management User Guide.
	IamUserAccessToBilling *string `type:"string" enum:"IAMUserAccessToBilling"`

	// (Optional)
	//
	// The name of an IAM role that Organizations automatically preconfigures in
	// the new member account. This role trusts the master account, allowing users
	// in the master account to assume the role, as permitted by the master account
	// administrator. The role has administrator permissions in the new member account.
	//
	// If you do not specify this parameter, the role name defaults to OrganizationAccountAccessRole.
	//
	// For more information about how to use this role to access the member account,
	// see Accessing and Administering the Member Accounts in Your Organization
	// (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role)
	// in the AWS Organizations User Guide, and steps 2 and 3 in Tutorial: Delegate
	// Access Across AWS Accounts Using IAM Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html)
	// in the IAM User Guide.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of characters that can consist of uppercase letters,
	// lowercase letters, digits with no spaces, and any of the following characters:
	// =,.@-
	RoleName *string `type:"string"`
}

// String returns the string representation
func (s CreateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountInput"}
	if s.AccountName == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountName"))
	}
	if s.AccountName != nil && len(*s.AccountName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountName", 1))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountName sets the AccountName field's value.
func (s *CreateAccountInput) SetAccountName(v string) *CreateAccountInput {
	s.AccountName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateAccountInput) SetEmail(v string) *CreateAccountInput {
	s.Email = &v
	return s
}

// SetIamUserAccessToBilling sets the IamUserAccessToBilling field's value.
func (s *CreateAccountInput) SetIamUserAccessToBilling(v string) *CreateAccountInput {
	s.IamUserAccessToBilling = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *CreateAccountInput) SetRoleName(v string) *CreateAccountInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccountResponse
type CreateAccountOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the request to create an account.
	// This response structure might not be fully populated when you first receive
	// it because account creation is an asynchronous process. You can pass the
	// returned CreateAccountStatus ID as a parameter to DescribeCreateAccountStatus
	// to get status about the progress of the request at later times.
	CreateAccountStatus *CreateAccountStatus `type:"structure"`
}

// String returns the string representation
func (s CreateAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountOutput) GoString() string {
	return s.String()
}

// SetCreateAccountStatus sets the CreateAccountStatus field's value.
func (s *CreateAccountOutput) SetCreateAccountStatus(v *CreateAccountStatus) *CreateAccountOutput {
	s.CreateAccountStatus = v
	return s
}

// Contains the status about a CreateAccount request to create an AWS account
// in an organization.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateAccountStatus
type CreateAccountStatus struct {
	_ struct{} `type:"structure"`

	// If the account was created successfully, the unique identifier (ID) of the
	// new account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	AccountId *string `type:"string"`

	// The account name given to the account when it was created.
	AccountName *string `min:"1" type:"string"`

	// The date and time that the account was created and the request completed.
	CompletedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// If the request failed, a description of the reason for the failure.
	FailureReason *string `type:"string" enum:"CreateAccountFailureReason"`

	// The unique identifier (ID) that references this request. You get this value
	// from the response of the initial CreateAccount request to create the account.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an create account
	// request ID string requires "car-" followed by from 8 to 32 lower-case letters
	// or digits.
	Id *string `type:"string"`

	// The date and time that the request was made for the account creation.
	RequestedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of the request.
	State *string `type:"string" enum:"CreateAccountState"`
}

// String returns the string representation
func (s CreateAccountStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccountStatus) SetAccountId(v string) *CreateAccountStatus {
	s.AccountId = &v
	return s
}

// SetAccountName sets the AccountName field's value.
func (s *CreateAccountStatus) SetAccountName(v string) *CreateAccountStatus {
	s.AccountName = &v
	return s
}

// SetCompletedTimestamp sets the CompletedTimestamp field's value.
func (s *CreateAccountStatus) SetCompletedTimestamp(v time.Time) *CreateAccountStatus {
	s.CompletedTimestamp = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateAccountStatus) SetFailureReason(v string) *CreateAccountStatus {
	s.FailureReason = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAccountStatus) SetId(v string) *CreateAccountStatus {
	s.Id = &v
	return s
}

// SetRequestedTimestamp sets the RequestedTimestamp field's value.
func (s *CreateAccountStatus) SetRequestedTimestamp(v time.Time) *CreateAccountStatus {
	s.RequestedTimestamp = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateAccountStatus) SetState(v string) *CreateAccountStatus {
	s.State = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationRequest
type CreateOrganizationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the feature set supported by the new organization. Each feature
	// set supports different levels of functionality.
	//
	//    * CONSOLIDATED_BILLING: All member accounts have their bills consolidated
	//    to and paid by the master account. For more information, see Consolidated
	//    Billing (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only)
	//    in the AWS Organizations User Guide.
	//
	//    * ALL: In addition to all the features supported by the consolidated billing
	//    feature set, the master account can also apply any type of policy to any
	//    member account in the organization. For more information, see All features
	//    (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all)
	//    in the AWS Organizations User Guide.
	FeatureSet *string `type:"string" enum:"OrganizationFeatureSet"`
}

// String returns the string representation
func (s CreateOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationInput) GoString() string {
	return s.String()
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *CreateOrganizationInput) SetFeatureSet(v string) *CreateOrganizationInput {
	s.FeatureSet = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationResponse
type CreateOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the newly created organization.
	Organization *Organization `type:"structure"`
}

// String returns the string representation
func (s CreateOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationOutput) GoString() string {
	return s.String()
}

// SetOrganization sets the Organization field's value.
func (s *CreateOrganizationOutput) SetOrganization(v *Organization) *CreateOrganizationOutput {
	s.Organization = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationalUnitRequest
type CreateOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The friendly name to assign to the new OU.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The unique identifier (ID) of the parent root or OU in which you want to
	// create the new OU.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// ParentId is a required field
	ParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationalUnitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOrganizationalUnitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOrganizationalUnitInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateOrganizationalUnitInput) SetName(v string) *CreateOrganizationalUnitInput {
	s.Name = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *CreateOrganizationalUnitInput) SetParentId(v string) *CreateOrganizationalUnitInput {
	s.ParentId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateOrganizationalUnitResponse
type CreateOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the newly created OU.
	OrganizationalUnit *OrganizationalUnit `type:"structure"`
}

// String returns the string representation
func (s CreateOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrganizationalUnitOutput) GoString() string {
	return s.String()
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *CreateOrganizationalUnitOutput) SetOrganizationalUnit(v *OrganizationalUnit) *CreateOrganizationalUnitOutput {
	s.OrganizationalUnit = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreatePolicyRequest
type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy content to add to the new policy. For example, if you create a
	// service control policy (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scp.html)
	// (SCP), this string must be JSON text that specifies the permissions that
	// admins in attached accounts can delegate to their users, groups, and roles.
	// For more information about the SCP syntax, see Service Control Policy Syntax
	// (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
	// in the AWS Organizations User Guide.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// An optional description to assign to the policy.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The friendly name to assign to the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of policy to create.
	//
	// In the current release, the only type of policy that you can create is a
	// service control policy (SCP).
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"PolicyType"`
}

// String returns the string representation
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CreatePolicyInput) SetContent(v string) *CreatePolicyInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePolicyInput) SetDescription(v string) *CreatePolicyInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePolicyInput) SetName(v string) *CreatePolicyInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreatePolicyInput) SetType(v string) *CreatePolicyInput {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreatePolicyResponse
type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the newly created policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *CreatePolicyOutput) SetPolicy(v *Policy) *CreatePolicyOutput {
	s.Policy = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeclineHandshakeRequest
type DeclineHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want to decline. You
	// can get the ID from the ListHandshakesForAccount operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeclineHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineHandshakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeclineHandshakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeclineHandshakeInput"}
	if s.HandshakeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandshakeId sets the HandshakeId field's value.
func (s *DeclineHandshakeInput) SetHandshakeId(v string) *DeclineHandshakeInput {
	s.HandshakeId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeclineHandshakeResponse
type DeclineHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the declined handshake. The state
	// is updated to show the value DECLINED.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s DeclineHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineHandshakeOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *DeclineHandshakeOutput) SetHandshake(v *Handshake) *DeclineHandshakeOutput {
	s.Handshake = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationInput
type DeleteOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationOutput
type DeleteOrganizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationalUnitRequest
type DeleteOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the organizational unit that you want to delete.
	// You can get the ID from the ListOrganizationalUnitsForParent operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lower-case letters
	// or digits (the ID of the root that contains the OU) followed by a second
	// "-" dash and from 8 to 32 additional lower-case letters or digits.
	//
	// OrganizationalUnitId is a required field
	OrganizationalUnitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationalUnitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOrganizationalUnitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOrganizationalUnitInput"}
	if s.OrganizationalUnitId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationalUnitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *DeleteOrganizationalUnitInput) SetOrganizationalUnitId(v string) *DeleteOrganizationalUnitInput {
	s.OrganizationalUnitId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeleteOrganizationalUnitOutput
type DeleteOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOrganizationalUnitOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeletePolicyRequest
type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the policy that you want to delete. You can
	// get the ID from the ListPolicies or ListPoliciesForTarget operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lower-case letters or digits.
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeletePolicyInput) SetPolicyId(v string) *DeletePolicyInput {
	s.PolicyId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DeletePolicyOutput
type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccountRequest
type DescribeAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the AWS account that you want information about.
	// You can get the ID from the ListAccounts or ListAccountsForParent operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeAccountInput) SetAccountId(v string) *DescribeAccountInput {
	s.AccountId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeAccountResponse
type DescribeAccountOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the requested account.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *DescribeAccountOutput) SetAccount(v *Account) *DescribeAccountOutput {
	s.Account = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatusRequest
type DescribeCreateAccountStatusInput struct {
	_ struct{} `type:"structure"`

	// Specifies the operationId that uniquely identifies the request. You can get
	// the ID from the response to an earlier CreateAccount request, or from the
	// ListCreateAccountStatus operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an create account
	// request ID string requires "car-" followed by from 8 to 32 lower-case letters
	// or digits.
	//
	// CreateAccountRequestId is a required field
	CreateAccountRequestId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCreateAccountStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCreateAccountStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCreateAccountStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCreateAccountStatusInput"}
	if s.CreateAccountRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateAccountRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateAccountRequestId sets the CreateAccountRequestId field's value.
func (s *DescribeCreateAccountStatusInput) SetCreateAccountRequestId(v string) *DescribeCreateAccountStatusInput {
	s.CreateAccountRequestId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeCreateAccountStatusResponse
type DescribeCreateAccountStatusOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the current status of an account creation request.
	CreateAccountStatus *CreateAccountStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeCreateAccountStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCreateAccountStatusOutput) GoString() string {
	return s.String()
}

// SetCreateAccountStatus sets the CreateAccountStatus field's value.
func (s *DescribeCreateAccountStatusOutput) SetCreateAccountStatus(v *CreateAccountStatus) *DescribeCreateAccountStatusOutput {
	s.CreateAccountStatus = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeHandshakeRequest
type DescribeHandshakeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the handshake that you want information about.
	// You can get the ID from the original call to InviteAccountToOrganization,
	// or from a call to ListHandshakesForAccount or ListHandshakesForOrganization.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	//
	// HandshakeId is a required field
	HandshakeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHandshakeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHandshakeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHandshakeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHandshakeInput"}
	if s.HandshakeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HandshakeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandshakeId sets the HandshakeId field's value.
func (s *DescribeHandshakeInput) SetHandshakeId(v string) *DescribeHandshakeInput {
	s.HandshakeId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeHandshakeResponse
type DescribeHandshakeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the specified handshake.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s DescribeHandshakeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHandshakeOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *DescribeHandshakeOutput) SetHandshake(v *Handshake) *DescribeHandshakeOutput {
	s.Handshake = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationInput
type DescribeOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationResponse
type DescribeOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the organization.
	Organization *Organization `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationOutput) GoString() string {
	return s.String()
}

// SetOrganization sets the Organization field's value.
func (s *DescribeOrganizationOutput) SetOrganization(v *Organization) *DescribeOrganizationOutput {
	s.Organization = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnitRequest
type DescribeOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the organizational unit that you want details
	// about. You can get the ID from the ListOrganizationalUnitsForParent operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lower-case letters
	// or digits (the ID of the root that contains the OU) followed by a second
	// "-" dash and from 8 to 32 additional lower-case letters or digits.
	//
	// OrganizationalUnitId is a required field
	OrganizationalUnitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationalUnitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationalUnitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrganizationalUnitInput"}
	if s.OrganizationalUnitId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationalUnitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *DescribeOrganizationalUnitInput) SetOrganizationalUnitId(v string) *DescribeOrganizationalUnitInput {
	s.OrganizationalUnitId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeOrganizationalUnitResponse
type DescribeOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the specified OU.
	OrganizationalUnit *OrganizationalUnit `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationalUnitOutput) GoString() string {
	return s.String()
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *DescribeOrganizationalUnitOutput) SetOrganizationalUnit(v *OrganizationalUnit) *DescribeOrganizationalUnitOutput {
	s.OrganizationalUnit = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribePolicyRequest
type DescribePolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the policy that you want details about. You
	// can get the ID from the ListPolicies or ListPoliciesForTarget operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lower-case letters or digits.
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DescribePolicyInput) SetPolicyId(v string) *DescribePolicyInput {
	s.PolicyId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribePolicyResponse
type DescribePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the specified policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s DescribePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DescribePolicyOutput) SetPolicy(v *Policy) *DescribePolicyOutput {
	s.Policy = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DetachPolicyRequest
type DetachPolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the policy you want to detach. You can get
	// the ID from the ListPolicies or ListPoliciesForTarget operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lower-case letters or digits.
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root, OU, or account from which you want
	// to detach the policy. You can get the ID from the ListRoots, ListOrganizationalUnitsForParent,
	// or ListAccounts operations.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Account: a string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DetachPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachPolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DetachPolicyInput) SetPolicyId(v string) *DetachPolicyInput {
	s.PolicyId = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *DetachPolicyInput) SetTargetId(v string) *DetachPolicyInput {
	s.TargetId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DetachPolicyOutput
type DetachPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisablePolicyTypeRequest
type DisablePolicyTypeInput struct {
	_ struct{} `type:"structure"`

	// The policy type that you want to disable in this root.
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The unique identifier (ID) of the root in which you want to disable a policy
	// type. You can get the ID from the ListPolicies operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a root ID string
	// requires "r-" followed by from 4 to 32 lower-case letters or digits.
	//
	// RootId is a required field
	RootId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisablePolicyTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisablePolicyTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisablePolicyTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisablePolicyTypeInput"}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}
	if s.RootId == nil {
		invalidParams.Add(request.NewErrParamRequired("RootId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyType sets the PolicyType field's value.
func (s *DisablePolicyTypeInput) SetPolicyType(v string) *DisablePolicyTypeInput {
	s.PolicyType = &v
	return s
}

// SetRootId sets the RootId field's value.
func (s *DisablePolicyTypeInput) SetRootId(v string) *DisablePolicyTypeInput {
	s.RootId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DisablePolicyTypeResponse
type DisablePolicyTypeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that shows the root with the updated list of enabled policy types.
	Root *Root `type:"structure"`
}

// String returns the string representation
func (s DisablePolicyTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisablePolicyTypeOutput) GoString() string {
	return s.String()
}

// SetRoot sets the Root field's value.
func (s *DisablePolicyTypeOutput) SetRoot(v *Root) *DisablePolicyTypeOutput {
	s.Root = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAllFeaturesRequest
type EnableAllFeaturesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableAllFeaturesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAllFeaturesInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnableAllFeaturesResponse
type EnableAllFeaturesOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the handshake created to support
	// this request to enable all features in the organization.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s EnableAllFeaturesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAllFeaturesOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *EnableAllFeaturesOutput) SetHandshake(v *Handshake) *EnableAllFeaturesOutput {
	s.Handshake = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnablePolicyTypeRequest
type EnablePolicyTypeInput struct {
	_ struct{} `type:"structure"`

	// The policy type that you want to enable.
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The unique identifier (ID) of the root in which you want to enable a policy
	// type. You can get the ID from the ListRoots operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a root ID string
	// requires "r-" followed by from 4 to 32 lower-case letters or digits.
	//
	// RootId is a required field
	RootId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnablePolicyTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnablePolicyTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnablePolicyTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnablePolicyTypeInput"}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}
	if s.RootId == nil {
		invalidParams.Add(request.NewErrParamRequired("RootId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyType sets the PolicyType field's value.
func (s *EnablePolicyTypeInput) SetPolicyType(v string) *EnablePolicyTypeInput {
	s.PolicyType = &v
	return s
}

// SetRootId sets the RootId field's value.
func (s *EnablePolicyTypeInput) SetRootId(v string) *EnablePolicyTypeInput {
	s.RootId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/EnablePolicyTypeResponse
type EnablePolicyTypeOutput struct {
	_ struct{} `type:"structure"`

	// A structure that shows the root with the updated list of enabled policy types.
	Root *Root `type:"structure"`
}

// String returns the string representation
func (s EnablePolicyTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnablePolicyTypeOutput) GoString() string {
	return s.String()
}

// SetRoot sets the Root field's value.
func (s *EnablePolicyTypeOutput) SetRoot(v *Root) *EnablePolicyTypeOutput {
	s.Root = v
	return s
}

// Contains information that must be exchanged to securely establish a relationship
// between two accounts (an originator and a recipient). For example, when a
// master account (the originator) invites another account (the recipient) to
// join its organization, the two accounts exchange information as a series
// of handshake requests and responses.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/Handshake
type Handshake struct {
	_ struct{} `type:"structure"`

	// The type of handshake, indicating what action occurs when the recipient accepts
	// the handshake.
	Action *string `type:"string" enum:"ActionType"`

	// The Amazon Resource Name (ARN) of a handshake.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The date and time that the handshake expires. If the recipient of the handshake
	// request fails to respond before the specified date and time, the handshake
	// becomes inactive and is no longer valid.
	ExpirationTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The unique identifier (ID) of a handshake. The originating account creates
	// the ID when it initiates the handshake.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	Id *string `type:"string"`

	// Information about the two accounts that are participating in the handshake.
	Parties []*HandshakeParty `type:"list"`

	// The date and time that the handshake request was made.
	RequestedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Additional information that is needed to process the handshake.
	Resources []*HandshakeResource `type:"list"`

	// The current state of the handshake. Use the state to trace the flow of the
	// handshake through the process from its creation to its acceptance. The meaning
	// of each of the valid values is as follows:
	//
	//    * REQUESTED: This handshake was sent to multiple recipients (applicable
	//    to only some handshake types) and not all recipients have responded yet.
	//    The request stays in this state until all recipients respond.
	//
	//    * OPEN: This handshake was sent to multiple recipients (applicable to
	//    only some policy types) and all recipients have responded, allowing the
	//    originator to complete the handshake action.
	//
	//    * CANCELED: This handshake is no longer active because it was canceled
	//    by the originating account.
	//
	//    * ACCEPTED: This handshake is complete because it has been accepted by
	//    the recipient.
	//
	//    * DECLINED: This handshake is no longer active because it was declined
	//    by the recipient account.
	//
	//    * EXPIRED: This handshake is no longer active because the originator did
	//    not receive a response of any kind from the recipient before the expiration
	//    time (15 days).
	State *string `type:"string" enum:"HandshakeState"`
}

// String returns the string representation
func (s Handshake) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Handshake) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Handshake) SetAction(v string) *Handshake {
	s.Action = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Handshake) SetArn(v string) *Handshake {
	s.Arn = &v
	return s
}

// SetExpirationTimestamp sets the ExpirationTimestamp field's value.
func (s *Handshake) SetExpirationTimestamp(v time.Time) *Handshake {
	s.ExpirationTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *Handshake) SetId(v string) *Handshake {
	s.Id = &v
	return s
}

// SetParties sets the Parties field's value.
func (s *Handshake) SetParties(v []*HandshakeParty) *Handshake {
	s.Parties = v
	return s
}

// SetRequestedTimestamp sets the RequestedTimestamp field's value.
func (s *Handshake) SetRequestedTimestamp(v time.Time) *Handshake {
	s.RequestedTimestamp = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *Handshake) SetResources(v []*HandshakeResource) *Handshake {
	s.Resources = v
	return s
}

// SetState sets the State field's value.
func (s *Handshake) SetState(v string) *Handshake {
	s.State = &v
	return s
}

// Specifies the criteria that are used to select the handshakes for the operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/HandshakeFilter
type HandshakeFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the type of handshake action.
	//
	// If you specify ActionType, you cannot also specify ParentHandshakeId.
	ActionType *string `type:"string" enum:"ActionType"`

	// Specifies the parent handshake. Only used for handshake types that are a
	// child of another type.
	//
	// If you specify ParentHandshakeId, you cannot also specify ActionType.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	ParentHandshakeId *string `type:"string"`
}

// String returns the string representation
func (s HandshakeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeFilter) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *HandshakeFilter) SetActionType(v string) *HandshakeFilter {
	s.ActionType = &v
	return s
}

// SetParentHandshakeId sets the ParentHandshakeId field's value.
func (s *HandshakeFilter) SetParentHandshakeId(v string) *HandshakeFilter {
	s.ParentHandshakeId = &v
	return s
}

// Identifies a participant in a handshake.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/HandshakeParty
type HandshakeParty struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) for the party.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for handshake ID string
	// requires "h-" followed by from 8 to 32 lower-case letters or digits.
	Id *string `min:"1" type:"string"`

	// The type of party.
	Type *string `type:"string" enum:"HandshakePartyType"`
}

// String returns the string representation
func (s HandshakeParty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeParty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HandshakeParty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HandshakeParty"}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *HandshakeParty) SetId(v string) *HandshakeParty {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *HandshakeParty) SetType(v string) *HandshakeParty {
	s.Type = &v
	return s
}

// Contains additional data that is needed to process a handshake.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/HandshakeResource
type HandshakeResource struct {
	_ struct{} `type:"structure"`

	// When needed, contains an additional array of HandshakeResource objects.
	Resources []*HandshakeResource `type:"list"`

	// The type of information being passed, specifying how the value is to be interpreted
	// by the other party:
	//
	//    * ACCOUNT - Specifies an AWS account ID number.
	//
	//    * ORGANIZATION - Specifies an organization ID number.
	//
	//    * EMAIL - Specifies the email address that is associated with the account
	//    that receives the handshake.
	//
	//    * OWNER_EMAIL - Specifies the email address associated with the master
	//    account. Included as information about an organization.
	//
	//    * OWNER_NAME - Specifies the name associated with the master account.
	//    Included as information about an organization.
	//
	//    * NOTES - Additional text provided by the handshake initiator and intended
	//    for the recipient to read.
	Type *string `type:"string" enum:"HandshakeResourceType"`

	// The information that is passed to the other party in the handshake. The format
	// of the value string must match the requirements of the specified type.
	Value *string `type:"string"`
}

// String returns the string representation
func (s HandshakeResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HandshakeResource) GoString() string {
	return s.String()
}

// SetResources sets the Resources field's value.
func (s *HandshakeResource) SetResources(v []*HandshakeResource) *HandshakeResource {
	s.Resources = v
	return s
}

// SetType sets the Type field's value.
func (s *HandshakeResource) SetType(v string) *HandshakeResource {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HandshakeResource) SetValue(v string) *HandshakeResource {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/InviteAccountToOrganizationRequest
type InviteAccountToOrganizationInput struct {
	_ struct{} `type:"structure"`

	// Additional information that you want to include in the generated email to
	// the recipient account owner.
	Notes *string `type:"string"`

	// The identifier (ID) of the AWS account that you want to invite to join your
	// organization. This is a JSON object that contains the following elements:
	//
	// { "Type": "ACCOUNT", "Id": "<account id number>" }
	//
	// If you use the AWS CLI, you can submit this as a single string, similar to
	// the following example:
	//
	// --target id=123456789012,type=ACCOUNT
	//
	// If you specify "Type": "ACCOUNT", then you must provide the AWS account ID
	// number as the Id. If you specify "Type": "EMAIL", then you must specify the
	// email address that is associated with the account.
	//
	// --target id=bill@example.com,type=EMAIL
	//
	// Target is a required field
	Target *HandshakeParty `type:"structure" required:"true"`
}

// String returns the string representation
func (s InviteAccountToOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteAccountToOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteAccountToOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteAccountToOrganizationInput"}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotes sets the Notes field's value.
func (s *InviteAccountToOrganizationInput) SetNotes(v string) *InviteAccountToOrganizationInput {
	s.Notes = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *InviteAccountToOrganizationInput) SetTarget(v *HandshakeParty) *InviteAccountToOrganizationInput {
	s.Target = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/InviteAccountToOrganizationResponse
type InviteAccountToOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the handshake that is created to
	// support this invitation request.
	Handshake *Handshake `type:"structure"`
}

// String returns the string representation
func (s InviteAccountToOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteAccountToOrganizationOutput) GoString() string {
	return s.String()
}

// SetHandshake sets the Handshake field's value.
func (s *InviteAccountToOrganizationOutput) SetHandshake(v *Handshake) *InviteAccountToOrganizationOutput {
	s.Handshake = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/LeaveOrganizationInput
type LeaveOrganizationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LeaveOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LeaveOrganizationInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/LeaveOrganizationOutput
type LeaveOrganizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LeaveOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LeaveOrganizationOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccountsForParentRequest
type ListAccountsForParentInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) for the parent root or organization unit (OU)
	// whose accounts you want to list.
	//
	// ParentId is a required field
	ParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListAccountsForParentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsForParentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsForParentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountsForParentInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountsForParentInput) SetMaxResults(v int64) *ListAccountsForParentInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsForParentInput) SetNextToken(v string) *ListAccountsForParentInput {
	s.NextToken = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *ListAccountsForParentInput) SetParentId(v string) *ListAccountsForParentInput {
	s.ParentId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccountsForParentResponse
type ListAccountsForParentOutput struct {
	_ struct{} `type:"structure"`

	// A list of the accounts in the specified root or OU.
	Accounts []*Account `type:"list"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsForParentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsForParentOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *ListAccountsForParentOutput) SetAccounts(v []*Account) *ListAccountsForParentOutput {
	s.Accounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsForParentOutput) SetNextToken(v string) *ListAccountsForParentOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccountsRequest
type ListAccountsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountsInput) SetMaxResults(v int64) *ListAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsInput) SetNextToken(v string) *ListAccountsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListAccountsResponse
type ListAccountsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects in the organization.
	Accounts []*Account `type:"list"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *ListAccountsOutput) SetAccounts(v []*Account) *ListAccountsOutput {
	s.Accounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsOutput) SetNextToken(v string) *ListAccountsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListChildrenRequest
type ListChildrenInput struct {
	_ struct{} `type:"structure"`

	// Filters the output to include only the specified child type.
	//
	// ChildType is a required field
	ChildType *string `type:"string" required:"true" enum:"ChildType"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) for the parent root or OU whose children you want
	// to list.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// ParentId is a required field
	ParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListChildrenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChildrenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChildrenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChildrenInput"}
	if s.ChildType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildType"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildType sets the ChildType field's value.
func (s *ListChildrenInput) SetChildType(v string) *ListChildrenInput {
	s.ChildType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChildrenInput) SetMaxResults(v int64) *ListChildrenInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChildrenInput) SetNextToken(v string) *ListChildrenInput {
	s.NextToken = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *ListChildrenInput) SetParentId(v string) *ListChildrenInput {
	s.ParentId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListChildrenResponse
type ListChildrenOutput struct {
	_ struct{} `type:"structure"`

	// The list of children of the specified parent container.
	Children []*Child `type:"list"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListChildrenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChildrenOutput) GoString() string {
	return s.String()
}

// SetChildren sets the Children field's value.
func (s *ListChildrenOutput) SetChildren(v []*Child) *ListChildrenOutput {
	s.Children = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChildrenOutput) SetNextToken(v string) *ListChildrenOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListCreateAccountStatusRequest
type ListCreateAccountStatusInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`

	// A list of one or more states that you want included in the response. If this
	// parameter is not present, then all requests are included in the response.
	States []*string `type:"list"`
}

// String returns the string representation
func (s ListCreateAccountStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCreateAccountStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCreateAccountStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCreateAccountStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCreateAccountStatusInput) SetMaxResults(v int64) *ListCreateAccountStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCreateAccountStatusInput) SetNextToken(v string) *ListCreateAccountStatusInput {
	s.NextToken = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListCreateAccountStatusInput) SetStates(v []*string) *ListCreateAccountStatusInput {
	s.States = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListCreateAccountStatusResponse
type ListCreateAccountStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects with details about the requests. Certain elements, such
	// as the accountId number, are present in the output only after the account
	// has been successfully created.
	CreateAccountStatuses []*CreateAccountStatus `type:"list"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCreateAccountStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCreateAccountStatusOutput) GoString() string {
	return s.String()
}

// SetCreateAccountStatuses sets the CreateAccountStatuses field's value.
func (s *ListCreateAccountStatusOutput) SetCreateAccountStatuses(v []*CreateAccountStatus) *ListCreateAccountStatusOutput {
	s.CreateAccountStatuses = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCreateAccountStatusOutput) SetNextToken(v string) *ListCreateAccountStatusOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForAccountRequest
type ListHandshakesForAccountInput struct {
	_ struct{} `type:"structure"`

	// Filters the handshakes that you want included in the response. The default
	// is all types. Use the ActionType element to limit the output to only a specified
	// type, such as INVITE, ENABLE-FULL-CONTROL, or APPROVE-FULL-CONTROL. Alternatively,
	// for the ENABLE-FULL-CONTROL handshake that generates a separate child handshake
	// for each member account, you can specify ParentHandshakeId to see only the
	// handshakes that were generated by that parent request.
	Filter *HandshakeFilter `type:"structure"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHandshakesForAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHandshakesForAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHandshakesForAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHandshakesForAccountInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListHandshakesForAccountInput) SetFilter(v *HandshakeFilter) *ListHandshakesForAccountInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHandshakesForAccountInput) SetMaxResults(v int64) *ListHandshakesForAccountInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHandshakesForAccountInput) SetNextToken(v string) *ListHandshakesForAccountInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForAccountResponse
type ListHandshakesForAccountOutput struct {
	_ struct{} `type:"structure"`

	// A list of Handshake objects with details about each of the handshakes that
	// is associated with the specified account.
	Handshakes []*Handshake `type:"list"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHandshakesForAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHandshakesForAccountOutput) GoString() string {
	return s.String()
}

// SetHandshakes sets the Handshakes field's value.
func (s *ListHandshakesForAccountOutput) SetHandshakes(v []*Handshake) *ListHandshakesForAccountOutput {
	s.Handshakes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHandshakesForAccountOutput) SetNextToken(v string) *ListHandshakesForAccountOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForOrganizationRequest
type ListHandshakesForOrganizationInput struct {
	_ struct{} `type:"structure"`

	// A filter of the handshakes that you want included in the response. The default
	// is all types. Use the ActionType element to limit the output to only a specified
	// type, such as INVITE, ENABLE-ALL-FEATURES, or APPROVE-ALL-FEATURES. Alternatively,
	// for the ENABLE-ALL-FEATURES handshake that generates a separate child handshake
	// for each member account, you can specify the ParentHandshakeId to see only
	// the handshakes that were generated by that parent request.
	Filter *HandshakeFilter `type:"structure"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHandshakesForOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHandshakesForOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHandshakesForOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHandshakesForOrganizationInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListHandshakesForOrganizationInput) SetFilter(v *HandshakeFilter) *ListHandshakesForOrganizationInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHandshakesForOrganizationInput) SetMaxResults(v int64) *ListHandshakesForOrganizationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHandshakesForOrganizationInput) SetNextToken(v string) *ListHandshakesForOrganizationInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListHandshakesForOrganizationResponse
type ListHandshakesForOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// A list of Handshake objects with details about each of the handshakes that
	// are associated with an organization.
	Handshakes []*Handshake `type:"list"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHandshakesForOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHandshakesForOrganizationOutput) GoString() string {
	return s.String()
}

// SetHandshakes sets the Handshakes field's value.
func (s *ListHandshakesForOrganizationOutput) SetHandshakes(v []*Handshake) *ListHandshakesForOrganizationOutput {
	s.Handshakes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHandshakesForOrganizationOutput) SetNextToken(v string) *ListHandshakesForOrganizationOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListOrganizationalUnitsForParentRequest
type ListOrganizationalUnitsForParentInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) of the root or OU whose child OUs you want to
	// list.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// ParentId is a required field
	ParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListOrganizationalUnitsForParentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationalUnitsForParentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationalUnitsForParentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationalUnitsForParentInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationalUnitsForParentInput) SetMaxResults(v int64) *ListOrganizationalUnitsForParentInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationalUnitsForParentInput) SetNextToken(v string) *ListOrganizationalUnitsForParentInput {
	s.NextToken = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *ListOrganizationalUnitsForParentInput) SetParentId(v string) *ListOrganizationalUnitsForParentInput {
	s.ParentId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListOrganizationalUnitsForParentResponse
type ListOrganizationalUnitsForParentOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// A list of the OUs in the specified root or parent OU.
	OrganizationalUnits []*OrganizationalUnit `type:"list"`
}

// String returns the string representation
func (s ListOrganizationalUnitsForParentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationalUnitsForParentOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationalUnitsForParentOutput) SetNextToken(v string) *ListOrganizationalUnitsForParentOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationalUnits sets the OrganizationalUnits field's value.
func (s *ListOrganizationalUnitsForParentOutput) SetOrganizationalUnits(v []*OrganizationalUnit) *ListOrganizationalUnitsForParentOutput {
	s.OrganizationalUnits = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListParentsRequest
type ListParentsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the OU or account whose parent containers you
	// want to list. Do not specify a root.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a child ID string
	// requires one of the following:
	//
	//    * Account: a string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that contains
	//    the OU) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// ChildId is a required field
	ChildId *string `type:"string" required:"true"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListParentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListParentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListParentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListParentsInput"}
	if s.ChildId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildId sets the ChildId field's value.
func (s *ListParentsInput) SetChildId(v string) *ListParentsInput {
	s.ChildId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListParentsInput) SetMaxResults(v int64) *ListParentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListParentsInput) SetNextToken(v string) *ListParentsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListParentsResponse
type ListParentsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// A list of parents for the specified child account or OU.
	Parents []*Parent `type:"list"`
}

// String returns the string representation
func (s ListParentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListParentsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListParentsOutput) SetNextToken(v string) *ListParentsOutput {
	s.NextToken = &v
	return s
}

// SetParents sets the Parents field's value.
func (s *ListParentsOutput) SetParents(v []*Parent) *ListParentsOutput {
	s.Parents = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTargetRequest
type ListPoliciesForTargetInput struct {
	_ struct{} `type:"structure"`

	// The type of policy that you want to include in the returned list.
	//
	// Filter is a required field
	Filter *string `type:"string" required:"true" enum:"PolicyType"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) of the root, organizational unit, or account whose
	// policies you want to list.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Account: a string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListPoliciesForTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesForTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesForTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesForTargetInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPoliciesForTargetInput) SetFilter(v string) *ListPoliciesForTargetInput {
	s.Filter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPoliciesForTargetInput) SetMaxResults(v int64) *ListPoliciesForTargetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesForTargetInput) SetNextToken(v string) *ListPoliciesForTargetInput {
	s.NextToken = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *ListPoliciesForTargetInput) SetTargetId(v string) *ListPoliciesForTargetInput {
	s.TargetId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTargetResponse
type ListPoliciesForTargetOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// The list of policies that match the criteria in the request.
	Policies []*PolicySummary `type:"list"`
}

// String returns the string representation
func (s ListPoliciesForTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesForTargetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesForTargetOutput) SetNextToken(v string) *ListPoliciesForTargetOutput {
	s.NextToken = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPoliciesForTargetOutput) SetPolicies(v []*PolicySummary) *ListPoliciesForTargetOutput {
	s.Policies = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesRequest
type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the type of policy that you want to include in the response.
	//
	// Filter is a required field
	Filter *string `type:"string" required:"true" enum:"PolicyType"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPoliciesInput) SetFilter(v string) *ListPoliciesInput {
	s.Filter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPoliciesInput) SetMaxResults(v int64) *ListPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesInput) SetNextToken(v string) *ListPoliciesInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesResponse
type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// A list of policies that match the filter criteria in the request. The output
	// list does not include the policy contents. To see the content for a policy,
	// see DescribePolicy.
	Policies []*PolicySummary `type:"list"`
}

// String returns the string representation
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPoliciesOutput) SetNextToken(v string) *ListPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPoliciesOutput) SetPolicies(v []*PolicySummary) *ListPoliciesOutput {
	s.Policies = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListRootsRequest
type ListRootsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListRootsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRootsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRootsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRootsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRootsInput) SetMaxResults(v int64) *ListRootsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRootsInput) SetNextToken(v string) *ListRootsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListRootsResponse
type ListRootsOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// A list of roots that are defined in an organization.
	Roots []*Root `type:"list"`
}

// String returns the string representation
func (s ListRootsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRootsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRootsOutput) SetNextToken(v string) *ListRootsOutput {
	s.NextToken = &v
	return s
}

// SetRoots sets the Roots field's value.
func (s *ListRootsOutput) SetRoots(v []*Root) *ListRootsOutput {
	s.Roots = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTargetsForPolicyRequest
type ListTargetsForPolicyInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this to limit the number of results you want included in the
	// response. If you do not include this parameter, it defaults to a value that
	// is specific to the operation. If additional items exist beyond the maximum
	// you specify, the NextToken response element is present and has a value (is
	// not null). Include that value as the NextToken request parameter in the next
	// call to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) of the policy for which you want to know its attachments.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lower-case letters or digits.
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTargetsForPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsForPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsForPolicyInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTargetsForPolicyInput) SetMaxResults(v int64) *ListTargetsForPolicyInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsForPolicyInput) SetNextToken(v string) *ListTargetsForPolicyInput {
	s.NextToken = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *ListTargetsForPolicyInput) SetPolicyId(v string) *ListTargetsForPolicyInput {
	s.PolicyId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTargetsForPolicyResponse
type ListTargetsForPolicyOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// A list of structures, each of which contains details about one of the entities
	// to which the specified policy is attached.
	Targets []*PolicyTargetSummary `type:"list"`
}

// String returns the string representation
func (s ListTargetsForPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForPolicyOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsForPolicyOutput) SetNextToken(v string) *ListTargetsForPolicyOutput {
	s.NextToken = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsForPolicyOutput) SetTargets(v []*PolicyTargetSummary) *ListTargetsForPolicyOutput {
	s.Targets = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/MoveAccountRequest
type MoveAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the account that you want to move.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root or organizational unit that you want
	// to move the account to.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// DestinationParentId is a required field
	DestinationParentId *string `type:"string" required:"true"`

	// The unique identifier (ID) of the root or organizational unit that you want
	// to move the account from.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// SourceParentId is a required field
	SourceParentId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MoveAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MoveAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MoveAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MoveAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.DestinationParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationParentId"))
	}
	if s.SourceParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceParentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *MoveAccountInput) SetAccountId(v string) *MoveAccountInput {
	s.AccountId = &v
	return s
}

// SetDestinationParentId sets the DestinationParentId field's value.
func (s *MoveAccountInput) SetDestinationParentId(v string) *MoveAccountInput {
	s.DestinationParentId = &v
	return s
}

// SetSourceParentId sets the SourceParentId field's value.
func (s *MoveAccountInput) SetSourceParentId(v string) *MoveAccountInput {
	s.SourceParentId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/MoveAccountOutput
type MoveAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s MoveAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MoveAccountOutput) GoString() string {
	return s.String()
}

// Contains details about an organization. An organization is a collection of
// accounts that are centrally managed together using consolidated billing,
// organized hierarchically with organizational units (OUs), and controlled
// with policies .
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/Organization
type Organization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an organization.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// A list of policy types that are enabled for this organization. For example,
	// if your organization has all features enabled, then service control policies
	// (SCPs) are included in the list.
	AvailablePolicyTypes []*PolicyTypeSummary `type:"list"`

	// Specifies the functionality that currently is available to the organization.
	// If set to "ALL", then all features are enabled and policies can be applied
	// to accounts in the organization. If set to "CONSOLIDATED_BILLING", then only
	// consolidated billing functionality is available. For more information, see
	// Enabling All Features in Your Organization (http://docs.aws.amazon.com/IAM/latest/UserGuide/orgs_manage_org_support-all-features.html)
	// in the AWS Organizations User Guide.
	FeatureSet *string `type:"string" enum:"OrganizationFeatureSet"`

	// The unique identifier (ID) of an organization.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organization ID
	// string requires "o-" followed by from 10 to 32 lower-case letters or digits.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the account that is designated as the master
	// account for the organization.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	MasterAccountArn *string `type:"string"`

	// The email address that is associated with the AWS account that is designated
	// as the master account for the organization.
	MasterAccountEmail *string `min:"6" type:"string"`

	// The unique identifier (ID) of the master account of an organization.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	MasterAccountId *string `type:"string"`
}

// String returns the string representation
func (s Organization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Organization) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Organization) SetArn(v string) *Organization {
	s.Arn = &v
	return s
}

// SetAvailablePolicyTypes sets the AvailablePolicyTypes field's value.
func (s *Organization) SetAvailablePolicyTypes(v []*PolicyTypeSummary) *Organization {
	s.AvailablePolicyTypes = v
	return s
}

// SetFeatureSet sets the FeatureSet field's value.
func (s *Organization) SetFeatureSet(v string) *Organization {
	s.FeatureSet = &v
	return s
}

// SetId sets the Id field's value.
func (s *Organization) SetId(v string) *Organization {
	s.Id = &v
	return s
}

// SetMasterAccountArn sets the MasterAccountArn field's value.
func (s *Organization) SetMasterAccountArn(v string) *Organization {
	s.MasterAccountArn = &v
	return s
}

// SetMasterAccountEmail sets the MasterAccountEmail field's value.
func (s *Organization) SetMasterAccountEmail(v string) *Organization {
	s.MasterAccountEmail = &v
	return s
}

// SetMasterAccountId sets the MasterAccountId field's value.
func (s *Organization) SetMasterAccountId(v string) *Organization {
	s.MasterAccountId = &v
	return s
}

// Contains details about an organizational unit (OU). An OU is a container
// of AWS accounts within a root of an organization. Policies that are attached
// to an OU apply to all accounts contained in that OU and in any child OUs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/OrganizationalUnit
type OrganizationalUnit struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of this OU.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The unique identifier (ID) associated with this OU.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lower-case letters
	// or digits (the ID of the root that contains the OU) followed by a second
	// "-" dash and from 8 to 32 additional lower-case letters or digits.
	Id *string `type:"string"`

	// The friendly name of this OU.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OrganizationalUnit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationalUnit) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *OrganizationalUnit) SetArn(v string) *OrganizationalUnit {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *OrganizationalUnit) SetId(v string) *OrganizationalUnit {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *OrganizationalUnit) SetName(v string) *OrganizationalUnit {
	s.Name = &v
	return s
}

// Contains information about either a root or an organizational unit (OU) that
// can contain OUs or accounts in an organization.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/Parent
type Parent struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the parent entity.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a parent ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	Id *string `type:"string"`

	// The type of the parent entity.
	Type *string `type:"string" enum:"ParentType"`
}

// String returns the string representation
func (s Parent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parent) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Parent) SetId(v string) *Parent {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *Parent) SetType(v string) *Parent {
	s.Type = &v
	return s
}

// Contains rules to be applied to the affected accounts. Policies can be attached
// directly to accounts, or to roots and OUs to affect all accounts in those
// hierarchies.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/Policy
type Policy struct {
	_ struct{} `type:"structure"`

	// The text content of the policy.
	Content *string `min:"1" type:"string"`

	// A structure that contains additional details about the policy.
	PolicySummary *PolicySummary `type:"structure"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Policy) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *Policy) SetContent(v string) *Policy {
	s.Content = &v
	return s
}

// SetPolicySummary sets the PolicySummary field's value.
func (s *Policy) SetPolicySummary(v *PolicySummary) *Policy {
	s.PolicySummary = v
	return s
}

// Contains information about a policy, but does not include the content. To
// see the content of a policy, see DescribePolicy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/PolicySummary
type PolicySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// A boolean value that indicates whether the specified policy is an AWS managed
	// policy. If true, then you can attach the policy to roots, OUs, or accounts,
	// but you cannot edit it.
	AwsManaged *bool `type:"boolean"`

	// The description of the policy.
	Description *string `type:"string"`

	// The unique identifier (ID) of the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lower-case letters or digits.
	Id *string `type:"string"`

	// The friendly name of the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The type of policy.
	Type *string `type:"string" enum:"PolicyType"`
}

// String returns the string representation
func (s PolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicySummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PolicySummary) SetArn(v string) *PolicySummary {
	s.Arn = &v
	return s
}

// SetAwsManaged sets the AwsManaged field's value.
func (s *PolicySummary) SetAwsManaged(v bool) *PolicySummary {
	s.AwsManaged = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PolicySummary) SetDescription(v string) *PolicySummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *PolicySummary) SetId(v string) *PolicySummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *PolicySummary) SetName(v string) *PolicySummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *PolicySummary) SetType(v string) *PolicySummary {
	s.Type = &v
	return s
}

// Contains information about a root, OU, or account that a policy is attached
// to.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/PolicyTargetSummary
type PolicyTargetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy target.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The friendly name of the policy target.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The unique identifier (ID) of the policy target.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Account: a string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	TargetId *string `type:"string"`

	// The type of the policy target.
	Type *string `type:"string" enum:"TargetType"`
}

// String returns the string representation
func (s PolicyTargetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyTargetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PolicyTargetSummary) SetArn(v string) *PolicyTargetSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *PolicyTargetSummary) SetName(v string) *PolicyTargetSummary {
	s.Name = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *PolicyTargetSummary) SetTargetId(v string) *PolicyTargetSummary {
	s.TargetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *PolicyTargetSummary) SetType(v string) *PolicyTargetSummary {
	s.Type = &v
	return s
}

// Contains information about a policy type and its status in the associated
// root.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/PolicyTypeSummary
type PolicyTypeSummary struct {
	_ struct{} `type:"structure"`

	// The status of the policy type as it relates to the associated root. To attach
	// a policy of the specified type to a root or to an OU or account in that root,
	// it must be available in the organization and enabled for that root.
	Status *string `type:"string" enum:"PolicyTypeStatus"`

	// The name of the policy type.
	Type *string `type:"string" enum:"PolicyType"`
}

// String returns the string representation
func (s PolicyTypeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyTypeSummary) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *PolicyTypeSummary) SetStatus(v string) *PolicyTypeSummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *PolicyTypeSummary) SetType(v string) *PolicyTypeSummary {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/RemoveAccountFromOrganizationRequest
type RemoveAccountFromOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the member account that you want to remove
	// from the organization.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an account ID string
	// requires exactly 12 digits.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveAccountFromOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAccountFromOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAccountFromOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAccountFromOrganizationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *RemoveAccountFromOrganizationInput) SetAccountId(v string) *RemoveAccountFromOrganizationInput {
	s.AccountId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/RemoveAccountFromOrganizationOutput
type RemoveAccountFromOrganizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveAccountFromOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAccountFromOrganizationOutput) GoString() string {
	return s.String()
}

// Contains details about a root. A root is a top-level parent node in the hierarchy
// of an organization that can contain organizational units (OUs) and accounts.
// Every root contains every AWS account in the organization. Each root enables
// the accounts to be organized in a different way and to have different policy
// types enabled for use in that root.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/Root
type Root struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the root.
	//
	// For more information about ARNs in Organizations, see ARN Formats Supported
	// by Organizations (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_permissions.html#orgs-permissions-arns)
	// in the AWS Organizations User Guide.
	Arn *string `type:"string"`

	// The unique identifier (ID) for the root.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a root ID string
	// requires "r-" followed by from 4 to 32 lower-case letters or digits.
	Id *string `type:"string"`

	// The friendly name of the root.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The types of policies that are currently enabled for the root and therefore
	// can be attached to the root or to its OUs or accounts.
	PolicyTypes []*PolicyTypeSummary `type:"list"`
}

// String returns the string representation
func (s Root) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Root) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Root) SetArn(v string) *Root {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Root) SetId(v string) *Root {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Root) SetName(v string) *Root {
	s.Name = &v
	return s
}

// SetPolicyTypes sets the PolicyTypes field's value.
func (s *Root) SetPolicyTypes(v []*PolicyTypeSummary) *Root {
	s.PolicyTypes = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdateOrganizationalUnitRequest
type UpdateOrganizationalUnitInput struct {
	_ struct{} `type:"structure"`

	// The new name that you want to assign to the OU.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The unique identifier (ID) of the OU that you want to rename. You can get
	// the ID from the ListOrganizationalUnitsForParent operation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for an organizational
	// unit ID string requires "ou-" followed by from 4 to 32 lower-case letters
	// or digits (the ID of the root that contains the OU) followed by a second
	// "-" dash and from 8 to 32 additional lower-case letters or digits.
	//
	// OrganizationalUnitId is a required field
	OrganizationalUnitId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateOrganizationalUnitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationalUnitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrganizationalUnitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrganizationalUnitInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationalUnitId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationalUnitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateOrganizationalUnitInput) SetName(v string) *UpdateOrganizationalUnitInput {
	s.Name = &v
	return s
}

// SetOrganizationalUnitId sets the OrganizationalUnitId field's value.
func (s *UpdateOrganizationalUnitInput) SetOrganizationalUnitId(v string) *UpdateOrganizationalUnitInput {
	s.OrganizationalUnitId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdateOrganizationalUnitResponse
type UpdateOrganizationalUnitOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains the details about the specified OU, including its
	// new name.
	OrganizationalUnit *OrganizationalUnit `type:"structure"`
}

// String returns the string representation
func (s UpdateOrganizationalUnitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationalUnitOutput) GoString() string {
	return s.String()
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *UpdateOrganizationalUnitOutput) SetOrganizationalUnit(v *OrganizationalUnit) *UpdateOrganizationalUnitOutput {
	s.OrganizationalUnit = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdatePolicyRequest
type UpdatePolicyInput struct {
	_ struct{} `type:"structure"`

	// If provided, the new content for the policy. The text must be correctly formatted
	// JSON that complies with the syntax for the policy's type. For more information,
	// see Service Control Policy Syntax (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_scp-syntax.html)
	// in the AWS Organizations User Guide.
	Content *string `min:"1" type:"string"`

	// If provided, the new description for the policy.
	Description *string `type:"string"`

	// If provided, the new name for the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) that is used to validate
	// this parameter is a string of any of the characters in the ASCII character
	// range.
	Name *string `min:"1" type:"string"`

	// The unique identifier (ID) of the policy that you want to update.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lower-case letters or digits.
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePolicyInput"}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *UpdatePolicyInput) SetContent(v string) *UpdatePolicyInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePolicyInput) SetDescription(v string) *UpdatePolicyInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePolicyInput) SetName(v string) *UpdatePolicyInput {
	s.Name = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *UpdatePolicyInput) SetPolicyId(v string) *UpdatePolicyInput {
	s.PolicyId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/UpdatePolicyResponse
type UpdatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the updated policy, showing the requested
	// changes.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s UpdatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *UpdatePolicyOutput) SetPolicy(v *Policy) *UpdatePolicyOutput {
	s.Policy = v
	return s
}

const (
	// AccountJoinedMethodInvited is a AccountJoinedMethod enum value
	AccountJoinedMethodInvited = "INVITED"

	// AccountJoinedMethodCreated is a AccountJoinedMethod enum value
	AccountJoinedMethodCreated = "CREATED"
)

const (
	// AccountStatusActive is a AccountStatus enum value
	AccountStatusActive = "ACTIVE"

	// AccountStatusSuspended is a AccountStatus enum value
	AccountStatusSuspended = "SUSPENDED"
)

const (
	// ActionTypeInvite is a ActionType enum value
	ActionTypeInvite = "INVITE"

	// ActionTypeEnableAllFeatures is a ActionType enum value
	ActionTypeEnableAllFeatures = "ENABLE_ALL_FEATURES"

	// ActionTypeApproveAllFeatures is a ActionType enum value
	ActionTypeApproveAllFeatures = "APPROVE_ALL_FEATURES"
)

const (
	// ChildTypeAccount is a ChildType enum value
	ChildTypeAccount = "ACCOUNT"

	// ChildTypeOrganizationalUnit is a ChildType enum value
	ChildTypeOrganizationalUnit = "ORGANIZATIONAL_UNIT"
)

const (
	// ConstraintViolationExceptionReasonAccountNumberLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonAccountNumberLimitExceeded = "ACCOUNT_NUMBER_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonHandshakeRateLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonHandshakeRateLimitExceeded = "HANDSHAKE_RATE_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonOuNumberLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonOuNumberLimitExceeded = "OU_NUMBER_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonOuDepthLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonOuDepthLimitExceeded = "OU_DEPTH_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonPolicyNumberLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonPolicyNumberLimitExceeded = "POLICY_NUMBER_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonMaxPolicyTypeAttachmentLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMaxPolicyTypeAttachmentLimitExceeded = "MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonMinPolicyTypeAttachmentLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMinPolicyTypeAttachmentLimitExceeded = "MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED"

	// ConstraintViolationExceptionReasonAccountCannotLeaveOrganization is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonAccountCannotLeaveOrganization = "ACCOUNT_CANNOT_LEAVE_ORGANIZATION"

	// ConstraintViolationExceptionReasonMasterAccountPaymentInstrumentRequired is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonMasterAccountPaymentInstrumentRequired = "MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED"

	// ConstraintViolationExceptionReasonAccountCreationRateLimitExceeded is a ConstraintViolationExceptionReason enum value
	ConstraintViolationExceptionReasonAccountCreationRateLimitExceeded = "ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED"
)

const (
	// CreateAccountFailureReasonAccountLimitExceeded is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonAccountLimitExceeded = "ACCOUNT_LIMIT_EXCEEDED"

	// CreateAccountFailureReasonEmailAlreadyExists is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonEmailAlreadyExists = "EMAIL_ALREADY_EXISTS"

	// CreateAccountFailureReasonInvalidAddress is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonInvalidAddress = "INVALID_ADDRESS"

	// CreateAccountFailureReasonInternalFailure is a CreateAccountFailureReason enum value
	CreateAccountFailureReasonInternalFailure = "INTERNAL_FAILURE"
)

const (
	// CreateAccountStateInProgress is a CreateAccountState enum value
	CreateAccountStateInProgress = "IN_PROGRESS"

	// CreateAccountStateSucceeded is a CreateAccountState enum value
	CreateAccountStateSucceeded = "SUCCEEDED"

	// CreateAccountStateFailed is a CreateAccountState enum value
	CreateAccountStateFailed = "FAILED"
)

const (
	// HandshakeConstraintViolationExceptionReasonAccountNumberLimitExceeded is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonAccountNumberLimitExceeded = "ACCOUNT_NUMBER_LIMIT_EXCEEDED"

	// HandshakeConstraintViolationExceptionReasonHandshakeRateLimitExceeded is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonHandshakeRateLimitExceeded = "HANDSHAKE_RATE_LIMIT_EXCEEDED"

	// HandshakeConstraintViolationExceptionReasonAlreadyInAnOrganization is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonAlreadyInAnOrganization = "ALREADY_IN_AN_ORGANIZATION"

	// HandshakeConstraintViolationExceptionReasonOrganizationAlreadyHasAllFeatures is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonOrganizationAlreadyHasAllFeatures = "ORGANIZATION_ALREADY_HAS_ALL_FEATURES"

	// HandshakeConstraintViolationExceptionReasonInviteDisabledDuringEnableAllFeatures is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonInviteDisabledDuringEnableAllFeatures = "INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES"

	// HandshakeConstraintViolationExceptionReasonPaymentInstrumentRequired is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonPaymentInstrumentRequired = "PAYMENT_INSTRUMENT_REQUIRED"

	// HandshakeConstraintViolationExceptionReasonOrganizationFromDifferentSellerOfRecord is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonOrganizationFromDifferentSellerOfRecord = "ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD"

	// HandshakeConstraintViolationExceptionReasonOrganizationMembershipChangeRateLimitExceeded is a HandshakeConstraintViolationExceptionReason enum value
	HandshakeConstraintViolationExceptionReasonOrganizationMembershipChangeRateLimitExceeded = "ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED"
)

const (
	// HandshakePartyTypeAccount is a HandshakePartyType enum value
	HandshakePartyTypeAccount = "ACCOUNT"

	// HandshakePartyTypeOrganization is a HandshakePartyType enum value
	HandshakePartyTypeOrganization = "ORGANIZATION"

	// HandshakePartyTypeEmail is a HandshakePartyType enum value
	HandshakePartyTypeEmail = "EMAIL"
)

const (
	// HandshakeResourceTypeAccount is a HandshakeResourceType enum value
	HandshakeResourceTypeAccount = "ACCOUNT"

	// HandshakeResourceTypeOrganization is a HandshakeResourceType enum value
	HandshakeResourceTypeOrganization = "ORGANIZATION"

	// HandshakeResourceTypeOrganizationFeatureSet is a HandshakeResourceType enum value
	HandshakeResourceTypeOrganizationFeatureSet = "ORGANIZATION_FEATURE_SET"

	// HandshakeResourceTypeEmail is a HandshakeResourceType enum value
	HandshakeResourceTypeEmail = "EMAIL"

	// HandshakeResourceTypeMasterEmail is a HandshakeResourceType enum value
	HandshakeResourceTypeMasterEmail = "MASTER_EMAIL"

	// HandshakeResourceTypeMasterName is a HandshakeResourceType enum value
	HandshakeResourceTypeMasterName = "MASTER_NAME"

	// HandshakeResourceTypeNotes is a HandshakeResourceType enum value
	HandshakeResourceTypeNotes = "NOTES"

	// HandshakeResourceTypeParentHandshake is a HandshakeResourceType enum value
	HandshakeResourceTypeParentHandshake = "PARENT_HANDSHAKE"
)

const (
	// HandshakeStateRequested is a HandshakeState enum value
	HandshakeStateRequested = "REQUESTED"

	// HandshakeStateOpen is a HandshakeState enum value
	HandshakeStateOpen = "OPEN"

	// HandshakeStateCanceled is a HandshakeState enum value
	HandshakeStateCanceled = "CANCELED"

	// HandshakeStateAccepted is a HandshakeState enum value
	HandshakeStateAccepted = "ACCEPTED"

	// HandshakeStateDeclined is a HandshakeState enum value
	HandshakeStateDeclined = "DECLINED"

	// HandshakeStateExpired is a HandshakeState enum value
	HandshakeStateExpired = "EXPIRED"
)

const (
	// IAMUserAccessToBillingAllow is a IAMUserAccessToBilling enum value
	IAMUserAccessToBillingAllow = "ALLOW"

	// IAMUserAccessToBillingDeny is a IAMUserAccessToBilling enum value
	IAMUserAccessToBillingDeny = "DENY"
)

const (
	// InvalidInputExceptionReasonInvalidPartyTypeTarget is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidPartyTypeTarget = "INVALID_PARTY_TYPE_TARGET"

	// InvalidInputExceptionReasonInvalidSyntaxOrganizationArn is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidSyntaxOrganizationArn = "INVALID_SYNTAX_ORGANIZATION_ARN"

	// InvalidInputExceptionReasonInvalidSyntaxPolicyId is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidSyntaxPolicyId = "INVALID_SYNTAX_POLICY_ID"

	// InvalidInputExceptionReasonInvalidEnum is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidEnum = "INVALID_ENUM"

	// InvalidInputExceptionReasonInvalidListMember is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidListMember = "INVALID_LIST_MEMBER"

	// InvalidInputExceptionReasonMaxLengthExceeded is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMaxLengthExceeded = "MAX_LENGTH_EXCEEDED"

	// InvalidInputExceptionReasonMaxValueExceeded is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMaxValueExceeded = "MAX_VALUE_EXCEEDED"

	// InvalidInputExceptionReasonMinLengthExceeded is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMinLengthExceeded = "MIN_LENGTH_EXCEEDED"

	// InvalidInputExceptionReasonMinValueExceeded is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMinValueExceeded = "MIN_VALUE_EXCEEDED"

	// InvalidInputExceptionReasonImmutablePolicy is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonImmutablePolicy = "IMMUTABLE_POLICY"

	// InvalidInputExceptionReasonInvalidPattern is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidPattern = "INVALID_PATTERN"

	// InvalidInputExceptionReasonInvalidPatternTargetId is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidPatternTargetId = "INVALID_PATTERN_TARGET_ID"

	// InvalidInputExceptionReasonInputRequired is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInputRequired = "INPUT_REQUIRED"

	// InvalidInputExceptionReasonInvalidNextToken is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonInvalidNextToken = "INVALID_NEXT_TOKEN"

	// InvalidInputExceptionReasonMaxLimitExceededFilter is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMaxLimitExceededFilter = "MAX_LIMIT_EXCEEDED_FILTER"

	// InvalidInputExceptionReasonMovingAccountBetweenDifferentRoots is a InvalidInputExceptionReason enum value
	InvalidInputExceptionReasonMovingAccountBetweenDifferentRoots = "MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS"
)

const (
	// OrganizationFeatureSetAll is a OrganizationFeatureSet enum value
	OrganizationFeatureSetAll = "ALL"

	// OrganizationFeatureSetConsolidatedBilling is a OrganizationFeatureSet enum value
	OrganizationFeatureSetConsolidatedBilling = "CONSOLIDATED_BILLING"
)

const (
	// ParentTypeRoot is a ParentType enum value
	ParentTypeRoot = "ROOT"

	// ParentTypeOrganizationalUnit is a ParentType enum value
	ParentTypeOrganizationalUnit = "ORGANIZATIONAL_UNIT"
)

const (
	// PolicyTypeServiceControlPolicy is a PolicyType enum value
	PolicyTypeServiceControlPolicy = "SERVICE_CONTROL_POLICY"
)

const (
	// PolicyTypeStatusEnabled is a PolicyTypeStatus enum value
	PolicyTypeStatusEnabled = "ENABLED"

	// PolicyTypeStatusPendingEnable is a PolicyTypeStatus enum value
	PolicyTypeStatusPendingEnable = "PENDING_ENABLE"

	// PolicyTypeStatusPendingDisable is a PolicyTypeStatus enum value
	PolicyTypeStatusPendingDisable = "PENDING_DISABLE"
)

const (
	// TargetTypeAccount is a TargetType enum value
	TargetTypeAccount = "ACCOUNT"

	// TargetTypeOrganizationalUnit is a TargetType enum value
	TargetTypeOrganizationalUnit = "ORGANIZATIONAL_UNIT"

	// TargetTypeRoot is a TargetType enum value
	TargetTypeRoot = "ROOT"
)
