// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package sms provides a client for AWS Server Migration Service.
package sms

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateReplicationJob = "CreateReplicationJob"

// CreateReplicationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReplicationJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReplicationJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReplicationJobRequest method.
//    req, resp := client.CreateReplicationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateReplicationJob
func (c *SMS) CreateReplicationJobRequest(input *CreateReplicationJobInput) (req *request.Request, output *CreateReplicationJobOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationJobInput{}
	}

	output = &CreateReplicationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationJob API operation for AWS Server Migration Service.
//
// The CreateReplicationJob API is used to create a ReplicationJob to replicate
// a server on AWS. Call this API to first create a ReplicationJob, which will
// then schedule periodic ReplicationRuns to replicate your server to AWS. Each
// ReplicationRun will result in the creation of an AWS AMI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation CreateReplicationJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The specified operation is not allowed. This error can occur for a number
//   of reasons; for example, you might be trying to start a Replication Run before
//   seed Replication Run.
//
//   * ErrCodeServerCannotBeReplicatedException "ServerCannotBeReplicatedException"
//   The provided server cannot be replicated.
//
//   * ErrCodeReplicationJobAlreadyExistsException "ReplicationJobAlreadyExistsException"
//   An active Replication Job already exists for the specified server.
//
//   * ErrCodeNoConnectorsAvailableException "NoConnectorsAvailableException"
//   No connectors are available to handle this request. Please associate connector(s)
//   and verify any existing connectors are healthy and can respond to requests.
//
//   * ErrCodeInternalError "InternalError"
//   An internal error has occured.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateReplicationJob
func (c *SMS) CreateReplicationJob(input *CreateReplicationJobInput) (*CreateReplicationJobOutput, error) {
	req, out := c.CreateReplicationJobRequest(input)
	return out, req.Send()
}

// CreateReplicationJobWithContext is the same as CreateReplicationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) CreateReplicationJobWithContext(ctx aws.Context, input *CreateReplicationJobInput, opts ...request.Option) (*CreateReplicationJobOutput, error) {
	req, out := c.CreateReplicationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationJob = "DeleteReplicationJob"

// DeleteReplicationJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteReplicationJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteReplicationJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteReplicationJobRequest method.
//    req, resp := client.DeleteReplicationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJob
func (c *SMS) DeleteReplicationJobRequest(input *DeleteReplicationJobInput) (req *request.Request, output *DeleteReplicationJobOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationJobInput{}
	}

	output = &DeleteReplicationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationJob API operation for AWS Server Migration Service.
//
// The DeleteReplicationJob API is used to delete a ReplicationJob, resulting
// in no further ReplicationRuns. This will delete the contents of the S3 bucket
// used to store SMS artifacts, but will not delete any AMIs created by the
// SMS service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DeleteReplicationJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The specified operation is not allowed. This error can occur for a number
//   of reasons; for example, you might be trying to start a Replication Run before
//   seed Replication Run.
//
//   * ErrCodeReplicationJobNotFoundException "ReplicationJobNotFoundException"
//   The specified Replication Job cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJob
func (c *SMS) DeleteReplicationJob(input *DeleteReplicationJobInput) (*DeleteReplicationJobOutput, error) {
	req, out := c.DeleteReplicationJobRequest(input)
	return out, req.Send()
}

// DeleteReplicationJobWithContext is the same as DeleteReplicationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DeleteReplicationJobWithContext(ctx aws.Context, input *DeleteReplicationJobInput, opts ...request.Option) (*DeleteReplicationJobOutput, error) {
	req, out := c.DeleteReplicationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServerCatalog = "DeleteServerCatalog"

// DeleteServerCatalogRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServerCatalog operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteServerCatalog for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteServerCatalog method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteServerCatalogRequest method.
//    req, resp := client.DeleteServerCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalog
func (c *SMS) DeleteServerCatalogRequest(input *DeleteServerCatalogInput) (req *request.Request, output *DeleteServerCatalogOutput) {
	op := &request.Operation{
		Name:       opDeleteServerCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerCatalogInput{}
	}

	output = &DeleteServerCatalogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteServerCatalog API operation for AWS Server Migration Service.
//
// The DeleteServerCatalog API clears all servers from your server catalog.
// This means that these servers will no longer be accessible to the Server
// Migration Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DeleteServerCatalog for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The specified operation is not allowed. This error can occur for a number
//   of reasons; for example, you might be trying to start a Replication Run before
//   seed Replication Run.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalog
func (c *SMS) DeleteServerCatalog(input *DeleteServerCatalogInput) (*DeleteServerCatalogOutput, error) {
	req, out := c.DeleteServerCatalogRequest(input)
	return out, req.Send()
}

// DeleteServerCatalogWithContext is the same as DeleteServerCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServerCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DeleteServerCatalogWithContext(ctx aws.Context, input *DeleteServerCatalogInput, opts ...request.Option) (*DeleteServerCatalogOutput, error) {
	req, out := c.DeleteServerCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateConnector = "DisassociateConnector"

// DisassociateConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateConnector operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateConnector for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateConnector method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateConnectorRequest method.
//    req, resp := client.DisassociateConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnector
func (c *SMS) DisassociateConnectorRequest(input *DisassociateConnectorInput) (req *request.Request, output *DisassociateConnectorOutput) {
	op := &request.Operation{
		Name:       opDisassociateConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConnectorInput{}
	}

	output = &DisassociateConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateConnector API operation for AWS Server Migration Service.
//
// The DisassociateConnector API will disassociate a connector from the Server
// Migration Service, rendering it unavailable to support replication jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation DisassociateConnector for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The specified operation is not allowed. This error can occur for a number
//   of reasons; for example, you might be trying to start a Replication Run before
//   seed Replication Run.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnector
func (c *SMS) DisassociateConnector(input *DisassociateConnectorInput) (*DisassociateConnectorOutput, error) {
	req, out := c.DisassociateConnectorRequest(input)
	return out, req.Send()
}

// DisassociateConnectorWithContext is the same as DisassociateConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) DisassociateConnectorWithContext(ctx aws.Context, input *DisassociateConnectorInput, opts ...request.Option) (*DisassociateConnectorOutput, error) {
	req, out := c.DisassociateConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectors = "GetConnectors"

// GetConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectors operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetConnectors for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetConnectors method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetConnectorsRequest method.
//    req, resp := client.GetConnectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors
func (c *SMS) GetConnectorsRequest(input *GetConnectorsInput) (req *request.Request, output *GetConnectorsOutput) {
	op := &request.Operation{
		Name:       opGetConnectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetConnectorsInput{}
	}

	output = &GetConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectors API operation for AWS Server Migration Service.
//
// The GetConnectors API returns a list of connectors that are registered with
// the Server Migration Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetConnectors for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors
func (c *SMS) GetConnectors(input *GetConnectorsInput) (*GetConnectorsOutput, error) {
	req, out := c.GetConnectorsRequest(input)
	return out, req.Send()
}

// GetConnectorsWithContext is the same as GetConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetConnectorsWithContext(ctx aws.Context, input *GetConnectorsInput, opts ...request.Option) (*GetConnectorsOutput, error) {
	req, out := c.GetConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetConnectorsPages iterates over the pages of a GetConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetConnectors operation.
//    pageNum := 0
//    err := client.GetConnectorsPages(params,
//        func(page *GetConnectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SMS) GetConnectorsPages(input *GetConnectorsInput, fn func(*GetConnectorsOutput, bool) bool) error {
	return c.GetConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetConnectorsPagesWithContext same as GetConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetConnectorsPagesWithContext(ctx aws.Context, input *GetConnectorsInput, fn func(*GetConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			inCpy := *input
			req, _ := c.GetConnectorsRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetConnectorsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetReplicationJobs = "GetReplicationJobs"

// GetReplicationJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetReplicationJobs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetReplicationJobs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetReplicationJobs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetReplicationJobsRequest method.
//    req, resp := client.GetReplicationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs
func (c *SMS) GetReplicationJobsRequest(input *GetReplicationJobsInput) (req *request.Request, output *GetReplicationJobsOutput) {
	op := &request.Operation{
		Name:       opGetReplicationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetReplicationJobsInput{}
	}

	output = &GetReplicationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReplicationJobs API operation for AWS Server Migration Service.
//
// The GetReplicationJobs API will return all of your ReplicationJobs and their
// details. This API returns a paginated list, that may be consecutively called
// with nextToken to retrieve all ReplicationJobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetReplicationJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs
func (c *SMS) GetReplicationJobs(input *GetReplicationJobsInput) (*GetReplicationJobsOutput, error) {
	req, out := c.GetReplicationJobsRequest(input)
	return out, req.Send()
}

// GetReplicationJobsWithContext is the same as GetReplicationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetReplicationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetReplicationJobsWithContext(ctx aws.Context, input *GetReplicationJobsInput, opts ...request.Option) (*GetReplicationJobsOutput, error) {
	req, out := c.GetReplicationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetReplicationJobsPages iterates over the pages of a GetReplicationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetReplicationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetReplicationJobs operation.
//    pageNum := 0
//    err := client.GetReplicationJobsPages(params,
//        func(page *GetReplicationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SMS) GetReplicationJobsPages(input *GetReplicationJobsInput, fn func(*GetReplicationJobsOutput, bool) bool) error {
	return c.GetReplicationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetReplicationJobsPagesWithContext same as GetReplicationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetReplicationJobsPagesWithContext(ctx aws.Context, input *GetReplicationJobsInput, fn func(*GetReplicationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			inCpy := *input
			req, _ := c.GetReplicationJobsRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetReplicationJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetReplicationRuns = "GetReplicationRuns"

// GetReplicationRunsRequest generates a "aws/request.Request" representing the
// client's request for the GetReplicationRuns operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetReplicationRuns for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetReplicationRuns method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetReplicationRunsRequest method.
//    req, resp := client.GetReplicationRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRuns
func (c *SMS) GetReplicationRunsRequest(input *GetReplicationRunsInput) (req *request.Request, output *GetReplicationRunsOutput) {
	op := &request.Operation{
		Name:       opGetReplicationRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetReplicationRunsInput{}
	}

	output = &GetReplicationRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReplicationRuns API operation for AWS Server Migration Service.
//
// The GetReplicationRuns API will return all ReplicationRuns for a given ReplicationJob.
// This API returns a paginated list, that may be consecutively called with
// nextToken to retrieve all ReplicationRuns for a ReplicationJob.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetReplicationRuns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRuns
func (c *SMS) GetReplicationRuns(input *GetReplicationRunsInput) (*GetReplicationRunsOutput, error) {
	req, out := c.GetReplicationRunsRequest(input)
	return out, req.Send()
}

// GetReplicationRunsWithContext is the same as GetReplicationRuns with the addition of
// the ability to pass a context and additional request options.
//
// See GetReplicationRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetReplicationRunsWithContext(ctx aws.Context, input *GetReplicationRunsInput, opts ...request.Option) (*GetReplicationRunsOutput, error) {
	req, out := c.GetReplicationRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetReplicationRunsPages iterates over the pages of a GetReplicationRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetReplicationRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetReplicationRuns operation.
//    pageNum := 0
//    err := client.GetReplicationRunsPages(params,
//        func(page *GetReplicationRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SMS) GetReplicationRunsPages(input *GetReplicationRunsInput, fn func(*GetReplicationRunsOutput, bool) bool) error {
	return c.GetReplicationRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetReplicationRunsPagesWithContext same as GetReplicationRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetReplicationRunsPagesWithContext(ctx aws.Context, input *GetReplicationRunsInput, fn func(*GetReplicationRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			inCpy := *input
			req, _ := c.GetReplicationRunsRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetReplicationRunsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetServers = "GetServers"

// GetServersRequest generates a "aws/request.Request" representing the
// client's request for the GetServers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetServers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetServers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetServersRequest method.
//    req, resp := client.GetServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers
func (c *SMS) GetServersRequest(input *GetServersInput) (req *request.Request, output *GetServersOutput) {
	op := &request.Operation{
		Name:       opGetServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetServersInput{}
	}

	output = &GetServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServers API operation for AWS Server Migration Service.
//
// The GetServers API returns a list of all servers in your server catalog.
// For this call to succeed, you must previously have called ImportServerCatalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation GetServers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers
func (c *SMS) GetServers(input *GetServersInput) (*GetServersOutput, error) {
	req, out := c.GetServersRequest(input)
	return out, req.Send()
}

// GetServersWithContext is the same as GetServers with the addition of
// the ability to pass a context and additional request options.
//
// See GetServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetServersWithContext(ctx aws.Context, input *GetServersInput, opts ...request.Option) (*GetServersOutput, error) {
	req, out := c.GetServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetServersPages iterates over the pages of a GetServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetServers operation.
//    pageNum := 0
//    err := client.GetServersPages(params,
//        func(page *GetServersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SMS) GetServersPages(input *GetServersInput, fn func(*GetServersOutput, bool) bool) error {
	return c.GetServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetServersPagesWithContext same as GetServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) GetServersPagesWithContext(ctx aws.Context, input *GetServersInput, fn func(*GetServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			inCpy := *input
			req, _ := c.GetServersRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetServersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opImportServerCatalog = "ImportServerCatalog"

// ImportServerCatalogRequest generates a "aws/request.Request" representing the
// client's request for the ImportServerCatalog operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportServerCatalog for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportServerCatalog method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportServerCatalogRequest method.
//    req, resp := client.ImportServerCatalogRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalog
func (c *SMS) ImportServerCatalogRequest(input *ImportServerCatalogInput) (req *request.Request, output *ImportServerCatalogOutput) {
	op := &request.Operation{
		Name:       opImportServerCatalog,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportServerCatalogInput{}
	}

	output = &ImportServerCatalogOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportServerCatalog API operation for AWS Server Migration Service.
//
// The ImportServerCatalog API is used to gather the complete list of on-premises
// servers on your premises. This API call requires connectors to be installed
// and monitoring all servers you would like imported. This API call returns
// immediately, but may take some time to retrieve all of the servers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation ImportServerCatalog for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The specified operation is not allowed. This error can occur for a number
//   of reasons; for example, you might be trying to start a Replication Run before
//   seed Replication Run.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
//   * ErrCodeNoConnectorsAvailableException "NoConnectorsAvailableException"
//   No connectors are available to handle this request. Please associate connector(s)
//   and verify any existing connectors are healthy and can respond to requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalog
func (c *SMS) ImportServerCatalog(input *ImportServerCatalogInput) (*ImportServerCatalogOutput, error) {
	req, out := c.ImportServerCatalogRequest(input)
	return out, req.Send()
}

// ImportServerCatalogWithContext is the same as ImportServerCatalog with the addition of
// the ability to pass a context and additional request options.
//
// See ImportServerCatalog for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) ImportServerCatalogWithContext(ctx aws.Context, input *ImportServerCatalogInput, opts ...request.Option) (*ImportServerCatalogOutput, error) {
	req, out := c.ImportServerCatalogRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartOnDemandReplicationRun = "StartOnDemandReplicationRun"

// StartOnDemandReplicationRunRequest generates a "aws/request.Request" representing the
// client's request for the StartOnDemandReplicationRun operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartOnDemandReplicationRun for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartOnDemandReplicationRun method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartOnDemandReplicationRunRequest method.
//    req, resp := client.StartOnDemandReplicationRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandReplicationRun
func (c *SMS) StartOnDemandReplicationRunRequest(input *StartOnDemandReplicationRunInput) (req *request.Request, output *StartOnDemandReplicationRunOutput) {
	op := &request.Operation{
		Name:       opStartOnDemandReplicationRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartOnDemandReplicationRunInput{}
	}

	output = &StartOnDemandReplicationRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartOnDemandReplicationRun API operation for AWS Server Migration Service.
//
// The StartOnDemandReplicationRun API is used to start a ReplicationRun on
// demand (in addition to those that are scheduled based on your frequency).
// This ReplicationRun will start immediately. StartOnDemandReplicationRun is
// subject to limits on how many on demand ReplicationRuns you may call per
// 24-hour period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation StartOnDemandReplicationRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The specified operation is not allowed. This error can occur for a number
//   of reasons; for example, you might be trying to start a Replication Run before
//   seed Replication Run.
//
//   * ErrCodeReplicationRunLimitExceededException "ReplicationRunLimitExceededException"
//   This user has exceeded the maximum allowed Replication Run limit.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandReplicationRun
func (c *SMS) StartOnDemandReplicationRun(input *StartOnDemandReplicationRunInput) (*StartOnDemandReplicationRunOutput, error) {
	req, out := c.StartOnDemandReplicationRunRequest(input)
	return out, req.Send()
}

// StartOnDemandReplicationRunWithContext is the same as StartOnDemandReplicationRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartOnDemandReplicationRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) StartOnDemandReplicationRunWithContext(ctx aws.Context, input *StartOnDemandReplicationRunInput, opts ...request.Option) (*StartOnDemandReplicationRunOutput, error) {
	req, out := c.StartOnDemandReplicationRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReplicationJob = "UpdateReplicationJob"

// UpdateReplicationJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReplicationJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateReplicationJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateReplicationJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateReplicationJobRequest method.
//    req, resp := client.UpdateReplicationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateReplicationJob
func (c *SMS) UpdateReplicationJobRequest(input *UpdateReplicationJobInput) (req *request.Request, output *UpdateReplicationJobOutput) {
	op := &request.Operation{
		Name:       opUpdateReplicationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateReplicationJobInput{}
	}

	output = &UpdateReplicationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReplicationJob API operation for AWS Server Migration Service.
//
// The UpdateReplicationJob API is used to change the settings of your existing
// ReplicationJob created using CreateReplicationJob. Calling this API will
// affect the next scheduled ReplicationRun.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Server Migration Service's
// API operation UpdateReplicationJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter specified in the request is not valid, is unsupported, or cannot
//   be used.
//
//   * ErrCodeMissingRequiredParameterException "MissingRequiredParameterException"
//   The request is missing a required parameter. Ensure that you have supplied
//   all the required parameters for the request.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The specified operation is not allowed. This error can occur for a number
//   of reasons; for example, you might be trying to start a Replication Run before
//   seed Replication Run.
//
//   * ErrCodeUnauthorizedOperationException "UnauthorizedOperationException"
//   This user does not have permissions to perform this operation.
//
//   * ErrCodeServerCannotBeReplicatedException "ServerCannotBeReplicatedException"
//   The provided server cannot be replicated.
//
//   * ErrCodeReplicationJobNotFoundException "ReplicationJobNotFoundException"
//   The specified Replication Job cannot be found.
//
//   * ErrCodeInternalError "InternalError"
//   An internal error has occured.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateReplicationJob
func (c *SMS) UpdateReplicationJob(input *UpdateReplicationJobInput) (*UpdateReplicationJobOutput, error) {
	req, out := c.UpdateReplicationJobRequest(input)
	return out, req.Send()
}

// UpdateReplicationJobWithContext is the same as UpdateReplicationJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReplicationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SMS) UpdateReplicationJobWithContext(ctx aws.Context, input *UpdateReplicationJobInput, opts ...request.Option) (*UpdateReplicationJobOutput, error) {
	req, out := c.UpdateReplicationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Object representing a Connector
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/Connector
type Connector struct {
	_ struct{} `type:"structure"`

	// Timestamp of an operation
	AssociatedOn *time.Time `locationName:"associatedOn" type:"timestamp" timestampFormat:"unix"`

	// List of Connector Capabilities
	CapabilityList []*string `locationName:"capabilityList" locationNameList:"item" type:"list"`

	// Unique Identifier for Connector
	ConnectorId *string `locationName:"connectorId" type:"string"`

	// Internet Protocol (IP) Address
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// Hardware (MAC) address
	MacAddress *string `locationName:"macAddress" type:"string"`

	// Status of on-premise Connector
	Status *string `locationName:"status" type:"string" enum:"ConnectorStatus"`

	// Connector version string
	Version *string `locationName:"version" type:"string"`

	// Unique Identifier for VM Manager
	VmManagerId *string `locationName:"vmManagerId" type:"string"`

	// VM Manager Name
	VmManagerName *string `locationName:"vmManagerName" type:"string"`

	// VM Management Product
	VmManagerType *string `locationName:"vmManagerType" type:"string" enum:"VmManagerType"`
}

// String returns the string representation
func (s Connector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connector) GoString() string {
	return s.String()
}

// SetAssociatedOn sets the AssociatedOn field's value.
func (s *Connector) SetAssociatedOn(v time.Time) *Connector {
	s.AssociatedOn = &v
	return s
}

// SetCapabilityList sets the CapabilityList field's value.
func (s *Connector) SetCapabilityList(v []*string) *Connector {
	s.CapabilityList = v
	return s
}

// SetConnectorId sets the ConnectorId field's value.
func (s *Connector) SetConnectorId(v string) *Connector {
	s.ConnectorId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Connector) SetIpAddress(v string) *Connector {
	s.IpAddress = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *Connector) SetMacAddress(v string) *Connector {
	s.MacAddress = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Connector) SetStatus(v string) *Connector {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Connector) SetVersion(v string) *Connector {
	s.Version = &v
	return s
}

// SetVmManagerId sets the VmManagerId field's value.
func (s *Connector) SetVmManagerId(v string) *Connector {
	s.VmManagerId = &v
	return s
}

// SetVmManagerName sets the VmManagerName field's value.
func (s *Connector) SetVmManagerName(v string) *Connector {
	s.VmManagerName = &v
	return s
}

// SetVmManagerType sets the VmManagerType field's value.
func (s *Connector) SetVmManagerType(v string) *Connector {
	s.VmManagerType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateReplicationJobRequest
type CreateReplicationJobInput struct {
	_ struct{} `type:"structure"`

	// The description for a Replication Job/Run.
	Description *string `locationName:"description" type:"string"`

	// Interval between Replication Runs. This value is specified in hours, and
	// represents the time between consecutive Replication Runs.
	//
	// Frequency is a required field
	Frequency *int64 `locationName:"frequency" type:"integer" required:"true"`

	// The license type to be used for the Amazon Machine Image (AMI) created after
	// a successful ReplicationRun.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"LicenseType"`

	// Name of service role in customer's account to be used by SMS service.
	RoleName *string `locationName:"roleName" type:"string"`

	// Timestamp of an operation
	//
	// SeedReplicationTime is a required field
	SeedReplicationTime *time.Time `locationName:"seedReplicationTime" type:"timestamp" timestampFormat:"unix" required:"true"`

	// Unique Identifier for a server
	//
	// ServerId is a required field
	ServerId *string `locationName:"serverId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReplicationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationJobInput"}
	if s.Frequency == nil {
		invalidParams.Add(request.NewErrParamRequired("Frequency"))
	}
	if s.SeedReplicationTime == nil {
		invalidParams.Add(request.NewErrParamRequired("SeedReplicationTime"))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateReplicationJobInput) SetDescription(v string) *CreateReplicationJobInput {
	s.Description = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *CreateReplicationJobInput) SetFrequency(v int64) *CreateReplicationJobInput {
	s.Frequency = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *CreateReplicationJobInput) SetLicenseType(v string) *CreateReplicationJobInput {
	s.LicenseType = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *CreateReplicationJobInput) SetRoleName(v string) *CreateReplicationJobInput {
	s.RoleName = &v
	return s
}

// SetSeedReplicationTime sets the SeedReplicationTime field's value.
func (s *CreateReplicationJobInput) SetSeedReplicationTime(v time.Time) *CreateReplicationJobInput {
	s.SeedReplicationTime = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *CreateReplicationJobInput) SetServerId(v string) *CreateReplicationJobInput {
	s.ServerId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateReplicationJobResponse
type CreateReplicationJobOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for a Replication Job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`
}

// String returns the string representation
func (s CreateReplicationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationJobOutput) GoString() string {
	return s.String()
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *CreateReplicationJobOutput) SetReplicationJobId(v string) *CreateReplicationJobOutput {
	s.ReplicationJobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJobRequest
type DeleteReplicationJobInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for a Replication Job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationJobInput"}
	if s.ReplicationJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *DeleteReplicationJobInput) SetReplicationJobId(v string) *DeleteReplicationJobInput {
	s.ReplicationJobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJobResponse
type DeleteReplicationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationJobOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalogRequest
type DeleteServerCatalogInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerCatalogInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalogResponse
type DeleteServerCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerCatalogOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnectorRequest
type DisassociateConnectorInput struct {
	_ struct{} `type:"structure"`

	// Unique Identifier for Connector
	//
	// ConnectorId is a required field
	ConnectorId *string `locationName:"connectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateConnectorInput"}
	if s.ConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorId sets the ConnectorId field's value.
func (s *DisassociateConnectorInput) SetConnectorId(v string) *DisassociateConnectorInput {
	s.ConnectorId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnectorResponse
type DisassociateConnectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateConnectorOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectorsRequest
type GetConnectorsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in one API call. If left empty, this
	// will default to 50.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Pagination token to pass as input to API call
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectorsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetConnectorsInput) SetMaxResults(v int64) *GetConnectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConnectorsInput) SetNextToken(v string) *GetConnectorsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectorsResponse
type GetConnectorsOutput struct {
	_ struct{} `type:"structure"`

	// List of connectors
	ConnectorList []*Connector `locationName:"connectorList" locationNameList:"item" type:"list"`

	// Pagination token to pass as input to API call
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectorsOutput) GoString() string {
	return s.String()
}

// SetConnectorList sets the ConnectorList field's value.
func (s *GetConnectorsOutput) SetConnectorList(v []*Connector) *GetConnectorsOutput {
	s.ConnectorList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConnectorsOutput) SetNextToken(v string) *GetConnectorsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobsRequest
type GetReplicationJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in one API call. If left empty, this
	// will default to 50.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Pagination token to pass as input to API call
	NextToken *string `locationName:"nextToken" type:"string"`

	// The unique identifier for a Replication Job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`
}

// String returns the string representation
func (s GetReplicationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReplicationJobsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetReplicationJobsInput) SetMaxResults(v int64) *GetReplicationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetReplicationJobsInput) SetNextToken(v string) *GetReplicationJobsInput {
	s.NextToken = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *GetReplicationJobsInput) SetReplicationJobId(v string) *GetReplicationJobsInput {
	s.ReplicationJobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobsResponse
type GetReplicationJobsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token to pass as input to API call
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of Replication Jobs
	ReplicationJobList []*ReplicationJob `locationName:"replicationJobList" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s GetReplicationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReplicationJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetReplicationJobsOutput) SetNextToken(v string) *GetReplicationJobsOutput {
	s.NextToken = &v
	return s
}

// SetReplicationJobList sets the ReplicationJobList field's value.
func (s *GetReplicationJobsOutput) SetReplicationJobList(v []*ReplicationJob) *GetReplicationJobsOutput {
	s.ReplicationJobList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRunsRequest
type GetReplicationRunsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in one API call. If left empty, this
	// will default to 50.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Pagination token to pass as input to API call
	NextToken *string `locationName:"nextToken" type:"string"`

	// The unique identifier for a Replication Job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetReplicationRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReplicationRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReplicationRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReplicationRunsInput"}
	if s.ReplicationJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetReplicationRunsInput) SetMaxResults(v int64) *GetReplicationRunsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetReplicationRunsInput) SetNextToken(v string) *GetReplicationRunsInput {
	s.NextToken = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *GetReplicationRunsInput) SetReplicationJobId(v string) *GetReplicationRunsInput {
	s.ReplicationJobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRunsResponse
type GetReplicationRunsOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token to pass as input to API call
	NextToken *string `locationName:"nextToken" type:"string"`

	// Object representing a Replication Job
	ReplicationJob *ReplicationJob `locationName:"replicationJob" type:"structure"`

	// List of Replication Runs
	ReplicationRunList []*ReplicationRun `locationName:"replicationRunList" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s GetReplicationRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReplicationRunsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetReplicationRunsOutput) SetNextToken(v string) *GetReplicationRunsOutput {
	s.NextToken = &v
	return s
}

// SetReplicationJob sets the ReplicationJob field's value.
func (s *GetReplicationRunsOutput) SetReplicationJob(v *ReplicationJob) *GetReplicationRunsOutput {
	s.ReplicationJob = v
	return s
}

// SetReplicationRunList sets the ReplicationRunList field's value.
func (s *GetReplicationRunsOutput) SetReplicationRunList(v []*ReplicationRun) *GetReplicationRunsOutput {
	s.ReplicationRunList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServersRequest
type GetServersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in one API call. If left empty, this
	// will default to 50.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Pagination token to pass as input to API call
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetServersInput) SetMaxResults(v int64) *GetServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServersInput) SetNextToken(v string) *GetServersInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServersResponse
type GetServersOutput struct {
	_ struct{} `type:"structure"`

	// Timestamp of an operation
	LastModifiedOn *time.Time `locationName:"lastModifiedOn" type:"timestamp" timestampFormat:"unix"`

	// Pagination token to pass as input to API call
	NextToken *string `locationName:"nextToken" type:"string"`

	// Status of Server catalog
	ServerCatalogStatus *string `locationName:"serverCatalogStatus" type:"string" enum:"ServerCatalogStatus"`

	// List of servers from catalog
	ServerList []*Server `locationName:"serverList" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s GetServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServersOutput) GoString() string {
	return s.String()
}

// SetLastModifiedOn sets the LastModifiedOn field's value.
func (s *GetServersOutput) SetLastModifiedOn(v time.Time) *GetServersOutput {
	s.LastModifiedOn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetServersOutput) SetNextToken(v string) *GetServersOutput {
	s.NextToken = &v
	return s
}

// SetServerCatalogStatus sets the ServerCatalogStatus field's value.
func (s *GetServersOutput) SetServerCatalogStatus(v string) *GetServersOutput {
	s.ServerCatalogStatus = &v
	return s
}

// SetServerList sets the ServerList field's value.
func (s *GetServersOutput) SetServerList(v []*Server) *GetServersOutput {
	s.ServerList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalogRequest
type ImportServerCatalogInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportServerCatalogInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportServerCatalogInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalogResponse
type ImportServerCatalogOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportServerCatalogOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportServerCatalogOutput) GoString() string {
	return s.String()
}

// Object representing a Replication Job
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ReplicationJob
type ReplicationJob struct {
	_ struct{} `type:"structure"`

	// The description for a Replication Job/Run.
	Description *string `locationName:"description" type:"string"`

	// Interval between Replication Runs. This value is specified in hours, and
	// represents the time between consecutive Replication Runs.
	Frequency *int64 `locationName:"frequency" type:"integer"`

	// The AMI id for the image resulting from a Replication Run.
	LatestAmiId *string `locationName:"latestAmiId" type:"string"`

	// The license type to be used for the Amazon Machine Image (AMI) created after
	// a successful ReplicationRun.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"LicenseType"`

	// Timestamp of an operation
	NextReplicationRunStartTime *time.Time `locationName:"nextReplicationRunStartTime" type:"timestamp" timestampFormat:"unix"`

	// The unique identifier for a Replication Job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`

	// List of Replication Runs
	ReplicationRunList []*ReplicationRun `locationName:"replicationRunList" locationNameList:"item" type:"list"`

	// Name of service role in customer's account to be used by SMS service.
	RoleName *string `locationName:"roleName" type:"string"`

	// Timestamp of an operation
	SeedReplicationTime *time.Time `locationName:"seedReplicationTime" type:"timestamp" timestampFormat:"unix"`

	// Unique Identifier for a server
	ServerId *string `locationName:"serverId" type:"string"`

	// Type of server.
	ServerType *string `locationName:"serverType" type:"string" enum:"ServerType"`

	// Current state of Replication Job
	State *string `locationName:"state" type:"string" enum:"ReplicationJobState"`

	// String describing current status of Replication Job
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Object representing a VM server
	VmServer *VmServer `locationName:"vmServer" type:"structure"`
}

// String returns the string representation
func (s ReplicationJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationJob) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ReplicationJob) SetDescription(v string) *ReplicationJob {
	s.Description = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *ReplicationJob) SetFrequency(v int64) *ReplicationJob {
	s.Frequency = &v
	return s
}

// SetLatestAmiId sets the LatestAmiId field's value.
func (s *ReplicationJob) SetLatestAmiId(v string) *ReplicationJob {
	s.LatestAmiId = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *ReplicationJob) SetLicenseType(v string) *ReplicationJob {
	s.LicenseType = &v
	return s
}

// SetNextReplicationRunStartTime sets the NextReplicationRunStartTime field's value.
func (s *ReplicationJob) SetNextReplicationRunStartTime(v time.Time) *ReplicationJob {
	s.NextReplicationRunStartTime = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *ReplicationJob) SetReplicationJobId(v string) *ReplicationJob {
	s.ReplicationJobId = &v
	return s
}

// SetReplicationRunList sets the ReplicationRunList field's value.
func (s *ReplicationJob) SetReplicationRunList(v []*ReplicationRun) *ReplicationJob {
	s.ReplicationRunList = v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *ReplicationJob) SetRoleName(v string) *ReplicationJob {
	s.RoleName = &v
	return s
}

// SetSeedReplicationTime sets the SeedReplicationTime field's value.
func (s *ReplicationJob) SetSeedReplicationTime(v time.Time) *ReplicationJob {
	s.SeedReplicationTime = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ReplicationJob) SetServerId(v string) *ReplicationJob {
	s.ServerId = &v
	return s
}

// SetServerType sets the ServerType field's value.
func (s *ReplicationJob) SetServerType(v string) *ReplicationJob {
	s.ServerType = &v
	return s
}

// SetState sets the State field's value.
func (s *ReplicationJob) SetState(v string) *ReplicationJob {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReplicationJob) SetStatusMessage(v string) *ReplicationJob {
	s.StatusMessage = &v
	return s
}

// SetVmServer sets the VmServer field's value.
func (s *ReplicationJob) SetVmServer(v *VmServer) *ReplicationJob {
	s.VmServer = v
	return s
}

// Object representing a Replication Run
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ReplicationRun
type ReplicationRun struct {
	_ struct{} `type:"structure"`

	// The AMI id for the image resulting from a Replication Run.
	AmiId *string `locationName:"amiId" type:"string"`

	// Timestamp of an operation
	CompletedTime *time.Time `locationName:"completedTime" type:"timestamp" timestampFormat:"unix"`

	// The description for a Replication Job/Run.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier for a Replication Run.
	ReplicationRunId *string `locationName:"replicationRunId" type:"string"`

	// Timestamp of an operation
	ScheduledStartTime *time.Time `locationName:"scheduledStartTime" type:"timestamp" timestampFormat:"unix"`

	// Current state of Replication Run
	State *string `locationName:"state" type:"string" enum:"ReplicationRunState"`

	// String describing current status of Replication Run
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// Type of Replication Run
	Type *string `locationName:"type" type:"string" enum:"ReplicationRunType"`
}

// String returns the string representation
func (s ReplicationRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRun) GoString() string {
	return s.String()
}

// SetAmiId sets the AmiId field's value.
func (s *ReplicationRun) SetAmiId(v string) *ReplicationRun {
	s.AmiId = &v
	return s
}

// SetCompletedTime sets the CompletedTime field's value.
func (s *ReplicationRun) SetCompletedTime(v time.Time) *ReplicationRun {
	s.CompletedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ReplicationRun) SetDescription(v string) *ReplicationRun {
	s.Description = &v
	return s
}

// SetReplicationRunId sets the ReplicationRunId field's value.
func (s *ReplicationRun) SetReplicationRunId(v string) *ReplicationRun {
	s.ReplicationRunId = &v
	return s
}

// SetScheduledStartTime sets the ScheduledStartTime field's value.
func (s *ReplicationRun) SetScheduledStartTime(v time.Time) *ReplicationRun {
	s.ScheduledStartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReplicationRun) SetState(v string) *ReplicationRun {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReplicationRun) SetStatusMessage(v string) *ReplicationRun {
	s.StatusMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *ReplicationRun) SetType(v string) *ReplicationRun {
	s.Type = &v
	return s
}

// Object representing a server
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/Server
type Server struct {
	_ struct{} `type:"structure"`

	// The unique identifier for a Replication Job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`

	// An indicator of the Replication Job being deleted or failed.
	ReplicationJobTerminated *bool `locationName:"replicationJobTerminated" type:"boolean"`

	// Unique Identifier for a server
	ServerId *string `locationName:"serverId" type:"string"`

	// Type of server.
	ServerType *string `locationName:"serverType" type:"string" enum:"ServerType"`

	// Object representing a VM server
	VmServer *VmServer `locationName:"vmServer" type:"structure"`
}

// String returns the string representation
func (s Server) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Server) GoString() string {
	return s.String()
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *Server) SetReplicationJobId(v string) *Server {
	s.ReplicationJobId = &v
	return s
}

// SetReplicationJobTerminated sets the ReplicationJobTerminated field's value.
func (s *Server) SetReplicationJobTerminated(v bool) *Server {
	s.ReplicationJobTerminated = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *Server) SetServerId(v string) *Server {
	s.ServerId = &v
	return s
}

// SetServerType sets the ServerType field's value.
func (s *Server) SetServerType(v string) *Server {
	s.ServerType = &v
	return s
}

// SetVmServer sets the VmServer field's value.
func (s *Server) SetVmServer(v *VmServer) *Server {
	s.VmServer = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandReplicationRunRequest
type StartOnDemandReplicationRunInput struct {
	_ struct{} `type:"structure"`

	// The description for a Replication Job/Run.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier for a Replication Job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`
}

// String returns the string representation
func (s StartOnDemandReplicationRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOnDemandReplicationRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartOnDemandReplicationRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartOnDemandReplicationRunInput"}
	if s.ReplicationJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *StartOnDemandReplicationRunInput) SetDescription(v string) *StartOnDemandReplicationRunInput {
	s.Description = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *StartOnDemandReplicationRunInput) SetReplicationJobId(v string) *StartOnDemandReplicationRunInput {
	s.ReplicationJobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandReplicationRunResponse
type StartOnDemandReplicationRunOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for a Replication Run.
	ReplicationRunId *string `locationName:"replicationRunId" type:"string"`
}

// String returns the string representation
func (s StartOnDemandReplicationRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOnDemandReplicationRunOutput) GoString() string {
	return s.String()
}

// SetReplicationRunId sets the ReplicationRunId field's value.
func (s *StartOnDemandReplicationRunOutput) SetReplicationRunId(v string) *StartOnDemandReplicationRunOutput {
	s.ReplicationRunId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateReplicationJobRequest
type UpdateReplicationJobInput struct {
	_ struct{} `type:"structure"`

	// The description for a Replication Job/Run.
	Description *string `locationName:"description" type:"string"`

	// Interval between Replication Runs. This value is specified in hours, and
	// represents the time between consecutive Replication Runs.
	Frequency *int64 `locationName:"frequency" type:"integer"`

	// The license type to be used for the Amazon Machine Image (AMI) created after
	// a successful ReplicationRun.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"LicenseType"`

	// Timestamp of an operation
	NextReplicationRunStartTime *time.Time `locationName:"nextReplicationRunStartTime" type:"timestamp" timestampFormat:"unix"`

	// The unique identifier for a Replication Job.
	//
	// ReplicationJobId is a required field
	ReplicationJobId *string `locationName:"replicationJobId" type:"string" required:"true"`

	// Name of service role in customer's account to be used by SMS service.
	RoleName *string `locationName:"roleName" type:"string"`
}

// String returns the string representation
func (s UpdateReplicationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReplicationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationJobInput"}
	if s.ReplicationJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationJobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateReplicationJobInput) SetDescription(v string) *UpdateReplicationJobInput {
	s.Description = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *UpdateReplicationJobInput) SetFrequency(v int64) *UpdateReplicationJobInput {
	s.Frequency = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *UpdateReplicationJobInput) SetLicenseType(v string) *UpdateReplicationJobInput {
	s.LicenseType = &v
	return s
}

// SetNextReplicationRunStartTime sets the NextReplicationRunStartTime field's value.
func (s *UpdateReplicationJobInput) SetNextReplicationRunStartTime(v time.Time) *UpdateReplicationJobInput {
	s.NextReplicationRunStartTime = &v
	return s
}

// SetReplicationJobId sets the ReplicationJobId field's value.
func (s *UpdateReplicationJobInput) SetReplicationJobId(v string) *UpdateReplicationJobInput {
	s.ReplicationJobId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *UpdateReplicationJobInput) SetRoleName(v string) *UpdateReplicationJobInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateReplicationJobResponse
type UpdateReplicationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateReplicationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReplicationJobOutput) GoString() string {
	return s.String()
}

// Object representing a VM server
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/VmServer
type VmServer struct {
	_ struct{} `type:"structure"`

	// VM Manager Name
	VmManagerName *string `locationName:"vmManagerName" type:"string"`

	// VM Management Product
	VmManagerType *string `locationName:"vmManagerType" type:"string" enum:"VmManagerType"`

	// Name of Virtual Machine
	VmName *string `locationName:"vmName" type:"string"`

	// Path to VM
	VmPath *string `locationName:"vmPath" type:"string"`

	// Object representing a server's location
	VmServerAddress *VmServerAddress `locationName:"vmServerAddress" type:"structure"`
}

// String returns the string representation
func (s VmServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VmServer) GoString() string {
	return s.String()
}

// SetVmManagerName sets the VmManagerName field's value.
func (s *VmServer) SetVmManagerName(v string) *VmServer {
	s.VmManagerName = &v
	return s
}

// SetVmManagerType sets the VmManagerType field's value.
func (s *VmServer) SetVmManagerType(v string) *VmServer {
	s.VmManagerType = &v
	return s
}

// SetVmName sets the VmName field's value.
func (s *VmServer) SetVmName(v string) *VmServer {
	s.VmName = &v
	return s
}

// SetVmPath sets the VmPath field's value.
func (s *VmServer) SetVmPath(v string) *VmServer {
	s.VmPath = &v
	return s
}

// SetVmServerAddress sets the VmServerAddress field's value.
func (s *VmServer) SetVmServerAddress(v *VmServerAddress) *VmServer {
	s.VmServerAddress = v
	return s
}

// Object representing a server's location
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/VmServerAddress
type VmServerAddress struct {
	_ struct{} `type:"structure"`

	// Unique Identifier for a VM
	VmId *string `locationName:"vmId" type:"string"`

	// Unique Identifier for VM Manager
	VmManagerId *string `locationName:"vmManagerId" type:"string"`
}

// String returns the string representation
func (s VmServerAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VmServerAddress) GoString() string {
	return s.String()
}

// SetVmId sets the VmId field's value.
func (s *VmServerAddress) SetVmId(v string) *VmServerAddress {
	s.VmId = &v
	return s
}

// SetVmManagerId sets the VmManagerId field's value.
func (s *VmServerAddress) SetVmManagerId(v string) *VmServerAddress {
	s.VmManagerId = &v
	return s
}

// Capabilities for a Connector
const (
	// ConnectorCapabilityVsphere is a ConnectorCapability enum value
	ConnectorCapabilityVsphere = "VSPHERE"
)

// Status of on-premise Connector
const (
	// ConnectorStatusHealthy is a ConnectorStatus enum value
	ConnectorStatusHealthy = "HEALTHY"

	// ConnectorStatusUnhealthy is a ConnectorStatus enum value
	ConnectorStatusUnhealthy = "UNHEALTHY"
)

// The license type to be used for the Amazon Machine Image (AMI) created after
// a successful ReplicationRun.
const (
	// LicenseTypeAws is a LicenseType enum value
	LicenseTypeAws = "AWS"

	// LicenseTypeByol is a LicenseType enum value
	LicenseTypeByol = "BYOL"
)

// Current state of Replication Job
const (
	// ReplicationJobStatePending is a ReplicationJobState enum value
	ReplicationJobStatePending = "PENDING"

	// ReplicationJobStateActive is a ReplicationJobState enum value
	ReplicationJobStateActive = "ACTIVE"

	// ReplicationJobStateFailed is a ReplicationJobState enum value
	ReplicationJobStateFailed = "FAILED"

	// ReplicationJobStateDeleting is a ReplicationJobState enum value
	ReplicationJobStateDeleting = "DELETING"

	// ReplicationJobStateDeleted is a ReplicationJobState enum value
	ReplicationJobStateDeleted = "DELETED"
)

// Current state of Replication Run
const (
	// ReplicationRunStatePending is a ReplicationRunState enum value
	ReplicationRunStatePending = "PENDING"

	// ReplicationRunStateMissed is a ReplicationRunState enum value
	ReplicationRunStateMissed = "MISSED"

	// ReplicationRunStateActive is a ReplicationRunState enum value
	ReplicationRunStateActive = "ACTIVE"

	// ReplicationRunStateFailed is a ReplicationRunState enum value
	ReplicationRunStateFailed = "FAILED"

	// ReplicationRunStateCompleted is a ReplicationRunState enum value
	ReplicationRunStateCompleted = "COMPLETED"

	// ReplicationRunStateDeleting is a ReplicationRunState enum value
	ReplicationRunStateDeleting = "DELETING"

	// ReplicationRunStateDeleted is a ReplicationRunState enum value
	ReplicationRunStateDeleted = "DELETED"
)

// Type of Replication Run
const (
	// ReplicationRunTypeOnDemand is a ReplicationRunType enum value
	ReplicationRunTypeOnDemand = "ON_DEMAND"

	// ReplicationRunTypeAutomatic is a ReplicationRunType enum value
	ReplicationRunTypeAutomatic = "AUTOMATIC"
)

// Status of Server catalog
const (
	// ServerCatalogStatusNotImported is a ServerCatalogStatus enum value
	ServerCatalogStatusNotImported = "NOT_IMPORTED"

	// ServerCatalogStatusImporting is a ServerCatalogStatus enum value
	ServerCatalogStatusImporting = "IMPORTING"

	// ServerCatalogStatusAvailable is a ServerCatalogStatus enum value
	ServerCatalogStatusAvailable = "AVAILABLE"

	// ServerCatalogStatusDeleted is a ServerCatalogStatus enum value
	ServerCatalogStatusDeleted = "DELETED"

	// ServerCatalogStatusExpired is a ServerCatalogStatus enum value
	ServerCatalogStatusExpired = "EXPIRED"
)

// Type of server.
const (
	// ServerTypeVirtualMachine is a ServerType enum value
	ServerTypeVirtualMachine = "VIRTUAL_MACHINE"
)

// VM Management Product
const (
	// VmManagerTypeVsphere is a VmManagerType enum value
	VmManagerTypeVsphere = "VSPHERE"
)
