# 
# putlast.sh - add a new sequenced directory to an archive
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 
errname=putlast

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "*+add a new sequenced directory to an archive from a template\\n"
		printf "usage: putlast [options] locker locker-arg source-dir dest-dir txn txn-args...\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf " -A --archive archive          specify the archive name\\n"
		printf " -e --errname name             program name for error messages\\n"
		printf "\\n"
		printf "Copy SOURCE-DIR to the indicated archive, creating DEST-DIR\\n"
		printf "which must not already exist.\\n"
		printf "\\n"
		printf "In addition to not already existing, DEST-DIR must be a valid\\n"
		printf "addition to its parent directory (for example, if DEST-DIR is\\n"
		printf "a new version directory, no higher numbered version may already\\n"
		printf "exist).  Whether or not DEST-DIR is valid is determined by the\\n"
		printf "helper script LOCKER.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "putlast: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -A|--archive)	shift
    			if test $# -eq 0 ; then
			  printf "putlast: -A and --archive require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archive="$1"
			shift
			;;

    -e|--errname)	shift
    			if test $# -eq 0 ; then
			  printf "putlast: -e and --errname require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			errname="$1"
			shift
			;;

    -*)			printf "putlast: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 5 ; then
    printf "usage: putlast [options] locker locker-arg source-dir end-dir txn txn-args...\\n" 1>&2
    printf "try --help\\n" 1>&2
    exit 1
fi

locker="$1"
shift

locker_arg="$1"
shift

source="$1"
shift

dest="$1"
shift

txn="$1"
shift

# Note that "$@" is now the arguments (if any) for the "$txn" script.



################################################################
# Sanity Check and Process Defaults
# 

archive=`larch my-default-archive -e "$errname" -R "$root" -A "$archive"`

cd "$source"
source="`pwd`"

################################################################
# Obtain a lock in the archive
# 
# 

lockdir=`larch $locker -R "$archroot" -A "$archive" "$locker_arg"`
wftp-home
wftp-cd $lockdir
wftp-cd +contents
there="`wftp-pwd`"

for f in `ls "$source"` ; do

  wftp-cd "$there"

  if test ! -d "$source/$f" ; then
    wftp-put "$f" < "$source/$f"

  else

    larch nested --sub larch putdir -R "$root" -A "$archive" "$f" "$f"
  fi
done

wftp-cd "$there"


################################################################
# Put it in place
# 

# Tell the caller (via a callback) that we are about to 
# commit.
# 
larch "$txn" --start "$@"

wftp-cd ..

wftp-rename +contents "../`basename $dest`"

# Tell the caller (via a callback) that we have finished the
# commit successfully.
# 
larch "$txn" --finish "$@"

wftp-home
wftp-rmdir $lockdir
