# 
# wd-txn.sh - project tree part of a commit or import transaction
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "*perform the project tree part of a commit or import transaction\\n"
		printf "usage: wd-txn [options] wdroot archive revision log-file\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --start                       used just prior to a commit\\n"
		printf " --finish                      used after a successful commit\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

type=neither

while test $# -ne 0 ; do

  case "$1" in 

    --start)            shift
    			type=start
			;;

    --finish)           shift
			type=finish
			;;

    -*)			printf "wd-txn: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 4 ; then
  printf "usage: wd-txn [options] wdroot archive revision log-file\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi


wdroot="$1"
archive="$2"
revision="$3"
logfile="$4"

################################################################
# Sanity Check and Process Defaults
# 

larch valid-archive-name -e wd-txn -- "$archive"
larch valid-package-name -e wd-txn -l -- "$revision"

if test $type = neither ; then
  printf "wd-txn: either --start or --finish must be specified\\n" 1>&2
  exit 1
fi

base=`larch parse-package-name -b $revision`
branch=`larch parse-package-name $revision`
vsn=`larch parse-package-name -v $revision`
patchlvl=`larch parse-package-name -l $revision`

################################################################
# Do it
# 

cd "$wdroot"

case $type in 

  start)	cd "$wdroot/{arch}"
    		rm -f ++mid-commit
		cp "$logfile" ++mid-commit
		exit 0
    		;;



  finish)	cd "$wdroot/{arch}"
  		mv ++mid-commit ++commit-definite
	        larch copy-to-patch-log "$logfile" $archive/$branch--$vsn $patchlvl .
		rm ++commit-definite
		exit 0
		;;

  *)		printf "wd-txn: internal error\\n" 1>&2
  		printf "  unrecognized operator (%s)\\n" "$type" 1>&2
		printf "\\n" 1>&2
		exit 1
		;;
		
esac
