#!/bin/sh
# what-changed-config.sh: nested-tree what-changed
################################################################
# Copyright (C) 2001 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 
command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V)

		printf "Hackerlab what-changed-config 0.0 (nested-tree what-changed)\\n"
		printf "Copyright 2001, Tom Lord\\n"
		printf "\\n"
		printf "\\n"
	        printf "This is free software; see the source for copying conditions.\\n"
      		printf "There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\\n"
      		printf "PARTICULAR PURPOSE.\\n"
		printf "\\n"
		exit 0
		;;


      --help|-h)
		printf "nested-tree what-changed\\n"
		printf "usage: what-changed-config [options] config-name\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " --silent                      no output (except odd errors)\\n"
		printf " --quiet                       brief output\\n"
		printf " --report                      default output\\n"
		printf " --verbose                     maximal output\\n"
		printf " --debug                       debugging output\\n"
		printf "\\n"
		printf " -d --dir DIR                  cd to DIR first\\n"
		printf "\\n"
                printf " -o --output OUTUPT            specify an output directory name\\n"
                printf "\\n"
                printf " --diffs                       include diffs in outline\\n"
                printf " --html                        also generate HTML format output\\n"
                printf " --url                         output should be a URL\\n"
                printf "                                 implies --html\\n"
                printf "\\n"
		printf "Generate a what-changed report for each nested project tree\\n"
		printf "in a configuration.  (See \"arch what-changed --help\".)\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

dir=.
output=
diffs=
html=
url=

quiet=--quiet
report=--report
verbose=
silent_opt=
quiet_opt=
report_opt=
verbose_opt=
debug_opt=

force_opt=

while test $# -ne 0 ; do

  case "$1" in 

    --o|--output)       shift
                        if test $# -eq 0 ; then
                          printf "what-changed-config: -o and --output require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        output="$1"
                        shift
                        ;;

    --diffs)		shift
    			diffs=--diffs
			;;

    --html)		shift
    			html=--html
			;;

    --url)		shift
    			html=--html
    			url=--url
			;;


    --force)    shift
		force_opt=--force
		;;

    --silent)	shift
    		quiet=
		report=
		verbose=
		silent_opt=--silent
		quiet_opt=
		report_opt=
		verbose_opt=
		;;

    --quiet)	shift
    		quiet=--quiet
		report=
		verbose=
		silent_opt=
		quiet_opt=--quiet
		report_opt=
		verbose_opt=
		;;

    --report)	shift
    		quiet=--quiet
		report=--report
		verbose=
		silent_opt=
		quiet_opt=
		report_opt=--report
		verbose_opt=
		;;

    --verbose)	shift
    		quiet=--quiet
		report=--report
		verbose=--verbose
		silent_opt=
		quiet_opt=
		report_opt=
		verbose_opt=--verbose
		;;

    --debug)	shift
    		arch heading "what-changed-config: debugging output enabled\\n"
    		set -x
		debug_opt=--debug
		;;

    -d|--dir)		shift
    			if test $# -eq 0 ; then
			  printf "what-changed-config: -d and --dir require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			dir=$1
			shift
			;;

    --)			shift
    			break
			;;

    -*)			printf "what-changed-config: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: what-changed-config [options] name\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

name="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

cd "$dir"
dir="`pwd`"

wdroot="`arch tree-root --accurate`"
cd "$wdroot"

config_file="$wdroot/configs/$name"

if test ! -e "$config_file" ; then
  printf "\\n" 1>&2
  printf "what-changed-config: no configuration named %s\\n" "$name" 1>&2
  printf "   tree root: %s\\n" "$wdroot" 1>&2
  printf "   looking for: %s\\n" "$config_file" 1>&2
  printf "\\n" 1>&2
fi

if test -z "$output" ; then
  output="$wdroot/,,what-changed-config.`date +%Y-%m-%d`.$$"
fi


################################################################
# Make the Output Directory
# 

mkdir "$output"


################################################################
# What Changed in the Root Tree?
# 

arch what-changed

################################################################
# Greetings
# 

if test ! -z "$quiet" ; then
  arch heading "what-changed-config\\n"
  printf "arguments: %s\\n" "$command_line" | fold -w 60 | arch body-indent
  arch heading --sub "what-changed-config start time: %s\\n" "`date`"
  arch heading --sub "project tree: %s\\n" "$wdroot"
  arch heading --sub "configuration: %s\\n" "$name"
  cat "$config_file" | arch body-indent --sub
fi

################################################################
# Generate the Report
# 

cd "$wdroot"

cat "$config_file" \
| arch file-syntax-filter --sh-comments --blank-lines --trailing-spaces \
| sort -k 1 \
| awk -v silent_opt="$silent_opt" \
      -v quiet_opt="$quiet_opt" \
      -v report_opt="$report_opt" \
      -v debug_opt="$debug_opt" \
      -v force_opt="$force_opt" \
      '{
          printf("arch nested --sub arch update %s %s %s %s %s  --in-place -- %s %s\n", force_opt, silent_opt, quiet_opt, report_opt, debug_opt, $1, $2);
       }' \
| sh

# tag: Tom Lord Sat Dec 29 23:20:42 2001 (configurations/what-changed-configuration.sh)
#
