# 
# explicit-default.sh - set the default explicit tag in a dir
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "set the default explicit tag for a directory\\n"
                printf "usage: explicit-default [options] [TAG-PREFIX] \\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf " -d --delete                   remove the default\\n"
                printf " -f --force                    set: overwrite an existing default\\n"
                printf "                               print or delete: no error for\\n"
		printf "                                                missing default\\n"
		printf " -w --weak                     set a weak default (see below)\\n"
                printf " --dont-care                   use paths by default\\n"
                printf "\\n"
                printf " -D --dir[ectory] DIR          cd to DIR\\n"
                printf "\\n"
                printf "For files in this directory, use:\\n"
		printf "\\n"
		printf "	TAG-PREFIX__BASENAME\\n"
		printf "\\n"
		printf "as the default explicit tag for all files in this directory that\\n"
		printf "do not have an explicit explicit tag.\\n"
                printf "\\n"
                printf "With no arguments, print the previously set TAG-PREFIX.\\n"
                printf "\\n"
                printf "By default, this command sets, prints or deletes a \"strong\\n"
		printf "default\" -- a default explicit tag which overrides implicit tags.\\n"
		printf "\\n"
                printf "With --weak, set (or print) a weak default tag which is\\n"
                printf "overridden by explicit tags.\\n"
                printf "\\n"
                printf "The --dont-care option sets (or with -d, clears) a flag for that\\n"
		printf "directory that causes untagged files not to be reported as such\\n"
		printf "in \"larch tree-lint\" reports.\\n"
                printf "\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

mode=
force=
file="=all"

while test $# -ne 0 ; do

  case "$1" in 

    --dont-care)	shift
			file="=dont-care"
			;;

    -D|--dir|--directory)
			shift
			if test $# -eq 0 ; then
			  printf "explicit-default: -D (--dir[ectory]) requires an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			cd "$1"
			shift
			;;
				    


    -w|--weak)		shift
			file="=default"
			;;

    -d|--delete)	shift
			mode=delete
			;;

    -f|--force)		shift
			force=yes
			;;

    --)			shift
    			break
			;;
			
    -*)                 printf "explicit-default: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test ! -z "$mode" ; then

  if test $# -ne 0 ; then
    printf "usage: explicit-default [options] -d\\n" 1>&2
    printf "try --help\\n" 1>&2
    exit 1
  fi

else
  if test $# -gt 1 ; then
    printf "usage: explicit-default [options] [tag-prefix]\\n" 1>&2
    printf "try --help\\n" 1>&2
    exit 1
  fi

  if test $# -gt 0 ; then
    tag_prefix="$1"
    shift
    mode=set
    if test "$file" = "=dont-care" ; then
      tag_prefix="$tag_prefix `date` $$ `larch my-id --uid`"
    fi
  else
    mode=print
  fi
fi

################################################################
# Do It
# 

case "$mode" in 

  delete)	if test -z "$force" -a ! -e .arch-ids/$file ; then 
		  printf "explicit-default: no default tag set\\n" 1>&2
		  printf "\\n" 1>&2
		  printf "Try \"larch explicit-default --help\".\\n" 1>&2
		  exit 1
		fi

		if test -z "$force" ; then
		  rm .arch-ids/$file
		else
		  rm -f .arch-ids/$file
		fi
		exit 0
		;;

  set)		if test -z "$force" -a -e .arch-ids/$file ; then 
		  printf "explicit-default: default explicit already set\\n" 1>&2
		  printf "\\n" 1>&2
		  printf "Try \"larch explicit-default --help\".\\n" 1>&2
		  exit 1
		fi

		if test -z "$force" -a $file = "=default" -a -e .arch-ids/=all ; then
		  printf "explicit-default: strong default already exists\\n" 1>&2
		  printf "\\n" 1>&2
		  printf "Try \"larch explicit-default --help\".\\n" 1>&2
		  exit 1
		fi

		mkdir -p .arch-ids
		printf "%s\\n" "$tag_prefix" > .arch-ids/$file
		exit 0
		;;


  print)	if test "$file" = "=dont-care" ; then
		  if test -e .arch-ids/$file ; then

		    printf "don't care flag is set\\n"
		    exit 0

		  else

		    printf "don't care flag is not set\\n"
		    if test -z "$force" ; then
		      exit 1
		    else
		      exit 0
		    fi

		  fi
		fi
		
		if test -z "$force" -a ! -e .arch-ids/$file ; then 
		  printf "explicit-default: no default explicit set\\n" 1>&2
		  printf "\\n" 1>&2
		  printf "Try \"larch explicit-default --help\".\\n" 1>&2
		  exit 1
		fi

		if test -e .arch-ids/$file ; then
		  cat  .arch-ids/$file
		fi

		exit 0
		;;

esac

