# 
# cache-dir.sh - find the user's cache directory
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "find the user's larch cache directory\\n"
		printf "usage: cache-dir [options]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "This command finds the users cache directory (a location\\n"
		printf "where larch stores many temporary files) and prints its location.\\n"
		printf "\\n"
		printf "By default, the directory is ~/.arch-cache, but this may be overridden\\n"
		printf "by \$ARCHCACHE.\\n"
		printf "\\n"
		printf "If the cache directory does not already exist, this command will\\n"
		printf "attempt to create it.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    -*)			printf "cache-dir: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 0 ; then
  printf "usage: cache-dir [options]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi


################################################################
# Find the user's cache dir:
# 

if test "x$ARCHCACHE" != x ; then
  cache="$ARCHCACHE"
else
  cache="`cd ; pwd`"/.arch-cache
fi

# in case ARCHCACHE specified a relative path name,
# it is relative to the user's home directory.
#
cd

if test ! -e "$cache" ; then
  mkdir "$cache"
fi

if test ! -d "$cache" ; then
  printf "cache-dir: cache directory is not a directory (%s)\\n" "$cache" 1>&2
  exit 1
fi

if test ! -e "$cache/==readme.arch" ; then
  cd "$cache"
  nfiles="`ls -a | wc -l`"
  if test "$nfiles" -ne 2 ; then
    printf "cache-dir: corrupt cache directory (%s)\\n" "$cache" 1>&2
    printf "  file ==readme.larch not found in cache\\n" "$cache" 1>&2
    exit 1
  else
    printf "This is a cache directory for the arch revision control system\\n"  > "$cache/==readme.arch"
    printf "\\n" >> "$cache/==readme.arch"
    printf "(do not remove this file)\\n"  >> "$cache/==readme.arch"
  fi
fi


################################################################
# Print the cache directory location as an absolute path
# 
cd "$cache"
pwd
