# notify-library.sh: add new revisions to the library
# 
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "add new revisions to the library\\n"
                printf "usage: notify-library [options] recipient archive/version revision ..."
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
		printf "Invoke:\\n"
		printf "\\n"
		printf "	larch library-add ARCHIVE/VERSION--REVISION\\n"
		printf "\\n"
		printf "for each REVISION argument.  Then send email to RECIPIENT\\n"
		printf "indicating that the library has been updated.\\n"
		printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
    			break
			;;

    -*)                 printf "notify-library: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 3 ; then
  printf "usage: notify-library [options] recipient version branch ..." 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

recipient="$1"
shift

version="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

larch valid-package-name --archive --vsn -e notify-library "$version"


################################################################
# Update Library
#

did=

while test $# -ne 0 ; do

  larch library-add "$version--$1"
  did="$did $1"
  shift

done

if test -e =browser-opts ; then
  larch make-library-browser `cat =browser-opts \
			     | larch file-syntax-filter --sh-comments --blank-lines --trailing-spaces ` \
			    "$version"
  msg=" and browser"
else
  msg=
fi



( \
  printf "notify-library added new revisions to the library%s.\\n" "$msg" ; \
  printf "\\n" ; \
  printf "For version %s\\n" "$version" ; \
  printf "these revisions were added:\\n" ; \
  printf "%s\\n" "$did" \
  | sed -e 's/ /\
    /g' \
) \
| $ARCH_MAILER -s "Revisions added to library" "$recipient" 


# tag: Tom Lord Sat Jan 26 19:42:28 2002 (notify/notify-library.sh)
#
