BEGIN { getline;
        while (!match ($0, "^$"))
        {
          field = tolower ($1);
          sub (":.*", "", field);
          headers[field] = $0;
          sub ("^[^:]*:[ \t]*", "", headers[field]);
          getline;
          while (match ($0, "^[ \t]"))
            {
              headers[field] = headers[field] "\n" $0;
              getline;
            }
        }
      }

{ quit; }

END { 
      if (date != "")
        print "    " headers["standard-date"];
      if (creator != "")
        print "    " headers["creator"];
      if (summary != "")
        {
          n_lines = split(headers["summary"], lines, "\n");
          for (x = 1; x <= n_lines; ++x)
            {
              sub("^[ \t]{0,9}", "", lines[x]);
              print "    " lines[x];
            }
        }
    }


# tag: Tom Lord Wed Jan 23 18:32:33 2002 (patch-logs/patch-list-description.awk)
#
