# 
# set-tree-version.sh - set a default checkin location
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "set the default version for a source tree\\n"
		printf "usage: set-tree-version [options] [archive/]version\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root root                specify the local archive root\\n"
		printf " -A --archie archive           specify the archive name\\n"
		printf "\\n"
                printf " -d --dir DIR                  cd to DIR first\\n"
		printf "\\n"
		printf " -v                            be verbose\\n"
		printf "\\n"
		printf "This operation sets the default version on which to check-in\\n"
		printf "the source tree DIR (default: the current directory) during\\n"
		printf "a commit.\\n"
		printf "\\n"
		printf "You can specify the archive for this version as an ordinary\\n"
		printf "command line argument (ARCHIVE/VERSION) or via -R, -A and\\n"
		printf "the environment as usual (try \"larch my-default-archive\\n"
		printf " --help\").\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=
verbose=0

dir=.

while test $# -ne 0 ; do

  case "$1" in 

    -d|--dir)		shift
			if test $# -eq 0 ; then
			  printf "set-tree-version: -d and --dir require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			dir="$1"
			shift
			;;

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "set-tree-version: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;

    -A|--archive)	shift
    			if test $# -eq 0 ; then
			  printf "set-tree-version: -A and --archive require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archive="$1"
			shift
			;;

    -v)			shift
			verbose=1
			;;

    -*)			printf "set-tree-version: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: set-tree-version [options] archive/version\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

archive_version="$1"

################################################################
# Sanity Check
# 

cd "$dir"
dir="`pwd`"

larch valid-package-name -e set-tree-version --vsn -- "$archive_version"

archive=`larch parse-package-name -R "$archroot" -A "$archive" --arch "$archive_version"`
version=`larch parse-package-name -R "$archroot" -A "$archive" --package-version "$archive_version"`
category=`larch parse-package-name --basename $version`

cd "$dir"
wdroot="`larch tree-root --accurate`"



################################################################
# Create the larch Control Files
# 

cd "$wdroot/{arch}"
rm -f ./++default-version
printf "%s/%s\\n" "$archive" "$version" > ./++default-version

if test $verbose != 0 ; then
  printf "default version for commits: %s\\n" "$version"
  printf "default archive for commits: %s\\n" "$archive"
fi
