# 
# archives.sh - report registered archives and their locations
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "report registered archives and their locations\\n"
		printf "usage: archives [options]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -n --names                    print archive names only\\n"
		printf " -l --locations                print archive locations only\\n"
		printf "\\n"
		printf "\\n"
		printf "Print a list of registered archives and their locations\\n"
		printf "\\n"
		printf "The output format is:\\n"
		printf "\\n"
		printf "	\"%%s\\n\\t%%s\" \"\$archive\" \"\$location\"\\n"
		printf "\\n"
		printf "The options -n (--name) and -l (--locations) cancel each other.\\n"
		printf "\\n"
		printf "With -n, the output format is:\\n"
		printf "\\n"
		printf "	\"%%s\" \"\$archive\"\\n"
		printf "\\n"
		printf "With -l, the output format is:\\n"
		printf "\\n"
		printf "	\"%%s\" \"\$location\"\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

type=both

while test $# -ne 0 ; do

  case "$1" in 

    -n|--names)		shift
    			type=names
			;;

    -l|--locations)	shift
    			type=locations
			;;

    -*)			printf "archives: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 0 ; then
  printf "usage: archives [options]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

################################################################
# Print the List
# 

mkdir -p ~/.arch-params/=locations
cd ~/.arch-params/=locations

for f in * ,ign ; do
  if larch valid-archive-name -- "$f" ; then
    case $type in
      both)		printf "%s\\n\\t%s\\n" "$f" "`cat \"$f\"`"
      			;;

      names)		printf "%s\\n" "$f"
	      		;;

      locations)	printf "%s\\n" "`cat \"$f\"`"
	      		;;
    esac
  fi
done

